unit SCTestMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, StdCtrls, Buttons, StatesAndCounties;

type
  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
  public
    StatesAndCounties: TStatesAndCounties;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
StatesAndCounties := TStatesAndCounties.Create(self);
if StatesAndCounties.GetStates(ComboBox1.Items)
then Label1.Caption := IntToStr(ComboBox1.Items.Count);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  StatesAndCounties.Free;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
var s: string;
begin
with ComboBox1 do with StatesAndCounties do
  begin
  s := GetStateName(Items[ItemIndex]);
  if s <> EmptyStr then
    begin
    Label2.Caption := GetStateAbbrev(s) + ': ' + s;
    if GetCounties(Items[ItemIndex], ComboBox2.Items)
    then Label3.Caption := IntToStr(ComboBox2.Items.Count);
    end;
  end;
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
with ComboBox2 do with StatesAndCounties do
  begin
  Label4.Caption := Items[ItemIndex];
  end;
end;

end.

