unit SpeedParserUnit;

{****************************************}
{  This application demonstrates how to  }
{  use the SpeedParser Component         }
{  Copyright  2001 Mattias Andersson    }
{  mattias@centaurix.com                 }
{****************************************}

interface

uses
  Windows, Messages, Classes, Graphics, Controls, Forms, SpeedParser,
  StdCtrls, ExtCtrls, g32, icqclient;
type
  TMainForm = class(TForm)
    SpeedParserRed: TSpeedParser;
    SpeedParserGreen: TSpeedParser;
    SpeedParserBlue: TSpeedParser;
    Panel1: TPanel;
    Image: TImage;
    Panel2: TPanel;
    btnDraw: TButton;
    BlueComponent: TEdit;
    GreenComponent: TEdit;
    RedComponent: TEdit;
    cmbPreset: TComboBox;
    lblRed: TLabel;
    lblGreen: TLabel;
    lblBlue: TLabel;
    Label1: TLabel;
    procedure btnDrawClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cmbPresetChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  // You can register SpeedParser in the Components Palette
  // to be able to simply drop SpeedParser components on your
  // form at design time instead of creating them by code as
  // we are doing here:
  SpeedParserRed := TSpeedParser.Create(Self);
  SpeedParserGreen := TSpeedParser.Create(Self);
  SpeedParserBlue := TSpeedParser.Create(Self);

  { Here we add the new variables }
  SpeedParserRed.AddVar('width');
  SpeedParserRed.AddVar('height');
  SpeedParserGreen.AddVar('width');
  SpeedParserGreen.AddVar('height');
  SpeedParserBlue.AddVar('width');
  SpeedParserBlue.AddVar('height');
end;

procedure TMainForm.btnDrawClick(Sender: TObject);
var
  R, G, B: Byte;
  X, Y: Integer;
begin
  Screen.Cursor := crHourGlass;
  { Setting the parsestring property will cause the
    component to optimize the expression in memory }
  SpeedParserRed.ParseString := RedComponent.Text;
  SpeedParserGreen.ParseString := GreenComponent.Text;
  SpeedParserBlue.ParseString := BlueComponent.Text;
  with Image do
  begin
    { We set the variables 'width' and 'height' to the
      corresponding image properties }
    SpeedParserRed.SetVar('width', Width);
    SpeedParserRed.SetVar('height', Height);
    SpeedParserGreen.SetVar('width', Width);
    SpeedParserGreen.SetVar('height', Height);
    SpeedParserBlue.SetVar('width', Width);
    SpeedParserBlue.SetVar('height', Height);
  end;
  for Y := 0 to Image.Height do
  begin
    for X := 0 to Image.Width do
    begin
      { We calculate the RGB values for every pixel using the parse function }
      R := Round(SpeedParserRed.Parse(X, Y));
      G := Round(SpeedParserGreen.Parse(X, Y));
      B := Round(SpeedParserBlue.Parse(X, Y));
      Image.Canvas.Pixels[X, Y] := R + G shl 8 + B shl 16;
    end;
    if Y mod 64 = 0 then  Image.Repaint;
  end;
  Screen.Cursor := crDefault;
end;

procedure TMainForm.cmbPresetChange(Sender: TObject);
begin
  case cmbPreset.ItemIndex of
    0:begin
        RedComponent.Text := 'x+sin(y/2)*16+y+sin(x/2)*16';
        GreenComponent.Text := 'x+sin(y/2)*16+y+sin(x/2)*16';
        BlueComponent.Text := 'abs(x+y-255)';
      end;
    1:begin
        RedComponent.Text := '255-(x/width)*255';
        GreenComponent.Text := '(x/width)*255';
        BlueComponent.Text := '(y/height)*255';
       end;
    2:begin
        RedComponent.Text := 'abs(255-sqrt((x-127)*(x-127)+(y-127)*(y-127))/64)';
        GreenComponent.Text := 'abs(255-sqrt((x-127)*(x-127)+(y-127)*(y-127))/32)';
        BlueComponent.Text := 'abs(255-sqrt((x-127)*(x-127)+(y-127)*(y-127))/64)';
      end;
    3:begin
        RedComponent.Text := '-x*2+y';
        GreenComponent.Text := '-x*3+y*2';
        BlueComponent.Text := '0';
      end;

  end;
end;

procedure TMainForm.FormResize(Sender: TObject);
begin
  Image.Picture.Bitmap.Height := Image.Height;
  Image.Picture.Bitmap.Width := Image.Width;
end;

end.
