{
Unrar.Dll Dynamic Wrapper Component by Rogier Timmermans

version : 0.1c

changes since v0.1 :
------------------------------

v0.1a) 
- property ErrorOnDirExists : set to false to ignore "create error" events, when a directory already exists. 
                              Files will still generate the error. Default=False (So the default setting is to ignore existing directories !);

v01.b)
- UnRar.Dll can now have ANY name, could be usefull for temp. file generation...

v0.1c)
- Fixed v0.1b ; any name feature is now available; I uploaded the old source-file, that one only had some of the test code in
  there; this new version now has a property for the name, and, it's used in the extract-function as well now.
  Sorry for this little mistake...
}


unit RTdunRar;

interface
uses messages, windows, sysutils, dialogs, classes;

const
UnPack_UnRarDllNotLoaded =-101;
Unpack_ReadErr =101;
UnPack_OK =100;
UnPack_Opened=0;
UnPack_Stopped=255;

const
  rMaxCommentSize = 65535; {Modify this to change the limit of Comment size}

  erEndArchive    = 10; {End of archive} {Finished !}
  erNoMemory      = 11; {Not enough memory to initialize data structures} {This one bites, hopefully you'll never meet this one, i haven't yet...}
  erBadData       = 12; {Archive header broken} {Speaks for itself}
  erBadArchive    = 13; {File is not valid RAR archive} {same here}
  erUnknownFormat = 14; {UnKnown comment format} {i don't process comments, so i haven't seen it yet}
  erEOpen         = 15; {File open error}
  erECreate       = 16; {File create error} {File/dir already exists, or, due to a bug in the Dll, when dir exists, it also generates this}
  erEClose        = 17; {File close error}
  erERead         = 18; {Read error}
  erEWrite        = 19; {Write error}
  erSmallBuf      = 20; {Buffer too small, comments weren't read completely}

  opList          =  0; {Open archive for reading file headers only}
  opExtract       =  1; {Open archive for testing and extracting files}

  doSkip          =  0; {Move to the next file in archive}
                        {Warning: If the archive is solid and opExtract mode                                  was set when the archive was opened, the
                                  current file will be processed - the operation
                                  will be performed slower than a simple seek}
  doTest          =  1; {Test the current file and move to the next file in
                         the archive. If the archive was opened with opList mode,
                         the operation is equal to doSkip}
  doExtract       =  2; {Extract the current file and move to the next file.
                         If the archive was opened with opList mode,
                         the operation is equal to doSkip}

  moVolAsk        =  0; {Required volume is absent. The function should prompt
                         user and return non-zero value to retry the operation.
                         The function may also specify a new volume name,
                         placing it to ArcName parameter}
                         {!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
  moVolNotify     =  1; {Required volume is successfully opened. This is a
                         notification call and ArcName modification is NOT
                         allowed. The funciton should return non-zero value
                         to continue or a zero value to terminate operation}
                         {!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}

type
    TRARHeaderData = record
                    ArcName                            : array[1..260] of char;
                    FileName                           : array[1..260] of char;
                    Flags                              : Cardinal;
                    PackSize                           : Cardinal;
                    UnpSize                            : Cardinal;
                    HostOS                             : Cardinal;
                    FileCRC                            : Cardinal;
                    FileTime                           : Cardinal;
                    UnpVer                             : Cardinal;
                    Method                             : Cardinal;
                    FileAttr                           : Cardinal;
                    CmtBuf                             : PChar;
                    CmtBufSize, CmtSize, CmtState      : Cardinal;
                  end;

  TRAROpenArchiveData = record
                         ArcName                       : PChar;
                         OpenMode                      : Cardinal;
                         OpenResult                    : Cardinal;
                         CmtBuf                        : PChar;
                         CmtBufSize                    : Cardinal;
                         CmtSize                       : Cardinal;
                         CmtState                      : Cardinal;
                       end;

  TComment = record
               Size : Integer;
               Data : Array[1..rMaxCommentSize] of Char;
             end;

TChangeVolProc      = function (var ArcName : PChar; Mode : Integer) : Integer; cdecl;
TProcessDataProc    = function (Addr : PChar; Size : Integer) : Integer; cdecl;

var RAROpenArchive : function (var ArchiveData : TRAROpenArchiveData) : THandle; stdcall;
var RARCloseArchive: function (hArcData : THandle) : Integer; stdcall;
var RARReadHeader  : function (hArcData : THandle; var HeaderData : TRARHeaderData) : Integer; stdcall;
var RARProcessFile : function  (hArcData : THandle; Operation : Integer; DestPath, DestName : PChar) : Integer; stdcall;
var RARSetChangeVolProc  : procedure (hArcData : THandle; CVP : TChangeVolProc); stdcall;
var RARSetProcessDataProc: procedure (hArcData : THandle; PDP : TProcessDataProc); stdcall;
var RARSetPassword       : procedure (hArcData : THandle; Password : PChar); stdcall;

type TErrorProc          = procedure (Sender: TObject; Error : Integer) of object;
     TFileBeingExtracted = procedure (Sender: TObject; eFile : TRARHeaderData) of object;
     TFileExtracted      = procedure (Sender: TObject; eFile : TRARHeaderData; Result : Boolean) of object;
     TProcessDataProcN   = function (Sender: TObject; Addr : PChar; BlockSize, Position : Integer) : Integer of object;

Type TdRar=class(TComponent)
   private
     FArchive_file              : string;
     FTarget_dir                : string;
     FUnRarDllPath           : string;
     FUnRarDllName         : string; 

     FError                     : TErrorProc;
     FFileExtracted             : TFileExtracted;
     FFileBeingExtracted        : TFileBeingExtracted;
     FOnProgress                : TProcessDataProcN;
     FStop                      : Boolean;
     FErrorOnDirExists          : Boolean;

     FActualPos                 : Integer;
   protected
   public
    constructor Create(AOwner : TComponent); override;
    destructor Free;
    Function ExtractArchive:integer;
    Function GetRarErrorString(Error : Integer) : String;
   published
    property Archivefilename : string
      read FArchive_file write FArchive_file;
    property TargetDirectory : string
      read FTarget_Dir write FTarget_Dir;
    property Path2UnrarDll : string
      read FUnRarDllPath write FUnRarDllPath;
    property NameofUnrarDll : string
      read FUnRarDllName write FUnRarDllName;

    property Stop : Boolean
      read FStop write FStop default False;

    property ErrorOnDirExists : Boolean
     read FErrorOnDirExists write FErrorOnDirExists default False;

    property OnError : TErrorProc
      read FError write FError;
    property OnExtracting : TFileBeingExtracted
      read FFileBeingExtracted write FFileBeingExtracted;
    property OnExtract : TFileExtracted
      read FFileExtracted write FFileExtracted;
    property OnProcessData : TProcessDataProcN
      read FOnProgress write FOnProgress;
 end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Compression', [TdRAR]);
end;

//const
var  RarDllHandle:thandle=0;
//const
var UnRarHandle:thandle=0;

Function LoadRarDLL (const dllpath:string; const dllname:string) :boolean;
var DlPath, dlname:String;
var pt:pchar;
var oldmode:integer;
begin
  if RtdunRar.RarDllHandle<>0 then result:=true
  else begin
    if (dllpath[length(dllpath)]<>'\') then dlpath:=dllpath+'\'
      else dlpath:=dllpath; {path with \ or without... add a \ if there isn't one...}

   if dllname='' then dlname:='unrar.dll' else dlname:=dllname;
    pt:=pchar(dlpath+dlname); {now cast it}
    oldmode:=SetErrorMode($8001);
    RtdunRar.RarDllHandle:=LoadLibrary(pt);
    SetErrorMode(oldmode);
    if RtdunRar.RarDllHandle<>0 then begin
      @RAROpenArchive:=GetProcAddress(RtdunRar.RarDllHandle,'RAROpenArchive');
      @RARCloseArchive:=GetProcAddress(RtdunRar.RarDllHandle,'RARCloseArchive');
      @RARReadHeader:=GetProcAddress(RtdunRar.RarDllHandle,'RARReadHeader');
      @RARProcessFile:=GetProcAddress(RtdunRar.RarDllHandle,'RARProcessFile');
      @RARSetProcessDataProc:=GetProcAddress(RtdunRar.RarDllHandle,'RARSetProcessDataProc');
{      @RarSetPassword:=GetProcAddress(RarDllHandle,'RarSetPassword');
      @RarSetChangeVolProc:=GetProcAddress(RarDllHandle,'RarSetChangeVolProc');}

      if (@RarOpenArchive=nil) or (@RarCloseArchive=nil) or (@RarReadHeader=nil) or
         (@RarProcessFile=nil) or (@RarSetProcessDataProc=nil) then begin
        FreeLibrary(RtdunRar.RarDllHandle);
        RtdunRar.RarDllHandle:=0;
      end;
    end;
    result:=RtdunRar.RarDllHandle<>0;
  end;
end;

Procedure UnloadRarDll;
begin
  if RtdunRar.RarDllHandle<>0 then
    FreeLibrary(RtdunRar.RarDllHandle);
  RtdunRar.RarDllHandle:=0;
end;

procedure CloseRARfile;
begin
  if RtdunRar.unRARhandle<>0 then
    RARCloseArchive(RtdunRar.unRARhandle);
  RtdunRar.unRARhandle:=0;
end;

Function TdRar.GetRarErrorString(Error : Integer) : String;
begin
  case Error of
    UnPack_UnRarDllNotLoaded : Result:='Unable to load Unrar.Dll...';
    erEndArchive, UnPack_OK : Result:='End of archive, All Done !';
    erNoMemory      : Result:='Not enough memory to initialize data structures';
    erBadData       : Result:='CRC error, data damaged';
    erBadArchive    : Result:='File is not a valid RAR archive';
    erUnknownFormat : Result:='Unknown comment format';
    erEOpen         : Result:='File open error';
    erECreate       : Result:='File create error, either a ReadOnly-File or a directory that already exists...';
    erEClose        : Result:='File close error';
    erERead,Unpack_ReadErr : Result:='Read error';
    erEWrite        : Result:='Write error';
    erSmallBuf      : Result:='Buffer is too small for comment';
    UnPack_Stopped : Result:='Decompression Canceled by user !';
    else Result:='Unknown error !'+#13+'Code :'+inttostr(Error);
  end;
end;

constructor TdRAR.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FUnRarDllName:='unrar.dll';
end;

destructor TdRAR.Free;
begin
  inherited free;
end;

var xSelf:Pointer;

function ProcessDataProc(Addr : PChar; Size : Integer) : Integer; cdecl;
begin
  TdRAR(xSelf).FActualPos:=(TdRAR(xSelf).FActualPos+Size);
  Result:=TdRAR(xSelf).OnProcessData(xSelf,Addr,Size,TdRAR(xSelf).FActualPos);
end;

Function Tdrar.ExtractArchive:integer;
var RAROpenArchiveData:TRAROpenArchiveData;
    RARHeaderData:TRARHeaderData;
    err,res,temp:integer;
    Extractdone:boolean;
    s:string;
Begin
  xSelf:=Self;
  if (not LoadRARDll(Path2UnRarDll, NameofUnrarDll)) then
                                      begin
                                        if Assigned(onError) then OnError(Self,UnPack_UnRarDllNotLoaded);
                                        result:=UnPack_UnRarDllNotLoaded;
                                        exit;
                                       end;
  if unRARhandle=0 then begin  {open first!}
    fillchar(RAROpenArchiveData, sizeof(tRAROpenArchiveData),#0); {Clear it, just to make sure !}
    with RAROpenArchiveData do
      begin
        ArcName:=pchar(FArchive_file);        {Set the Archive File}
        OpenMode:=OpEXTRACT;     {Set the open-mode}
       end;
    unRARhandle:=RAROpenArchive(RAROpenArchiveData); {Now open the Archive and gobble up some memory}

    case RAROpenArchiveData.OpenResult of {What did opening report ?}
      0: begin Res:=unPack_opened; end; {openend}
      erBadData : begin res:=erBadData;if Assigned(OnError) then OnError(Self,RarOpenArchiveData.OpenResult); end;
      erBadArchive: begin res:=erBadArchive;if Assigned(OnError) then OnError(Self,RarOpenArchiveData.OpenResult);end;
     else
      begin res:=unPack_ReadErr;if Assigned(OnError) then OnError(Self,RarOpenArchiveData.OpenResult);end;
    end;

    if (res<>unpack_opened) then begin {if not opened ok, bail !}
                                if Assigned(OnError) then OnError(Self,Res);
                                Result:=Res;
                                CloseRARfile;
                                UnloadRarDll;
                                Exit;
                               end;
    RARSetProcessDataProc(unRARhandle,@ProcessDataProc); {Set the processing procedure}
  end else
    result:=unpack_opened;
  fillchar(RARHeaderData,sizeof(TRARHeaderData),#0); // fill with 0 to make sure it's clean
  extractdone:=false; // we're not done
  repeat
     err:=RARReadHeader(unRARhandle,RARHeaderData);
     if FStop then // stop pressed, now clean up & exit
      begin
        CloseRarFile;
        UnloadRarDll;
        err:=UnPack_Stopped;
        Result:=Err;
        FStop:=False;
        Exit;
      end;
    if err<>0 then // something went wrong, so notify user...
       begin
         if Assigned(OnError) then OnError(Self, err);
         result:=Err;
         CloseRARfile;
         UnloadRarDll;
         exit;
        end;
      S:='';
        for Temp:=1 to SizeOf(RarHeaderData.FileName) do
          if RarHeaderData.FileName[Temp]=#00 then break
           else S:=S+RarHeaderData.FileName[Temp]; // get filename from RarHeader
      if Assigned(OnExtracting) then OnExtracting(Self, RarHeaderData);
      FActualPos:=0;
      err:=RARProcessFile(unRARhandle,doEXTRACT,pchar(Targetdirectory),nil);
      if (FErrorOnDirExists=false) and (err =erECreate) and (RarHeaderData.Flags and 128=128) and (RarHeaderData.Flags and 64=64)and (RarHeaderData.Flags and 32=32)then err:=0; // ignore "dir-create" error if it already existed
      if Assigned(OnExtract) then OnExtract(Self, RarHeaderData, (err=0));
    if err<>0 then begin
      If Assigned(OnError) then OnError(Self,err); // insert your extensions here...
      if (err in [erEndArchive, UnPack_Stopped]) then result:=Unpack_Stopped else result:=err;
      extractdone:=true;
    end;
  until extractdone;
  CloseRARfile; // make sure we return the memory we gobbled up; if it's already gone, this won't do a thing...
  UnloadRarDll; // make sure we get rid of the Dll ; if it's already gone, it doesn't do anything
end;

end.
