{
          UnAce.dll dynamic wrapper component v0.1
                     by Rogier Timmermans
-------------------------------------------------------------
              Contact info : MagicRT@Hotmail.com
-------------------------------------------------------------
Based on "delphi-example" from Christian Ghisler which is
included with the Dll. I just made the component...

There's also a wrapper for Unrar.Dll that i made a few days
earlier, mail me if you want it.

}

unit RTdunAce;

interface
uses messages, windows, sysutils, dialogs, classes;

const

  UnPack_UnAceDllNotLoaded =-101;
  UnPack_OK =100;
  UnPack_Stopped=110;
  UnPack_Done =0;
  Unpack_ReadErr =101;

  ACEERR_MEM=      1;
  ACEERR_FILES=    2;
  ACEERR_FOUND=    3;
  ACEERR_FULL=     4;
  ACEERR_OPEN=     5;
  ACEERR_READ=     6;
  ACEERR_WRITE=    7;
  ACEERR_CLINE=    8;
  ACEERR_CRC=      9;
  ACEERR_OTHER=   10;
  ACEERR_EXISTS=  11;
  ACEERR_END=      128;
  ACEERR_HANDLE=   129;
  ACEERR_CONSTANT= 130;
  ACEERR_NOPASSW=  131;
  ACEERR_METHOD=   132;
  ACEERR_USER=   255;

  ACEOPEN_LIST=    0;
  ACEOPEN_EXTRACT= 1;

  ACECMD_SKIP=     0;
  ACECMD_TEST=     1;
  ACECMD_EXTRACT=  2;

  ACEVOL_REQUEST=  0;
  ACEVOL_OPENED=   1;


  ACESEL_YES=      0;
  ACESEL_ALWAYS=   1;
  ACESEL_NO=       2;
  ACESEL_CANCEL=   3;

  ACECMT_OK=       0;
  ACECMT_SMALLBUF= 1;
  ACECMT_NONE=   255;

type
  pbyte=^byte;
  TChangeVolProc=function(ArcName:pchar;Mode:longint):longint;
  TProcessDataProc=function(Addr:pbyte;Size:longint):longint;

type
  TACEHeaderData=packed record
    ArcName:array [0..259] of char;
    FileName:array [0..259] of char;
    Flags,
    PackSize,
    UnpSize,
    FileCRC,
    FileTime,
    Method,
    QUAL,
    FileAttr:longint;
    CmtBuf:pchar;
    CmtBufSize,
    CmtSize,
    CmtState:longint;
  end;

  tACEOpenArchiveData=packed record
    ArcName:pchar;
    OpenMode,
    OpenResult,
    Flags,
    Host:longint;
    AV:array[0..50] of char;
    CmtBuf:pchar;
    CmtBufSize,
    CmtSize,
    CmtState:longint;
    ChangeVolProc:TChangeVolProc;
    ProcessDataProc:TProcessDataProc;
  end;

type
  TACEOpenArchive=function(var ArchiveData:tACEOpenArchiveData):thandle; stdcall;
  TACECloseArchive=function(hArcData:thandle):longint; stdcall;
  TACEReadHeader=function(hArcData:thandle;var HeaderData:TACEHeaderData):longint; stdcall;
  TACEProcessFile=function(hArcData:thandle;Operation:longint;DestPath:pchar):longint; stdcall;
  TACESetPassword=function(hArcData:thandle;Password:pchar):longint; stdcall;

var
  ACEOpenArchive:TACEOpenArchive;
  ACECloseArchive:TACECloseArchive;
  ACEReadHeader:TACEReadHeader;
  ACEProcessFile:TACEProcessFile;
  ACESetPassword:TACESetPassword;


type TErrorProc          = procedure (Sender: TObject; Error : Integer) of object;
     TFileBeingExtracted = procedure (Sender: TObject; eFile : TAceHeaderData) of object;
     TFileExtracted      = procedure (Sender: TObject; eFile : TAceHeaderData; Result : Boolean) of object;
     TProcessDataProcN   = function (Sender: TObject; Addr : Pbyte; BlockSize, Position : Integer) : Integer of object;

Type TdAce=class(TComponent)
   private
     FArchive_file              : string;
     FTarget_dir                : string;
     FUnAceDllPath              : string;

     FError                     : TErrorProc;
     FFileExtracted             : TFileExtracted;
     FFileBeingExtracted        : TFileBeingExtracted;
     FOnProgress                : TProcessDataProcN;
     FStop                      : Boolean;

     FActualPos                 : Integer;
   protected
   public
    constructor Create(AOwner : TComponent); override;
    destructor Free;
    Function UnAcefile_Extract_component:integer;
   published
    property Archivefilename : string
      read FArchive_file write FArchive_file;
    property TargetDirectory : string
      read FTarget_Dir write FTarget_Dir;
    property Path2UnAceDll : string
      read FUnAceDllPath write FUnAceDllPath;

    property Stop : Boolean
      read FStop write FStop default False;

    property OnError : TErrorProc
      read FError write FError;
    property OnExtracting : TFileBeingExtracted
      read FFileBeingExtracted write FFileBeingExtracted;
    property OnExtract : TFileExtracted
      read FFileExtracted write FFileExtracted;
    property OnProcessData : TProcessDataProcN
      read FOnProgress write FOnProgress;
 end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Compression', [TdACE]);
end;

const AceDllHandle:thandle=0;
const UnAceHandle:thandle=0;

constructor TdAce.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
end;

destructor TdAce.Free;
begin
  inherited free;
end;

Procedure UnloadAceDll;
begin
  if RtdunAce.AceDllHandle<>0 then
    FreeLibrary(RtdunAce.AceDllHandle);
  RtdunAce.AceDllHandle:=0;
end;

procedure CloseAcefile;
begin
  if RtdunAce.unAcehandle<>0 then
    AceCloseArchive(RtdunAce.unAcehandle);
  RtdunAce.unAcehandle:=0;
end;

Function LoadAceDLL (const dllpath:string) :boolean;
var DlPath:String;
var pt:pchar;
var oldmode:integer;
begin
  if RtdunAce.AceDllHandle<>0 then result:=true
  else begin
    if (dllpath[length(dllpath)]<>'\') then dlpath:=dllpath+'\'
      else dlpath:=dllpath;
    pt:=pchar(dlpath+'unace.dll');
    oldmode:=SetErrorMode($8001);
    RtdunAce.AceDllHandle:=LoadLibrary(pt);
    SetErrorMode(oldmode);
    if RtdunAce.AceDllHandle<>0 then begin

      @ACEOpenArchive:=GetProcAddress(RtdunAce.AceDllHandle,'ACEOpenArchive');
      @ACECloseArchive:=GetProcAddress(RtdunAce.AceDllHandle,'ACECloseArchive');
      @ACEReadHeader:=GetProcAddress(RtdunAce.AceDllHandle,'ACEReadHeader');
      @ACEProcessFile:=GetProcAddress(RtdunAce.AceDllHandle,'ACEProcessFile');
      @ACESetPassword:=GetProcAddress(RtdunAce.AceDllHandle,'ACESetPassword');
      if (@ACEOpenArchive=nil) or (@ACECloseArchive=nil) or (@ACEReadHeader=nil) or
         (@ACEProcessFile=nil) or (@ACESetPassword=nil) then begin
        FreeLibrary(RtdunAce.AceDllHandle);
        RtdunAce.AceDllHandle:=0;
      end;
    end;
    result:=RtdunAce.AceDllHandle<>0;
  end;
end;

var xself:pointer;

function ProgressProc(Addr:pbyte;Size:longint):longint;
begin
  TdAce(xself).FActualPos:=(TdAce(xSelf).FActualPos+Size);
  TdAce(xself).OnProcessData(xself,Addr,size,TdAce(xself).FActualPos); {fire event}
  Result:=ord(not tdAce(xself).stop); // interupt unpacking immediately, returns 255
end;

function ChangeProc(ArcName:pchar;Mode:longint):longint;
begin
result:=1; // not implemented
end;

Function TdAce.UnAcefile_Extract_component:integer;
var ACEOpenArchiveData:tACEOpenArchiveData;
    ACEHeaderData:tACEHeaderData;
    err:integer;
    temp:integer;
    Extractdone:boolean;
    s:string;
Begin
  xSelf:=Self;
  if (not LoadAceDll(Path2UnAceDll)) then
                                      begin
                                        if Assigned(onError) then OnError(Self,UnPack_UnAceDllNotLoaded);
                                        result:=UnPack_UnAceDllNotLoaded;
                                        exit;
                                       end;
  if unAcehandle=0 then begin  {open first!}
    fillchar(AceOpenArchiveData, sizeof(tAceOpenArchiveData),#0); {Clear it, just to make sure !}
    with AceOpenArchiveData do begin
      ArcName:=pchar(FArchive_file);        {Set the Archive File}
      OpenMode:=ACEOPEN_EXTRACT;     {Set the open-mode}
      ProcessDataProc:=@ProgressProc;
      ChangeVolProc:=@ChangeProc;
    end;
    unAcehandle:=AceOpenArchive(AceOpenArchiveData); {Now open the Archive and gobble up some memory}
    err:=ACEOpenArchiveData.OpenResult;
    if err<>0 then begin {if not opened ok, bail !}
                                if Assigned(OnError) then OnError(Self,err);
                                CloseAcefile;
                                UnloadAceDll;
                                result:=err;
                                exit;
                               end;
  end else
    result:=err;
  fillchar(AceHeaderData,sizeof(TAceHeaderData),#0);
  extractdone:=false;
  repeat
     err:=AceReadHeader(unAcehandle,AceHeaderData);
     if FStop then
      begin
        FStop:=False;
        result:=UnPack_Stopped;
        CloseAceFile;
        UnloadAceDll;
        Exit;
      end;
    if err<>0 then
       begin
         if Assigned(OnError) then OnError(Self, err);
         if err=UnPack_Stopped then Result:=UnPack_Stopped;
         if Err=ACEERR_END then Result:=ACEERR_END;
         if (err<>ACEERR_END) and (err<>UnPack_Stopped) then result:=Unpack_ReadErr; // general read error, -> error in header isn't funny anyway...
         CloseAcefile;
         UnloadAceDll;
         exit;
        end;
      S:=''; for Temp:=1 to SizeOf(AceHeaderData.FileName) do if AceHeaderData.FileName[Temp]=#00 then break else S:=S+AceHeaderData.FileName[Temp]; // get filename from RarHeader
      if Assigned(OnExtracting) then OnExtracting(Self, AceHeaderData);
      FActualPos:=0;
      if TargetDirectory[length(TargetDirectory)]<>'\' then TargetDirectory:=TargetDirectory+'\';
      err:=AceProcessFile(unAcehandle,ACECMD_EXTRACT,pchar(TargetDirectory+AceHeaderData.Filename));
      if Assigned(OnExtract) then OnExtract(Self, AceHeaderData, err=0);
    if err<>0 then begin
      If Assigned(OnError) then OnError(Self,err);
      extractdone:=true;
    end;
  until extractdone;
  CloseAcefile; // make sure we return the memory we gobbled up; if it's already gone, this won't do a thing...
  UnloadAceDll; // make sure we get rid of the Dll ; if it's already gone, it doesn't do anything
  result:=err;
end;
end.
