//PROFILE-NO
unit Profonli;
interface

uses
  Windows,
  Forms, Controls, StdCtrls,
  Classes,
  SysUtils, ComCtrls, ExtCtrls;
{$H-}
{$V-}                 
{$O-}           
{$D-}     
{$B-}
{$Q-}               
{$I-}               
{$R-}       
{$A+}
{$W+}
{$J+}
{$T+}
{$X+}
{$WARNINGS OFF}

PROCEDURE ProfOnlineOperation;

TYPE
  TOnlineProform = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Panel1: TPanel;
    CycBut: TCheckBox;
    MinLab: TLabel;
    FrequAnz: TTrackBar;
    Label6: TLabel;
    CycTimer: TTimer;
    Panel2: TPanel;
    RunId: TLabel;
    Label5: TLabel;
    Label1: TLabel;
    CPUFrequenz: TLabel;
    Label3: TLabel;
    GroupBox2: TGroupBox;
    Edit1: TEdit;
    procedure StarteMessung(Sender: TObject);
    procedure StoppeMessung(Sender: TObject);
    procedure Anhaengen(Sender: TObject);
    procedure Erzeugen(Sender: TObject);
    procedure ResultatLoeschen(Sender: TObject);
    procedure Zerstoeren(Sender: TObject);
    procedure TickChange(Sender: TObject);
    procedure ActDeact(Sender: TObject);
    procedure CycAppend(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure ButtonOnOff;
  public
    { Public-Deklarationen }
    IstAktiv : Boolean;
    RunNr    : Integer;
  end;

var
  OnlineProform: TOnlineProform;

{$R *.dfm}

IMPLEMENTATION
USES
  Profint;

FUNCTION  GetMHZ120    : Integer; external 'PROFMEAS.DLL';
FUNCTION  ProfIstAktiv : Boolean; external 'PROFMEAS.DLL';
PROCEDURE ProfResultatLoeschen;   external 'PROFMEAS.DLL';


VAR
  winxpos : Integer;
  winypos : Integer;
  toppos  : Integer;

PROCEDURE ProfOnlineOperation;
VAR
  hs : String;
BEGIN
  Application.CreateForm(TOnlineProForm, OnlineProForm);
  OnLineProForm.Caption := 'ProDelphi - online operation';
  Str(GetMHz120,hs);
  OnlineProForm.CPUFrequenz.Caption := hs;
//  OnlineProForm.Edit1.text := 'CPU performs with ' + hs + ' MHz';
END;

FUNCTION GetIniFile : String;
BEGIN
  Result := ExtractFilePath(ParamStr(0)) + 'profile.ini';
END;

procedure TOnlineProform.StarteMessung(Sender: TObject);
begin
  ProfActivate;
  ButtonOnOff;
end;

procedure TOnlineProform.StoppeMessung(Sender: TObject);
begin
  ProfDeactivate;
  ButtonOnOff;
END;

procedure TOnlineProform.Anhaengen(Sender: TObject);
VAR
  txt : Array[0..255] OF Char;
  Run : String;
BEGIN
  StrPLCopy(txt, OnlineProForm.Edit1.Text +
                 ' (Run: ' + RunId.Caption + ')', 255);
  ProfSetComment(txt);
  ProfAppendResults(FALSE);
  INC(RunNr);
  Str(RunNr, Run);
  RunId.Caption := Run;
END;

procedure TOnlineProform.Erzeugen(Sender: TObject);
BEGIN
  RunNr := 1;
  IF winxpos <> -1 THEN BEGIN
    Left := winxpos;
    Top  := Winypos;
  END;
  IF TopPos <> 0 THEN
    SetWindowPos(handle, HWND_TOPMOST, 0, 0, 0, 0,
                 SWP_NOSIZE OR SWP_NOMOVE OR SWP_SHOWWINDOW);
  ButtonOnOff;
END;

procedure TOnlineProform.ButtonOnOff;
BEGIN
  IF ProfIstAktiv = TRUE THEN BEGIN
    Button1.Enabled := FALSE;
    Button2.Enabled := TRUE;
    END
  ELSE BEGIN
    Button2.Enabled := FALSE;
    Button1.Enabled := TRUE;
  END;
END;

procedure TOnlineProform.ResultatLoeschen(Sender: TObject);
BEGIN
  ProfResultatLoeschen;
END;

procedure TOnlineProform.Zerstoeren(Sender: TObject);
VAR
  rect   : TRect;
  xp, yp : Array[0..24] OF Char;
  namec  : Array[0..255] OF Char;
BEGIN
  StrPCopy(namec, GetIniFile);
  GetWindowRect(handle, rect);
  Str(rect.top, yp);
  Str(rect.left, xp);
  WritePrivateProfileString('PROFILER','SCREEN-X',xp,namec);
  WritePrivateProfileString('PROFILER','SCREEN-Y',yp,namec);
END;

PROCEDURE InitUnit;
VAR
  namec   : Array[0..255] OF Char;
  tmpbuff : Array[0..255] OF Char;
  anzeige : Integer;
BEGIN
  StrPCopy(namec, GetIniFile);
  GetPrivateProfileString('PROFILER','SCREEN-X','-1',tmpbuff,SizeOf(tmpbuff)-1,namec);
  VAL(tmpbuff, winxpos, anzeige);
  IF anzeige <> 0 THEN
    Winxpos := -1;
  GetPrivateProfileString('PROFILER','SCREEN-Y','-1',tmpbuff,SizeOf(tmpbuff)-1,namec);
  VAL(tmpbuff, winypos, anzeige);
  IF anzeige <> 0 THEN
    Winypos := -1;
  GetPrivateProfileString('PROFILER','ONTOP','0',tmpbuff,SizeOf(tmpbuff)-1,namec);
  VAL(tmpbuff, toppos, anzeige);
END;

procedure TOnlineProform.TickChange(Sender: TObject);
VAR
  hs : String;
begin
  CycTimer.Enabled := FALSE;
  Str(FrequAnz.Position, hs);
  MinLab.Caption := hs;
  CycTimer.Interval := FrequAnz.Position * 60000;
  IF CycBut.Checked = TRUE THEN
    CycTimer.Enabled := TRUE;
end;

procedure TOnlineProform.ActDeact(Sender: TObject);
begin
  IF CycBut.Checked = TRUE THEN BEGIN
    CycTimer.Enabled := TRUE;
    FrequAnz.Visible := FALSE;
    END
  ELSE BEGIN
    CycTimer.Enabled := FALSE;
    FrequAnz.Visible := TRUE;
  END;
end;

procedure TOnlineProform.CycAppend(Sender: TObject);
BEGIN
  Edit1.Text := DateTimeToStr(Now);
  Anhaengen(Sender);
end;

INITIALIZATION
  InitUnit;
END.
