unit DemoX;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ToolWin, ComCtrls, PDJSound, ImgList, Buttons, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    PDJSound1: TPDJSound;
    ListView1: TListView;
    ImageList1: TImageList;
    StatusBar1: TStatusBar;
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    ToolButton1: TSpeedButton;
    ToolButton2: TSpeedButton;
    ToolButton3: TSpeedButton;
    ToolButton6: TSpeedButton;
    ToolButton5: TSpeedButton;
    ToolButton8: TSpeedButton;
    ToolButton10: TSpeedButton;
    ToolButton12: TSpeedButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    procedure ToolButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure ToolButton8Click(Sender: TObject);
    procedure ToolButton10Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure StatusBar1DrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
    procedure ToolButton12Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure PDJSound1Play(Sender: TObject);
    procedure PDJSound1Stop(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Path:string;
implementation

uses About;

const

Copyright = 'Copyright  2000-2001 by Peric';
{$R *.DFM}

procedure TForm1.ToolButton1Click(Sender: TObject);
begin
PDJSound1.SoundFile:=ListView1.Items[0].SubItems[0];
PDJSound1.play;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
Toolbutton5.enabled:=False;
Path:=ExtractFilePath(Application.ExeName);
end;


procedure TForm1.ToolButton2Click(Sender: TObject);
begin
PDJSound1.SoundFile:=ListView1.Items[1].SubItems[0];
PDJSound1.play;
end;

procedure TForm1.ToolButton3Click(Sender: TObject);
begin
PDJSound1.SoundFile:=ListView1.Items[2].SubItems[0];
PDJSound1.play;
end;

procedure TForm1.ToolButton6Click(Sender: TObject);
begin
PDJSound1.SoundFile:=ListView1.Items[3].SubItems[0];
PDJSound1.play;
end;

procedure TForm1.ToolButton8Click(Sender: TObject);
begin
PDJSound1.stop;
end;

procedure TForm1.ToolButton10Click(Sender: TObject);
begin
with OpenDialog1 do
if execute then
begin
ListView1.Items.Clear;
FormShow(self);
With ListView1.Items do
With Add do
begin
Caption:='Custom Sound';
ImageIndex:=0;
SubItems.Add(FileName);
end;
end;
Toolbutton5.enabled:=True;
end;


procedure TForm1.FormShow(Sender: TObject);
var
N:integer;
begin
With ListView1.Items do
For N:=1 to 4 do
With Add do
begin
Caption:='Sound No. '+ IntToStr(N);
ImageIndex:=0;
Case N of
1:
SubItems.Add(Path+'Hello.wav');
2:
SubItems.Add(Path+'Fire2.wav');
3:
SubItems.Add(Path+'Byebye1.wav');
4:
SubItems.Add(Path+'Nooo.wav');
end;
end;
application.OnHint:=FormActivate;
end;

procedure TForm1.ToolButton5Click(Sender: TObject);
begin
PDJSound1.SoundFile:=ListView1.Items[4].SubItems[0];
PDJSound1.play;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
StatusBar1.Panels[0].text:=Application.Hint;
end;

procedure TForm1.StatusBar1DrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
  var
  Icon: HIcon;
  R:TRect;
  begin
with StatusBar.Canvas do begin
iF Panel.index = 1 then begin
Icon := LoadIcon(HInstance, PChar('MAINICON'));
DrawIconEx(Handle, Rect.Left+2,4,Icon, 13,13,0,0, DI_Normal);
R.Left:=Rect.Left+23;
R.Top:=3;
R.Right:=Rect.Left+23+TextWidth(Copyright);
R.Bottom:=3+TextHeight(Copyright);
DrawText(Handle,PChar(Copyright),Length(Copyright),R, DT_LEFT );
end;

end;
end;

procedure TForm1.ToolButton12Click(Sender: TObject);
begin
Form2.Showmodal
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
if CheckBox1.Checked then begin
CheckBox1.Caption:='Event ON';
end
else
begin
CheckBox1.Caption:='Event OFF';
caption:='PDJSound Demo';
end;
end;

procedure TForm1.PDJSound1Play(Sender: TObject);
begin
if CheckBox1.Checked then
Caption:='Play Sound';
end;

procedure TForm1.PDJSound1Stop(Sender: TObject);
begin
if CheckBox1.Checked then
Caption:='Stop Sound';
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
If CheckBox2.Checked then
PDJSound1.LoopSound:=True else
PDJSound1.LoopSound:=False;
end;

end.
