unit PDJSound;

// TPDJSound version 1.00
// Freeware Component for D3,D4,D5,D6
// Copyright  2000-2001 by Peric
// Birthday of Component 07.04.2001.
// E-mail: pericddn@ptt.yu
// If I' find any errors or rubbish in PDJSound please send me Your suggest or Reclamation.

{$IFDEF VER100}
  {$DEFINE PDJ_D3}
{$ELSE}
  {$IFDEF VER120}
    {$DEFINE PDJ_D4}
  {$ELSE}
    {$DEFINE PDJ_D5Up}
  {$ENDIF}
{$ENDIF}


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs
  ,MMSystem;

  {$R PDJSound.res}
  
  type
  TOnPlayEvent = procedure(Sender: TObject) of object;
  TOnStopEvent = procedure(Sender: TObject) of object;
  TPDJSound = class(TComponent)

  private
  
   FOnPlay:TOnPlayEvent;
   FOnStop:TOnStopEvent;
   FLoop:boolean;
   W:integer;
   FVersion,FSoundFile:string;
   function GetVersion:string;
   procedure SetVersion(const value:string);
   procedure SetLoop(value:boolean);

  protected

  public

   constructor Create(Aowner:Tcomponent);override;
   destructor Destroy; override;
   procedure Play;
   procedure Stop;

  published

   property SoundFile:string read FSoundFile write FSoundFile;
   property Version:string read GetVersion write SetVersion;
   property OnPlay: TOnPlayEvent read FOnPlay write FOnPlay;
   property OnStop: TOnStopEvent read FOnStop write FOnStop;
   property LoopSound: boolean read FLoop write SetLoop default False;
  end;

procedure Register;

implementation


procedure Register;
begin
  RegisterComponents('PDJ', [TPDJSound]);
end;

constructor TPDJSound.Create(AOwner:TComponent);
begin
inherited Create(AOwner);
FVersion:='Version 1.00, Copyright  2000-2001 by Peric, E-mail: pericddn@ptt.yu';
FLoop:=False;
end;

function TPDJSound.GetVersion:string;
begin
Result:=FVersion;
end;

procedure TPDJSound.SetVersion(const value:string);
begin
FVersion:=FVersion;
end;

procedure TPDJSound.Play;
begin
if FLoop then
sndPlaySound(pchar(FSoundFile), snd_Async or snd_NoDefault or SND_LOOP)else
sndPlaySound(pchar(FSoundFile), snd_Async or snd_NoDefault );
if Assigned(FOnPlay) then begin FOnPlay(Self);
W:=1;
end;
end;

procedure TPDJSound.SetLoop(value:boolean);
begin
if value<>FLoop then
FLoop:=value;
end;

procedure TPDJSound.Stop;
begin
sndPlaySound(nil, snd_Async or snd_NoDefault);
if W=1 then
if Assigned(FOnStop) then FOnStop(Self);
end;

destructor TPDJSound.Destroy;
begin
  inherited Destroy;
end;

end.
