{Author:	Poul Bak}
{Copyright  1999-2001 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft-denmark@dk2net.dk}

{Component Version: 5.00.00.00}
{PBSystemPath gives easy access to systempaths, see Shellfolders.txt to see why
you shall use PBSystemPath.}
{The paths are detected at runtime.}
{A tip: In your code, check if the property is empty (=''). As you can see in
Shellfolders.txt not all paths are supported by all windows-versions.}
unit PBSystem;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	Registry;

type
	TPBSystemPath = class(TComponent)
	private
		{ Private declarations }
		FIncludeBackSlash : Boolean;
		FAppData, FCache, FCookies, FDeskTop, FFavorites : string;
		FFonts, FHistory, FNetHood, FPersonal, FPrintHood : string;
		FPrograms, FRecent, FSendTo, FStartMenu, FStartUp : string;
		FTemplates, FWindows, FSystem, FTemp : string;
		FCommonFiles, FConfig, FDevice, FMedia, FOtherDevice : string;
		FProgramFiles, FSystemRoot, FWallPaper : string;
		FVersion, FMyPictures, FLocalSettings, FLocalAppData, FContent : string;
		function ReplaceEnvString(const TempString : string) : string;
		function FullPath(const Path : string) : string;
		procedure SetIncludeBackSlash(const Value : Boolean);
		procedure Dummy(const Value: String);
		procedure GetPaths;
	protected
		{ Protected declarations }
	public
		{ Public declarations }
		constructor Create(AOwner: TComponent); override;
	published
		{ Published declarations }
{When IncludeBackSlash is True the paths always end with a backslash '\'.
Normally Windows only end a path with '\' if it is a root dir.
When you are sure a path ends with '\' you can simply add the path and
the filename to build a fully qualified filename.
This is compatiple with ExtractFilePath.}
		property IncludeBackSlash : Boolean read FIncludeBackSlash
			write SetIncludeBackSlash;
		property AppData : string read FAppData write Dummy stored False;
		property Cache : string read FCache write Dummy stored False;
		property Cookies : string read FCookies write Dummy stored False;
		property DeskTop : string read FDeskTop write Dummy stored False;
		property Favorites : string read FFavorites write Dummy stored False;
		property Fonts : string read FFonts write Dummy stored False;
		property History : string read FHistory write Dummy stored False;
		property NetHood : string read FNetHood write Dummy stored False;
		property Personal : string read FPersonal write Dummy stored False;
		property PrintHood : string read FPrintHood write Dummy stored False;
		property Programs : string read FPrograms write Dummy stored False;
		property Recent : string read FRecent write Dummy stored False;
		property SendTo : string read FSendTo write Dummy stored False;
		property StartMenu : string read FStartMenu write Dummy stored False;
		property StartUp : string read FStartUp write Dummy stored False;
		property Templates : string read FTemplates write Dummy stored False;
		property Windows : string read FWindows write Dummy stored False;
		property System : string read FSystem write Dummy stored False;
		property Temp : string read FTemp write Dummy stored False;
		property CommonFiles : string read FCommonFiles write Dummy stored False;
		property Config : string read FConfig write Dummy stored False;
		property Device : string read FDevice write Dummy stored False;
		property Media : string read FMedia write Dummy stored False;
		property OtherDevice : string read FOtherDevice write Dummy stored False;
		property ProgramFiles : string read FProgramFiles write Dummy stored False;
		property SystemRoot : string read FSystemRoot write Dummy stored False;
		property WallPaper : string read FWallPaper write Dummy stored False;
		property ComponentVersion : string read FVersion write Dummy stored False;
		property MyPictures : string read FMyPictures write Dummy stored False;
		property LocalSettings : string read FLocalSettings write Dummy stored False;
		property LocalAppData : string read FLocalAppData write Dummy stored False;
		property Content : string read FContent write Dummy stored False;
	end;

procedure Register;

implementation

constructor TPBSystemPath.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
	FIncludeBackSlash := True;
	FVersion := '5.00.00.00';
	GetPaths;
end;

procedure TPBSystemPath.Dummy(const Value: String);
begin
//	Read only !
end;

procedure TPBSystemPath.SetIncludeBackSlash(const Value : Boolean);
begin
	if FIncludeBackSlash <> Value then
	begin
		FIncludeBackSlash := Value;
		GetPaths;
	end;
end;

procedure TPBSystemPath.GetPaths;
var
	PText : array[0..MAX_PATH] of Char;
	Reg : TRegistry;
begin
	GetWindowsDirectory(PText, MAX_PATH);
	FWindows := FullPath(String(PText));
	GetSystemDirectory(PText, MAX_PATH);
	FSystem := FullPath(String(PText));
	GetTempPath(MAX_PATH, PText);
	FTemp := FullPath(String(PText));
	Reg := TRegistry.Create;
	if Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False) then
	begin
		FAppData := ReplaceEnvString(Reg.ReadString('AppData'));
		FCache := ReplaceEnvString(Reg.ReadString('Cache'));
		FCookies := ReplaceEnvString(Reg.ReadString('Cookies'));
		FDeskTop := ReplaceEnvString(Reg.ReadString('DeskTop'));
		FFavorites := ReplaceEnvString(Reg.ReadString('Favorites'));
		FFonts := ReplaceEnvString(Reg.ReadString('Fonts'));
		FHistory := ReplaceEnvString(Reg.ReadString('History'));
		FNetHood := ReplaceEnvString(Reg.ReadString('NetHood'));
		FPersonal := ReplaceEnvString(Reg.ReadString('Personal'));
		FPrintHood := ReplaceEnvString(Reg.ReadString('PrintHood'));
		FPrograms := ReplaceEnvString(Reg.ReadString('Programs'));
		FRecent := ReplaceEnvString(Reg.ReadString('Recent'));
		FSendTo := ReplaceEnvString(Reg.ReadString('SendTo'));
		FStartMenu := ReplaceEnvString(Reg.ReadString('Start Menu'));
		FStartUp := ReplaceEnvString(Reg.ReadString('StartUp'));
		FTemplates := ReplaceEnvString(Reg.ReadString('Templates'));
		FMyPictures := ReplaceEnvString(Reg.ReadString('My Pictures'));
		FLocalSettings := ReplaceEnvString(Reg.ReadString('Local Settings'));
		FLocalAppData := ReplaceEnvString(Reg.ReadString('Local AppData'));
		FContent := ReplaceEnvString(Reg.ReadString('Content'));
	end;
	Reg.RootKey := HKEY_LOCAL_MACHINE;
	if Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False) then
	begin
		FCommonFiles := ReplaceEnvString(Reg.ReadString('CommonFilesDir'));
		FConfig := ReplaceEnvString(Reg.ReadString('ConfigPath'));
		FDevice := ReplaceEnvString(Reg.ReadString('DevicePath'));
		FMedia := ReplaceEnvString(Reg.ReadString('MediaPath'));
		FOtherDevice := ReplaceEnvString(Reg.ReadString('OtherDevicePath'));
		FProgramFiles := ReplaceEnvString(Reg.ReadString('ProgramFilesPath'));
		FSystemRoot := ReplaceEnvString(Reg.ReadString('SystemRoot'));
		FWallPaper := ReplaceEnvString(Reg.ReadString('WallPaperDir'));
	end;
	Reg.Free;
end;

function TPBSystemPath.FullPath(const Path : string) : string;
begin
	if Path = '' then Result := ''
	else if (Path[Length(Path)] ='\') or (not FIncludeBackSlash)
		then Result := Path
	else Result := Path + '\';
end;

function TPBSystemPath.ReplaceEnvString(const TempString : string) : string;
var
	EnvVar : string;
	EnvPart : Boolean;
	t, EnvStart, EnvEnd : integer;
	EnvBuf : array[0..MAX_PATH] of Char;
begin
	Result := TempString;
	if Result <> '' then
	begin
		EnvVar := '';
		EnvPart := False;
		EnvStart := 0;
		EnvEnd := 0;
		for t := 1 to Length(Result) do
		begin
			if Result[t] = '%' then
			begin
				EnvPart := not EnvPart;
				if EnvPart then EnvStart := t
				else EnvEnd := t;
			end;
		end;
		if (EnvEnd > EnvStart) and (EnvStart > 0) then
		begin
			EnvVar := Copy(Result, EnvStart + 1, EnvEnd - EnvStart - 1);
			if GetEnvironmentVariable(PChar(EnvVar), EnvBuf, MAX_PATH) <> 0
				then Result := Copy(Result, 1, EnvStart - 1) + String(EnvBuf)
				+ Copy(Result, EnvEnd + 1, Length(Result) - EnvEnd);
		end;
	end;
	Result := FullPath(Result);
end;

procedure Register;
begin
	RegisterComponents('PB', [TPBSystemPath]);
end;

end.

