unit Main;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, ExtCtrls, PBShareMap;

type
	TForm1 = class(TForm)
    WriteMap: TButton;
    ReadMap: TButton;
    Clear: TButton;
		ExistsAlready: TCheckBox;
    IsMapOpen: TCheckBox;
    OpenMap: TButton;
    CloseMap: TButton;
		Bevel1: TBevel;
    PBShareMap2: TPBShareMap;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Memo1: TMemo;
    AutoSynchronize: TCheckBox;
    Handles: TComboBox;
    Label3: TLabel;
    Label4: TLabel;
    Edit2: TEdit;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    PBShareMap1: TPBShareMap;
    Label5: TLabel;
		procedure WriteMapClick(Sender: TObject);
		procedure ReadMapClick(Sender: TObject);
		procedure ClearClick(Sender: TObject);
		procedure OpenMapClick(Sender: TObject);
		procedure CloseMapClick(Sender: TObject);
		procedure Check;
		procedure ExistsAlreadyClick(Sender: TObject);
    procedure Memo1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure AutoSynchronizeClick(Sender: TObject);
    procedure PBShareMap1AppListChange(Sender: TObject);
    procedure PBShareMap1Update(Sender: TObject);
    procedure PBShareMap2Update(Sender: TObject);
    procedure PBShareMap1OpenFirst(Sender: TObject);
	private
    { Private declarations }
  public
		{ Public declarations }
	end;

const
	LText = 'If you have AutoSynchronize set to True'#13#10
		+ 'you will see that when you change the text in this memo'#13#10
		+ 'the other applications will be updated'#13#10
		+ 'automatically. When AutoSynchronize is False'#13#10
		+ 'you will have to call the WriteMap method.';

var
	Form1: TForm1;
	Tid0 : integer;

implementation

{$R *.DFM}

procedure TForm1.WriteMapClick(Sender: TObject);
begin
	Tid0 := GetTickCount;
	PBShareMap1.WriteMap;
end;

procedure TForm1.ReadMapClick(Sender: TObject);
begin
	PBShareMap1.ReadMap;
end;

procedure TForm1.ClearClick(Sender: TObject);
begin
	Memo1.Clear;
	Tid0 := GetTickCount;
	PBShareMap1.MapStrings.Clear;
	Check;
end;

procedure TForm1.OpenMapClick(Sender: TObject);
begin
	Tid0 := GetTickCount;
	PBShareMap1.OpenMap;
	Check;
end;

procedure TForm1.CloseMapClick(Sender: TObject);
begin
	PBShareMap1.CloseMap;
	Check;
end;

procedure TForm1.Check;
begin
	ExistsAlready.Checked := PBShareMap1.ExistsAlready;
	IsMapOpen.Checked := PBShareMap1.IsMapOpen;
	Handles.Items.Assign(PBShareMap1.AppList);
	Handles.ItemIndex := 0;
end;

procedure TForm1.ExistsAlreadyClick(Sender: TObject);
begin
	Check;
end;

procedure TForm1.PBShareMap1AppListChange(Sender: TObject);
begin
	Handles.Items.Assign(PBShareMap1.AppList);
	Handles.ItemIndex := 0;
	Edit2.Text := IntToStr(PBShareMap1.MapsOpen);
end;

procedure TForm1.AutoSynchronizeClick(Sender: TObject);
begin
	Tid0 := GetTickCount;
	PBShareMap1.AutoSynchronize := AutoSynchronize.Checked;
end;

procedure TForm1.Memo1KeyUp(Sender: TObject; var Key: Word;
	Shift: TShiftState);
{I use OnKeyUp instead of OnChange because OnChange will also trigger
when PBShareMap updates the Memo - leading to an message-loop!).}
begin
	Tid0 := GetTickCount;
	PBShareMap1.MapStrings.Assign(Memo1.Lines);
// Note: Using 'assign' is not fast, but is's easy and okay for 'small' text.
end;

procedure TForm1.PBShareMap1Update(Sender: TObject);
begin
	Memo1.Lines.Assign(PBShareMap1.MapStrings);
// Using the default property Values makes it easy to store variables.
	PBShareMap2['Time'] := IntToStr(GetTickCount);
	Check;
end;

procedure TForm1.PBShareMap2Update(Sender: TObject);
begin
	if PBShareMap2.MapStrings.Count > 0
	then Edit1.Text := IntToStr(StrToInt(PBShareMap2['Time']) - Tid0);
end;

procedure TForm1.PBShareMap1OpenFirst(Sender: TObject);
begin
	AutoSynchronize.Checked := PBShareMap1.AutoSynchronize;
{Only the first application loads something into the Memo
(the other application(s) get(s) it from PBShareMap).}
	Memo1.Lines.Text := LText;
	Tid0 := GetTickCount;
	PBShareMap1.MapStrings.Assign(Memo1.Lines);
	Check;
end;

end.

