{Author:	Poul Bak}
{Copyright  2001 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft-denmark@dk2net.dk}
{}
{Component Version: 1.10.00.00}
{}
{PBPathList is a component that makes it easier to use to the Windows built-in
shellfolders.}
{Depending on your Windows version it makes a list with 20-40 paths.}
{The individual paths can be called like: PBPathList1['%PERSONAL%'].}
{The component can simulate paths not present on the system.}
{Included is the free 'SHFolder.dll' which let you access shell-folders on
older systems - even those not defined.}
{You can build system-independent paths like '%PERSONAL%\MyFolder' and get the
actual path at runtime.}
{You decide the case of the returned paths: pcDontCare, pcLower, pcUpper,
pcUpperName (First letter upper - the rest lower).}
{Also included are some functions to work with paths: 'DisplayPath', 'FullPath',
'CreateShellfolder' and 'UpperName'.}
{}
{To use this component you must ensure that 'SHFolder.dll' is on the end-user's
computer - the easiest is to distribute it with your program.}
unit PBPathList;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ShlObj;

type
{The case of the paths returned.}
{See also PathCase }
	TPathCase = (pcDontCare, pcLower, pcUpper, pcUpperName);

{Author:	Poul Bak}
{Copyright  2001 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft-denmark@dk2net.dk}
{}
{Component Version: 1.10.00.00}
{}
{PBPathList is a component that makes it easier to use to the Windows built-in
shellfolders.}
{Depending on your Windows version it makes a list with 20-40 paths.}
{The individual paths can be called like: PBPathList1['%PERSONAL%'].}
{The component can simulate paths not present on the system.}
{Included is the free 'SHFolder.dll' which let you access shell-folders on
older systems - even those not defined.}
{You can build system-independent paths like '%PERSONAL%\MyFolder' and get the
actual path at runtime.}
{You decide the case of the returned paths: pcDontCare, pcLower, pcUpper,
pcUpperName (First letter upper - the rest lower).}
{Also included are some functions to work with paths: 'DisplayPath', 'FullPath',
'CreateShellfolder' and 'UpperName'.}
{}
{To use this component you must ensure that 'SHFolder.dll' is on the end-user's
computer - the easiest is to distribute it with your program.}
	TPBPathList = class(TComponent)
	private
		{ Private declarations }
		FList : TStringList;
		FPathCase : TPathCase;
		FVersion : string;
		FSimulateNotFound : Boolean;
		FCount : integer;
		function ChangeCase(Name : string) : string;
		function GetValues(Name : string) : string;
		procedure DontSetCount(Value : integer);
		procedure DontSetValues(Name : string; const Value : string);
		procedure Dummy(Value : string);
		procedure DontSetList(Value : TStringList);
		procedure SetPathCase(Value : TPathCase);
		procedure SetSimulateNotFound(Value : Boolean);
		procedure GetList;
	protected
		{ Protected declarations }
	public
		{ Public declarations }
		constructor Create(AOwner : Tcomponent); override;
		destructor Destroy; override;
{Builds a complex shellname in the form '%SHELLFOLDER%\MyFolder' when you have
the actual path.}
{Use the complex form in for instance INI-files.}
{See also ReplaceShellName }
		function BuildShellName(Path : string) : string;
{Creates a shellfolder if it doesn't exist. For instance when passed
'%MYPICTURES%' as Name it will create the shellfolder with localized foldername
 ('C:\Dokumenter\Billeder' on my danish computer).}
{Don't use this function without asking the end-user - once created they are
hard to remove again - involves the Registry.}
		function CreateShellFolder(Name : string) : Boolean;
{Replaces a complex shellname in the form '%SHELLFOLDER%\Myfolder' with the
actual path for instance 'C:Windows\System\MyFolder'.}
{See also BuildShellName }
		function ReplaceShellName(NamePath : string) : string;
{The default property. Getting a path from the list is done by calling the
components default property like this: PBPathList1['%SHELLFOLDER%'] - assuming
the components name is PBPathList1.}
{Read only}
		property Values[Name : string] : string read GetValues
			write DontSetValues; default;
	published
		{ Published declarations }
{For informational purpose: the number of paths in the list on this computer.}
{Read only}
		property Count : integer read FCount write DontSetCount stored False;
{The actual list of shellnames and corresponding path-values.}
{Normally not used directly.}
{Getting a path from the list is done by calling the components default property
like this: PBPathList1['%SHELLFOLDER%'] - assuming the components name is
PBPathList1.}
{Read only}
		property List : TStringList read FList write DontSetList stored False;
{The case of the returned paths.}
{See also TPathCase and UpperName }
		property PathCase : TPathCase read FPathCase
			write SetPathCase default pcUpperName;
{The component can simulate some paths that are undefined on older systems.}
{Especially many of the 'COMMON' paths are undefined on Windows9x.}
{If SimulateNotFound is True the component returns the path to the users folders.}
		property SimulateNotFound : Boolean read FSimulateNotFound
			write SetSimulateNotFound default True;
{Read only}
		property Version : string read FVersion write Dummy stored False;
	end;

{The definition of SHGetFolderPath from 'SHFolder.dll'. By using this DLL even
older systems can benefit from the newer shellfolder-definitions.}
{The SHGetFolderPath first tries to use the actual 'shell32.dll' on the computer
(ensuring the newest shellapi). If that fails it will use the functions in
'SHFolder.dll'.}
{To use this component you must ensure that 'SHFolder.dll' is on the end-user's
computer - the easiest is to distribute it with your program.}
function SHGetFolderPath(HwndOwner : HWND; nFolder : LongInt; hToken : THandle;
	dwFlags : DWord; PPath : PChar) : HRESULT; stdcall;
	external 'SHFolder.dll'	name 'SHGetFolderPathA';
{A function that translates a string so that the first letter of each word is
uppercase and the rest is lowercase.}
function UpperName(const S: string): string;
{A function that turns a path (for instance returned by ExtractFilePath) into
a standard windows path - for instance 'C:\' or 'C:\Myfolder'.}
{See also: FullPath }
function DisplayPath(const Path: string) : string;
{A function that ensures that a path ends with a backslash '\'.}
{makes it easy to build a path simply add the path and filename.}
{See also: DisplayPath }
function FullPath(const Path: string) : string;
procedure Register;

const
	PBPathNames : array[0..$31] of string = ('%DESKTOP%', '%INTERNET%',
		'%PROGRAMS%', '%CONTROLS%', '%PRINTERS%', '%PERSONAL%',	'%FAVORITES%',
		'%STARTUP%', '%RECENT%', '%SENDTO%', '%BITBUCKET%', '%STARTMENU%', '%%',
		'%%', '%%', '%%', '%DESKTOPDIRECTORY%',	'%DRIVES%', '%NETWORK%',
		'%NETHOOD%', '%FONTS%', '%TEMPLATES%', '%COMMON_STARTMENU%',
		'%COMMON_PROGRAMS%', '%COMMON_STARTUP%', '%COMMON_DESKTOPDIRECTORY%',
		'%APPDATA%', '%PRINTHOOD%', '%%', '%ALTSTARTUP%', '%COMMON_ALTSTARTUP%',
		'%COMMON_FAVORITES%', '%INTERNET_CACHE%', '%COOKIES%', '%HISTORY%',
		'%COMMON_APPDATA%', '%WINDOWS%', '%SYSTEM%', '%PROGRAM_FILES%',
		'%MYPICTURES%', '%PROFILE%', '%SYSTEMX86%',	'%PROGRAM_FILESX86%',
		'%PROGRAM_FILES_COMMON%',	'%PROGRAM_FILES_COMMONX86%', '%COMMON_TEMPLATES%',
		'%COMMON_DOCUMENTS%', '%COMMON_ADMINTOOLS%', '%ADMINTOOLS%', '%CONNECTIONS%');
	CSIDL_FLAG_CREATE = $8000;


implementation

function DisplayPath(const Path: string) : string;
begin
	if Path = '' then Result := ''
	else if Length(ExtractFileDrive(Path)) = Length(Path)
		then Result := Path + '\'
	else if (Length(ExtractFileDrive(Path)) = Length(Path) - 1)
		and (Path[Length(Path)] = '\')
		then Result := Path
	else if Path[Length(Path)] = '\'
		then Result := Copy(Path, 1, Length(Path) - 1)
	else Result := Path;
end;

function FullPath(const Path: string) : string;
begin
	if Path = '' then Result := ''
	else if Path[Length(Path)] = '\' then Result := Path
	else Result := Path + '\';
end;

function UpperName(const S: string): string;
var
	s1 : string;
	p : boolean;
	t : integer;
begin
	p := True;
	Result := '';
	for t := 1 to Length(S) do
	begin
		s1 := Copy(S, t, 1);
		if p = True then Result := Result + AnsiUpperCase(s1)
		else Result := Result + AnsiLowerCase(s1);
		if Pos(s1, ' .,;-+*/?=()&!\<>:_"{|}[]%') <> 0 then p := True
		else p := False;
	end;
	s1 := ExtractFileExt(Result);
	if s1 <> '' then Result := ChangeFileExt(Result, AnsiUpperCase(s1));
end;

// ----------------------- PBPathList ------------------------------
constructor TPBPathList.Create(AOwner : Tcomponent);
begin
	inherited;
	FPathCase := pcUpperName;
	FList := TStringList.Create;
	FSimulateNotFound := True;
	FVersion := '1.10.00.00';
	GetList;
end;

destructor TPBPathList.Destroy;
begin
	FList.Free;
	FList := nil;
	inherited;
end;

procedure TPBPathList.GetList;
var
	t : integer;
	TempPath : array[0..MAX_PATH] of Char;
begin
	FList.Clear;
	for t := 0 to $31 do if PBPathNames[t] <> '%%' then
	begin
		// First: Try using Shell32.dll from Windows
		if SHGetSpecialFolderPath(Application.Handle, TempPath, t, False)
			then FList.Add(PBPathNames[t] + '=' + ChangeCase(DisplayPath(TempPath)))
		else
		begin
			// Try Using SHFolder.dll (version 5.50.4134.600)
			SHGetFolderPath(Application.Handle, t, 0, 0, TempPath);
			if TempPath <> '' then FList.Add(PBPathNames[t] + '='
				+ ChangeCase(DisplayPath(TempPath)));
		end;
	end;
	if FSimulateNotFound then
	begin
		for t := 0 to $31 do if (PBPathNames[t] <> '%%')
			and (Self[PBPathNames[t]] = '') then
		begin
			case t of
				$27 : if Self['%PERSONAL%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%PERSONAL%']); // CSIDL_MYPICTURES
				$2F : if Self['%ADMINTOOLS%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%ADMINTOOLS%']); // CSIDL_COMMON_ADMINTOOLS
				$1D : if Self['%STARTUP%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%STARTUP%']); // CSIDL_ALTSTARTUP
				$1E : if Self['%ALTSTARTUP%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%ALTSTARTUP%']); // CSIDL_COMMON_ALTSTARTUP
				$23 : if Self['%APPDATA%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%APPDATA%']); // CSIDL_COMMON_APPDATA
				$19 : if Self['%DESKTOPDIRECTORY%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%DESKTOPDIRECTORY%']); // CSIDL_COMMON_DESKTOPDIRECTORY
				$2E : if Self['%PERSONAL%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%PERSONAL%']); // CSIDL_COMMON_DOCUMENTS
				$1F : if Self['%FAVORITES%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%FAVORITES%']); // CSIDL_COMMON_FAVORITES
				$17 : if Self['%PROGRAMS%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%PROGRAMS%']); // CSIDL_COMMON_PROGRAMS
				$16 : if Self['%STARTMENU%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%STARTMENU%']); // CSIDL_COMMON_STARTMENU
				$18 : if Self['%STARTUP%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%STARTUP%']); // CSIDL_COMMON_STARTUP
				$2D : if Self['%TEMPLATES%'] <> '' then FList.Add(PBPathNames[t] + '='
					+ Self['%TEMPLATES%']); // CSIDL_COMMON_TEMPLATES
			end;
		end;
	end;
	GetTempPath(MAX_PATH, TempPath);
	if DisplayPath(TempPath) <> DisplayPath(GetCurrentDir)
		then FList.Add('%TEMP%=' + ChangeCase(DisplayPath(TempPath)));
	FList.Sort;
	FCount := FList.Count;
end;

function TPBPathList.ChangeCase(Name : string) : string;
begin
	case FPathCase of
		pcDontCare : Result := Name;
		pcLower : Result := AnsiLowerCase(Name);
		pcUpper : Result := AnsiUpperCase(Name);
		pcUpperName : Result := UpperName(Name);
	end;
end;

function TPBPathList.BuildShellName(Path : string) : string;
var
	t, Len, ResultNumber : integer;
	Name, Val : string;
begin
	ResultNumber := -1;
	Len := 0;
	for t := 0 to FList.Count - 1 do
	begin
		Name := FList.Names[t];
		Val := UpperName(Values[Name]);
		if (Pos(Val, UpperName(Path)) = 1) and (Length(Val) > Len)
			and ((Length(Val) = Length(Path)) or (Copy(Path, Length(Val) + 1, 1) = '\')
			or (Copy(Val, Length(Val), 1) = '\')) then
		begin
			ResultNumber := t;
			Len := Length(Val);
		end;
	end;
	if ResultNumber = -1 then Result := Path
	else Result := FList.Names[ResultNumber]
		+ ChangeCase(Copy(Path, Len + 1, Length(Path) - Len));
end;

function TPBPathList.ReplaceShellName(NamePath : string) : string;
var
	EndPos : integer;
	Name : string;
begin
	if Copy(NamePath, 1, 1) = '%' then
	begin
		EndPos := Pos('%', Copy(NamePath, 2, Length(NamePath) - 1));
		if (EndPos = 0) then Result := NamePath
		else
		begin
			Name := Copy(NamePath, 1, EndPos + 1);
			Result := Values[Name];
			if Result = '' then Result := NamePath
			else
			begin
				Delete(NamePath, 1, Length(Name));
				if Copy(NamePath, 1, 1) = '\' then Delete(NamePath, 1, 1);
				Result := ChangeCase(DisplayPath(FullPath(Result) + NamePath));
			end;
		end;
	end
	else Result := ChangeCase(NamePath);
end;

function TPBPathList.GetValues(Name : string) : string;
begin
	Result := ChangeCase(FList.Values[AnsiUpperCase(Name)]);
end;

procedure TPBPathList.SetPathCase(Value : TPathCase);
begin
	if FPathCase <> Value then
	begin
		FPathCase := Value;
		GetList;
	end;
end;

procedure TPBPathList.SetSimulateNotFound(Value : Boolean);
begin
	if FSimulateNotFound <> Value then
	begin
		FSimulateNotFound := Value;
		GetList;
	end;
end;

function TPBPathList.CreateShellFolder(Name : string) : Boolean;
var
	t : integer;
	TempPath : array[0..MAX_PATH] of Char;
begin
	Result := True;
	t := 0;
	while (t < $31) and (AnsiUpperCase(Name) <> PBPathNames[t]) do Inc(t);
	if (AnsiUpperCase(Name) <> PBPathNames[t]) then Result := False
	else if SHGetFolderPath(Application.Handle, t or CSIDL_FLAG_CREATE,
		0, 0, TempPath) <> 0 then Result := False;
	GetList;
end;

// Dummy set-procedures (read only) !
procedure TPBPathList.DontSetCount(Value : integer); begin end;
procedure TPBPathList.DontSetValues(Name : string; const Value : string); begin end;
procedure TPBPathList.Dummy(Value : string); begin end;
procedure TPBPathList.DontSetList(Value : TStringList); begin end;

procedure Register;
begin
	RegisterComponents('PB', [TPBPathList]);
end;

end.
