//****************************************************************************
// LsAlignEdit v1.10
//============================================================================
//
// LsAlignEdit is a descendant of TCustomEdit.  In addition to many properties
// inherited from TCustomEdit, it also incorporates new properties as follows:
//
//    Alignment     : provides with Left, Center, or Right text justification.
//    ColorNormal   : Background color when Focused is false.
//    ColorFocused  : Background color when focused.
//    RealValueOnly : Boolean; if True, it only accept the following chars:
//                    '0'..'9', '+', '-', '.', 'E', and 'e'.
//
// (C)2000-2001 Leo D. Shih, all rights reserved
//              eMail ldshih@ecn.ab.ca
//
// This component is currently distributed as freeware, without warranty of
// any kind, either expressed or implied.
//
//****************************************************************************


unit LsAlignEdit;

interface

uses
  Messages, Windows, SysUtils, Classes, StdCtrls, Controls, Graphics, Forms;

type

  TLsAlignEdit = class(TCustomEdit)
  private
    {Private declarations}
    FColorNormal: TColor;
    FColorFocused: TColor;
    FAlignment: TAlignment;
    FFocused: Boolean;
    FRealValueOnly: Boolean;  //1.1
  protected
    {Protected declarations}
    procedure SetColorFocused(Value: TColor);
    procedure SetColorNormal(Value: TColor);
    procedure DoEnter; override;
    procedure DoExit; override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure SetAlignment(Value: TAlignment);
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
//    procedure SetFocused(Value: Boolean);
    procedure SetRealValueOnly(Value: Boolean);
    procedure KeyPress(var Key: char); override;  //1.1
  public
    {Public declarations}
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetFocused(Value: Boolean);
  published
    {Published declarations}
    property ColorNormal: TColor read FColorNormal write SetColorNormal;
    property ColorFocused: TColor read FColorFocused write SetColorFocused;
    property Alignment: TAlignment read FAlignment write SetAlignment
      default taLeftJustify;
    property RealValueOnly: Boolean read FRealValueOnly write SetRealValueOnly;
    property AutoSelect;
    property AutoSize;
    property BorderStyle;
    property CharCase;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property HideSelection;
    property MaxLength;
    property OEMConvert;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PasswordChar;
    property PopupMenu;
    property ReadOnly;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Text;
    property Visible;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

  procedure Register;

implementation

const
  Alignments: array[TAlignment] of Word = (ES_LEFT, ES_RIGHT, ES_CENTER);

constructor TLsAlignEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FColorNormal := clWindow;
  FColorFocused := clInfoBk;  //clWindow;
  FFocused := False;
  Color := FColorNormal;
  FAlignment := taLeftJustify;
  FRealValueOnly := False;
end;

procedure TLsAlignEdit.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or Alignments[FAlignment];
end;

destructor TLsAlignEdit.Destroy;
begin
  inherited Destroy;
end;

procedure TLsAlignEdit.SetAlignment(Value: TAlignment);
begin
  if FAlignment <> Value then
  begin
    FAlignment := Value;
    RecreateWnd;
  end;
end;

procedure TLsAlignEdit.SetColorFocused(Value: TColor);
begin
  Color := value;
  FColorFocused := value;
end;

procedure TLsAlignEdit.SetColorNormal(Value: TColor);
begin
  if not ((csDesigning in ComponentState) and FFocused) then
    Color := value;
  FColorNormal := value;
end;

procedure TLsAlignEdit.DoEnter;
begin
  SetColorFocused(FColorFocused);
  inherited DoEnter;
end;

procedure TLsAlignEdit.DoExit;
begin
  SetColorNormal(FColorNormal);
  inherited DoExit;
end;

procedure TLsAlignEdit.SetFocused(Value: Boolean);
begin
  if FFocused <> Value then
  begin
    FFocused := Value;
    if FFocused then
      SetColorFocused(FColorFocused)
    else
      SetColorNormal(FColorNormal);
    if (FAlignment <> taLeftJustify) then
      Invalidate;
  end;
end;

procedure TLsAlignEdit.CMEnter(var Message: TCMEnter);
begin
  SetFocused(True);
  if AutoSelect and not (csLButtonDown in ControlState) then
    SelectAll;
  Invalidate;
end;

procedure TLsAlignEdit.CMExit(var Message: TCMExit);
begin
  SetFocused(false);
  DoExit;
end;

procedure TLsAlignEdit.SetRealValueOnly(Value: Boolean);
begin
  if FRealValueOnly <> Value then
    FRealValueOnly := Value;
end;

procedure TLsAlignEdit.KeyPress(var Key: char);  //1.1>>
var
  KeyOK: Boolean;
begin
  if FRealValueOnly then
  begin
//    KeyOk := False;
    Case Key of
      '0'..'9', '.', '+', '-', 'E', 'e', #8: KeyOk := True;
    else
      KeyOk := False;
    end;
    if not KeyOk then
      Key := #0;
  end;
  inherited KeyPress(Key);
end;  //1.1<<

procedure register;
begin
  RegisterComponents('LsComp', [TLsAlignEdit]);
end;

end.

