
unit Fc_unit1;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Printers,
  LsAlignEdit, ImgList, ComCtrls, ToolWin;

type
  TFc_Form1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Print1: TMenuItem;
    PrintSetup1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Investment1: TMenuItem;
    FinalValue1: TMenuItem;
    InitialPrincipal1: TMenuItem;
    InterestRate1: TMenuItem;
    Investmentterm1: TMenuItem;
    Loans1: TMenuItem;
    Payment1: TMenuItem;
    Principal1: TMenuItem;
    LoanTerm1: TMenuItem;
    Annuity1: TMenuItem;
    FinalValue2: TMenuItem;
    RegularDeposit1: TMenuItem;
    AnnuityTerm1: TMenuItem;
    Mortgage1: TMenuItem;
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Help1: TMenuItem;
    About1: TMenuItem;
    Fc_Memo1: TMemo;
    ClearBtn2: TBitBtn;
    PrintDialog1: TPrintDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    Contents1: TMenuItem;
    AnnuitywithDeposit1: TMenuItem;
    N2: TMenuItem;
    AnnuitywithWithdrawals1: TMenuItem;
    Principal2: TMenuItem;
    WithdrawalAmount1: TMenuItem;
    NumberofWithdrawals1: TMenuItem;
    Panel3: TPanel;
    Label6: TLabel;
    Panel4: TPanel;
    PrintBtn: TBitBtn;
    Panel5: TPanel;
    Panel6: TPanel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Image1: TImage;
    Panel7: TPanel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    ToolBar1: TToolBar;
    CalcBtn: TToolButton;
    ImageList1: TImageList;
    RptBtn: TToolButton;
    CancelBtn: TToolButton;
    HelpBtn1: TToolButton;
    ImageList2: TImageList;
    ExitBtn: TToolButton;

    procedure CalcBtnClick(Sender: TObject);
    procedure RptBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FinalValue1Click(Sender: TObject);
    procedure InitialPrincipal1Click(Sender: TObject);
    procedure InterestRate1Click(Sender: TObject);
    procedure Investmentterm1Click(Sender: TObject);
    procedure Payment1Click(Sender: TObject);
    procedure Principal1Click(Sender: TObject);
    procedure LoanTerm1Click(Sender: TObject);
    procedure FinalValue2Click(Sender: TObject);
    procedure RegularDeposit1Click(Sender: TObject);
    procedure AnnuityTerm1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Principal2Click(Sender: TObject);
    procedure WithdrawalAmount1Click(Sender: TObject);
    procedure NumberofWithdrawals1Click(Sender: TObject);
    procedure ClearBtn2Click(Sender: TObject);
    procedure PrintSetup1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure HelpBtn1Click(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure EditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PrintBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EnableEdits;
    procedure DisableEdits;
    procedure Mortgage1Click(Sender: TObject);
    procedure ProcessMortgage;
  private
    { Private declarations }
    Compute: Boolean;
    FinFunc: Integer;
    function FinalValue: Double;
    function InitPrincipal: Double;
    function AnnualInt: Double;
    function InvestTerm: integer;
    function LPayment: Double;
    function LPrincipal: Double;
    function LTerm: integer;
    function AFValue: Double;
    function ADeposit: Double;
    function ATerm: integer;
    function WDrawPrin: Double;
    function WDrawAmt: Double;
    function WDTerm: integer;

    procedure ShowComponents;
    procedure ClearComponents;
    procedure ClearEdits;

  public
    { Public declarations }
    NewMortgData: Boolean;  //2.0
    InValues: Boolean;    //2.0
    GetOut: Boolean;      //2.0
    Edit1: TLsAlignEdit;  //2.0
    Edit2: TLsAlignEdit;  //2.0
    Edit3: TLsAlignEdit;  //2.0
    Edit4: TLsAlignEdit;  //2.0
    Edit5: TLsAlignEdit;  //2.0
    Edit6: TLsAlignEdit;  //2.0
    Edit7: TLsAlignEdit;  //2.0
    Edit8: TLsAlignEdit;  //2.0
    Edit9: TLsAlignEdit;  //2.0
  end;

  function InvestFV(Principal, InterestRate: Double;
    CompoundYear, NumberMonths: Integer): Double;
  function InvestP(FinalValue, InterestRate: Double;
    CompoundYear, NumberMonths: integer): Double;
  function InvestIR(Principal, FinalValue: Double;
    CompoundYear, NumberMonths: integer): Double;
  function InvestNM(Principal, FinalValue, InterestRate: Double;
    CompoundYear: integer): integer;
  function LoanPay(Principal, InterestRate: Double; TotalNumPay,
    NumPayPerYr: integer): Double;
  function LoanPrin(Payment, InterestRate: Double; TotalNumPay,
    NumPayPerYr: integer): Double;
  function LoanTNP(Principal, Payment, InterestRate: Double;
    NumPayPerYr: integer): integer;
  function AnnuFV(Deposit, InterestRate: Double;
    TotalNumDep, NumDepPerYr: integer): Double;
  function AnnuDep(FinalValue, InterestRate: Double;
    TotalNumDep, NumDepPerYr: integer): Double;
  function AnnuTND(Deposit, FinalValue, InterestRate: Double;
    NumDepPerYr: integer): integer;
  function WDrawP(Withdrawal, InterestRate: Double;
    TotalNumW, NumWPerYr: integer): Double;
  function WDrawWD(Principal, InterestRate: Double;
    TotalNumW, NumWPerYr: integer): Double;
  function WDrawTNW(Principal, Withdrawal, InterestRate: Double;
    NumWPerYr: byte): integer;

var
  Fc_Form1: TFc_Form1;


implementation

{$R *.DFM}


uses Fc_Unit2;


function InvestFV(Principal, InterestRate: Double;
  CompoundYear, NumberMonths: Integer): Double;
var
  Growth: Double;
begin
  Growth := exp(NumberMonths / 12.0 * CompoundYear *
    ln(1.0 + InterestRate / 100.0 / CompoundYear));
  Result := (Principal * Growth);
end;


function InvestP(FinalValue, InterestRate: Double;
  CompoundYear, NumberMonths: integer): Double;
var
  Growth: Double;
begin
  Growth := exp(NumberMonths / 12.0 * CompoundYear *
    ln(1.0 + InterestRate / 100.0 / CompoundYear));
  Result := (FinalValue / Growth);
end;


function InvestIR(Principal, FinalValue: Double;
  CompoundYear, NumberMonths: integer): Double;
begin
  Result := CompoundYear * (exp(ln(FinalValue / Principal) /
    CompoundYear / NumberMonths * 12.0) - 1.0) * 100.0
end;


function InvestNM(Principal, FinalValue, InterestRate: Double;
  CompoundYear: integer): integer;
var
  RealNM: Double;
  NumMonth: integer;
begin
  RealNM := ln(FinalValue / Principal) /
    ln(InterestRate / 100.0 / CompoundYear + 1.0) /
    CompoundYear * 12;
  if frac(RealNM) = 0.0 then
    NumMonth := trunc(RealNM)
  else
    NumMonth := trunc(RealNM) + 1;
  result := NumMonth;
end;


function LoanPay(Principal, InterestRate: Double; TotalNumPay,
  NumPayPerYr: integer): Double;
var
  Temp: Double;
begin
  Temp := exp(-TotalNumPay * ln(1.0 + interestRate / 100.0 / NumPayPerYr));
  Result := Principal * InterestRate / 100.0 / NumPayPerYr / (1.0 - Temp);
end;


function LoanPrin(Payment, InterestRate: Double; TotalNumPay,
  NumPayPerYr: integer): Double;
var
  Temp: Double;
begin
  Temp := exp(-TotalNumPay * ln(1.0 + InterestRate / 100.0 / NumPayPerYr));
  Result := Payment * NumPayPerYr * 100.0 / InterestRate * (1.0 - Temp);
end;


function LoanTNP(Principal, Payment, InterestRate: Double;
  NumPayPerYr: integer): integer;
var
  Temp, RealTNP: Double;
  LoanTerm: integer;
begin
  Temp := Principal * InterestRate / 100.0 / Payment / NumPayPerYr;
  if Temp > 1 then
    RealTNP := 0.0
  else
    RealTNP := -ln(1.0 - Temp) / ln(1.0 + InterestRate / 100.0 / NumPayPerYr);
  if frac(RealTNP) = 0.0 then
    LoanTerm := trunc(RealTNP)
  else
    LoanTerm := trunc(RealTNP) + 1;
  Result := LoanTerm;
end;


function AnnuFV(Deposit, InterestRate: Double;
  TotalNumDep, NumDepPerYr: integer): Double;
var
  Product: Double;
  j: integer;
begin
  Product := 1.0;
  for j := 1 to TotalNumDep do
    Product := Product * (1.0 + InterestRate / 100.0 / NumDepPerYr);
  Result := Deposit * (Product - 1.0) * NumDepPerYr * 100.0 / InterestRate;
end;


function AnnuDep(FinalValue, InterestRate: Double;
  TotalNumDep, NumDepPerYr: integer): Double;
var
  Product: Double;
  j: integer;
begin
  Product := 1.0;
  for j := 1 to TotalNumDep do
    Product := Product * (1.0 + InterestRate / 100.0 / NumDepPerYr);
  Result := FinalValue * InterestRate / 100.0 / NumDepPerYr / (Product - 1.0);
end;


function AnnuTND(Deposit, FinalValue, InterestRate: Double;
  NumDepPerYr: integer): integer;
var
  Temp, RealTND: Double;
  TNumDep: integer;
begin
  Temp := InterestRate / 100.0 / NumDepPerYr;
  RealTND := ln(1.0 + FinalValue * Temp / Deposit) / ln(1.0 + Temp);
  if frac(RealTND) = 0.0 then
    TNumDep := trunc(RealTND)
  else
    TNumDep := trunc(RealTND) + 1;
  Result := TNumDep;
end;


function WDrawP(Withdrawal, InterestRate: Double;
  TotalNumW, NumWPerYr: integer): Double;
var
  Product: Double;
  j: integer;
begin
  Product := 1.0;
  for j := 1 to TotalNumW do
    Product := Product * (1.0 + InterestRate / 100.0 / NumWPerYr);
  Result := Withdrawal * NumWPerYr * (1.0 - 1.0 / Product) *
    100.0 / InterestRate;
end;


function WDrawWD(Principal, InterestRate: Double;
  TotalNumW, NumWPerYr: integer): Double;
var
  Product: Double;
  j: integer;
begin
  Product := 1.0;
  for j := 1 to TotalNumW do
    Product := Product * (1.0 + InterestRate / 100.0 / NumWPerYr);
  Result := Principal * InterestRate / 100.0 / NumWPerYr *
    (1.0 + 1.0 / (Product - 1.0));
end;


function WDrawTNW(Principal, Withdrawal, InterestRate: double;
  NumWPerYr: byte): integer;
var
  Temp, RealTNW: Double;
  TNWDraw: integer;
begin
  Temp := 1.0 - Principal * InterestRate / 100.0 / NumWPerYr / Withdrawal;
  if Temp <= 0.0 then
    RealTNW := 0
  else
    RealTNW := -ln(Temp) / ln(1.0 + InterestRate / 100.0 / NumWPerYr);
  if frac(RealTNW) = 0.0 then
    TNWDraw := trunc(RealTNW)
  else
    TNWDraw := trunc(RealTNW) + 1;
  result := TNWDraw;
end;


procedure TFc_Form1.CalcBtnClick(Sender: TObject);
begin
  if (FinFunc in [1..13]) then  //2.1
  begin
    if (Edit1.Text = '') or (Edit2.Text = '') or
      (Edit3.Text = '') or (Edit4.Text = '') then
    begin
      MessageDlg('Data entries incomplete!', mtError, [mbOK],0);
      exit;
    end;
    case FinFunc of
      1: FinalValue;
      2: InitPrincipal;
      3: AnnualInt;
      4: InvestTerm;
      5: LPayment;
      6: LPrincipal;
      7: LTerm;
      8: AFValue;
      9: ADeposit;
      10: ATerm;
      11: WDrawPrin;
      12: WDrawAmt;
      13: WDTerm;
    end;
  end
  else if (FinFunc = 14) then   //2.1 >>
  begin
    InValues := False;
    NewMortgData := False;
    if (Edit6.Text = '') or (StrToFloat(Edit6.Text) <= 0.0) then
    begin
      MessageDlg('Invalid Principal Value', mtInformation, [mbOK], 0);
      Mortgage1Click(Sender);
      Edit6.SetFocus;
    end
    else if (Edit7.Text = '') or (StrToFloat(Edit7.Text) >= 100.0) then
    begin
      MessageDlg('Invalid Interest Rate', mtError, [mbOK], 0);
      Mortgage1Click(Sender);
      Edit7.SetFocus;
    end
    else if (Edit8.Text = '') or (StrToFloat(Edit8.Text) <= 0.0) then
    begin
      MessageDlg('Invalid Term of Loan', mtError, [mbOK], 0);
      Mortgage1Click(Sender);
      Edit8.SetFocus;
    end
    else if (Edit9.Text = '') or (not (StrToInt(Edit9.Text) in [1..2])) then
    begin
      MessageDlg('Number of payment per month should be 1 or 2', mtError, [mbOK], 0);
      Mortgage1Click(Sender);
      Edit9.SetFocus;
    end
    else begin
      GetOut := False;
      InValues := True;
      NewMortgData := True;
      Panel6.Visible := True;
      ProcessMortgage;
    end;
  end;  //else if FinFunc=14  //2.1 <<
end;


procedure TFc_Form1.RptBtnClick(Sender: TObject);
begin
  ClearEdits;
  Fc_Form1.Refresh;
  if FinFunc in [1..13] then
    Edit1.SetFocus
  else if FinFunc = 14 then  //2.1 >>
    Edit6.SetFocus;
end;


procedure TFc_Form1.CancelBtnClick(Sender: TObject);
begin
  if FinFunc in [1..13] then  //2.1
  begin
    Compute := False;
    ClearComponents;
    DisableEdits;
  end
  else if FinFunc = 14 then
  begin
    if NewMortgData = True then  //2.1 >>
    begin
      Edit6.Text := '';
      Edit7.Text := '';
      Edit8.Text := '';
      Edit9.Text := '';
    end;  //2.1 <<
    ClearComponents;
    Fc_Memo1.Clear;
    Fc_Memo1.Visible := False;
    ClearBtn2.Visible := False;
    Print1.Enabled := False;
    PrintSetup1.Enabled := False;
    Panel1.Visible := True;
    Panel5.Visible := True;
    Panel6.Visible := False;
    Panel7.Visible := False;
    InValues := False;
    GetOut := True;
  end;  //2.1 <<
  FinFunc := 0;  //2.1
  Caption := 'Financial Calculator';
end;


procedure TFc_Form1.Exit1Click(Sender: TObject);
begin
  Close;
end;


procedure TFc_Form1.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;


procedure TFc_Form1.ShowComponents;
begin
    Panel1.Visible := True;
    Panel5.Visible := False;
    Fc_Memo1.Visible := False;
    Label1.visible := True;
    CalcBtn.Enabled := True;
    RptBtn.Enabled := True;
    CancelBtn.Enabled := True;  //2.1
    HelpBtn1.Enabled := True;
    CancelBtn.Visible := True;
    ClearBtn2.visible := False;
    PrintBtn.visible := False;
    Print1.Enabled := False;
    PrintSetup1.Enabled := False;
    Panel2.Caption := '';
    EnableEdits;
end;

procedure TFc_Form1.EnableEdits;
begin
  Edit1.Visible := True;  //2.0
  Edit2.Visible := True;  //2.0
  Edit3.Visible := True;  //2.0
  Edit4.Visible := True;  //2.0
  Edit5.Visible := True;  //2.0
end;

procedure TFc_Form1.DisableEdits;
begin
  Edit1.Visible := False;  //2.0
  Edit2.Visible := False;  //2.0
  Edit3.Visible := False;  //2.0
  Edit4.Visible := False;  //2.0
  Edit5.Visible := False;  //2.0
end;


procedure TFc_Form1.ClearComponents;
begin
    Label1.Caption := '';
    Label2.Caption := '';
    Label3.Caption := '';
    Label4.Caption := '';
    Label5.Caption := '';
    Label6.Caption := '';
    Edit1.Text := '';
    Edit2.Text := '';
    Edit3.Text := '';
    Edit4.Text := '';
    Edit5.Text := '';
    Panel5.Visible := True;
    Label1.visible := False;
    CalcBtn.Enabled := False;
    RptBtn.Enabled := False;
    CancelBtn.Enabled := False;  //2.1
end;


procedure TFc_Form1.ClearEdits;
begin
  if FinFunc in [1..13] then
    begin
    Edit1.Text := '';
    Edit2.Text := '';
    Edit3.Text := '';
    Edit4.Text := '';
    Edit5.Text := '';
  end
  else if FinFunc = 14 then
  begin
    Edit6.Text := '';
    Edit7.Text := '';
    Edit8.Text := '';
    Edit9.Text := '';
  end;
end;


function TFc_Form1.FinalValue: Double;
var
  InitAmt, IntRate: Double;
  CompFreq, NumMon: Integer;
begin
  InitAmt := StrToFloat(Edit1.Text);
  IntRate := StrToFloat(Edit2.Text);
  CompFreq := StrToInt(Edit3.Text);
  NumMon := StrToInt(Edit4.Text);

  Result := InvestFV(InitAmt, IntRate, CompFreq, NumMon);
  Edit5.Text := FormatFloat('#,##0.00', Result);
end;


function TFc_Form1.InitPrincipal: Double;
var
  IntRate, FinalVal: Double;
  CompFreq, NumMon: Integer;
begin
  FinalVal := StrToFloat(Edit1.Text);
  IntRate := StrToFloat(Edit2.Text);
  CompFreq := StrToInt(Edit3.Text);
  NumMon := StrToInt(Edit4.Text);

  Result := InvestP(FinalVal, IntRate, CompFreq, NumMon);
  Edit5.Text := FormatFloat('#,##0.00', Result);
end;


function TFc_Form1.AnnualInt: Double;
var
  InitAmt, FinalVal: Double;
  CompFreq, NumMon: Integer;
begin
  InitAmt := StrToFloat(Edit1.Text);
  FinalVal := StrToFloat(Edit2.Text);
  CompFreq := StrToInt(Edit3.Text);
  NumMon := StrToInt(Edit4.Text);

  Result := InvestIR(InitAmt, FinalVal, CompFreq, NumMon);
  Edit5.Text := FormatFloat('0.000000', Result);
end;


function TFc_Form1.InvestTerm: integer;
var
  InitAmt, IntRate, FinalVal: Double;
  CompFreq: Integer;
begin
  InitAmt := StrToFloat(Edit1.Text);
  FinalVal := StrToFloat(Edit2.Text);
  IntRate := StrToFloat(Edit3.Text);
  CompFreq := StrToInt(Edit4.Text);

  Result := InvestNM(InitAmt, FinalVal, IntRate, CompFreq);
  Edit5.Text := Format('%10.0d', [Result]);
end;


function TFc_Form1.LPayment: Double;
var
  PrinAmt, IntRate: Double;
  TNumPay, NPayPerYr: Integer;
begin
  PrinAmt := StrToFloat(Edit1.Text);
  IntRate := StrToFloat(Edit2.Text);
  TNumPay := StrToInt(Edit3.Text);
  NPayPerYr := StrToInt(Edit4.Text);

  Result := LoanPay(PrinAmt, IntRate, TNumPay, NPayPerYr);
  Edit5.Text := FormatFloat('#,##0.00', Result);
end;


function TFc_Form1.LPrincipal: Double;
var
  IntRate, RPayment: Double;
  TNumPay, NPayPerYr: Integer;
begin
  RPayment := StrToFloat(Edit1.Text);
  IntRate := StrToFloat(Edit2.Text);
  TNumPay := StrToInt(Edit3.Text);
  NPayPerYr := StrToInt(Edit4.Text);

  Result := LoanPrin(RPayment, IntRate, TNumPay, NPayPerYr);
  Edit5.Text := FormatFloat('#,##0.00', Result);
end;


function TFc_Form1.LTerm: integer;
var
  PrinAmt, IntRate, RPayment: Double;
  NPayPerYr: Integer;
begin
  PrinAmt := StrToFloat(Edit1.Text);
  RPayment := StrToFloat(Edit2.Text);
  IntRate := StrToFloat(Edit3.Text);
  NPayPerYr := StrToInt(Edit4.Text);

  Result := LoanTNP(PrinAmt, RPayment, IntRate, NPayPerYr);
  if Result = 0 then
  begin
    Edit5.Text := 'Error!';
    MessageDlg('Your loan payments are too small to achieve amortization',
      mtError, [mbOK], 0);
  end
  else
      Edit5.Text := Format('%10.0d', [Result]);
end;


function TFc_Form1.AFValue: Double;
var
  DepAmt, IntRate: Double;
  TNumDep, NDepPerYr: Integer;
begin
  DepAmt := StrToFloat(Edit1.Text);
  IntRate := StrToFloat(Edit2.Text);
  TNumDep := StrToInt(Edit3.Text);
  NDepPerYr := StrToInt(Edit4.Text);

  Result := AnnuFV(DepAmt, IntRate, TNumDep, NDepPerYr);
  Edit5.Text := FormatFloat('#,##0.00', Result);
end;


function TFc_Form1.ADeposit: Double;
var
  IntRate, FinalVal: Double;
  TNumDep, NDepPerYr: Integer;
begin
  FinalVal := StrToFloat(Edit1.Text);
  IntRate := StrToFloat(Edit2.Text);
  TNumDep := StrToInt(Edit3.Text);
  NDepPerYr := StrToInt(Edit4.Text);

  Result := AnnuDep(FinalVal, IntRate, TNumDep, NDepPerYr);
  Edit5.Text := FormatFloat('#,##0.00', Result);
end;


function TFc_Form1.ATerm: integer;
var
  DepAmt, IntRate, FinalVal: Double;
  NDepPerYr: Integer;
begin
  DepAmt := StrToFloat(Edit1.Text);
  FinalVal := StrToFloat(Edit2.Text);
  IntRate := StrToFloat(Edit3.Text);
  NDepPerYr := StrToInt(Edit4.Text);

  Result := AnnuTND(DepAmt, FinalVal, IntRate, NDepPerYr);
  Edit5.Text := Format('%10.0d', [Result]);
end;


function TFc_Form1.WDrawPrin: Double;
var
  WdAmt, IntRate: Double;
  TNumWd, NWdPerYr: integer;
begin
  WdAmt := StrToFloat(Edit1.Text);
  IntRate := StrToFloat(Edit2.Text);
  TNumWd := StrToInt(Edit3.Text);
  NWdPerYr := StrToInt(Edit4.Text);

  Result := WDrawP(WdAmt, IntRate, TNumWd, NWdPerYr);
  Edit5.Text := FormatFloat('#,##0.00', Result);
end;


function TFc_Form1.WDrawAmt: Double;
var
  WdPrin, IntRate: Double;
  TNumWd, NWdPerYr: integer;
begin
  WdPrin := StrToFloat(Edit1.Text);
  IntRate := StrToFloat(Edit2.Text);
  TNumWd := StrToInt(Edit3.Text);
  NWdPerYr := StrToInt(Edit4.Text);

  Result := WDrawWD(WdPrin, IntRate, TNumWd, NWdPerYr);
  Edit5.Text := FormatFloat('#,##0.00', Result);
end;


function TFc_Form1.WDTerm: integer;
var
  WdAmt, WdPrin, IntRate: Double;
  NWdPerYr: integer;
begin
  WdPrin := StrToFloat(Edit1.Text);
  WdAmt := StrToFloat(Edit2.Text);
  IntRate := StrToFloat(Edit3.Text);
  NWdPerYr := StrToInt(Edit4.Text);

  Result := WDrawTNW(WdPrin, WdAmt, IntRate, NWdPerYr);
  if Result = 0 then
  begin
    Edit5.Text := 'Error!';
    MessageDlg('Your withdrawals are not large enough to deplete the annuity',
      mtError, [mbOK], 0);
  end
  else
    Edit5.Text := IntToStr(Result);
end;


procedure TFc_Form1.FinalValue1Click(Sender: TObject);
begin
  FinFunc := 1;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (INVESTMENT - Final Value)';
  Label1.Caption := 'Calculate the final value of an investment, with given investment specifications';
  Label2.Caption := 'Principal (Initial amount invested)';
  Label3.Caption := 'Annual Interest Rate (in percent)';
  Label4.Caption := 'Number of compounding periods per year';
  Label5.Caption := 'Term - Length of investment (in months)';
  Label6.Caption := 'Final Value at maturity';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.InitialPrincipal1Click(Sender: TObject);
begin
  FinFunc := 2;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (INVESTMENT - Principal)';
  Label1.Caption := 'Calculate the initial investment required to reach a certain final value';
  Label2.Caption := 'Final Value of the investment';
  Label3.Caption := 'Annual Interest Rate (in percent)';
  Label4.Caption := 'Number of compounding periods per year';
  Label5.Caption := 'Term - Length of investment (in months)';
  Label6.Caption := 'Principal (initial investment)';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.InterestRate1Click(Sender: TObject);
begin
  FinFunc := 3;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (INVESTMENT - Interest Rate)';
  Label1.Caption := 'Calculate the interest rate required to produce a specified return';
  Label2.Caption := 'Principal (initial amount invested)';
  Label3.Caption := 'Final Value of the investment';
  Label4.Caption := 'Number of compounding periods per year';
  Label5.Caption := 'Term - Length of investment (in months)';
  Label6.Caption := 'Annual Interest Rate (in percent)';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.Investmentterm1Click(Sender: TObject);
begin
  FinFunc := 4;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (INVESTMENT - Term)';
  Label1.Caption := 'Calculate the Term required for an investment to mature';
  Label2.Caption := 'Principal (initial amount invested)';
  Label3.Caption := 'Final Value of the investment';
  Label4.Caption := 'Annual interest rate (in percent)';
  Label5.Caption := 'Number of compounding periods per year';
  Label6.Caption := 'Term - Length of investment (in months)';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.Payment1Click(Sender: TObject);
begin
  FinFunc := 5;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (LOAN - Payment)';
  Label1.Caption := 'Calculate the amount of each payment required to payback a loan';
  Label2.Caption := 'Principal (The amount borrowed)';
  Label3.Caption := 'Annual interest rate (in percent)';
  Label4.Caption := 'Term (Total number of payments)';
  Label5.Caption := 'Number of payments per year';
  Label6.Caption := 'Amount of each payment';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.Principal1Click(Sender: TObject);
begin
  FinFunc := 6;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (LOAN - Principal)';
  Label1.Caption := 'Calculate the principal (initial amount borrowed) for a loan';
  Label2.Caption := 'Amount of each payment';
  Label3.Caption := 'Annual interest rate (in percent)';
  Label4.Caption := 'Term (Total number of payments)';
  Label5.Caption := 'Number of payments per year';
  Label6.Caption := 'Principal (initial amount borrowed)';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.LoanTerm1Click(Sender: TObject);
begin
  FinFunc := 7;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (LOAN - Term)';
  Label1.Caption := 'Calculate the term (total number of payments) required to pay back a loan';
  Label2.Caption := 'Principal (the amount borrowed)';
  Label3.Caption := 'Amount of each payment';
  Label4.Caption := 'Annual interest rate (in percent)';
  Label5.Caption := 'Number of payments per year';
  Label6.Caption := 'Total number of payments';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.FinalValue2Click(Sender: TObject);
begin
  FinFunc := 8;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (ANNUITY - Final Value)';
  Label1.Caption := 'Calculate the final value of an annuity with deposits made in regular intervals';
  Label2.Caption := 'Amount of each deposit';
  Label3.Caption := 'Annual interest rate (in percent)';
  Label4.Caption := 'Term (Total number of deposits)';
  Label5.Caption := 'Number of deposits per year';
  Label6.Caption := 'Final value of the annuity';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.RegularDeposit1Click(Sender: TObject);
begin
  FinFunc := 9;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (ANNUITY - Amount of Deposit)';
  Label1.Caption := 'Calculate the amount of each deposit required to reach a specified final value';
  Label2.Caption := 'Final value of the annuity';
  Label3.Caption := 'Annual interest rate (in percent)';
  Label4.Caption := 'Term (Total number of deposits)';
  Label5.Caption := 'Number of deposits per year';
  Label6.Caption := 'Amount of each deposit';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.AnnuityTerm1Click(Sender: TObject);
begin
  FinFunc := 10;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (ANNUITY - Term)';
  Label1.Caption := 'Calculate the total number of deposits required for an annuity to mature';
  Label2.Caption := 'Amount of each deposit';
  Label3.Caption := 'Final value of the annuity';
  Label4.Caption := 'Annual interest rate (in percent)';
  Label5.Caption := 'Number of deposits made each year';
  Label6.Caption := 'Term (total number of deposits)';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.Principal2Click(Sender: TObject);
begin
  FinFunc := 11;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (ANNUITY - Principal)';
  Label1.Caption := 'Principal required to sustain an investment with regular withdrawals';
  Label2.Caption := 'Amount of each withdrawal';
  Label3.Caption := 'Annual interest rate (in percent)';
  Label4.Caption := 'Term (total number of withdrawals)';
  Label5.Caption := 'Number of withdrawals made each year';
  Label6.Caption := 'Principal (initial investment) required';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.WithdrawalAmount1Click(Sender: TObject);
begin
  FinFunc := 12;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (ANNUITY - Withdrawal Amount)';
  Label1.Caption := 'Calculate the withdrawal amount, enabling an investment to sustain itself';
  Label2.Caption := 'Principal (initial investment)';
  Label3.Caption := 'Annual interest rate (in percent)';
  Label4.Caption := 'Term (total number of withdrawals)';
  Label5.Caption := 'Number of withdrawals made each year';
  Label6.Caption := 'Maximum amount of each withdrawal';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.NumberofWithdrawals1Click(Sender: TObject);
begin
  FinFunc := 13;
  ClearEdits;
  Fc_Form1.Caption := 'Financial Calculator (ANNUITY - Number of Withdrawals)';
  Label1.Caption := 'Calculate the number of withdrawals until an investment is depleted to zero';
  Label2.Caption := 'Principal (initial investment)';
  Label3.Caption := 'Amount of each withdrawal';
  Label4.Caption := 'Annual interest rate (in percent)';
  Label5.Caption := 'Number of withdrawals made each year';
  Label6.Caption := 'Total number of withdrawals';
  ShowComponents;
  Edit1.SetFocus;
end;


procedure TFc_Form1.ClearBtn2Click(Sender: TObject);
begin
  Fc_Memo1.Clear;
  Fc_Form1.Caption := 'Financial Calculator';
  Fc_Memo1.visible := False;
  Label1.visible := False;
  Label6.Caption := '';
  Edit5.Text := '';
  Panel6.visible := False;
  ClearBtn2.visible := False;
  PrintBtn.Visible := False;
  Print1.Enabled := False;
  PrintSetup1.Enabled := False;
  Edit6.Text := '';
  Edit7.Text := '';
  Edit8.Text := '';
  Edit9.Text := '';
  Panel7.Visible := False;
  Panel1.Visible := True;
  Panel5.Visible := True;
  FinFunc := 0;
end;


procedure TFc_Form1.PrintSetup1Click(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;


procedure TFc_Form1.Print1Click(Sender: TObject);
begin
  PrintBtnClick(Sender);
end;

procedure TFc_Form1.Contents1Click(Sender: TObject);
begin
  Application.HelpFile:='FIN_CALC.HLP';   //2.1
  Application.HelpCommand(HELP_FINDER, 0); //2.1
end;

procedure TFc_Form1.HelpBtn1Click(Sender: TObject);
var
  ContxtNum: integer;
begin
  if (FinFunc in [1..14]) then
  begin
    ContxtNum := 0;
    case FinFunc of
      1: ContxtNum := 11;
      2: ContxtNum := 12;
      3: ContxtNum := 13;
      4: ContxtNum := 14;
      5: ContxtNum := 21;
      6: ContxtNum := 22;
      7: ContxtNum := 23;
      8: ContxtNum := 31;
      9: ContxtNum := 32;
      10: ContxtNum := 33;
      11: ContxtNum := 41;
      12: ContxtNum := 42;
      13: ContxtNum := 43;
      14: ContxtNum := 51;
    end;
    Application.HelpContext(ContxtNum);
  end
  else begin    //show contents
    Application.HelpFile:='FIN_CALC.HLP';   //2.1
    Application.HelpCommand(HELP_FINDER, 0); //2.1
  end;
end;


procedure TFc_Form1.EditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key = VK_Return)  then
  begin
    CalcBtnClick(self);
    if (FinFunc in [1..13]) then  //2.1
      PostMessage(Handle, WM_KEYDOWN, VK_TAB, 0);   //2.1
  end;
end;


procedure TFc_Form1.PrintBtnClick(Sender: TObject);
var
  Line, i: integer;
  PrintText: System.Text;
begin
  if PrintDialog1.Execute then
  begin
    AssignPrn(PrintText);
    Rewrite(PrintText);

    Printer.Canvas.Font.Name := 'Courier New';
    Printer.Canvas.Font.Size := 10;

    writeln(PrintText, #10 + #10 + #10 + #10 + #13);

    for i := 0 to 7 do
      writeln(PrintText, '          ' +
        Fc_memo1.Lines[i]);

    writeln(PrintText, '          ' +
      ' Payment  Remaining   ---Interest Paid---   --Amount Amortized--');
    writeln(PrintText, '          ' +
      ' Number   Balance     This Time   To Date   This Time    To Date');
    Line := 9;
    while Line < Fc_Memo1.Lines.Count do
    begin
      writeln(PrintText, '          ' +
        Fc_memo1.Lines[Line]);
      Line := Line + 1;
      if Line mod 56 = 0 then
        write(PrintText, #12 + #10 + #10 + #10 + #10 + #13);
    end;
    System.Close(PrintText);
  end;
end;


procedure TFc_Form1.ExitBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TFc_Form1.FormActivate(Sender: TObject);
begin
  NewMortgData := True;
  Panel5.visible := True;
  Panel2.Caption := 'Select financial transactions from the Main Menu';
end;


procedure TFc_Form1.FormCreate(Sender: TObject);  //2.0 >>
begin
  Edit1 := TLsAlignEdit.Create(Self);
  with Edit1 do
  begin
    Parent := Panel1;
    Alignment := taRightJustify;
    RealValueOnly := True;
    Left := 308;
    Top := 20;
    Height := 23;
    Width := 121;
    Font.Name := 'MS Sans Serif';
    Font.Size := 9;
    Font.Color := clBlack;
    TabStop := True;
    TabOrder := 0;
  end;
  Edit2 := TLsAlignEdit.Create(Self);
  with Edit2 do
  begin
    Parent := Panel1;
    Alignment := taRightJustify;
    RealValueOnly := True;
    Left := 308;
    Top := 48;
    Height := 23;
    Width := 121;
    Font.Name := 'MS Sans Serif';
    Font.Size := 9;
    Font.Color := clBlack;
    TabStop := True;
    TabOrder := 1;
  end;
  Edit3 := TLsAlignEdit.Create(Self);
  with Edit3 do
  begin
    Parent := Panel1;
    Alignment := taRightJustify;
    RealValueOnly := True;
    Left := 308;
    Top := 76;
    Height := 23;
    Width := 121;
    Font.Name := 'MS Sans Serif';
    Font.Size := 9;
    Font.Color := clBlack;
    TabStop := True;
    TabOrder := 2;
  end;
  Edit4 := TLsAlignEdit.Create(Self);
  with Edit4 do
  begin
    Parent := Panel1;
    Alignment := taRightJustify;
    RealValueOnly := True;
    Left := 308;
    Top := 104;
    Height := 23;
    Width := 121;
    Font.Name := 'MS Sans Serif';
    Font.Size := 9;
    Font.Color := clBlack;
    TabStop := True;
    TabOrder := 3;
    OnKeyDown := EditKeyDown;
  end;
  Edit5 := TLsAlignEdit.Create(Self);
  with Edit5 do
  begin
    Parent := Panel3;
    Alignment := taRightJustify;
    RealValueOnly := True;  //2.1
    Left := 308;
    Top := 8;
    Height := 29;
    Width := 121;
    ColorNormal := clBlack;
    ColorFocused := clBlack;
    Font.Name := 'MS Sans Serif';
    Font.Size := 10;
    Font.Style := [fsBold];
    Font.Color := clLime;
    HideSelection := True;
    TabStop := False;
  end;
  Edit6 := TLsAlignEdit.Create(Self);
  with Edit6 do
  begin
    Parent := Panel7;
    Alignment := taRightJustify;
    RealValueOnly := True;  //2.1
    Left := 272;
    Top := 16;
    Height := 23;
    Width := 97;
    Font.Name := 'MS Sans Serif';
    Font.Size := 9;
    Font.Color := clBlack;
    TabStop := True;
  end;
  Edit7 := TLsAlignEdit.Create(Self);
  with Edit7 do
  begin
    Parent := Panel7;
    Alignment := taRightJustify;
    RealValueOnly := True;  //2.1
    Left := 272;
    Top := 44;
    Height := 23;
    Width := 97;
    Font.Name := 'MS Sans Serif';
    Font.Size := 9;
    Font.Color := clBlack;
    TabStop := True;
  end;
  Edit8 := TLsAlignEdit.Create(Self);
  with Edit8 do
  begin
    Parent := Panel7;
    Alignment := taRightJustify;
    RealValueOnly := True;  //2.1
    Left := 272;
    Top := 72;
    Height := 23;
    Width := 97;
    Font.Name := 'MS Sans Serif';
    Font.Size := 9;
    Font.Color := clBlack;
    TabStop := True;
  end;
  Edit9 := TLsAlignEdit.Create(Self);
  with Edit9 do
  begin
    Parent := Panel7;
    Alignment := taRightJustify;
    RealValueOnly := True;  //2.1
    Left := 272;
    Top := 100;
    Height := 23;
    Width := 97;
    Font.Name := 'MS Sans Serif';
    Font.Size := 9;
    Font.Color := clBlack;
    TabStop := True;
    OnKeyDown := EditKeyDown;  //2.1
  end;
  DisableEdits;
  Compute := False;  //2.1
  Panel5.visible := True;
end;  //2.0 <<


procedure TFc_Form1.Mortgage1Click(Sender: TObject);  //2.0 >>
begin
  CancelBtnClick(Self);  //2.1
  FinFunc := 14;  
  InValues := False;
  Panel7.Visible := True;
  Edit6.Enabled := True;
  Edit7.Enabled := True;
  Edit8.Enabled := True;
  Edit9.Enabled := True;
  CalcBtn.Enabled := True;
  RptBtn.Enabled := True;
  CancelBtn.Enabled := True;
  Caption := 'Financial Calculator (Mortgage)';  //2.1
  if NewMortgData = True then
  begin
    Edit6.Text := '';
    Edit7.Text := '';
    Edit8.Text := '';
    Edit9.Text := '';
  end;
  Edit6.SetFocus;
  if InValues = True then
  begin
    Panel7.Visible := False;
    ProcessMortgage;
  end;
end;  //2.0 <<


procedure TFc_Form1.ProcessMortgage;  //2.0 >>
var
  Principal, Payment, InterestRate, LastPayment: Double;
  Balance, Interest, IntFactor, Amortized: Double;
  TotalPayments, TotalInterest, TotalAmort: Double;
  TotalNumPay, NumPayPerYr, PayNum: integer;
  TotalNumMon, NumPayPerMon: integer;
  Header1, Header2, Header3, Header4: string;
  oneLine, st1, st2, st3, st4, st5, st6, st7, st8: string;
//  ErrMsg: string;
begin
  FinFunc := 14;
  Label1.visible := False;
  Panel1.visible := False;
  Panel2.Caption := '';
  Print1.Enabled := True;
  PrintSetup1.Enabled := True;
  Fc_Memo1.Align := alClient;
  Fc_Memo1.Clear;
  GetOut := False;
  Label1.Caption := ' MORTGAGE - Analysis of loan repayments';
  Header1 := '             MORTGAGE - Analysis of loan repayments';
  Header2 := ' ===============================================================';
  Header3 := '                       Repayment Schedule                       ';
  Header4 := ' ---------------------------------------------------------------';

  if not InValues then
    exit;
  if GetOut = True then
    Exit;

  // Convert input data
  Principal := StrToFloat(Edit6.Text);
  InterestRate := StrToFloat(Edit7.Text);
  TotalNumMon := StrToInt(Edit8.Text);
  NumPayPerMon := StrToInt(Edit9.Text);

  // Process and display data, also create Mortgage.txt file
  TotalNumPay := TotalNumMon * NumPayPerMon;
  NumPayPerYr := 12 * NumPayPerMon;
  Payment := LoanPay(Principal, InterestRate, TotalNumPay, NumPayPerYr);
  Payment := Round(Payment * 100) /100;  //2.1
  Balance := Principal;
  IntFactor := InterestRate / NumPayPerYr;
  TotalPayments := 0.0;
  TotalInterest := 0.0;
  TotalAmort := 0.0;
  PayNum := 0;

  st1 := ' Principal(amount borrowed) = ' + Format('%-10.2f', [Principal]);
  st2 := ' Annual Interest Rate(%)    = ' + Format('%-2.6f', [InterestRate]);
  st3 := ' Term of loan (in months)   = ' + Format('%-5d', [TotalNumMon]);
  st4 := ' Number payments per month  = ' + Format('%-1d', [NumPayPerMon]);
  st5 := ' Regular Payment per period = ' + Format('%-10.2f', [Payment]);

{$I-}
  AssignFile(OUTPUT, 'MORTGAGE.TXT');
  Rewrite(OUTPUT);

  writeln(OUTPUT, Header1);
  writeln(OUTPUT, Header2);
  writeln(OUTPUT, st1);
  writeln(OUTPUT, st2);
  writeln(OUTPUT, st3);
  writeln(OUTPUT, st4);
  writeln(OUTPUT, st5);
  writeln(OUTPUT, Header2);
  writeln(OUTPUT, Header3);
  writeln(OUTPUT, Header4);

  repeat
    PayNum := PayNum + 1;
    Interest := Balance * IntFactor / 100.0;
    Interest := Round(Interest * 100) / 100; //2.1
    if PayNum = TotalNumPay then
      Payment := Balance + Interest;
    LastPayment := Payment;
    Amortized := Payment - Interest;
    Balance := Balance - Amortized;
    if Balance < 0.0 then
    begin
      Payment := Payment + Balance;
      LastPayment := Payment;
      Amortized := Amortized + Balance;
      Balance := 0.0;
    end;
    TotalPayments := TotalPayments + Payment;
    TotalInterest := TotalInterest + Interest;
    TotalAmort := TotalAmort + Amortized;
    oneLine := Format('%5d %13.2f %10.2f %10.2f %10.2f %11.2f',
      [PayNum, Balance, Interest, TotalInterest, Amortized, TotalAmort]);
    writeln(OUTPUT, oneLine);
  until
    (PayNum = TotalNumPay) or (Balance = 0.0);
  writeln(OUTPUT, Header2);
  writeln;
  st6 := ' Last payment      = ' + Format('%11.2f', [LastPayment]);
  st7 := ' Total payments    = ' + Format('%11.2f', [TotalPayments]);
  st8 := ' Cost of borrowing = ' + Format('%11.2f', [(TotalPayments - Principal)]);
  writeln(OUTPUT, st6);
  writeln(OUTPUT, st7);
  writeln(OUTPUT, st8);
  System.CloseFile(OUTPUT);

  Fc_Memo1.visible := True;
  ClearBtn2.Visible := True;
  PrintBtn.Visible := True;
  Label1.visible := True;
  Label6.Caption := 'MORTGAGE - Payment per period';
  Label6.Visible := True;
  Edit5.Text := FormatFloat('#,##0.00', Payment);

  AssignFile(INPUT, 'MORTGAGE.TXT');
  Reset(INPUT);
  Fc_Memo1.Lines.LoadFromFile('MORTGAGE.TXT');
  Fc_Memo1.Modified := False;
  System.CloseFile(INPUT);
{$I+}
end; //ProcessMortgage  //2.0 <<


end.

