//---------------------------------------------------------------------------
#ifndef TfisFileNotificationH
#define TfisFileNotificationH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
//---------------------------------------------------------------------------
class TDirThread : public TThread
{
private:
    AnsiString prDirectory;
    HANDLE prKillEvent;
    bool prSubTree;
    DWORD prNotifyFilter;
    TTimer *prTimer;
protected:
    void __fastcall Execute();
public:
    __fastcall TDirThread(AnsiString aDirectory, bool aSubTree, DWORD aNotifyFilter,
        TTimer *aTimer);
    __fastcall ~TDirThread();
};
//---------------------------------------------------------------------------
enum TNotifyOption
{
    noFilename,
    noDirname,
    noAttributes,
    noSize,
    noLastWrite,
    noLastAccess,
    noCreation
};

typedef Set<TNotifyOption, noFilename, noCreation>  TNotifyOptions;
//---------------------------------------------------------------------------
class PACKAGE TfisFileNotification : public TComponent
{
private:
    bool prStarted;
    bool FSubTree;
    TNotifyOptions FOptions;
    AnsiString FDirectory;
    TNotifyEvent FOnDirectoryChanged;
    TDirThread *thrDirThread;
    TTimer *prTimer;
protected:
    void __fastcall Timer(TObject *Sender);
public:
    __fastcall TfisFileNotification(TComponent* Owner);
    __fastcall ~TfisFileNotification(void);
    void __fastcall Start(void);
    void __fastcall Stop(void);
__published:
    __property TNotifyEvent OnDirectoryChanged = {read = FOnDirectoryChanged,
        write = FOnDirectoryChanged};
    __property bool SubTree = {read = FSubTree, write = FSubTree,
        default = false};
    __property AnsiString Directory = {read = FDirectory, write = FDirectory};
    __property TNotifyOptions Notification = {read = FOptions, write = FOptions,
        default = noLastWrite};
};
//---------------------------------------------------------------------------
#endif
