//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TfisFileNotification.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TfisFileNotification *)
{
    new TfisFileNotification(NULL);
}
//---------------------------------------------------------------------------
__fastcall TDirThread::TDirThread(AnsiString aDirectory, bool aSubTree,
    DWORD aNotifyFilter, TTimer *aTimer) : TThread(false)
{
    prKillEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
    prDirectory = aDirectory;
    prSubTree = aSubTree;
    prNotifyFilter = aNotifyFilter;
    prTimer = aTimer;
}
//---------------------------------------------------------------------------
__fastcall TDirThread::~TDirThread()
{
    SetEvent(prKillEvent);
    CloseHandle(prKillEvent);
}
//---------------------------------------------------------------------------
void __fastcall TDirThread::Execute()
{
    HANDLE lObjList[2];

    lObjList[0] = prKillEvent;
    if((lObjList[1] = FindFirstChangeNotification(prDirectory.c_str(), prSubTree,
        prNotifyFilter)) != INVALID_HANDLE_VALUE)
    {
        do
        {
            if(WaitForMultipleObjects(2, lObjList, false, INFINITE) == WAIT_OBJECT_0)
            {
                break;
            }
            prTimer->Enabled = true;
        }while(FindNextChangeNotification(lObjList[1]));
        FindCloseChangeNotification(lObjList[1]);
    }
}
//---------------------------------------------------------------------------
__fastcall TfisFileNotification::TfisFileNotification(TComponent* Owner)
    : TComponent(Owner)
{
    FSubTree = false;
    prStarted = false;
    FDirectory = "";
    FOptions << noLastWrite;
    prTimer = new TTimer(this);
    prTimer->Enabled = false;
    prTimer->Interval = 10;
    prTimer->OnTimer = Timer;
}
//---------------------------------------------------------------------------
__fastcall TfisFileNotification::~TfisFileNotification(void)
{
    if(!ComponentState.Contains(csDesigning))
    {
        Stop();
    }
}
//---------------------------------------------------------------------------
void __fastcall TfisFileNotification::Timer(TObject *Sender)
{
    prTimer->Enabled = false;
    if(FOnDirectoryChanged)
    {
        FOnDirectoryChanged(this);
    }
}
//---------------------------------------------------------------------------
void __fastcall TfisFileNotification::Start(void)
{
    if(!prStarted)
    {
        DWORD lNotifyFilter = 0;
        for(int lItem = noFilename; lItem <= noCreation; lItem++)
        {
            if(FOptions.Contains((TNotifyOption)lItem))
            {
                lNotifyFilter += 1 << lItem;
            }
        }
        thrDirThread = new TDirThread(FDirectory, FSubTree, lNotifyFilter, prTimer);
        prStarted = true;
    }
}
//---------------------------------------------------------------------------
void __fastcall TfisFileNotification::Stop(void)
{
    if(prStarted)
    {
        delete thrDirThread;
        prStarted = false;
    }
}
//---------------------------------------------------------------------------
namespace Tfisfilenotification
{
    void __fastcall PACKAGE Register()
    {
         TComponentClass classes[1] = {__classid(TfisFileNotification)};
         RegisterComponents("FISH", classes, 0);
    }
}
//---------------------------------------------------------------------------


