unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, FolderTree, ExtCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    lblCurrentPath: TLabel;
    eSetPath: TEdit;
    Button1: TButton;
    cbxRecycleBin: TCheckBox;
    cbxNetHood: TCheckBox;
    RadioGroup1: TRadioGroup;
    cbxVirtualFirst: TCheckBox;
    FolderTree1: TFolderTree;
    procedure FolderTree1Change(Sender: TObject; Node: TTreeNode);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbxRecycleBinClick(Sender: TObject);
    procedure cbxNetHoodClick(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure cbxVirtualFirstClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FolderTree1Change(Sender: TObject; Node: TTreeNode);
begin
   lblCurrentPath.caption := FolderTree1.Directory;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   FolderTree1.SetDirectory(eSetPath.text);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
//
end;

procedure TForm1.cbxRecycleBinClick(Sender: TObject);
begin
   with FolderTree1 do
     if cbxRecycleBin.checked
       then FolderOptions := FolderOptions + [foRecycleBin]
       else FolderOptions := FolderOptions - [foRecycleBin];
end;

procedure TForm1.cbxNetHoodClick(Sender: TObject);
begin
   with FolderTree1 do
     if cbxNetHood.checked
       then FolderOptions := FolderOptions + [foNetworkNeighborhood]
       else FolderOptions := FolderOptions - [foNetworkNeighborhood];
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
   FolderTree1.DisplayMode := TDisplayMode(RadioGroup1.ItemIndex);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  FolderTree1.Active:=true;
  cbxRecycleBinClick(cbxRecycleBin);
  cbxNetHoodClick(cbxNetHood);
  RadioGroup1Click(RadioGroup1);
end;

procedure TForm1.cbxVirtualFirstClick(Sender: TObject);
begin
   with FolderTree1 do
     if cbxVirtualFirst.checked
       then FolderOptions := FolderOptions + [foVirtualFirst]
       else FolderOptions := FolderOptions - [foVirtualFirst];
end;

end.
