{Author:	Poul Bak}
{}
{Copyright  1999 - 2001 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft-denmark@dk2net.dk}
{}
{Component Version: 5.00.00.00}
{}
{PBSpinEdit is a standard Delphi Edit component with Alignment and
mouse-AutoSelect-all.}
{Can replace standard components without any disadvantages.}

{Supports Windows 95, 98 and NT.}
{Supports Default-Button click. (Standard SpinEdit does not).}
{Supports Cancel-button click.}

unit PBSpinEdit;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, Spin;

type
{Author:	Poul Bak}
{}
{Copyright  1999 - 2001 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft-denmark@dk2net.dk}
{}
{Component Version: 5.00.00.00}
{}
{PBSpinEdit is a standard Delphi Edit component with Alignment and
mouse-AutoSelect-all.}
{Can replace standard components without any disadvantages.}

{Supports Windows 95, 98 and NT.}
{Supports Default-Button click. (Standard SpinEdit does not).}
{Supports Cancel-button click.}
	TPBSpinEdit = class(TSpinEdit)
	private
		{ Private declarations }
		FAlignment : TAlignment;
		FEnter : Boolean;
		FVersion : string;
		function GetCursor : TCursor;
		procedure SetAlignment(Value: TAlignment);
		procedure SetCursor(Value : TCursor);
		procedure SetVersion(Value: String);
		procedure WMGetDlgCode(var Msg : TWMGetDlgCode); message WM_GETDLGCODE;
	protected
		{ Protected declarations }
		procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
		procedure DoEnter; override;
		procedure KeyDown(var Key: Word; Shift: TShiftState); override;
		procedure KeyPress(var Key: Char); override;
	public
		{ Public declarations }
		constructor Create(AOwner: TComponent); override;
		procedure CreateParams(var Params: TCreateParams); override;
	published
{Set Alignment to: taLeftJustify, taCenter or taRightJustify.}
{Default : taLeftJustify.}
{Supports Windows 95, 98 and NT.}
		property Alignment: TAlignment read FAlignment write SetAlignment;
{Default: True.}
{Set AutoSelect to True to select all text when you set focus:}
{Notice that when you set focus using the mouse, all text is also selected -
unlike standard Delphi components that only selects all when setting focus with <tab>.}
{When a form has a defaultbutton and you press <enter>, the click event
triggers and focus is returned to the edit control which autoselect all.}
		property AutoSelect;
		property Cursor : TCursor read GetCursor write SetCursor;
{Read only. }
		property Version: String read FVersion write SetVersion stored False;
end;

procedure Register;

implementation

constructor TPBSpinEdit.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
	Width := 100;
	FAlignment := taLeftJustify;
	FVersion := '5.00.00.00';
	Text := '';
	FEnter := False;
end;

procedure TPBSpinEdit.CreateParams(var Params: TCreateParams);
const
	Alignments: array[TAlignment] of Word = (ES_LEFT, ES_RIGHT, ES_CENTER);
begin
	inherited CreateParams(Params);
	Params.Style := Params.Style or ES_MULTILINE or Alignments[FAlignment];
end;

procedure TPBSpinEdit.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	if (Button = mbLeft) or (ssLeft in Shift) then
	begin
		if FEnter = True then
		begin
			FEnter := False;
			if AutoSelect then SelectAll;
		end;
	end;
	inherited MouseDown(Button, Shift, X, Y);
end;

procedure TPBSpinEdit.DoEnter;
begin
	inherited DoEnter;
	if csLButtonDown in ControlState then FEnter := True;
	if AutoSelect then SelectAll;
end;

procedure TPBSpinEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
	inherited KeyDown(Key, Shift);
	FEnter := False;
end;

procedure TPBSpinEdit.KeyPress(var Key: Char);
begin
	if (Key in [#13, #27]) then
	begin
		Key := #0;
		MessageBeep(0);
	end
	else inherited;
end;

procedure TPBSpinEdit.SetAlignment(Value: TAlignment);
var
	SelSt, SelLe : integer;
begin
	if FAlignment <> Value then
	begin
		SelSt := SelStart;
		SelLe := SelLength;
		FAlignment := Value;
		RecreateWnd;
		SelStart := SelSt;
		SelLength := SelLe;
	end;
end;

procedure TPBSpinEdit.SetVersion(Value: String);
begin
	{ Read only! }
end;

function TPBSpinEdit.GetCursor : TCursor;
begin
	Result := inherited Cursor;
end;

procedure TPBSpinEdit.SetCursor(Value : TCursor);
begin
	if inherited Cursor <> Value then
	begin
		inherited Cursor := Value;
		Button.Cursor := Value;
	end;
end;

procedure TPBSpinEdit.WMGetDlgCode(var Msg: TWMGetDlgCode);
begin
	Msg.Result := DLGC_WANTCHARS or DLGC_WANTARROWS;
end;

procedure Register;
begin
	RegisterComponents('PB', [TPBSpinEdit]);
end;

end.

