unit PBEditPackDemo_unit;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ExtCtrls, PBBinHexEdit, Mask, PBMaskEdit, StdCtrls, PBEdit, PBNumEdit, Spin,
	PBSpinEdit, ComCtrls, PBSuperSpin;

type
  TPBEditPackDemoForm = class(TForm)
    PBNumEdit1: TPBNumEdit;
    PBBinHexEdit1: TPBBinHexEdit;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button2: TButton;
    Bevel2: TBevel;
    Button3: TButton;
    CheckBox1: TCheckBox;
    Bevel3: TBevel;
    Bevel1: TBevel;
    PBMaskEdit1: TPBMaskEdit;
    PBSpinEdit1: TPBSpinEdit;
    CheckBox2: TCheckBox;
    PBEdit1: TPBEdit;
    PBSuperSpin1: TPBSuperSpin;
    Label4: TLabel;
    DecimalEdit: TPBSuperSpin;
    Label5: TLabel;
    CancelButton: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SetDecimalsClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PBEditPackDemoForm: TPBEditPackDemoForm;

implementation

{$R *.DFM}

procedure TPBEditPackDemoForm.Button1Click(Sender: TObject);
begin
	if PBEdit1.Alignment = taCenter then PBEdit1.Alignment := taLeftJustify
	else if PBEdit1.Alignment = taLeftJustify then PBEdit1.Alignment := taRightJustify
	else PBEdit1.Alignment := taCenter;
	if PBMaskEdit1.Alignment = taCenter then PBMaskEdit1.Alignment := taLeftJustify
	else if PBMaskEdit1.Alignment = taLeftJustify then PBMaskEdit1.Alignment := taRightJustify
	else PBMaskEdit1.Alignment := taCenter;
	if PBNumEdit1.Alignment = taRightJustify then PBNumEdit1.Alignment := taCenter
	else if PBNumEdit1.Alignment = taCenter then PBNumEdit1.Alignment := taLeftJustify
	else PBNumEdit1.Alignment := taRightJustify;
	if PBSuperSpin1.Alignment = taRightJustify then PBSuperSpin1.Alignment := taCenter
	else if PBSuperSpin1.Alignment = taCenter then PBSuperSpin1.Alignment := taLeftJustify
	else PBSuperSpin1.Alignment := taRightJustify;
	if PBBinHexEdit1.Alignment = taCenter then PBBinHexEdit1.Alignment := taLeftJustify
	else if PBBinHexEdit1.Alignment = taLeftJustify then PBBinHexEdit1.Alignment := taRightJustify
	else PBBinHexEdit1.Alignment := taCenter;
	if PBSpinEdit1.Alignment = taCenter then PBSpinEdit1.Alignment := taLeftJustify
	else if PBSpinEdit1.Alignment = taLeftJustify then PBSpinEdit1.Alignment := taRightJustify
	else PBSpinEdit1.Alignment := taCenter;
end;

procedure TPBEditPackDemoForm.Button2Click(Sender: TObject);
begin
	if PBBinHexEdit1.BaseFormat = Binary then PBBinHexEdit1.BaseFormat := HexaDecimal
	else if PBBinHexEdit1.BaseFormat = HexaDecimal then PBBinHexEdit1.BaseFormat := Number
	else if PBBinHexEdit1.BaseFormat = Number then PBBinHexEdit1.BaseFormat := Binary;
end;

procedure TPBEditPackDemoForm.Button3Click(Sender: TObject);
begin
	if PBNumEdit1.NumberFormat = Engineering then PBNumEdit1.NumberFormat := Standard
	else if PBNumEdit1.NumberFormat = Standard then PBNumEdit1.NumberFormat := Thousands
	else if PBNumEdit1.NumberFormat = Thousands then PBNumEdit1.NumberFormat := Scientific
	else PBNumEdit1.NumberFormat := Engineering;
	if PBSuperSpin1.NumberFormat = Engineering then PBSuperSpin1.NumberFormat := Standard
	else if PBSuperSpin1.NumberFormat = Standard then PBSuperSpin1.NumberFormat := Thousands
	else if PBSuperSpin1.NumberFormat = Thousands then PBSuperSpin1.NumberFormat := Scientific
	else PBSuperSpin1.NumberFormat := Engineering;
end;

procedure TPBEditPackDemoForm.FormCreate(Sender: TObject);
begin
	DecimalEdit.AsInteger := PBNumEdit1.Decimals;
end;

procedure TPBEditPackDemoForm.SetDecimalsClick(Sender: TObject);
begin
	PBNumEdit1.Decimals := DecimalEdit.AsInteger;
	PBSuperSpin1.Decimals := DecimalEdit.AsInteger;
	DecimalEdit.AsInteger := PBNumEdit1.Decimals;
end;


procedure TPBEditPackDemoForm.CheckBox1Click(Sender: TObject);
begin
	Button1.Default := CheckBox1.Checked;
end;

procedure TPBEditPackDemoForm.CheckBox2Click(Sender: TObject);
begin
	PBBinHexEdit1.AutoSelect := Not PBBinHexEdit1.AutoSelect;
	PBEdit1.AutoSelect := not PBEdit1.AutoSelect;
	PBMaskEdit1.AutoSelect := not PBMaskEdit1.AutoSelect;
	PBNumEdit1.AutoSelect := not PBNumEdit1.AutoSelect;
	PBSuperSpin1.AutoSelect := not PBSuperSpin1.AutoSelect;
	PBSpinEdit1.AutoSelect := not PBSpinEdit1.AutoSelect;
end;

procedure TPBEditPackDemoForm.CancelButtonClick(Sender: TObject);
begin
	Application.MessageBox('Pressing Escape automatically calls the CancelButton''s OnClick-event !',
		'Cancel !', MB_OK+MB_ICONASTERISK+MB_DEFBUTTON1+MB_APPLMODAL);
end;

end.

