unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  AutoRunner, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    CurrentUserCheck: TRadioButton;
    LocalMachineCheck: TRadioButton;
    CheckBox1: TCheckBox;
    AutoRunner: TAutoRunner;
    RG_Where: TRadioGroup;
    procedure CurrentUserCheckClick(Sender: TObject);
    procedure LocalMachineCheckClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure RG_WhereClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CurrentUserCheckClick(Sender: TObject);
begin
  AutoRunner.RegLocation := CurrentUser;

  RG_Where.controls[2].Enabled :=False;
  RG_Where.controls[3].Enabled :=False;
end;

procedure TForm1.LocalMachineCheckClick(Sender: TObject);
begin
  AutoRunner.RegLocation := LocalMachine;

  RG_Where.controls[2].Enabled :=True;
  RG_Where.controls[3].Enabled :=True;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  CheckBox1.Checked := AutoRunner.AutoRun;
  CurrentUserCheck.Checked := AutoRunner.RegLocation = CurrentUser;
  LocalMachineCheck.Checked := AutoRunner.RegLocation = LocalMachine;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  AutoRunner.AutoRun := CheckBox1.Checked;
end;

procedure TForm1.RG_WhereClick(Sender: TObject);
begin
     Case RG_Where.ItemIndex of

          0: AutoRunner.AutoRunWhere := Run;
          1: AutoRunner.AutoRunWhere := RunOnce;
          2: AutoRunner.AutoRunWhere := RunServices;
          3: AutoRunner.AutoRunWhere := RunServicesOnce;

     end;
end;

end.
