{
---------------------------------------------------------------
Code generated by AF Component Wizard
AF Component Wizard 2002 AFComponents - Ferruccio Accalai http://www.afsoftware.it
Idea by MAS-CompMaker, 2000-2002 Mats Asplund http://go.to/mdp
---------------------------------------------------------------

Component Name: TAFVersionCaption
        Author: Ferruccio Accalai
 Creation Date: 11/06/2002
       Version: 1.1
   Description: Component to show File Version directly in the application
                main form caption
        E-mail: info@afsoftware.it
       Website: www.afsoftware.it
  Legal Issues: All rigths reserved 2002-2004  by Ferruccio Accalai


Usage:
  This software is provided 'as-is', without any express or
  implied warranty.  In no event will the author be held liable
  for any  damages arising from the use of this software.

  Permission is granted to anyone to use this software for any
  purpose, including commercial applications, and to alter it
  and redistribute it freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented,
     you must not claim that you wrote the original software.
     If you use this software in a product, an acknowledgment
     in the product documentation would be appreciated but is
     not required.

  2. Altered source versions must be plainly marked as such, and
     must not be misrepresented as being the original software.

  3. This notice may not be removed or altered from any source
     distribution.

  4. If you decide to use this software in any of your applications.
     Send me an EMail and tell me about it.

Quick Reference:
  TAFVersionCaption inherits from TComponent.
  It add to the form caption the application version number if available.

  History:
  20/5/2004
   Removed the Execute procedure and moved the SetUpCaption call to the
   overrided Loaded procedure.
   Now it isn't needed to do any call during the Form.onactivate.
  11/6/2002
   First built of TAFVersionCaption;

  Key-Properties:

   @@@
   property InfoPrefix: String read GetInfoPrefix write SetInfoPrefix;
      This is custom prefix that you want to show before the version value
   @@@
   property ShowInfoPrefix: boolean read FShowInfoPrefix write
      SetShowInfoPrefix;
      If true then InfoPrefix will be showed;
   @@@
   property ShowParenthesis: Boolean read FParenthesis write
      SetShowParenthesis;
      If true the version value will be showed between parenthesis, oterwise not.
   @@@
   property ShortInfo: boolean read fShortInfo write fShortInfo;
      If true the version value will be showed in short format (1.00) otherwise
      it will be showed in format 1.0.0.0
   @@@

  Key-Events:
   @@@
   property OnError: TNotifyEvent read fOnError write fOnError;
      If an error occurs you can assign this event to create a custom caption
   @@@
   property OnNoInfoAvailable: TNotifyEvent read fOnNoInfoAvailable write
      fOnNoInfoAvailable;
      same as above, but just in case of no version info stored
   @@@
  Key-Methods:
      Protected: Loaded; override;
      The procedure that create te caption. Works only on runtime.
---------------------------------------------------------------
}

unit AFVersionCaption;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type

  TAFVersionCaption = class(TComponent)
  private
         { Private declarations }
    FInfoPrefix: string;
    FShowInfoPrefix: boolean;
    FCaption: String;
    FOldCaption: String;
    FParenthesis: Boolean;
    fShortInfo: Boolean;
    fOnError: TNotifyEvent;
    fOnNoInfoAvailable: TNotifyEvent;
    function GetInfo: string;
    procedure SetInfoPrefix(Value: String);
    function GetInfoPrefix: string;
    procedure SetShowInfoPrefix(Value: boolean);
    procedure SetShowParenthesis(VAlue: Boolean);
    procedure SetupCaption;
    function GetForm: TForm;
  protected
         { Protected declarations }
    property Form: TForm read GetForm;
    procedure Loaded; Override;
  public
         { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
         { Published declarations }
    property InfoPrefix: String read GetInfoPrefix write SetInfoPrefix;
    property ShowInfoPrefix: boolean read FShowInfoPrefix write
      SetShowInfoPrefix;
    property ShowParenthesis: Boolean read FParenthesis write
      SetShowParenthesis;
    property ShortInfo: boolean read fShortInfo write fShortInfo;
    property OnError: TNotifyEvent read fOnError write fOnError;
    property OnNoInfoAvailable: TNotifyEvent read fOnNoInfoAvailable write
      fOnNoInfoAvailable;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('AFCtrl',[TAFVersionCaption]);
end;

constructor TAFVersionCaption.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ShowInfoPrefix := true;
  FInfoPrefix := 'File Version:';
  FoldCaption := Form.Caption;
  fShortInfo := False;
end;

destructor TAFVersionCaption.Destroy;
begin
  inherited Destroy;
end;


function TAFVersionCaption.GetInfo: string;
var
  Size, Size2: DWord;
  Point, Point2: Pointer;
begin
  Size := GetFileVersionInfoSize(PChar (ParamStr (0)), Size2);
  if Size > 0 then
    begin
		GetMem (Point, Size);
      try
        If GetFileVersionInfo (PChar (ParamStr (0)), 0, Size, Point) then
			 begin
				VerQueryValue (Point, '\', Point2, Size2);
				with TVSFixedFileInfo (Point2^) do
				  begin
					 If fShortInfo then
						result := Format('%d.%.2d', [HiWord (dwFileVersionMS),LoWord
						  (dwFileVersionMS)])
					 else
						result := IntToStr (HiWord (dwFileVersionMS)) + '.' +
						  IntToStr (LoWord (dwFileVersionMS)) + '.' + IntToStr (
						  HiWord (dwFileVersionLS)) + '.' + IntToStr (LoWord (
						  dwFileVersionLS));
              end;
          end
        else
          begin
            result := '';
            If Assigned(fOnError) then
              fOnError(self);
          end;
      finally
		  FreeMem (Point);
      end;
    end
  else
    begin
      result := '';
      If Assigned(fOnNoInfoAvailable) then
        fOnNoInfoAvailable(self);
    end;
  If result <> '' then
    begin
      if ShowInfoPrefix then
        Result := InfoPrefix+' '+Result;
      if FParenthesis then
        result := '('+result+')';
    end;
end;

procedure TAFVersionCaption.SetInfoPrefix(Value: String);
begin
  if FInfoPrefix = Value then
    exit;
  FInfoPrefix := Value;
  SetupCaption;
end;
procedure TAFVersionCaption.SetShowParenthesis(Value: Boolean);
begin
  if FParenthesis = Value then
    exit;
  FParenthesis := Value;
  SetupCaption;
end;


function TAFVersionCaption.GetInfoPrefix: string;
begin
  result := FInfoPrefix;
end;

procedure TAFVersionCaption.SetShowInfoPrefix(Value: boolean);
begin
  if FShowInfoPrefix = value then
    exit;
  FShowInfoPrefix := Value;
  SetupCaption;
end;


procedure TAFVersionCaption.SetupCaption;
begin
  FCaption := GetInfo;
end;
function TAFVersionCaption.GetForm: TForm;
begin
  if Owner is TCustomForm then
    Result := TForm(Owner as TCustomForm)
  else
    Result := nil;
end;
Procedure TAFVersionCaption.Loaded;
begin
If not (CsDesigning in ComponentState) then begin
  SetUpCaption;
  If pOS('<',FCaption) = 0 then
    Form.Caption := FOldCaption+' '+FCaption
  else
    Form.Caption := FOldCaption;
  end;
end;

end.
