unit LedGroup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  stdctrls,DigitLed;

  type
  TLedGroup = class(TCustomGroupBox)
  private
    { Private declarations }
    FMaxDigits : byte;      //Number of digits
    Led        : TDigitLed;
    FCaption   : String;
    FCommaPos  : Byte;
    FOnColor   : TColor;
    FOffColor  : TColor;
    FMargin    : Byte;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure CreateDigits;
    procedure SetMaxDigits(Num:Byte);
    procedure Paint;override;
    procedure SetCaption(Caption:String);
    procedure SetCommaPos(Position:Byte);
    procedure SetOnColor(color:TColor);
    procedure SetOffColor(color:TColor);
    Procedure SetMargin (value:Byte);
  published
    { Published declarations }
    property MaxDigits: Byte Read FMaxDigits Write SetMaxDigits;
    property Caption : String Read FCaption Write SetCaption;
    property CommaPos : Byte Read FCommaPos Write SetCommaPos;
    property OnColor:TColor Read FOnColor Write SetOnColor Default clLime;
    property OffColor:TColor Read FOffColor Write SetOffColor Default clBtnFace;
    Property Margin : Byte Read FMargin Write SetMargin;
    property Color;
    property ShowHint;
  end;

procedure Register;

implementation
{$R *.DCR}

procedure Register;
begin
  RegisterComponents('MoonRed', [TLedGroup]);
end;

constructor TLedGroup.Create;
begin
inherited;
MaxDigits:=5;
Height:=65;
Width:=185;
FCaption:='     ';
FOnColor:=clLime;
FOffColor:=clBtnFace;
Color:=FOffColor;
CreateDigits;
end;

procedure TLedGroup.SetMaxDigits;
begin
FMaxDigits:=Num;
CreateDigits;
paint;
end;

procedure TLedGroup.CreateDigits;
var f:byte;
   aux: TComponent;
begin
for f:=1 to FMaxDigits do
  begin
  aux:=FindComponent('Led'+IntToStr(f));
  if (aux=nil) then  // if the led number does not exists
     begin  //creates the led
     Led:=TDigitled.Create(self);
     Led.Name:='Led'+IntToStr(f);
     led.top:=Margin;
     led.width:=Round((Width-Margin) / FMaxDigits);
     led.left:=(f-1)*(Round((Width-Margin-Margin) / FMaxDigits))+Margin;
     led.height:=height-(Margin+Margin);
     InsertControl(Led);
     end;
  end;

end;

procedure TLedGroup.Paint;
var
  f:byte;
begin
if ComponentCount>0 then
   begin
   for f:=0 to ComponentCount-1 do
    begin
    TWinControl(Components[f]).width:=round((Width-Margin) / FMaxDigits);
    TWinControl(Components[f]).left:=(f)*(Round((Width-Margin-Margin) / FMaxDigits))+Margin;
    TWinControl(Components[f]).top:=Margin;
    TWinControl(Components[f]).height:=height-(Margin+Margin);
    end;
   end;
end;

procedure TLedGroup.SetCaption;
var
  f:byte;
begin
if (Length(Caption)>0) then
   begin
   FCaption:=copy(Caption+'                    ',1,maxDigits);
   if Length(Caption)>ComponentCount
      then CreateDigits;
   for f:=0 to length(Caption)-1 do
    begin
    TDigitLed(components[f]).character:=FCaption[f+1];
    if f+1=CommaPos then TDigitLed(components[f]).Segments:=TDigitLed(components[f]).segments+[bPoint];
    end;
   end;
end;

procedure TLedGroup.SetCommaPos;
var
  f:byte;
begin
if (Position<=MaxDigits) and (Position>0) then
   begin
   FCommaPos:=Position;
   for f:=0 to ComponentCount-1 do
    begin
    if (f=Position-1) then //is the correct position
       begin
       TDigitLed(Components[f]).Segments:=TDigitLed(Components[f]).Segments+[bpoint]
       end
    else
       begin
       TDigitLed(Components[f]).Segments:=TDigitLed(Components[f]).Segments-[bpoint]
       end
    end // for
   end
else
   begin
   for f:=0 to ComponentCount-1 do
    begin
    TDigitLed(Components[f]).Segments:=TDigitLed(Components[f]).Segments-[bpoint]
    end // for
   end;

end;
procedure TLedGroup.SetOnColor;
var
  f:byte;
begin
for f:=0 to ComponentCount-1 do
 begin
 TDigitLed(Components[f]).OnColor:=color;
 end // for
end;

procedure TLedGroup.SetOffColor;
var
  f:byte;
begin
for f:=0 to ComponentCount-1 do
 begin
 TDigitLed(Components[f]).OffColor:=color;
 end // for
end;

procedure TLedGroup.SetMargin;
begin
FMargin:=Value;
Paint;
end;

end.

