unit DigitLed;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;
const
  CharCols=9;  //columns of every character (in dots)
  CharRows=9;  //rows of every character (in dots)

type
  TDigitBars = (bOne,bTwo,bThree,bFour,bFive,bSix,bSeven,bpoint,
                bDiagOne,bDiagTwo,bDiagThree,bDiagFour);
  TBarSet= set of TDigitBars;
  TArrChar = array ['0'..'Z'] of TBarSet;  //Holds the definition of every character

const
  CharDefs:TArrChar=([bOne,bTwo,bThree,bFour,bFive,bSix,bDiagTwo,bDiagFour],          // 0
                     [bTwo,bThree],                                // 1
                     [bOne,bTwo,bFour,bFive,bSeven],               // 2
                     [bOne,bTwo,bThree,bFour,bSeven],              // 3
                     [bTwo,bThree,bSix,bSeven],                    // 4
                     [bOne,bThree,bFour,bSix,bSeven],              // 5
                     [bOne,bThree,bFour,bFive,bSix,bSeven],        // 6
                     [bOne,bTwo,bThree,bSix],                      // 7
                     [bOne,bTwo,bThree,bFour,bFive,bSix,bSeven],   // 8
                     [bOne,bTwo,bThree,bFour,bSix,bSeven],         // 9
                     [],                                           // :
                     [bPoint],                                     // ;
                     [bDiagTwo,bDiagThree],                        // <
                     [bFour,bSeven],                               // =
                     [bDiagOne,bDiagFour], // >
                     [], // ?
                     [], // @
                     [bOne,bTwo,bThree,bFive,bSix,bSeven], // A
                     [bOne,bThree,bFour,bFive,bSix,bSeven,bDiagTwo], // B
                     [bOne,bFour,bFive,bSix], // C
                     [bTwo,bThree,bFour,bFive,bSeven], // D
                     [bOne,bFour,bFive,bSix,bSeven], // E
                     [bOne,bFive,bSix,bSeven], // F
                     [bOne,bThree,bFour,BFive,bSix,bSeven], // G
                     [bTwo,bThree,bFive,bSix,bSeven], // H
                     [bFive,bSix], // I
                     [bTwo,bThree,bFour,bFive], // J
                     [bThree,bFive,bSix,bSeven,BDiagTwo], // K
                     [bFour,bFive,bSix], // L
                     [bTwo,bThree,bFive,bSix,bDiagOne,bDiagTwo], // M
                     [bTwo,bThree,bFive,bSix,bDiagOne,bDiagThree], // N
                     [bOne,bTwo,bThree,bFour,bFive,bSix], // O
                     [bOne,bTwo,bFive,bSix,bSeven], // P
                     [bOne,bTwo,bThree,bFour,bFive,bSix,bDiagThree], // Q
                     [bOne,bTwo,bFive,bSix,bSeven,bDiagThree], // R
                     [bOne,bThree,bFour,bSix,bSeven], // S
                     [bFour,bFive,bSix,bSeven], // T
                     [bTwo,bThree,bFour,bFive,bSix], // U
                     [bFive,bSix,bDiagTwo,bDiagFour], // V
                     [bTwo,bThree,bFive,bSix,bDiagThree,bDiagFour], // W
                     [bDiagOne,bDiagTwo,bDiagThree,bDiagFour], // X
                     [bDiagOne,bDiagTwo,bDiagFour], // Y
                     [bOne,bFour,bDiagTwo,bDiagFour]); // Z;

type
  TCharacter = String[1];

  TDigitLed = class(TPaintBox)
  private
    { Private declarations }
    dw        : integer; //dot width
    dh        : integer; //dot height
    FOnColor  : TColor;
    FOffColor : TColor;
    FChar     : TCharacter;
    FSegments : TBarSet;

  protected
    { Protected declarations }
    function posdot(col,row,pos:byte):TPoint;
    procedure drawbar(bar:TDigitBars; Color:TColor; LineColor:TColor);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure paint; override;
    procedure SetOnColor(color:TColor);
    procedure SetOffColor(color:TColor);
    procedure SetSegments(Seg:TBarSet);
    procedure SetChar(Character: TCharacter);
  published
    { Published declarations }
    property OnColor:TColor Read FOnColor Write SetOnColor Default clLime;
    property OffColor:TColor Read FOffColor Write SetOffColor Default clBtnFace;
    property Segments:TBarSet Read FSegments Write SetSegments;
    property Character: TCharacter Read FChar Write SetChar;
    property Color;
    property ShowHint;
  end;

procedure Register;

implementation
{$R DIGITLED.DCR}

procedure Register;
begin
  RegisterComponents('MoonRed', [TDigitLed]);
end;

constructor TDigitLed.Create(AOwner: TComponent);
begin
inherited;
dw:=round(width / CharCols); // seven columns
dh:=round(height / CharRows); // nine rows
FOnColor:=clLime;
FOffColor:=clBtnFace;
Color:=clblack;
FSegments:=[bOne,bTwo,bThree,bFour,bFive,bSix,bSeven,bpoint,bDiagOne,bDiagTwo,bDiagThree,bDiagFour];
end;

function TDigitLed.posdot(col,row,pos:byte):TPoint;
begin  //Calculates the coordinate of 1 point inside a square
case pos of
  1: begin  // upperleft corner
     result.x:=(dw*col)-dw;
     result.y:=(dh*row)-dh;
     end;
  2: begin  // upperright corner
     result.x:=(dw*col);
     result.y:=(dh*row)-dh;
     end;
  3: begin  // downleft corner
     result.x:=(dw*col)-dw;
     result.y:=(dh*row);
     end;
  4: begin  // downright corner
     result.x:=(dw*col);
     result.y:=(dh*row);
     end;
  5: begin  // center
     {result.x:=(dw*col)-(dw div 2);
     result.y:=(dh*row)-(dh div 2);}
     result.x:=(dw*col)-round(dw / 2);
     result.y:=(dh*row)-round(dh / 2);
     end;
end; //case
end;

procedure TDigitLed.DrawBar;
begin
with canvas do
  begin
  brush.Color:=Color;
  pen.Color:=LineColor;
  case bar of
   bOne   : begin //bar 1
            polygon([posdot(1,1,5),posdot(2,1,1),posdot(CharCols-2,1,2),posdot(CharCols-1,1,5),
                  posdot(CharCols-2,1,4),posdot(2,1,3)]);
            end;
   bTwo   : begin
            polygon([posdot(CharCols-1,1,5),posdot(CharCols-1,2,2),posdot(CharCols-1,4,4),posdot(CharCols-1,5,5),
                     posdot(CharCols-1,4,3),posdot(CharCols-1,2,1)]);
            end;
   bThree : begin
            polygon([posdot(CharCols-1,5,5),posdot(CharCols-1,6,2),posdot(CharCols-1,CharCols-1,4),posdot(CharCols-1,9,5),
                  posdot(CharCols-1,CharCols-1+1,3),posdot(CharCols-1,6,1)]);
            end;
   bFour  : begin
            polygon([posdot(CharCols-1,9,5),posdot(CharCols-1-1,9,4),posdot(2,9,3),posdot(1,9,5),
                  posdot(2,9,1),posdot(CharCols-1,9,1)]);
            end;
   bFive  : begin
            polygon([posdot(1,5,5),posdot(1,6,2),posdot(1,CharCols-1,4),posdot(1,9,5),
                  posdot(1,CharCols-1,3),posdot(1,6,1)]);
            end;
   bSix   : begin
            polygon([posdot(1,1,5),posdot(1,2,2),posdot(1,4,4),posdot(1,5,5),
                  posdot(1,4,3),posdot(1,2,1)]);
            end;
   bSeven : begin
            polygon([posdot(CharCols-1,5,5),posdot(CharCols-1-1,5,4),posdot(2,5,3),posdot(1,5,5),
                  posdot(2,5,1),posdot(CharCols-1,5,1)]);
            end;
   bpoint : begin
            polygon([posdot(CharCols,CharRows,1),posdot(CharCols,CharRows,2),
                     posdot(CharCols,CharRows,4),posdot(CharCols,CharRows,3)]);
            end;
   bDiagOne:begin
            polygon([posdot(2,2,2),posdot(2,2,1),posdot(2,2,3),posdot(4,4,3),posdot(4,4,4),
                     posdot(4,4,2)]);
            end;
   bDiagTwo:begin
            polygon([posdot(charcols-2,2,1),posdot(charcols-2,2,2),posdot(charcols-2,2,4),
                     posdot(5,4,4),posdot(5,4,3),posdot(5,4,1)]);
            end;
 bDiagThree:begin
            polygon([posdot(5,6,1),posdot(5,6,2),posdot(charcols-2,8,2),posdot(charcols-2,8,4),
                     posdot(charcols-2,8,3),posdot(5,6,3)]);
            end;
  bDiagFour:begin
            polygon([posdot(4,6,1),posdot(4,6,2),posdot(4,6,4),
                     posdot(2,8,4),posdot(2,8,3),posdot(2,8,1)]);
            end;
       end; // case
  end; // with
end;


procedure TDigitLed.Paint;
var
  b:TDigitBars;
begin
inherited;
dw:=round(width / CharCols); // seven columns
dh:=round(height / CharRows); // nine rows
if hasparent then
for b:=bOne to bDiagFour do
 begin
 if b in Segments then DrawBar(b,OnCOlor,OffColor)
                  else DrawBar(b,OffCOlor,OffColor);
 end; //for
end;

procedure TDigitLed.SetOnColor;
begin
FOnColor:=Color;
Paint;
end;

procedure TDigitLed.SetOffColor;
begin
FOffColor:=Color;
Paint;
end;

procedure TDigitLed.SetSegments;
begin
FSegments:=seg;
Paint;
end;

procedure TDigitLed.SetChar;
var
  Havepoint:Boolean;
begin
Havepoint:=bpoint in Segments;
Character:=UpperCase(Character);
if Character[1] in ['0'..'Z'] then
   begin
   Segments:=CharDefs[Character[1]];
   FChar:=Character;
   end
else
   begin
   Segments:=[];
   FChar:='';
   end;
if Havepoint then Segments:=Segments+[bpoint];
end;
end.
