unit ListBx3D;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TListBox3DBevel = (bvNone,bvLowered,bvRaised,bvShadow);
  TListBox3DPressState = (bvNonePress,bvPress);
  TListBox3D = class(TCustomListBox)
  private
    FHighLightColor: TColor;
    FShadowColor: TColor;
    FBevel: TListBox3DBevel;
    FShadowSize: Byte;
    FPressState: TListBox3DPressState;
    procedure CNDrawItem(var Message: TWMDrawItem); message CN_DRAWITEM;
    procedure CNMeasureItem(var Message: TWMMeasureItem); message CN_MEASUREITEM;
    procedure DoDrawShadowText(ColorHigh,ColorLow: TColor;Rect: TRect;
      Index: Integer;State: TOwnerDrawState);
    function GetTextHeight: LongInt;
    procedure SetBevel(Value: TListBox3DBevel);
    procedure SetHighLightColor(Value: TColor);
    procedure SetShadowColor(Value: TColor);
    procedure SetShadowSize(Value: Byte);
  protected
    procedure DrawItem(Index: Integer; Rect: TRect;
      State: TOwnerDrawState); override;
    procedure MeasureItem(Index: Integer; var Height: Integer); override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property HighLightColor: TColor read FHighLightColor
      write SetHighLightColor default clBtnHighLight;
    property ShadowColor: TColor read FShadowColor
      write SetShadowColor default clBtnShadow;
    property Bevel: TListBox3DBevel read FBevel
      write SetBevel default bvRaised;
    property ShadowSize: Byte read FShadowSize
      write SetShadowSize default 1;
    property PressState: TListBox3DPressState read FPressState
      write FPressState default bvNonePress;
    {}
    property Align;
    property BorderStyle;
    property Color;
    property Columns;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property ExtendedSelect;
    property Font;
    property IntegralHeight;
    property ItemHeight;
    property Items;
    property MultiSelect;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Sorted;
    property Style;
    property TabOrder;
    property TabStop;
    property TabWidth;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('3DElements', [TListBox3D]);
end;

{
  class TListBox3D
  ~~~~~~~~~~~~~~~~
}
constructor TListBox3D.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Style:=lbOwnerDrawFixed;
  FHighLightColor:=clBtnHighLight;
  FShadowColor:=clBtnShadow;
  FBevel:=bvRaised;
  FShadowSize:=1;
  FPressState:=bvNonePress;
end;

procedure TListBox3D.DoDrawShadowText(ColorHigh,ColorLow: TColor;Rect: TRect;
  Index: Integer;State: TOwnerDrawState);
var
  R: TRect;
  OldColor: TColor;
  Flags: Word;
begin
  Flags:=DT_VCENTER or DT_SINGLELINE;
  OldColor:=Canvas.Font.Color;
  {High shadow text}
  if FBevel <> bvShadow then
  begin
    R:=Rect;
    OffsetRect(R,-FShadowSize,-FShadowSize);
    Inc(R.Left,2+FShadowSize);
    Canvas.Font.Color:=ColorHigh;
    if Enabled then
      DrawText(Canvas.Handle,PChar(Items[Index]),Length(Items[Index]),
        R,Flags);
  end;
  {Low shadow text}
  if (FBevel = bvShadow) and (odSelected in State) then
  else
  begin
    R:=Rect;
    OffsetRect(R,FShadowSize,FShadowSize);
    Inc(R.Left,2+FShadowSize);
    Canvas.Font.Color:=ColorLow;
    DrawText(Canvas.Handle,PChar(Items[Index]),Length(Items[Index]),
      R,Flags);
   end;
  {Text}
  Canvas.Font.Color:=OldColor;
  if not Enabled then Canvas.Font.Color:=clGrayText;
  Inc(Rect.Left,2+FShadowSize);
  DrawText(Canvas.Handle,PChar(Items[Index]),Length(Items[Index]),
    Rect,Flags);
end;

procedure TListBox3D.DrawItem(Index: Integer; Rect: TRect;
  State: TOwnerDrawState);
var
  R: TRect;
begin
  if Assigned(OnDrawItem) then OnDrawItem(Self,Index,Rect,State)
  else
  begin
    Canvas.FillRect(Rect);
    if odSelected in State then
    begin
      R:=Rect;
      DrawFrameControl(Canvas.Handle,R,DFC_BUTTON,DFCS_BUTTONPUSH);
    end;
    if Index < Items.Count then
    begin
      Canvas.Brush.Style:=bsClear;
      if FBevel = bvNone then
      begin
        Canvas.Font:=Font;
        Canvas.TextOut(Rect.Left+2,Rect.Top,Items[Index]);
      end
      else
        if (odSelected in State) and (FPressState = bvPress) then
          case FBevel of
            bvRaised : DoDrawShadowText(FShadowColor,FHighLightColor,
              Rect,Index,State);
            bvLowered: DoDrawShadowText(FHighLightColor,FShadowColor,
              Rect,Index,State);
            bvShadow : DoDrawShadowText(0,FShadowColor,Rect,Index,State);
          end
        else
          case FBevel of
            bvRaised : DoDrawShadowText(FHighLightColor,FShadowColor,
              Rect,Index,State);
            bvLowered: DoDrawShadowText(FShadowColor,FHighLightColor,
              Rect,Index,State);
            bvShadow : DoDrawShadowText(0,FShadowColor,Rect,Index,State);
          end;
    end;
  end;
end;

procedure TListBox3D.CNDrawItem(var Message: TWMDrawItem);
var
  State: TOwnerDrawState;
begin
  with Message.DrawItemStruct^ do
  begin
    Inc(rcItem.Bottom);
    State:=TOwnerDrawState(WordRec(LongRec(itemState).Lo).Lo);
    Canvas.Handle:=hDC;
    Canvas.Font:=Font;
    Canvas.Brush:=Brush;
    if Integer(itemID) >= 0 then
      DrawItem(itemID,rcItem,State)
    else
      Canvas.FillRect(rcItem);
    if (Integer(itemID) >= 0) and (odSelected in State) then
      Canvas.Brush.Color:=clHighlight;
    if odFocused in State then
    begin
      InflateRect(rcItem,-2,-2);
      Canvas.Pen.Color:=clWindowFrame;
      Canvas.Brush.Color:=clBtnFace;
      DrawFocusRect(Canvas.Handle,rcItem);
    end;
    Canvas.Handle:=0;
  end;
end;

procedure TListBox3D.CNMeasureItem(var Message: TWMMeasureItem);
begin
  with Message.MeasureItemStruct^ do
    MeasureItem(itemID,Integer(itemHeight));
end;

function TListBox3D.GetTextHeight: LongInt;
var
  hdcf: HDC;
  TM: TTextMetric;
  SaveFont: HFont;
begin
  hdcf:=GetDC(0);
  SaveFont:=SelectObject(hdcf,Font.Handle);
  GetTextMetrics(hdcf,TM);
  Result:=TM.tmHeight;
  SelectObject(hdcf,SaveFont);
  ReleaseDC(0,hdcf);
end;

procedure TListBox3D.MeasureItem(Index: Integer; var Height: Integer);
begin
  Height:=GetTextHeight+2;
  if FBevel <> bvNone then
    Inc(Height,2*FShadowSize);
end;

procedure TListBox3D.SetBevel(Value: TListBox3DBevel);
begin
  if FBevel <> Value then
  begin
    FBevel:=Value;
    Invalidate;
  end;
end;

procedure TListBox3D.SetHighLightColor(Value: TColor);
begin
  if FHighLightColor <> Value then
  begin
    FHighLightColor:=Value;
    Invalidate;
  end;
end;

procedure TListBox3D.SetShadowColor(Value: TColor);
begin
  if FShadowColor <> Value then
  begin
    FShadowColor:=Value;
    Invalidate;
  end;
end;

procedure TListBox3D.SetShadowSize(Value: Byte);
begin
  if FShadowSize <> Value then
  begin
    FShadowSize:=Value;
    ItemHeight:=GetTextHeight+2;
    if FBevel <> bvNone then
      ItemHeight:=ItemHeight+2*FShadowSize;
    Invalidate;
  end;
end;

end.
