unit Label3D;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls;

type
  TLabel3DBevel = (bvNone,bvLowered,bvRaised,bvShadow);
  TLabel3D = class(TLabel)
  private
    FHighLightColor: TColor;
    FShadowColor: TColor;
    FBevel: TLabel3DBevel;
    FShadowSize: Byte;
    procedure DoDrawText(var Rect: TRect;Flags: Word);
    procedure SetBevel(Value: TLabel3DBevel);
    procedure SetHighLightColor(Value: TColor);
    procedure SetShadowColor(Value: TColor);
    procedure SetShadowSize(Value: Byte);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property HighLightColor: TColor read FHighLightColor
      write SetHighLightColor default clBtnHighLight;
    property ShadowColor: TColor read FShadowColor
      write SetShadowColor default clBtnShadow;
    property Bevel: TLabel3DBevel read FBevel
      write SetBevel default bvRaised;
    property ShadowSize: Byte read FShadowSize
      write SetShadowSize default 1;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('3DElements', [TLabel3D]);
end;

{
  class TLabel3D
  ~~~~~~~~~~~~~~
}
constructor TLabel3D.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FHighLightColor:=clBtnHighLight;
  FShadowColor:=clBtnShadow;
  FBevel:=bvRaised;
  FShadowSize:=1;
end;

procedure TLabel3D.DoDrawText(var Rect: TRect;Flags: Word);
var
  Text: string;

procedure DoDrawShadowText(ColorHigh,ColorLow: TColor);
var
  R: TRect;
begin
  {High shadow text}
  if FBevel <> bvShadow then
  begin
    R:=Rect;
    OffsetRect(R,-FShadowSize,-FShadowSize);
    Canvas.Font.Color:=ColorHigh;
    if Enabled then
      DrawText(Canvas.Handle,PChar(Text),Length(Text),R,Flags);
  end;
  {Low shadow text}
  R:=Rect;
  OffsetRect(R,FShadowSize,FShadowSize);
  Canvas.Font.Color:=ColorLow;
  DrawText(Canvas.Handle,PChar(Text),Length(Text),R,Flags);
  {Text}
  Canvas.Font:=Font;
  if not Enabled then Canvas.Font.Color:=clGrayText;
  DrawText(Canvas.Handle,PChar(Text),Length(Text),Rect,Flags);
end;

begin
  Text:=GetLabelText;
  if (Flags and DT_CALCRECT <> 0) and ((Text = '') or ShowAccelChar and
    (Text[1] = '&') and (Text[2] = #0)) then Text:=Text+' ';
  if not ShowAccelChar then Flags:=Flags or DT_NOPREFIX;
  Canvas.Font:=Font;
  if FBevel = bvNone then
    DrawText(Canvas.Handle,PChar(Text),Length(Text),Rect,Flags)
  else
    case FBevel of
      bvRaised : DoDrawShadowText(FHighLightColor,FShadowColor);
      bvLowered: DoDrawShadowText(FShadowColor,FHighLightColor);
      bvShadow : DoDrawShadowText(0,FShadowColor);
    end;
end;

procedure TLabel3D.Paint;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var
  Rect: TRect;
begin
  with Canvas do
  begin
    if not Transparent then
    begin
      Brush.Color:=Self.Color;
      Brush.Style:=bsSolid;
      FillRect(ClientRect);
    end;
    Brush.Style:=bsClear;
    Rect:=ClientRect;
    DoDrawText(Rect,(DT_EXPANDTABS or DT_WORDBREAK) or
      Alignments[Alignment]);
  end;
end;

procedure TLabel3D.SetBevel(Value: TLabel3DBevel);
begin
  if FBevel <> Value then
  begin
    FBevel:=Value;
    Invalidate;
  end;
end;

procedure TLabel3D.SetHighLightColor(Value: TColor);
begin
  if FHighLightColor <> Value then
  begin
    FHighLightColor:=Value;
    Invalidate;
  end;
end;

procedure TLabel3D.SetShadowColor(Value: TColor);
begin
  if FShadowColor <> Value then
  begin
    FShadowColor:=Value;
    Invalidate;
  end;
end;

procedure TLabel3D.SetShadowSize(Value: Byte);
begin
  if FShadowSize <> Value then
  begin
    FShadowSize:=Value;
    Invalidate;
  end;
end;


end.
