{
  This code is donated to the public domain by me

   John Biddiscombe (The Lord of Darkness) - Feb 96. Mar 96.
   J.Biddiscombe@rl.ac.uk

  Distribute freely, use any of it you like.
  Send me some mail, It's nice to get feedback.

  Enjoy !
}

{
  second note - the code is a mess. I know. But it is only
  supposed to be a crappy game - I'm not trying to flog this as
  professional work. I've written all this in a 3 week period

  - not any more ! - But I haven't added much lately - Mar 96

  and not made any effort at all to tidy any up as I go along.
  Some bits are inefficient - but I've left them for reasons
  of my own. (mainly for future expansion etc etc)
  I will change all the bullets and bonuses, and
  add some more things too.

  On my machine in 800x600 mode Win95 it looks fine.

  On windows 3.x the bullets down the screen can look dodgy
  due to the lack of vertical retrace sync. Looks fine on win95
  I don't care about win3.x - though it might be that the win3.x
  machine I've been testing on is 1024x768 - Just don't know.

  Having said that...I've modified the game heavily so that it now runs
  OK on win3.x + Delphi 1, but the bullets still look dodgy.
  (too dark in a bright office - live in a cave - much better)

  I've put some comments in to guide anyone who isn't confident about
  this sort of thing. Apologies if it is trivial or wrong
  especially as I've put the comments in weeks after I wrote the code !!!
  you have been warned.

  when I put debug after a comment it usually means I put something in to
  test different ways of doing it, and the comment is just so I/we know

  The thing about games is that you try and optimize the code to do exactly
  what you want as fast as possible, so most of this is not - reusable -
  in the normal sense, but it will provide ideas.

  I listen to the radio while writing and often put records I hear in
  comments, Ignore them.

}


unit Gameform;

{ Yohan - New Kicks on Perfecto records  }
{ Album : deluxe men in space,artist ??  }

interface

uses
  { Borland }
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, StdCtrls, ExtCtrls, Dialogs,
  { Downloaded }
  { Mine }
  D_timer;

  { bonuses ???
    Extra energy
    Extra firespeed - up to limit of 15 ?
    Extra firepower - up to limit of ?
    Extra points
    Extra hyperspace jumps
    Extra Sheild energy
    Exploding bad bonus - 4 bullets
  }

const
  { some changes in Borlands implementation of API
    WIN32 - eg IntersectRect returns Boolean not integer }
  {$IFDEF VER90} { Delphi 2 }
  boolresult : boolean = false;
  {$ELSE }       { Delphi 1 }
  boolresult : integer = 0;
  {$ENDIF}

const
  new_monsters_per_sheet = 3;
  monsters_per_side      = 4;
  monsters_per_sidem1    = monsters_per_side-1;
  difficulty1            = 160;
  difficulty1m1          = difficulty1-1;
  difficulty2            = 30;
  difficulty2m1          = difficulty2-1;
  d_factor               = 1;
  pphit                  = 10;
  time_average           = 0.0029;    { the smaller the faster ! }
                                      { try it on 0.001 !!!      }
const
  top_row_y   = 64;    { all the squares are aligned on 64 pixel boundaries }
  left_col_x  = 64;    { this means I can do fast if (xx and 63) =0 tests   }
  right_col_x = 512;   { to check motion, firing etc                        }

type
  directions = array[0..2] of integer;
const
  randhoriz : directions = (0,1,2);
  randvert  : directions = (0,3,4);
  emptyRect : TRect = (left:0; top:0; right:0; bottom:0);

{ only use virtual when you must !!! - static calls are much faster
  Delphi components are wonderful for GUI's, but avoid them at times
  like these                                                         }

type
  PRectArray = ^TRectArray;
  TRectArray = array[0..0] of TRect;

{
all the objects are created at startup, none are created or destroyed
during play - changes are made to images etc by changing pointers or
rects
}

type
  Tmultiple_bitmap = Class(TObject)
    image           : TRect;
    images,imagesm1 : integer;
    imagewidth      : integer;
    imageheight     : integer;
    anim_pos        : integer;
    anim_counter    : integer;
    anim_rate       : integer;
    anim_dir        : integer;
    imagerects      : PRectArray;
    constructor Create(abitmap:TRect; numimages,rate:integer);
    destructor  Destroy; override;
    procedure   SetBitmap(abitmap:TRect; numimages,rate:integer);
    procedure   imagerect(imagenum:integer; var arect:TRect);
    function    animateimage : boolean;
    procedure   animation_forwards;
    procedure   animation_backwards;
  end;

type
  TBullet = Class(TObject)
    bp,lp       : TPoint;
    maxx,minx   : integer;
    maxy,miny   : integer;
    good        : boolean;
    horizontal  : boolean;
    direction   : integer;
    damage      : integer;
    constructor Create;
    destructor  Destroy; override;
    procedure   Setup(x,y:integer; dir:integer; dam:integer);
    procedure   SetupLimits(xmx,xmn,ymx,ymn:integer; goodguy:boolean);
    procedure   EraseThenDraw;
    procedure   Draw;
    procedure   Erase;
    function    Move : integer;
  end;

type
  objectarray = array[0..0] of TObject;
  indexarray  = array[0..0] of integer;

{ This is a bit excessive really, it works though ! }
{ bigger than it needs to be because of dynamic allocation and fixed limits }
{ by which I mean - maximum number of bullets is fixed, so linked list has
  limits at both ends }
{ ....and crap coding here ! (true too) }
type
  Tdoubly_linked_list = Class(TObject)
    listsize   : integer;
    listsizem1 : integer;
    objects    : ^objectarray;
    nextone    : ^indexarray;
    lastone    : ^indexarray;
    firstused  : integer;
    lastused   : integer;
    firstfree  : integer;
    lastfree   : integer;
    constructor create(size:integer);
    destructor  destroy; override;
    procedure   initialize;
    function    nextfree : integer;
    procedure   freeup(num:integer);
  end;

type
  TBulletlist = Class(Tdoubly_linked_list)
    constructor Create(size:integer);
    destructor  Destroy; override;
  end;

type
  TBonus = Class;

  TBonuslist = Class(Tdoubly_linked_list)
    constructor Create(size:integer);
    destructor  Destroy; override;
    procedure   update_counters;
    function    point_in_rects(x:TPoint) : TBonus;
  end;

  spritestate = (normal,exploding,dead);{ ..but I didn't eat the salmon mousse !}

  TSprite = Class(TObject)
    status        : spritestate;
    spritepic     : Tmultiple_bitmap;
    exploder      : Tmultiple_bitmap;
    sx,sy,sw,sh   : integer;
    offx,offy     : integer;
    maxx,minx     : integer;
    maxy,miny     : integer;
    needsredraw   : boolean;
    thisdirection : integer;
    firedirection : integer;
    constructor Create(abitmap:TRect; numimages,rate:integer; explosion:TRect; expimages,erate:integer);
    destructor  Destroy; override;
    procedure   SetupLimits(x,y,xmx,xmn,ymx,ymn,dir:integer);
    procedure   changepicture(newpic:TRect; numimages,rate:integer);
    procedure   changeexplosion(newpic:TRect; numimages,rate:integer);
    procedure   Draw;
    procedure   Erase;
    procedure   kill;
    function    animate : boolean;
    procedure   MoveTo(x,y:integer);
  end;

  TMonster = Class(TSprite)
    level         : integer;
    maxlevel      : integer;
    points        : integer;
    move_counter  : integer;
    procedure set_level(lev:integer);
  end;

  typeofbonus = (powerup2,powerup5,powerup10,firespeedup,firepowerup);
{ more to be added }

  TBonus = Class(TSprite)
    bonustype : typeofbonus;
    counter   : integer;
    constructor Create(abitmap:TRect; numimages,rate:integer; explosion:TRect; expimages,erate:integer; btype:typeofbonus);
    destructor  Destroy; override;
  end;

const
  bonusfreq   : array[0..ord(firepowerup)] of integer = (65,75,80,90,100);
{ probablity distribution for bonuses }

type
  TMonstergroup = Class(TObject)
    monsters    : array[0..monsters_per_side]   of TMonster;
    draworder   : array[0..monsters_per_sidem1] of integer;
    empty1st    : integer;
    horizontal  : boolean;
    xpos,ypos   : integer;
    setupgap    : integer;
    xl,xh,yl,yh : integer;
    constructor create(hor_flag:boolean; posx,posy,spacing,xmx,xmn,ymx,ymn:integer);
    destructor  destroy; override;
    procedure   reset_original_state(sheet:integer);
    procedure   draw;
    procedure   force_redraw;
    function    movegroup : boolean;
    function    are_any_exploding : boolean;
    function    is_hit_left(bullet:Tbullet) : integer;
    function    is_hit_right(bullet:Tbullet) : integer;
    function    is_hit_top(bullet:Tbullet ) : integer;
    procedure   Sendmonstershome;
  end;

type
  TPowerMeter = class(TObject)
    screenpos   : TPoint;
    notch       : TSprite;
    position    : integer;
    lastpos     : integer;
    orientation : integer;
    constructor create(image:TRect; startpos,orient:integer; pos:TPoint);
    destructor  destroy; override;
    procedure   setpos(newpos:integer);
    procedure   reset(newpos:integer);
    procedure   pminc;
    function    pmdec : boolean;
    procedure   draw;
  end;

type
  TScoremeter = class(TObject)
    digits     : TMultiple_bitmap;
    slots      : array[0..15] of integer;
    numdigs    : integer;
    score      : longint;
    lastscore  : longint;
    screen_pos : TPoint;
    i_width    : integer;
    i_height   : integer;
    s_inc      : integer;
    constructor create(image:TRect; numimages:integer; screenpos:TPoint; digs,sincr:integer);
    destructor  destroy; override;
    procedure   display(redo:boolean);
  end;

{
the best way to get speed increases is to use the game rules to limit wasted checks
etc. I've used a black background and sprites with a black edge to avoid
transparent copies.
Also bullets are only checked against the sides they are going to
(bonuses can't be avoided, but the linked list approach minimizes
wasted checks
}

type
  TGame_Form = class(TForm)
    go_button       : TButton;
    Pause_button    : TButton;
    New_game_button : TButton;
    exit_button     : TButton;
    Panel1          : TPanel;
    Panel2          : TPanel;
    Panel3          : TPanel;
    Panel4          : TPanel;
    Game_window     : TPaintBox;  { I don't like these at all }
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Pause_buttonClick(Sender: TObject);
    procedure go_buttonClick(Sender: TObject);
    procedure exit_buttonClick(Sender: TObject);
    procedure New_game_buttonClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormResize(Sender: TObject);
    procedure Game_windowPaint(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDeactivate(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure initialize;
    procedure setup_level(lev:integer);
    procedure start_game;
    procedure stop_game;
    procedure Confine_cursor(trap:boolean);
    procedure layoutsquares(destDC:HDC);
    procedure Mainloop;
    procedure Sendmonstershome;
    procedure Move_Players_ship;
    procedure Redraw_ship_bullets;
    procedure Redraw_monster_bullets;
    procedure NewShipBullet;
    procedure NewMonsterBullet(monster:TSprite);
    procedure redraw_monsters;
    procedure move_monsters;
    procedure Collisionwithbonus;
    procedure Createnewbonus;
    procedure Increase_score(num:integer);
  end;

{
don't let people tell you global variables are bad.
They have a fixed address, so the compiler can put them in instead of
pointer referencing
Normally I don't do this, but for the game, It doesn't matter
I don't need to encapsulate these in any objects.
If it works. Then fine.
}

var
  Game_Form      : TGame_Form;
  creation       : longint;       { monitoring objects                    }

{
  To speed things up, and to prevent delphi farting around and releasing
  handles to windows and DC's, I've created a single Memory DC with all
  the bitmaps on it. Then I use TRects which are all tiny windows on the
  mem DC for each sprite, each is then StretchBlt'ed onto screen (yes odd
  though it is, Stretchblt is slightly faster than Bitblt, or it was last
  time I timed it anyway). Only one DC is used for all the source BMPs
  and one Screen DC is requested for the main window.

  I've had to change this - now I'm using a TPaintbox and getting the DC every
  loop, which is not my prefered way of doing it. But I was having problems
  with win3.x.
}
  Game_DC        : HDC;           { the DC used for all game drawing      }
  Source_BMP     : TBitmap;
  Source_DC      : HDC;           { the bitmap with all the sprites on it }
  dull_bitmap    : HBitmap;       { the one the DC comes with             }
  lastbonusscore : longint;
  lastpause      : boolean;       { debug                                 }
  paused         : boolean;       { Game paused flag                      }
  shiprect       : TRect;         { Ship position for bullet checks       }
  sheet          : integer;       { current level                         }
  sheetmaxmon    : integer;       { current level + 3 (for monsters)      }

  monstergallery : array[1..20] of TRect;
  monstersgoinghome : boolean;
  bonusgallery   : array[0..9]  of TRect;
  bonushit       : TBonus;
  bonusallowed   : boolean;
  shipimage      : TRect;
  explosionimage : TRect;
  smallexpimage  : TRect;
  blankimage     : TRect;
  squareimage    : TRect;
  energyimage    : TRect;
  scoreimage     : TRect;
  scorecaption   : TRect;
  levelcaption   : TRect;
  Bullet_speed   : integer;
  bullet_damage  : integer;

  spaceship        : TSprite;
  topmonsters      : TMonstergroup;
  leftmonsters     : TMonstergroup;
  rightmonsters    : TMonstergroup;
  square           : TSprite;
  powerlevel       : TPowerMeter;
  shootlevel       : TPowerMeter;
  scoresheet       : TScoreMeter;
  levelsheet       : TScoreMeter;
  tickcount        : longint;
  shipbullettick   : longint;
  shipbullets      : TBulletList;
  MonsterBullets   : TBulletList;
  bonuses          : TBonuslist;
  dir_keys         : array[0..5] of boolean;
  lastlr           : integer;
  lastud           : integer;

  frames : array[0..3] of frame_speed_obj; { dodgy bodge used in debug }
  stick  : longint; { what is this ??? I can't remember, shall I just delete it }
  { I remember - it's used by the scoremeter to do the updates in units of x }

implementation

{$R *.DFM}

var Game_Dir : string;
{
I've got millions of bitmaps in my sprites directory, that is why
I use a sub-dir for gamepic. sorry.
}

function LoadBitmap(name:string) : TBitmap;
var tb : TBitmap;
begin
  tb := TBitmap.Create;
  tb.loadfromfile(name);
  result := tb;
end;

{ ---------------------------------------------------------------------------- }
{                               Simple Bullet                                  }
{ ---------------------------------------------------------------------------- }
constructor TBullet.Create;
begin
  inherited create;
  inc(creation); { when the program ends, creation should be 0, if it isn't }
end;             { I know I've forgotten to free some objects - debug       }

destructor TBullet.Destroy;
begin
  dec(Creation);
  inherited destroy;
end;

procedure TBullet.Setup(x,y:integer; dir:integer; dam:integer);
begin
  bp        := Point(x,y);
  lp        := bp;
  direction := dir;
  damage    := dam;
  if (direction=1) or (direction=2) then horizontal := true
  else horizontal := false;
end;

{ stop the bullet going too far off the edge }
procedure TBullet.SetupLimits(xmx,xmn,ymx,ymn:integer; goodguy:boolean);
begin
  good := goodguy; { monster or ours }
  maxx := xmx;
  minx := xmn;
  maxy := ymx;
  miny := ymn;
end;

{setpixel is slooow. I need directdraw to really soup up the bullets }

procedure TBullet.EraseThenDraw;      { all the bullets will be changed }
begin
  if horizontal then begin
    SetPixel(Game_DC,lp.x  ,lp.y  ,$00000000);
{    SetPixel(Game_DC,lp.x+1,lp.y  ,$00000000);}
{    SetPixel(Game_DC,lp.x-1,lp.y  ,$00000000);}
    SetPixel(Game_DC,bp.x  ,bp.y  ,$00FFFFFF);
{    SetPixel(Game_DC,bp.x+1,bp.y  ,$00FFFFFF);}
{    SetPixel(Game_DC,bp.x-1,bp.y  ,$00FFFFFF);}
  end
  else begin
    SetPixel(Game_DC,lp.x  ,lp.y  ,$00000000);
{    SetPixel(Game_DC,lp.x  ,lp.y+1,$00000000);}
{    SetPixel(Game_DC,lp.x  ,lp.y-1,$00000000);}
    SetPixel(Game_DC,bp.x  ,bp.y  ,$00FFFFFF);
{    SetPixel(Game_DC,bp.x  ,bp.y+1,$00FFFFFF);}
{    SetPixel(Game_DC,bp.x  ,bp.y-1,$00FFFFFF);}
  end;
end;

procedure TBullet.Draw;
begin
  if horizontal then begin
    SetPixel(Game_DC,bp.x  ,bp.y  ,$00FFFFFF);
{    SetPixel(Game_DC,bp.x+1,bp.y  ,$00FFFFFF);}
{    SetPixel(Game_DC,bp.x-1,bp.y  ,$00FFFFFF);}
  end
  else begin
    SetPixel(Game_DC,bp.x  ,bp.y  ,$00FFFFFF);
{    SetPixel(Game_DC,bp.x  ,bp.y+1,$00FFFFFF);}
{    SetPixel(Game_DC,bp.x  ,bp.y-1,$00FFFFFF);}
  end;
end;

procedure TBullet.Erase;
begin
  if horizontal then begin
    SetPixel(Game_DC,lp.x  ,lp.y  ,$00000000);
{    SetPixel(Game_DC,lp.x+1,lp.y  ,$00000000);}
{    SetPixel(Game_DC,lp.x-1,lp.y  ,$00000000);}
  end
  else begin
    SetPixel(Game_DC,lp.x  ,lp.y  ,$00000000);
{    SetPixel(Game_DC,lp.x  ,lp.y+1,$00000000);}
{    SetPixel(Game_DC,lp.x  ,lp.y-1,$00000000);}
  end;
end;

{ I could do two descendent objects for horiz and vert objects and use a virtual
approach, but a case statment is faster for just a couple of derived types }
{ I think }
function TBullet.Move : integer;
begin
  result := 0;
  lp     := bp;
  if not good then begin
    case direction of
      0 : begin result:=1; exit; end;
      1 : begin if bp.x<=minx then begin result:=1; exit; end else bp.x := bp.x - 3; end;
      2 : begin if bp.x>=maxx then begin result:=1; exit; end else bp.x := bp.x + 3; end;
      3 : begin if bp.y<=miny then begin result:=1; exit; end else bp.y := bp.y - 3; end;
      4 : begin if bp.y>=maxy then begin result:=1; exit; end else bp.y := bp.y + 3; end;
    end;
    if (PtInRect(shiprect,bp)) and (GetPixel(Game_DC,bp.x,bp.y)<>0) then result := 2
    else begin
      bonushit:=bonuses.point_in_rects(bp); if bonushit<>nil then result:=3;
    end;
  end
  else begin
    case direction of
      0 : begin result:=1; exit; end;
      1 : begin if bp.x<=minx then begin result:=1; exit; end else bp.x := bp.x - 4; end;
      2 : begin if bp.x>=maxx then begin result:=1; exit; end else bp.x := bp.x + 4; end;
      3 : begin if bp.y<=miny then begin result:=1; exit; end else bp.y := bp.y - 4; end;
      4 : begin if bp.y>=maxy then begin result:=1; exit; end else bp.y := bp.y + 4; end;
    end;
    if (GetPixel(Game_DC,bp.x,bp.y)<>0) then begin
      result := 2;
    end;
  end;
end;
{ ---------------------------------------------------------------------------- }
{                             Doubly linked list                               }
{ ---------------------------------------------------------------------------- }

{ this is really dreadful, but it works }
constructor Tdoubly_linked_list.Create(size:integer);
var lp1 : integer;
begin
  inherited create;
  inc(creation);
  listsize   := size;
  listsizem1 := size-1;
  getmem(objects,listsize*sizeof(pointer));
  getmem(nextone,listsize*sizeof(pointer));
  getmem(lastone,listsize*sizeof(pointer));
  initialize;
end;

destructor Tdoubly_linked_list.destroy;
var lp1 : integer;
begin
  dec(creation);
  for lp1:=0 to listsizem1 do objects^[lp1].free;
  freemem(objects,listsize*sizeof(pointer));
  freemem(nextone,listsize*sizeof(pointer));
  freemem(lastone,listsize*sizeof(pointer));
  inherited destroy;
end;

procedure Tdoubly_linked_list.initialize;
var lp1 : integer;
begin
  for lp1:=0 to listsizem1 do begin
    nextone^[lp1]:=lp1+1;
    lastone^[lp1]:=lp1-1;
  end;
  firstused   :=-1;
  lastused    :=-1;
  firstfree   := 0;
  lastfree    := listsizem1;
  lastone^[firstfree] := -1;
  nextone^[lastfree]  := -1;
end;

function Tdoubly_linked_list.nextfree : integer;
begin
  result := firstfree;
  if firstfree<>-1 then begin
    if firstused=-1 then firstused:=firstfree;
    lastused  := firstfree;
    firstfree := nextone^[firstfree];
    if firstfree=-1 then lastfree:=-1;
  end;
end;

procedure Tdoubly_linked_list.freeup(num:integer);
begin { this bit needs trimming down, but it is quite fast like this }
{ its really because bullets can be destroyed 'out of order' and to quickly
scan the list of on screen bullets I want them in a linked list.
The bullets are the most time consuming bit (relatively) when lots are on screen }
  if num=firstused then begin { - lots of else's so each chunk is only done once }
    if firstused=lastused then begin  { OK }
      firstused           := -1;
      lastused            := -1;
      nextone^[lastfree]  := num;
      lastone^[num]       := lastfree;
      lastfree            := num;
      nextone^[lastfree]  :=-1;
      lastone^[firstfree] :=-1;
    end
    else begin
      firstused := nextone^[firstused];
      lastone^[firstused] :=-1;
      if lastfree=-1 then begin   { OK }
        firstfree           := num;
        lastfree            := num;
        nextone^[lastused]  := num;
        lastone^[firstfree] := lastused;
        nextone^[lastfree]  := -1;
      end
      else begin            { OK }
        nextone^[lastfree] := num;
        lastone^[num]      := lastfree;
        lastfree           := num;
        nextone^[num]      :=-1;
      end;
    end;
  end
  else if num=lastused then begin
    lastused:=lastone^[lastused];
    if lastfree=-1 then begin { OK }
      firstfree           := num;
      lastfree            := num;
      nextone^[lastused]  := num;
      lastone^[firstfree] := lastused;
      nextone^[lastfree]  := -1;
    end
    else begin { OK }
      nextone^[lastused]  := firstfree;
      lastone^[firstfree] := lastused;
      nextone^[lastfree]  := num;
      lastone^[num]       := lastfree;
      lastfree            := num;
      nextone^[num]       :=-1;
    end;
  end
  else begin { OK }
    nextone^[lastone^[num]]:=nextone^[num];
    lastone^[nextone^[num]]:=lastone^[num];
    if lastfree=-1 then begin
      firstfree           := num;
      lastfree            := num;
      nextone^[lastused]  := num;
      lastone^[firstfree] := lastused;
      nextone^[lastfree]  := -1;
    end
    else begin { OK }
      nextone^[lastfree] := num;
      lastone^[num]      := lastfree;
      lastfree           := num;
      nextone^[lastfree] :=-1;
    end;
  end;
end;
{ ---------------------------------------------------------------------------- }
{                             Bullet linked list                               }
{ ---------------------------------------------------------------------------- }
constructor TBulletlist.Create(size:integer);
var lp1 : integer;
begin
  inc(creation);
  inherited create(size);
  for lp1:=0 to listsizem1 do objects^[lp1] := TBullet.Create;
end;

destructor TBulletlist.Destroy;
begin
  dec(creation);
  inherited destroy;
end;
{ ---------------------------------------------------------------------------- }
{                             Bonus linked list                                }
{ ---------------------------------------------------------------------------- }
constructor TBonuslist.Create(size:integer);
var lp1 : integer;
begin
  inc(creation);
  inherited create(size);
  for lp1:=0 to listsizem1 do objects^[lp1] :=    { use any default image to start }
    TBonus.Create(bonusgallery[0],1,0,smallexpimage,8,3,powerup2);
end;  { they get set properly when they appear randomly later }

destructor TBonuslist.Destroy;
begin
  dec(creation);
  inherited destroy;
end;

procedure TBonuslist.update_counters; { each bonus has a ticker counting down }
var lp1,lp2,ff : integer;
    tb         : TBonus;
begin
  lp1 := firstused; if lp1<0 then exit;
  repeat
    tb := TBonus(objects^[lp1]); lp2:=nextone^[lp1]; ff:=firstfree;
    with tb do begin
      case status of
        normal : begin
                   if counter>1 then begin dec(counter); end
                   else kill;
                 end;
        exploding : begin if not animate then freeup(lp1); end;
      end;
      if needsredraw then draw;
    end;
    lp1:=lp2;
  until (lp2=ff) or (lp2=-1);
end;

function TBonuslist.point_in_rects(x:TPoint) : TBonus;
var lp1,lp2,ff : integer; { is this point in the rect occupied by the bonuses }
    tb         : TBonus;  { scan the linked list - most of the time it'll bomb }
    bonusrect  : TRect;   { out because none are on screen }
begin
  result := nil;
  if firstused<>-1 then begin lp1 := firstused;
    repeat
      tb := TBonus(objects^[lp1]); lp2:=nextone^[lp1]; ff:=firstfree;
      with tb do begin
        Setrect(bonusrect,sx+3,sy+3,sx+13,sy+13);
        if PtinRect(bonusrect,x) then begin result := tb; exit; end;
      end;
      lp1:=lp2;
    until (lp2=ff) or (lp2=-1);
  end;
end;
{ ---------------------------------------------------------------------------- }
{                             Multiple Bitmap                                  }
{ ---------------------------------------------------------------------------- }
constructor Tmultiple_bitmap.Create(abitmap:TRect; numimages,rate:integer);
begin
  inherited create;
  inc(creation);
  SetBitmap(abitmap,numimages,rate);
end;

destructor Tmultiple_bitmap.Destroy;
begin
  if imagerects<>nil then FreeMem(imagerects,images*Sizeof(TRect));
  dec(Creation);
  inherited destroy;
end;

procedure Tmultiple_bitmap.SetBitmap(abitmap:TRect; numimages,rate:integer);
var lp1 : integer;
begin
  if imagerects<>nil then FreeMem(imagerects,images*Sizeof(TRect));
  image       := abitmap;
  images      := numimages;
  imagesm1    := numimages-1;
  imagewidth  := (image.right-image.left) div images;
  imageheight := (image.Bottom-image.top);
  anim_pos    := 0;
  anim_rate   := rate;
  anim_dir    := 1;
  GetMem(imagerects,images*Sizeof(TRect));
  for lp1 := 1 to images do imagerect(lp1-1,imagerects^[lp1-1]);
end;
{ create an array of TRects with all the squares set up before hand
  then we can access them as quick as possible when drawing }

procedure Tmultiple_bitmap.imagerect(imagenum:integer; var arect:TRect);
begin
  with arect do begin
    left   := image.left+imagenum*imagewidth;
    right  := left+imagewidth;
    top    := image.top;
    bottom := top+imageheight;
  end;
end;

function Tmultiple_bitmap.animateimage : boolean; { result is true by default }
begin                                             { not in Delphi 2 it isn't  }
  result := true;
  anim_counter := (anim_counter+1) and anim_rate;
  if anim_counter=0 then anim_pos := (anim_pos+anim_dir) and imagesm1
  else result := false;
end;
{ this function returns true normally, but false after last image
  useful for finding out when the explosion sequence has finished }

procedure Tmultiple_bitmap.animation_forwards;
begin anim_dir := 1; end;

procedure Tmultiple_bitmap.animation_backwards;
begin anim_dir :=-1; end; { imploding explosions ??? cool ! }
{ ---------------------------------------------------------------------------- }
{                                    Sprite                                    }
{ ---------------------------------------------------------------------------- }
constructor TSprite.Create(abitmap:TRect; numimages,rate:integer; explosion:TRect; expimages,erate:integer);
begin
  inherited create;
  inc(creation);
  spritepic     := Tmultiple_bitmap.Create(abitmap,numimages,rate);
  if expimages<>0 then
    exploder    := Tmultiple_bitmap.Create(explosion,expimages,erate)
  else exploder := nil;
  sw            := spritepic.imagewidth;
  sh            := spritepic.imageheight;
  offx          := sh div 2;
  offy          := sw div 2;
end;

destructor TSprite.Destroy;
begin
  spritepic.Free;
  exploder.Free;
  dec(Creation);
  inherited destroy;
end;

{ the limits are used to stop bullets and sprites going too far in any direction }
procedure TSprite.SetupLimits(x,y,xmx,xmn,ymx,ymn,dir:integer);
begin
  sx            := x;
  sy            := y;
  maxx          := xmx;
  minx          := xmn;
  maxy          := ymx;
  miny          := ymn;
  status        := normal;
  thisdirection := dir;
  firedirection := dir;
  needsredraw   := false;
end;

{ when we kill one monster and replace with the next type }
procedure TSprite.changepicture(newpic:TRect; numimages,rate:integer);
begin
  spritepic.SetBitmap(newpic,numimages,rate);
end;

procedure TSprite.changeexplosion(newpic:TRect; numimages,rate:integer);
begin      { not used at the moment }
  exploder.SetBitmap(newpic,numimages,rate);
end;

procedure TSprite.Draw;
begin
  case status of
    normal : with spritepic do with imagerects^[anim_pos] do begin
        StretchBlt(Game_DC,sx,sy,sw,sh,Source_DC,left,top,sw,sh,SrcCopy);
      end;
    exploding : with exploder do with imagerects^[anim_pos] do begin
        StretchBlt(Game_DC,sx,sy,sw,sh,Source_DC,left,top,sw,sh,SrcCopy);
      end;
    dead : ;
  end;
  needsredraw := false;
end;

procedure TSprite.Erase; { not used normally }
begin
  PatBlt(Game_DC,sx,sy,sw,sh,Blackness);
  needsredraw := false;
end;

procedure TSprite.kill;
begin
  status            := exploding;
  exploder.anim_pos := 0;
  thisdirection     := 0;
  needsredraw       := true;
end;

function TSprite.animate : boolean;  { result is true by default }
begin result := true; { Delphi 2 doesn't set default results - bastards }
  case status of
    normal    : with spritepic do if (images>1) and animateimage then needsredraw:=true;
    exploding : begin
      if exploder.animateimage then begin
        if exploder.anim_pos=0 then begin status:=dead; erase; result:=false; end
        else needsredraw:=true;
      end;
    end;
  end;
end;

procedure TSprite.MoveTo(x,y:integer); { not used }
begin
  sx := x-offx; sy := y-offy; needsredraw := true;
end;
{ ---------------------------------------------------------------------------- }
{                             Monster                                          }
{ ---------------------------------------------------------------------------- }
procedure TMonster.set_level(lev:integer);
begin
  points        := lev;
  level         := lev;
  maxlevel      := lev+new_monsters_per_sheet-1;
end;
{ ---------------------------------------------------------------------------- }
{                             Bonus                                            }
{ ---------------------------------------------------------------------------- }
constructor TBonus.Create(abitmap:TRect; numimages,rate:integer; explosion:TRect; expimages,erate:integer; btype:typeofbonus);
begin
  inc(creation);
  inherited create(abitmap,numimages,rate,explosion,expimages,erate);
  bonustype := btype;
end;

destructor  TBonus.Destroy;
begin
  dec(creation);
  inherited destroy;
end;
{ ---------------------------------------------------------------------------- }
{                               Monster Group                                  }
{ ---------------------------------------------------------------------------- }
constructor TMonstergroup.create(hor_flag:boolean; posx,posy,spacing,xmx,xmn,ymx,ymn:integer);
var lp1 : integer;
begin
  inherited create;
  inc(creation);
  horizontal   := hor_flag;
  xpos         := posx;
  ypos         := posy;
  setupgap     := spacing;
  xl           := xmn;
  xh           := xmx;
  yl           := ymn;
  yh           := ymx;
  for lp1 := 0 to monsters_per_sidem1 do
    monsters[lp1] := TMonster.Create(monstergallery[1],1,0,explosionimage,16,3);
  monsters[monsters_per_side] := TMonster.Create(blankimage,1,0,emptyRect,0,0);
  reset_original_state(1);
end;

destructor TMonstergroup.destroy;
var lp1 : integer;
begin
  for lp1:=0 to monsters_per_side do monsters[lp1].free;
  dec(creation);
  inherited destroy;
end;

procedure TMonstergroup.reset_original_state(sheet:integer);
var lp1 : integer;
begin
  empty1st    := 0;
  for lp1 := 0 to monsters_per_sidem1 do with monsters[lp1] do begin
    set_level(sheet);
    if horizontal then SetupLimits(xpos+setupgap*lp1,ypos,xh,xl,yh,yl,0)
    else               SetupLimits(xpos,ypos+setupgap*lp1,xh,xl,yh,yl,0);
    needsredraw := true;
    with spritepic do setbitmap(monstergallery[level],images,anim_dir);
    draworder[lp1] := lp1;
    move_counter := 0;
  end;
  monsters[monsters_per_side].sx:=0;
  monsters[monsters_per_side].sy:=0;
end;

procedure TMonstergroup.draw;
var lp1 : integer;
begin
  for lp1:=empty1st to monsters_per_sidem1 do with monsters[draworder[lp1]] do
    if needsredraw then Draw;
end;

procedure TMonstergroup.force_redraw;
var lp1 : integer;
begin
  for lp1:=empty1st to monsters_per_sidem1 do with monsters[draworder[lp1]] do Draw;
end;

{ same thing applies here - didn't want to use virtual calls
so do each type individually. Probably a bit unneccessary, but it's done now... }

function choose_horizontal_direction(monst:TMonster) : integer;
begin { Special bodge card played here with monstersgoinghome }
  with monst do begin
    if monstersgoinghome then begin move_counter:=5000; thisdirection:=0; exit; end;
    if sx>shiprect.left then begin
      if random(level+difficulty2)>difficulty2m1 then thisdirection:=1
      else monst.thisdirection := randhoriz[random(3)];
    end
    else if sx<shiprect.left then begin
      if random(level+difficulty2)>difficulty2m1 then thisdirection:=2
      else monst.thisdirection := randhoriz[random(3)];
    end
    else begin
      if random(level+difficulty2)>difficulty2m1 then thisdirection:=0
      else monst.thisdirection := randhoriz[random(3)];
    end;
    if thisdirection>0 then move_counter := abs(shiprect.left-sx) div 2
    else move_counter := 8;
  end;
end;

function can_monster_fire_h(monst:TMonster) : integer;
begin
  with monst do begin
    if ((sx and 63)=0) then begin
      if random(abs(sx-shiprect.left) div 16)=0 then
        if thisdirection=0 then begin
          if random(level+difficulty1)>difficulty1m1 then Game_Form.newmonsterBullet(monst);
        end
        else if random(level+difficulty2)>difficulty2m1 then Game_Form.newmonsterBullet(monst);
    end;
  end;
end;

function choose_vertical_direction(monst:TMonster) : integer;
begin
  with monst do begin
    if monstersgoinghome then begin move_counter:=5000; thisdirection:=0; exit; end;
    if sy>shiprect.top then begin
      if random(level+difficulty2)>difficulty2m1 then thisdirection:=3
      else monst.thisdirection := randvert[random(3)];
    end
    else if sy<shiprect.top then begin
      if random(level+difficulty2)>difficulty2m1 then thisdirection:=4
      else monst.thisdirection := randvert[random(3)];
    end
    else begin
      if random(level+difficulty2)>difficulty2m1 then thisdirection:=0
      else monst.thisdirection := randvert[random(3)];
    end;
    if thisdirection>0 then move_counter := abs(shiprect.top-sy) div 2
    else move_counter := 8;
  end;
end;

function can_monster_fire_v(monst:TMonster) : integer;
begin
  with monst do begin
    if ((sy and 63)=0) then begin
      if random(abs(sy-shiprect.top) div 16)=0 then
        if thisdirection=0 then begin
          if random(level+difficulty1)>difficulty1m1 then Game_Form.newmonsterBullet(monst);
        end
        else if random(level+difficulty2)>difficulty2m1 then Game_Form.newmonsterBullet(monst);
    end;
  end;
end;

{
the monsters are always stored in the d_o [ draworder ] array, in left right
or top down position, means we can check a bullet with the leftmost, and if it
is left of the monster ignore all the others. same with topmost. when monsters
die the d_o list is shuffled and new monsters appear in the left again (or top).
The list is stored in monsters[...] and d_o is the index - correction.
}

function TMonstergroup.Movegroup : boolean; { result is true by default }
var lp1,lp2,d_o : integer;
begin
  result:=false;
  if empty1st=monsters_per_side then begin result:=true; exit; end;
  if horizontal then for lp1:=empty1st to monsters_per_sidem1 do begin d_o := draworder[lp1];
    if d_o<monsters_per_side then with monsters[d_o] do begin
      if animate then begin { only false at end of explosion }
        case status of
          normal :
            case thisdirection of
              0 : begin
                    if move_counter=0 then choose_horizontal_direction(monsters[d_o])
                    else dec(move_counter);
                    can_monster_fire_h(monsters[d_o]);
                    needsredraw := true;
                  end;
              1 : if (sx=minx) or (move_counter=0)
                  or ((lp1>empty1st) and (sx<(monsters[draworder[lp1-1]].sx+32))
                    and (not monstersgoinghome)) then
                    choose_horizontal_direction(monsters[d_o])
                  else begin
                    sx := sx - 2;
                    dec(move_counter);
                    needsredraw := true;
                    can_monster_fire_h(monsters[d_o]);
                  end;
              2 : if (sx=maxx) or (move_counter=0)
                  or ((lp1<monsters_per_sidem1) and (sx>(monsters[draworder[lp1+1]].sx-32))
                    and (not monstersgoinghome)) then
                    choose_horizontal_direction(monsters[d_o])
                  else begin
                    sx := sx + 2;
                    dec(move_counter);
                    needsredraw := true;
                    can_monster_fire_h(monsters[d_o]);
                  end;
              else showmessage('error h');
            end;
          exploding,dead : begin end;
        end;
      end else begin
        lp2:=lp1;
        while lp2>empty1st do begin draworder[lp2] := draworder[lp2-1]; dec(lp2); end;
        if level<maxlevel then begin { ^ shift monsters into correct order }
          inc(level);
          points              := level;
          sx                  := minx;
          draworder[empty1st] := d_o;
          status              := normal;
          thisdirection       := 2;
          needsredraw         := true;
          move_counter        := 16;
          with spritepic do setbitmap(monstergallery[level],images,anim_rate);
        end
        else begin draworder[empty1st] := monsters_per_side; inc(empty1st); end;
      end;
    end;
  end
  else for lp1:=empty1st to monsters_per_sidem1 do begin d_o := draworder[lp1];
    if d_o<monsters_per_side then with monsters[d_o] do begin
      if animate then begin
        case status of
          normal :
            case thisdirection of
              0 : begin
                    if move_counter=0 then choose_vertical_direction(monsters[d_o])
                    else dec(move_counter);
                    can_monster_fire_v(monsters[d_o]);
                  end;
              3 : if (sy=miny) or (move_counter=0)
                  or ((lp1>empty1st) and (sy<(monsters[draworder[lp1-1]].sy+32))
                    and (not monstersgoinghome)) then
                    choose_vertical_direction(monsters[d_o])
                  else begin
                    sy := sy - 2;
                    dec(move_counter);
                    needsredraw := true;
                    can_monster_fire_v(monsters[d_o]);
                  end;
              4 : if (sy=maxy) or (move_counter=0)
                  or ((lp1<monsters_per_sidem1) and (sy>(monsters[draworder[lp1+1]].sy-32))
                    and (not monstersgoinghome)) then
                    choose_vertical_direction(monsters[d_o])
                  else begin
                    sy := sy + 2;
                    dec(move_counter);
                    needsredraw := true;
                    can_monster_fire_v(monsters[d_o]);
                  end;
              else showmessage('error');
            end;
          exploding,dead : begin end;
        end;
      end else begin { monster has just died - do we replace it }
        lp2:=lp1;
        while lp2>empty1st do begin draworder[lp2] := draworder[lp2-1]; dec(lp2); end;
        if level<maxlevel then begin  { ^ shift the monsters into correct order }
          inc(level);
          points              := level;
          sy                  := miny;
          draworder[empty1st] := d_o;
          status              := normal;
          needsredraw         := true;
          thisdirection       := 4;
          move_counter        := 16;
          with spritepic do setbitmap(monstergallery[level],images,anim_rate);
        end
        else begin draworder[empty1st] := monsters_per_side; inc(empty1st); end;
      end;
    end;
  end;
end;

function TMonstergroup.are_any_exploding : boolean;
var lp1 : integer; { only checked when we die }
begin  { used before sending the monster home when you die - aaaaaarrrgggghhh }
  result := false;
  for lp1:=empty1st to monsters_per_sidem1 do with monsters[draworder[lp1]] do
    if status=exploding then begin result := true; exit; end;
end;

{ save checking time, by doing left, right, top monsters in sub, checks
after all, a bullet going up, can't really hit a left monster etc etc etc }

function TMonstergroup.is_hit_left(bullet:Tbullet) : integer;
var lp1,tt : integer;
begin
  result:=0;
  for lp1:=0 to monsters_per_sidem1 do with bullet do begin
    if draworder[lp1]<monsters_per_side then with monsters[draworder[lp1]] do begin
      if bp.y<sy then exit
      else if (bp.y<(sy+32)) and (bp.x<(sx+32)) then begin
        result := 1;
        if points>0 then begin
          tt := points; points := points-damage;
          if points<=0 then begin points:=0; kill; end;
          game_form.Increase_score((tt-points)*pphit);
        end;
      end;
    end;
  end;
end;

function TMonstergroup.is_hit_right(bullet:Tbullet) : integer;
var lp1,tt : integer;
begin
  result:=0;
  for lp1:=0 to monsters_per_sidem1 do with bullet do begin
    if draworder[lp1]<monsters_per_side then with monsters[draworder[lp1]] do begin
      if bullet.bp.y<sy then exit
      else if (bullet.bp.y<(sy+32)) and (bullet.bp.x>sx) then begin
        result := 1;
        if points>0 then begin
          tt := points; points := points-damage;
          if points<=0 then begin points:=0; kill; end;
          game_form.Increase_score((tt-points)*pphit);
        end;
      end;
    end;
  end;
end;

function TMonstergroup.is_hit_top(bullet:Tbullet) : integer;
var lp1,tt : integer;
begin
  result:=0;
  for lp1:=0 to monsters_per_sidem1 do with bullet do begin
    if draworder[lp1]<monsters_per_side then with monsters[draworder[lp1]] do begin
      if bullet.bp.x<sx then exit
      else if (bullet.bp.x<(sx+32)) and (bullet.bp.y<(sy+32)) then begin
        result := 1;
        if points>0 then begin
          tt := points; points := points-damage;
          if points<=0 then begin points:=0; kill; end;
          game_form.Increase_score((tt-points)*pphit);
        end;
      end;
    end;
  end;
end;

{ ---------------------------------------------------------------------------- }
{                                   PowerMeter                                 }
{ ---------------------------------------------------------------------------- }
constructor TPowerMeter.create(image:TRect; startpos,orient:integer; pos:TPoint);
begin
  inherited create;
  inc(creation);
  notch       := TSprite.Create(image,1,0,emptyRect,0,0);
  position    := startpos;
  lastpos     := 0;
  orientation := orient;
  screenpos   := pos;
end;

destructor TPowerMeter.Destroy;
begin
  dec(creation);
  notch.free;
  inherited destroy;
end;

procedure TPowerMeter.setpos(newpos:integer);
begin
  position := newpos;
  draw;
end;

procedure TPowerMeter.reset(newpos:integer);
begin
  position := newpos;
  lastpos  := 0;
  draw;
end;

procedure TPowerMeter.pminc;
begin
  inc(position);
  draw;
end;

function TPowerMeter.pmdec : boolean; { result true by default }
begin result := true;
  dec(position); if position=0 then result := false;
  draw;
end;

{
  only ever redraws the bits that need updating, unlike the win95 meter
  which is shite, and redraws the whole thing every time
}

procedure TPowerMeter.draw;
var lp1 : integer;
begin  { Meters that go up/down are allowed too (experimenting) }
  if position=lastpos then exit
  else if position>lastpos then for lp1 := lastpos to position-1 do begin
    with notch.spritepic.image do begin
      if orientation=0 then StretchBlt(Game_DC,screenpos.x+lp1*16,screenpos.y,16,16,Source_DC,left,top,16,16,SrcCopy)
      else StretchBlt(Game_DC,screenpos.x,screenpos.y-lp1*16,16,16,Source_DC,left,top,16,16,SrcCopy)
    end;
  end
  else if position<lastpos then for lp1 := lastpos-1 downto position do begin
    if orientation=0 then PatBlt(Game_DC,screenpos.x+lp1*16,screenpos.y,16,16,Blackness)
    else PatBlt(Game_DC,screenpos.x,screenpos.y-lp1*16,16,16,Blackness);
  end;
  lastpos := position;
end;
{ ---------------------------------------------------------------------------- }
{                             Score drawing object                             }
{ ---------------------------------------------------------------------------- }
constructor TScoremeter.create(image:TRect; numimages:integer; screenpos:TPoint; digs,sincr:integer);
var lp1 : integer;
begin
  inherited create;
  inc(creation);
  numdigs    := digs;
  digits     := TMultiple_bitmap.Create(image,numimages,0);
  for lp1 := 0 to numdigs-1 do slots[lp1] := -1;
  score      := 0;
  lastscore  := 0;
  screen_pos := screenpos;
  i_width    := digits.imagewidth;
  i_height   := digits.imageheight;
  s_inc      := sincr;
end;

destructor TScoremeter.destroy;
begin
  digits.Free;
  dec(creation);
  inherited destroy;
end;

{
  I wanted the score to count in units of xxx even if it goes up by y*xxx
  so it only increases the score by one unit each time - bit like a pinball
  score  - units are ten points in this game.
}

{ redo is used when we want to repaint the whole thing, during a wm_paint or similar }
{ ie override the just display changes feature }
procedure TScoremeter.display(redo:boolean);
var scorestring     : string;
    lp1,dig,off,l,c : integer;
begin { stick = score tick - mini counter to get nice da da da count }
  if (lastscore=score) and (not redo) then exit;
  if ((stick and 3)=0) or redo then begin
    if score>lastscore then lastscore   := lastscore+s_inc;
    if redo then lastscore := score;
    scorestring := IntToStr(lastscore);
    l           := length(scorestring);
    for lp1:=(numdigs-1) downto l do scorestring := '0'+scorestring;
    c           := 0;
    for lp1:=numdigs downto 1 do begin
      dig := ord(scorestring[lp1])-ord('0');
      if redo or (dig<>slots[(numdigs-1)-c]) then begin
        slots[(numdigs-1)-c] := dig;
        with digits.imagerects^[dig] do
        StretchBlt(Game_DC,screen_pos.x+((numdigs-1)-c)*i_width,screen_pos.y,
          i_width,i_height,Source_DC,left,top,i_width,i_height,SrcCopy);
      end;
      inc(c);
    end;
  end;
  inc(stick);
end;
{ ---------------------------------------------------------------------------- }
{                Utility for getting rect of sprite in big bitmap              }
{ ---------------------------------------------------------------------------- }
procedure fill_rect_with_sprite_pos(grainsizex,grainsizey,x,y,nx,ny:integer; var arect:TRect);
begin
  SetRect(arect,x*grainsizex,y*grainsizey,x*grainsizex+nx*grainsizex,y*grainsizey+ny*grainsizey);
end;
{ ---------------------------------------------------------------------------- }
{                                    Form                                      }
{ ---------------------------------------------------------------------------- }
procedure TGame_Form.FormCreate(Sender: TObject);
var sDC    : HDC;
    lp1    : integer;
begin
  Game_window.Width  := 704-16;
  Game_window.Height := 576+16;

  { setup event handlers }
  OnDestroy      := FormDestroy;
  Application.OnDeactivate := FormDeactivate; { stop game when we lose focus }
  { setup source BMP and DC for copying from }
  Source_BMP     := LoadBitmap(Game_dir+'sprites\gamepic2.bmp');
  sDC            := GetDC(0); { screen }
  Source_DC      := CreateCompatibleDC(sDC);
  dull_bitmap    := SelectObject(Source_DC,Source_BMP.handle);
  releaseDC(0,sDC);

  { setup all the sprite coords within the DC }
  { example - explosionimage
    32 by 32 bitmap
    starting at (from top left) 0*32,0*32
    (if it was a 16*16 bitmap then 0*16,0*16 etc etc)
    16 images wide (at 32 pixels each in this case)
    1  height (at 32 again)
    when creating the sprite 16,7 means 16 images and 7 time units of delay
    before changing picture.
  }
  fill_rect_with_sprite_pos(32,32,0,0,16,1,explosionimage);
  fill_rect_with_sprite_pos(16,16,0,12,8,1,smallexpimage);
  fill_rect_with_sprite_pos(32,32,0,1,8,1,shipimage);
  spaceship      := TSprite.Create(shipimage,8,7,explosionimage,16,7);
  fill_rect_with_sprite_pos(32,32,0,4,1,1,squareimage);
  square         := TSprite.Create(squareimage,1,0,emptyRect,0,0);
  fill_rect_with_sprite_pos(32,32,0,2,1,1,blankimage);

  for lp1:=1 to 20 do fill_rect_with_sprite_pos(32,32,lp1,2,1,1,monstergallery[lp1]);
  for lp1:=0 to 9  do fill_rect_with_sprite_pos(16,16,lp1+1,10,1,1,bonusgallery[lp1]);
  bonuses := TBonuslist.Create(8);

  fill_rect_with_sprite_pos(16,16,0,10,1,1,energyimage);
  powerlevel    := TPowerMeter.Create(energyimage,5,0,Point(16,544));

  shootlevel    := TPowerMeter.Create(bonusgallery[4],5,0,Point(16,560));

  fill_rect_with_sprite_pos(12,16,0,13,10,1,scoreimage);
  scoresheet    := TScoreMeter.Create(scoreimage,10,Point(600,32),6,10);
  levelsheet    := TScoreMeter.Create(scoreimage,10,Point(600,64),2,1);

  fill_rect_with_sprite_pos(40,16,0,14,1,1,scorecaption);
  fill_rect_with_sprite_pos(40,16,0,15,1,1,levelcaption);

  leftmonsters  := TMonstergroup.Create(false,  0,64, 128,    1,  0,480, 32);
  rightmonsters := TMonstergroup.Create(false,512,64, 128,  512,511,480, 32);
  topmonsters   := TMonstergroup.Create(true , 64, 0, 128,  480, 32,   1, 0);

  { I'd like more bullets but it just takes too much time }
  ShipBullets    := TBulletlist.Create(32);
  MonsterBullets := TBulletlist.Create(32);

  { used in debug }
  for lp1:=0 to 3 do begin frames[lp1] := frame_speed_obj.create; frames[lp1].reset(10); end;

  initialize;
  sheet := 1;
  setup_level(sheet);
  start_ticker;
end;

procedure TGame_Form.FormDestroy(Sender: TObject);
var lp1 : integer;
begin
  for lp1:=0 to 3 do frames[lp1].free;
  bonuses.Free;
  ShipBullets.Free;
  MonsterBullets.Free;
  powerlevel.Free;
  shootlevel.Free;
  scoresheet.Free;
  levelsheet.Free;
  square.Free;
  spaceship.Free;
  leftmonsters.Free;
  rightmonsters.Free;
  topmonsters.Free;

  SelectObject(Source_DC,dull_bitmap); { the original one }
  DeleteDC(Source_DC);
  Source_BMP.Free;
end;

procedure clear_window(handle:HWnd); { not used any more }
var tDC : HDC;
    tr  : TRect;
begin
  tDC := GetDC(handle);
  GetClientRect(handle,tr);
  with tr do PatBlt(tDC,left,top,right,bottom,Blackness);
  ReleaseDC(handle,tDC);
end;

procedure TGame_Form.initialize;
var lp1 : integer;
begin
  bullet_damage := 1;
  spaceship.SetupLimits(256,256, 448,64,448,64,0);
  spaceship.spritepic.animation_forwards;
  spaceship.spritepic.anim_pos := 0;
  spaceship.exploder.anim_pos := 0;
  spaceship.status := normal;
  for lp1 := 0 to 31 do begin
    TBullet(ShipBullets.objects^[lp1]).SetupLimits(544,0,544,0,true);
    TBullet(ShipBullets.objects^[lp1]).Setup(0,0,0,bullet_damage);
  end;
  for lp1 := 0 to 31 do begin
    TBullet(MonsterBullets.objects^[lp1]).SetupLimits(496,48,496,48,false);
    TBullet(MonsterBullets.objects^[lp1]).Setup(0,0,0,1);
  end;
  powerlevel.reset(5);
  shootlevel.reset(1);
  bonuses.initialize;
  ShipBullets.initialize;
  MonsterBullets.initialize;
  monstersgoinghome := false;

  bonusallowed     := true;
  lastbonusscore   := 0;
  shipbullettick   := 0;
  scoresheet.score := 0;
  levelsheet.score := 1;
  game_DC        := 0;
  cursor         := 0;
  tickcount      := 0;
  paused         := true;
  lastlr         := 0;
  lastud         := 0;
  Bullet_speed   := 63;
  stick          := 0;
end;

procedure TGame_form.Increase_score(num:integer);
begin
  inc(scoresheet.score,num);
  if (scoresheet.score-lastbonusscore)>(250-sheet*10) then begin
    bonusallowed:=true;
    lastbonusscore:=scoresheet.score;
  end;
end;

procedure TGame_Form.setup_level(lev:integer);
begin
  levelsheet.score := lev;
  levelsheet.display(true);
  leftmonsters.reset_original_state(lev);
  rightmonsters.reset_original_state(lev);
  topmonsters.reset_original_state(lev);
end;

procedure TGame_Form.New_game_buttonClick(Sender: TObject);
begin
  stop_game;
  initialize;
  sheet := 1;
  setup_level(sheet);
  repaint;
end;

{
  Why have I done 4 mini loops - mask = 0,1,2,3 - well I wanted to time
  individual sections of the code, to see when improvements speeded things
  up or not. Each screen update is divided into 4 mini updates, and each can
  be timed using the frame-speed counters, the panels are used to display
  the cycles of each 'phase' of the clock. I just did it like this at first,
  then left it in. - debug
}
procedure TGame_Form.Mainloop;
var time      : double;
    mask      : integer;
    time_dest : double;
    ttt       : string;
begin
  time_dest := time_average-sheet*0.00005; { gets faster with each new level }
  while (not paused) do begin
    game_DC := game_window.canvas.handle;
    time := tick_seconds2;  { wait until time has elapsed }
    if time>=(time_dest) then begin
      time_dest := time_average-sheet*0.00005;
      start_ticker;

      mask := tickcount and 3;
      case mask of
        0 : begin
          spaceship.animate;
          case spaceship.status of
            normal    : begin Move_players_ship; collisionwithbonus; end;
            exploding : ;
            dead      : begin
              shiprect := emptyrect;
              { wait till all our bullets are gone, and monsters have finished
                exploding before sending them home }
              if (shipbullets.firstused=-1) and
              (not leftmonsters.are_any_exploding) and (not rightmonsters.are_any_exploding)
              and (not topmonsters.are_any_exploding) then sendmonstershome;
            end;
          end;
          with spaceship do if needsredraw then Draw;
          scoresheet.display(false); { just update if needed }
          bonuses.update_counters;   { count bonuses down }
          if bonusallowed and ((random(1024)<2) or ((scoresheet.score-lastbonusscore)>750))
          then begin { only allowed new ones when you've got some points - otherwise
          you could kill all but one monster and just wait around collecting them
          as they appear. Now that would be cheating ;-( }
            createnewbonus; bonusallowed:=false;
          end;
        end;
        1 : begin
          Redraw_monster_bullets;
        end;
        2 : begin
          Redraw_ship_bullets;
        end;
        3 : begin
          Move_monsters;
          redraw_monsters;
        end;
      end;
      if dir_keys[5] and (shipbullettick=0) and (spaceship.status=normal) then newshipbullet;
      shipbullettick := (shipbullettick+1) and bullet_speed;    { 15 min really }

{
  try removing the comments below and seeing the speed of 3 change with more/less
  of our bullets (mask=2) by firing lots and watching the numbers
  The game will slow right down, just to prove haw slow delphi is at setting a
  couple of captions. But the times are calculated from the start ticker at the
  beginning of the loop so they will accurately measure the elapsed interval.
  NB - the numbers are 10 frame averages, see frame_speed_object - create method.
  Change the 10 to a 1 or 2 to really test -
}
{
      time := tick_seconds2;
      frames[mask].update(time);
      case mask of
        0 : panel1.Caption:= IntToStr(round(frames[mask].average_frame_speed*100000));
        1 : panel2.Caption:= IntToStr(round(frames[mask].average_frame_speed*100000));
        2 : panel3.Caption:= IntToStr(round(frames[mask].average_frame_speed*100000));
        3 : panel4.Caption:= IntToStr(round(frames[mask].average_frame_speed*100000));
      end;
}
      inc(tickcount);
    end;
    Application.Processmessages; { this slows it right down ! }
    { and delphi releases the canvas handle so we have to get it every loop
    which is very annoying. I'll redo this to use a fixed DC. Originally
    I did this but was having problems on win3.x because Delphi was releasing
    the handle, and so was I, so it was crashing on exit. }
  end;
end;

{ this is really badly bodged, but I couldn't be arsed doing it any better.
just ran out of ideas here - sorry }
procedure TMonstergroup.sendmonstershome;
var lp1,thispos,pos,free_slots,diff : integer;
    number_of_monsters,tx           : integer;
begin
  number_of_monsters := 0; for lp1:=empty1st to monsters_per_sidem1 do inc(number_of_monsters);
  thispos    := 0;
  for lp1:=empty1st to monsters_per_sidem1 do begin
    free_slots := monsters_per_side-thispos;
    diff     := free_slots-number_of_monsters;
    thispos  := thispos+random(diff+1)+1;
    pos      := 64+(thispos-1)*128;
    dec(number_of_monsters);
    with monsters[draworder[lp1]] do begin
      if horizontal then tx:=sx else tx:=sy;
      if pos=tx then begin thisdirection := 0; move_counter:=5000; end
      else begin
        if pos>tx then begin if horizontal then thisdirection:=2 else thisdirection:=4; end
        else begin if horizontal then thisdirection:=1 else thisdirection:=3; end;
        move_counter:=abs(tx-pos) div 2;
        if move_counter=0 then showmessage('o');
      end;
    end;
  end;
end;

procedure TGame_Form.sendmonstershome;
begin
  if monstersgoinghome then exit;
  leftmonsters.sendmonstershome;
  rightmonsters.sendmonstershome;
  topmonsters.sendmonstershome;
  monstersgoinghome := true;
end;

procedure TGame_Form.layoutsquares(destDC:HDC);
var lp1,lp2 : integer;
    oldpen  : HPen;
    tp      : TPoint;
begin
  for lp1 := 0 to 7 do for lp2 := 0 to 7 do with squareimage do
    StretchBlt(destDC,32+lp1*64,32+lp2*64,32,32,source_DC,left,top,32,32,SrcCopy);
  oldpen := SelectObject(destDC,GetStockObject(White_Pen));
  movetoEx(destDC,16,540+3,@tp); lineto(destDC,540-16,540+3);
  SelectObject(destDC,oldpen);
end;

procedure TGame_Form.start_game;
begin
  paused := false;
  Confine_cursor(true); { can be used to stop the cursor moving over the game window }
  start_ticker;         { during play }
  mainloop;
end;

procedure TGame_Form.stop_game;
begin
  paused  := true;
  game_DC := 0;
  Confine_cursor(false);
end;

procedure TGame_form.Confine_cursor(trap:boolean);
var tr  : TRect;
    tp1 : TPoint;
begin
{                     removed this because it was annoying
  if trap then with cursor_pad do begin
    tp1 := ClienttoScreen(Point(width div 2,height div 2));
    SetCursorPos(tp1.x,tp1.y);
    tp1 := ClienttoScreen(Point(0,0));
    SetRect(tr,tp1.x,tp1.y,tp1.x+width,tp1.y+height);
    ClipCursor(@tr);
  end
  else
}
  ClipCursor(nil);
end;

procedure TGame_Form.Move_players_ship;
begin
  with spaceship do begin
    if ((sx and 63)=0) and ((sy and 63)=0) then begin
      if dir_keys[0] then thisdirection:=0
      else begin
        case thisdirection of
          0   : thisdirection:=firedirection;
          1,2 : if lastud<>0 then thisdirection:=lastud;
          3,4 : if lastlr<>0 then thisdirection:=lastlr;
        end;
      end;
    end;
    case thisdirection of
      0 : begin exit; end;
      1 : if sx<=minx then thisdirection:=0 else begin
            if lastlr=2 then thisdirection:=2;
            sx := sx - 2;
          end;
      2 : if sx>=maxx then thisdirection:=0 else begin
            if lastlr=1 then thisdirection:=1;
            sx := sx + 2;
          end;
      3 : if sy<=miny then thisdirection:=0 else begin
            if lastud=4 then thisdirection:=4;
            sy := sy - 2;
          end;
      4 : if sy>=maxy then thisdirection:=0 else begin
            if lastud=3 then thisdirection:=3;
            sy := sy + 2;
          end;
    end;
    SetRect(shiprect,sx,sy,sx+32,sy+32);
    needsredraw := true;
  end;
end;

procedure TGame_Form.redraw_monsters;
begin
  leftmonsters.draw;
  rightmonsters.draw;
  topmonsters.draw;
end;

procedure TGame_Form.move_monsters;
var b1,b2,b3 : boolean;
begin
  b1 := LeftMonsters.Movegroup;   { true if all are dead ! }
  b2 := rightMonsters.Movegroup;
  b3 := topMonsters.Movegroup;
  if b1 and b2 and b3 then begin inc(sheet); setup_level(sheet); end;
end;  { ought to put a little delay in between levels really }

procedure TGame_Form.Redraw_ship_bullets;
var lp1,lp2,ff : integer;
    flag       : boolean;
    tb         : TBullet;
    tbo        : TBonus;
begin { walk the linked list }
  with shipbullets do if firstused<>-1 then begin
    lp1 := firstused;
    repeat
      tb := TBullet(objects^[lp1]); lp2:=nextone^[lp1]; ff:=firstfree; flag := false;
      with tb do case tb.Move of
        0  : EraseThenDraw;
        1  : begin Erase; freeup(lp1); end; { reached end of travel }
        2  : begin Erase; freeup(lp1);  { hit monster or bonus ! }
               case direction of
                 1 : if leftmonsters.is_hit_left(tb)=0 then flag:=true;
                 2 : if rightmonsters.is_hit_right(tb)=0 then flag:=true;
                 3 : if topmonsters.is_hit_top(tb)=0 then flag:=true;
                 4 : flag:=true;
               end;
               if flag then begin  { check to see if bullet hit a bonus }
                 tbo:=bonuses.point_in_rects(tb.bp);
                 if tbo<>nil then dec(tbo.counter,25*damage);
               end;
             end;
      end;
      lp1:=lp2;
    until (lp2=ff) or (lp2=-1);
  end;
end;

procedure TGame_Form.Redraw_monster_bullets;
var lp1,lp2,ff : integer;
    tb         : TBullet;
begin
  with monsterbullets do if firstused<>-1 then begin
    lp1 := firstused;
    repeat
      tb := TBullet(objects^[lp1]); lp2:=nextone^[lp1]; ff:=firstfree;
      with tb do case tb.Move of
        0  : tb.EraseThenDraw;
        1  : begin tb.Erase; freeup(lp1); end; { reached end of travel }
        2  : begin { collision }
               if not powerlevel.pmdec then spaceship.kill;
               tb.Erase; freeup(lp1);
             end;
        3  : begin dec(bonushit.counter,25); Erase; freeup(lp1); { hit bonus }
               bonushit.needsredraw := true;  bonushit:=nil;
             end;
      end;
      lp1:=lp2;
    until (lp2=ff) or (lp2=-1);
  end;
end;

procedure TGame_Form.NewShipBullet;
var lp1,tempdir : integer;
begin
  tempdir:=spaceship.thisdirection;
  if spaceship.thisdirection=0 then tempdir:=spaceship.firedirection;
  lp1 := shipbullets.nextfree;
  if lp1<0 then exit;
  with spaceship do case tempdir of
    1 : TBullet(ShipBullets.objects^[lp1]).Setup(sx-1 ,sy+16,1,bullet_damage);
    2 : TBullet(ShipBullets.objects^[lp1]).Setup(sx+32,sy+16,2,bullet_damage);
    3 : TBullet(ShipBullets.objects^[lp1]).Setup(sx+16,sy   ,3,bullet_damage);
    4 : TBullet(ShipBullets.objects^[lp1]).Setup(sx+16,sy+32,4,bullet_damage);
  end;
  TBullet(ShipBullets.objects^[lp1]).Draw;
end;

procedure TGame_Form.NewMonsterBullet(monster:TSprite);
var lp1 : integer;
begin
  lp1 := Monsterbullets.nextfree;
  if lp1<>-1 then begin
    with monster do case thisdirection of
      0 : begin
            if sy=miny then TBullet(MonsterBullets.objects^[lp1]).Setup(sx+15,sy+32,4,1)
            else if sx=minx then TBullet(MonsterBullets.objects^[lp1]).Setup(sx+32,sy+15,2,1)
            else TBullet(MonsterBullets.objects^[lp1]).Setup(sx   ,sy+15,1,1);
          end;
      1 : TBullet(MonsterBullets.objects^[lp1]).Setup(sx+15,sy+32,4,1);
      2 : TBullet(MonsterBullets.objects^[lp1]).Setup(sx+15,sy+32,4,1);
      3,4 : begin
          if sx=minx then TBullet(MonsterBullets.objects^[lp1]).Setup(sx+32,sy+15,2,1)
          else            TBullet(MonsterBullets.objects^[lp1]).Setup(sx   ,sy+15,1,1);
        end;
    end;
    TBullet(MonsterBullets.objects^[lp1]).Draw;
  end;
end;

procedure TGame_form.Collisionwithbonus;
var lp1,lp2,ff         : integer;
    tb                 : TBonus;
    bonusrect,destrect : TRect;
begin
  with bonuses do if firstused<>-1 then begin
    lp1 := firstused;
    repeat
      tb := TBonus(objects^[lp1]); lp2:=nextone^[lp1]; ff:=firstfree;
      with tb do begin
        Setrect(bonusrect,sx+3,sy+3,sx+13,sy+13);
        if IntersectRect(destRect,ShipRect,bonusrect)<>boolresult then begin
          case status of
            normal : begin
              case bonustype of
                powerup2    : powerlevel.setpos(powerlevel.position+2);
                powerup5    : powerlevel.setpos(powerlevel.position+5);
                powerup10   : powerlevel.setpos(powerlevel.position+10);
                firespeedup : bullet_speed := bullet_speed shr 1;
                firepowerup : begin
                  inc(bullet_damage);
                  shootlevel.pminc;
                end;
              end;
            end;
            exploding : begin
              if not powerlevel.pmdec then spaceship.kill;
              needsredraw:=true;
            end;
          end;
          freeup(lp1);
          erase;
        end;
      end;
      lp1:=lp2;
    until (lp2=ff) or (lp2=-1);
  end;
end;

procedure TGame_form.Createnewbonus;
var x,y,lp1,c1,inx,b_type : integer;
begin   { will alter this to stop bonuses appearing on you or other bonuses }
  x   := random(7);
  y   := random(7);
  inx := bonuses.nextfree;
  if inx>-1 then with TBonus(bonuses.objects^[inx]) do begin
    c1 := random(100);
    for lp1:=0 to ord(firepowerup) do begin
      if c1<bonusfreq[lp1] then begin
        b_type:=lp1;
        if ((b_type=ord(firespeedup)) and (Bullet_speed=7)) then b_type:=ord(powerup5);
        break;
      end;
    end;
    bonustype   := typeofbonus(b_type);
    counter     := random(256)+256;
    status      := normal;
    needsredraw := true;
    changepicture(bonusgallery[b_type],1,0);
    exploder.anim_pos := 0;
    sx := x*64 +64+16-8;
    sy := y*64 +64+16-8;
  end;
end;

{ ---------------------------------------------------------------------------- }
{                     Button interface and messages stuff                      }
{ ---------------------------------------------------------------------------- }
procedure TGame_Form.Pause_buttonClick(Sender: TObject);
begin stop_game; end;

procedure TGame_Form.go_buttonClick(Sender: TObject);
begin start_game; end;

procedure TGame_Form.FormDeactivate(Sender: TObject);
begin stop_game; end; { don't want game to continue in background }

procedure TGame_Form.exit_buttonClick(Sender: TObject);
begin stop_game; close; end;

procedure TGame_Form.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  stop_game; Action := caFree;
end;

{ ALT-TAB
   Procedure TGame_Form.CMDialogKey(var Message: TCMDialogKey);
   begin { this doesn't work the way I want it to - bugger ! }
{     if Message.CharCode = VK_TAB then begin
       {Process the Alt+Tab key here}
{       showmessage('fderefsd');
       Message.result := 1;
       exit;
     end;
     inherited;
   end;
}
procedure TGame_Form.FormResize(Sender: TObject);
begin  { only just fits on an 800x600 screen, just trim it a tiny bit }
  if windowstate<>wsMaximized then stop_game;
  with game_window do begin
{ the default size is set in createform, but if it doesn't quite fit, then adjust }
    SetBounds((self.ClientWidth-width)div 2,(self.ClientHeight-height)div 2,width,height);
    if left<80 then left:=80;  { leave some space for buttons }
    if top<0 then top := 0;    { keep top visible             }
    if height>(self.ClientHeight-1) then height:=self.ClientHeight-1;
  end;
end;

procedure TGame_Form.Game_windowPaint(Sender: TObject);
begin
  game_DC    := game_window.canvas.handle;
  PatBlt(game_DC,0,0,game_window.width,game_window.height,BLACKNESS);
  SelectPalette(game_DC,Source_BMP.palette,false);
  RealizePalette(game_DC);
  layoutsquares(game_DC);
  powerlevel.reset(powerlevel.position);
  powerlevel.draw;
  shootlevel.reset(shootlevel.position);
  shootlevel.draw;
  with scorecaption do
    StretchBlt(Game_DC,552,32,40,16,Source_DC,left,top,40,16,SrcCopy);
  with levelcaption do
    StretchBlt(Game_DC,552,64,40,16,Source_DC,left,top,40,16,SrcCopy);
  scoresheet.display(true); { force all redraw, not just quick update }
  levelsheet.display(true);
  with spaceship do begin
    draw;
    SetRect(shiprect,sx,sy,sx+32,sy+32);
  end;
  leftmonsters.force_redraw;
  rightmonsters.force_redraw;
  topmonsters.force_redraw;
  Redraw_ship_bullets;
  redraw_monster_bullets;
end;

procedure TGame_Form.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var temp : word;
begin
  temp := key; key := 0; { stop further processing }
  with spaceship do begin case temp of
      ord('A')  : if (not dir_keys[5]) and (spaceship.status=normal) then begin
                    Game_DC := game_window.canvas.handle; { Bastards - kludge fix }
                    { this is why Delphi is crap! - the handle caching dumps our
                    game_DC, whenever the messageloop is entered }
                    dir_keys[5]:=true; newshipbullet; shipbullettick:=1;
                    { newshipbullet plots the bullet pixel, but we need to re-get
                    the canvas handle first }
                  end;
      ord('S')  : begin dir_keys[1]:=true; lastlr:=1; firedirection:=1; end;
      ord('D')  : begin dir_keys[2]:=true; lastlr:=2; firedirection:=2; end;
{up}  192       : begin dir_keys[3]:=true; lastud:=3; firedirection:=3; end;
{dn}  191       : begin dir_keys[4]:=true; lastud:=4; firedirection:=4; end;
      ord(' ')  : begin dir_keys[0]:=true;
                    if spaceship.status=dead then begin
                      New_game_button.Onclick(nil); { start a new game }
                      go_button.OnClick(nil);
                    end;
                  end;
      $1B       : begin if paused then start_game else stop_game; end;
      else key:=temp; { enable further processing }
    end;
    if (status=exploding) or (status=dead) then dir_keys[5]:=false;
  end;
end;

procedure TGame_Form.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var temp : word;
begin
  temp := key; key := 0; { stop further processing }
  with spaceship do begin case temp of
      ord('A')  : dir_keys[5] := false;
      ord('S')  : begin dir_keys[1]:=false; if dir_keys[2] then lastlr:=2 else lastlr:=0; end;
      ord('D')  : begin dir_keys[2]:=false; if dir_keys[1] then lastlr:=1 else lastlr:=0; end;
      192       : begin dir_keys[3]:=false; if dir_keys[4] then lastud:=4 else lastud:=0; end;
      191       : begin dir_keys[4]:=false; if dir_keys[3] then lastud:=3 else lastud:=0; end;
      ord(' ')  : begin dir_keys[0]:=false; end;
      else key := temp; { allow further processing - not really needed }
    end;
  end;
end;

var exitsave : pointer;
{$F+}
procedure exitchain;
begin
  exitproc := exitsave;
  if creation<>0 then showmessage('Object Creation Error');
  {
  if creation isn't zero then I've forgotten to delete something
  I add inc(creation) to all the constructors, as a way of checking.
  when the game is finished I can get rid of them - debug
  }
end;
{$F-}

initialization
  exitsave := exitproc;
  exitproc := @exitchain;
  randomize;
  Game_Dir := ExtractFilePath(Application.ExeName);
  creation := 0;
end.

{  Hadrian's Wizzy Wall }


