unit D_timer;

{
John Biddiscombe
J.Biddiscombe@rl.ac.uk

Revised for Delphi 2.

Should get 840nS resolution, but the graininess is quite coarse.
(ie ticks are every 840nS, but the accuracy is much less )

Delphi 1 users - see BYTE magazine April 95
'The software stopwatch' by Rick Grehan
Thanks very much for that !
Delphi 2 users, Win32API supports high resolution timers.

Tidied this up a bit, and removed the stopwatch overflow check
since it never happens (well almost never)

This version March 96

}

interface

uses WinTypes,WinProcs;

type { useful for monitoring average frame speed }
  frame_speed_obj = Class(TObject)
    average_frame_speed : double;
    averages            : double;
    procedure reset(avgs:double);
    function  update(newtime:double) : double;
  end;

procedure start_ticker;
procedure stop_ticker;
function  tick_seconds    : double;
function  tick_seconds2   : double;
function  elapsed_ticks   : longint;
procedure get_ticks;

{$IFDEF VER80 } { Borland Delphi version 1 }
function  get_VTD_address : pointer;
{$ENDIF }

implementation

var
  {$IFDEF VER90}
  ticks_per_second : comp;
  {$ENDIF }
  last_ticks       : comp;
  this_ticks       : comp;
  {$IFDEF VER80 }
  VTD_addr     : pointer;
const
  ticks_per_second = 1193180;  { 1/1193180 = 8.381e-7 }
  {$ENDIF }

{ --------------------------------------------------------------------------- }
{           Frame speed object, useful for game                               }
{ --------------------------------------------------------------------------- }
procedure frame_speed_obj.reset(avgs:double);
begin
  average_frame_speed := 0;
  averages            := avgs;
end;

function frame_speed_obj.update(newtime:double) : double;
begin
  average_frame_speed := average_frame_speed - (average_frame_speed/averages);
  average_frame_speed := average_frame_speed + (newtime/averages);
end;
{ --------------------------------------------------------------------------- }
{           Timer/Ticker stuff                                                }
{ --------------------------------------------------------------------------- }
procedure start_ticker;
begin
  get_ticks;
  last_ticks:=this_ticks;
end;

procedure stop_ticker;
begin
  get_ticks;
end;

function elapsed_ticks : longint;
begin
  elapsed_ticks := round(this_ticks-last_ticks);
end;

function tick_seconds : double;
begin
  if this_ticks>last_ticks then tick_seconds := (this_ticks-last_ticks)/Ticks_per_second
  else begin  { timer overflow }
    tick_seconds := (9.223372036854775807E18-(last_ticks-this_ticks)+1)/Ticks_per_second;
  end;
end;

{ returns time elapsed without resetting ticker }
function tick_seconds2 : double;
var temp : comp;
begin
  temp := this_ticks;
  get_ticks;
  tick_seconds2 := tick_seconds;
  this_ticks    := temp;
end;

{$IFDEF VER90 } { Borland Delphi version 2 }
procedure get_ticks;
begin
  QueryPerformanceCounter(TLargeInteger(this_ticks));
end;
{$ELSE }
function get_VTD_address : pointer;
begin
  asm
    mov AX,$1684        { Subcode to return API   }
    mov BX,$05          { Virtual Timer Device ID }
    xor DI,DI
    mov ES,DI
    int $2F
    mov [BP-04],DI      { put result on stack     }
    mov [BP-02],ES
  end;
end;

procedure get_ticks;
label retspot;
begin
  asm
    push cs                         { push code segment      }
    mov  bx,OFFSET retspot          { push offset of retspot }
    push bx
    mov  AX,WORD PTR VTD_Addr       { push VTD address       }
    mov  DX,WORD PTR VTD_Addr+2
    push DX
    push AX
    mov  AX,$0100
    retf                            { fake a far call        }
retspot :
    mov  WORD PTR this_ticks,ax     { comes back to here !   }
  end;
  inline(
    $66/$A3/this_ticks/             { mov this_ticks,EAX     }
    $66/$89/$16/this_ticks+4        { mov this_ticks+4,EDX   }
  );
end;
{$ENDIF }

initialization
  {$IFDEF VER90 } { Borland Delphi version 2 }
  QueryPerformanceFrequency(TLargeInteger(ticks_per_second));
  { should be 840 nS - or 838.xxx or something }
  {$ELSE }
  VTD_addr := get_VTD_address;
  {$ENDIF }
end.

