unit FZTest16;

interface

uses
  ZComp16, 

  {MBM: VCL Uses }
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    lblInputFilename: TLabel;
    edInputFilename: TEdit;
    btnBrowse: TButton;
    lblOutputFilename: TLabel;
    edOutputFilename: TEdit;
    btnTest: TButton;
    Bevel1: TBevel;
    mmResults: TMemo;
    dlgOpen: TOpenDialog;
    procedure btnBrowseClick(Sender: TObject);
    procedure edInputFilenameChange(Sender: TObject);
    procedure btnTestClick(Sender: TObject);
  private
    { Private declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.btnBrowseClick(Sender: TObject);
begin
  if (dlgOpen.Execute) then
    edInputFilename.Text := dlgOpen.FileName;
end;

procedure TForm1.edInputFilenameChange(Sender: TObject);
var                                                                             
  sEdit : string;                                                               
begin                                                                           
  sEdit := edInputFilename.Text;                                                  
  if Length(sEdit) > 5 then
    sEdit[Length(sEdit)-4] := '~';
  edOutputFilename.Text := sEdit;
  
  btnTest.Enabled := FileExists(edInputFilename.Text);
end;

procedure TForm1.btnTestClick(Sender: TObject);
var
  msY     : TMemoryStream;
  msX     : TMemoryStream;
  zComp   : TZCompress;
  lTick   : longInt;
begin
  msX     := TMemoryStream.Create;
  msY     := TMemoryStream.Create;
  zComp   := TZCompress.Create;
  try
    {MBM: Deflate }
    lTick := GetTickCount;
    msY.LoadFromFile(edInputFilename.Text);
    msY.Seek(0, 0);
    zComp.StreamDeflate(msY, msX, nil);

    mmResults.Lines.Add('');
    mmResults.Lines.Add(
      'Loaded '  + IntToStr(msY.Size) + ' bytes, ' +
      'Wrote ' + IntToStr(msX.Size) + ' bytes in ' +
      IntToStr(GetTickCount-lTick) + 'ms.');

    {MBM: Inflate }
    lTick := GetTickCount;
    msY.Seek(0, 0);
    msX.Seek(0, 0);
    zComp.StreamInflate(msX, msY, nil);
    msY.Seek(0, 0);
    msY.SaveToFile(edOutputFilename.Text);

    mmResults.Lines.Add('');
    mmResults.Lines.Add(
      'Loaded '  + IntToStr(msX.Size) + ' bytes, ' +
      'Wrote ' + IntToStr(msY.Size) + ' bytes in ' +
      IntToStr(GetTickCount-lTick) + 'ms.');

  finally
    zComp.Free;
    msY.Free;
    msX.Free;
  end;
end;

end.
 