{======================================================|
| Year Calendar, 1.0 - (c) 1996 by Alvaro L. S. Almeida|
|------------------------------------------------------|
| Display a whole year's calendar, in Delphi programs. |
| For Delphi 1, 2 e 3 (16 and 32 bits)                 |
|                                                      |
| See other components in our home-page.               |
|------------------------------------------------------|
| DROID Informatica ltda - Rio de Janeiro - Brazil     |
|                                                      |
| Home Page: http://www.di.com.br                      |
| E-Mail:    comp@di.com.br                            |
| Fax:       055 021 224-0331                          |
|======================================================}

unit Yearcal;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TMyNotifyEvent = procedure(Sender: TObject; SelectedDate: TDateTime) of object;
  TMyMouseEvent  = procedure(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
                               X, Y: Integer; SelectedDate: TDateTime) of object;

  TDRYearCal = class(TGraphicControl)
  private
    FH,             { Font Height }
    FW,             { Font Width  }
    MH,             { Month Height}
    MW: integer;    { Month Width }

    CurYear,                 { Current Year  }
    CurMonth,                { Current Month }
    CurDay       : word;     { Current Day   }

    FDate        : TDateTime;
    FMonthColor  : TColor;
    FWeekColor   : TColor;
    FSundayColor : TColor;
    FLineColor   : TColor;
    FCurDayColor : TColor;   { Current day color }

    FLines       : boolean;  { If TRUE, show lines between months}
    FYear        : integer;
    GapVert      : byte;     { Number of pixels between two days }
    GapHorz      : byte;     { Number of pixels between two days }
    FCol         : byte;     { Number of columns (default = 4)   }
    FDispYear    : boolean;  { If TRUE, display year beside month name }

    GapMonthVert : byte;     { Number of pixels between two months }
    GapMonthHorz : byte;     { Number of pixels between two months }

    FOnMouseDown : TMyMouseEvent;
    FOnMouseUp   : TMyMouseEvent;
    FOnClick     : TMyNotifyEvent;
    FOnDblClick  : TMyNotifyEvent;

    procedure SetNumCol(Value: Byte);
    procedure SetYear(Value: integer);
    procedure SetMonthColor(Value: TColor);
    procedure SetSundayColor(Value: TColor);
    procedure SetWeekColor(Value: TColor);
    procedure SetCurDayColor(Value: TColor);
    procedure SetLineColor(Value: TColor);
    procedure SetVertDayGap(Value: Byte);
    procedure SetHorzDayGap(Value: Byte);
    procedure SetVertMonthGap(Value: Byte);
    procedure SetHorzMonthGap(Value: Byte);
    procedure SetLines(Value: Boolean);
    procedure SetDisplayYear(value:boolean);
    procedure GetSelectedDate(x,y: integer);
    procedure PaintDay(DoPaint:boolean);

  protected
    procedure Paint; override;
    procedure MouseDown(Button:TMouseButton; Shift:TShiftState;
                        X, Y: Integer);  Override;
    procedure MouseUp  (Button:TMouseButton; Shift:TShiftState;
                        X, Y: Integer);  Override;
    procedure Click; Override;
    procedure DblClick; Override;

  public
    constructor Create(AOwner: TComponent); override;
    procedure DispMonth(month,c,l:integer);   { Display a month at the specified column (C) and line (L) }

  published
    property Enabled;
    property Visible;
    property Font;
    property Color;
    property ShowHint;

    property DisplayYear: boolean read FDispYear
                                  write SetDisplayYear;

    property MonthColor:  TColor  read  FMonthColor
                                  write SetMonthColor;

    property SundayColor: TColor  read  FSundayColor
                                  write SetSundayColor;

    property WeekColor:   TColor  read  FWeekColor
                                  write SetWeekColor;

    property CurDayColor: TColor  read  FCurDayColor
                                  write SetCurDayColor;

    property LineColor:   TColor  read  FLineColor
                                  write SetLineColor;

    property NumColumns:  Byte    read    FCol
                                  write   SetNumCol
                                  default 4;

    property Year:        integer read    FYear
                                  write   SetYear
                                  default 1996;

    property VertDayGap:  byte    read  GapVert
                                  write SetVertDayGap;

    property HorzDayGap:  byte    read  GapHorz
                                  write SetHorzDayGap;

    property VertMonthGap:byte    read  GapMonthVert
                                  write SetVertMonthGap;

    property HorzMonthGap:byte    read  GapMonthHorz
                                  write SetHorzMonthGap;

    property Lines :      boolean read  FLines
                                  write SetLines;

    property OnMouseDown: TMyMouseEvent read FOnMouseDown write FOnMouseDown;
    property OnMouseUp: TMyMouseEvent read FOnMouseUp write FOnMouseUp;
    property OnClick: TMyNotifyEvent read FOnClick write FOnClick;
    property OnDblClick: TMyNotifyEvent read FOnDblClick write FOnDblClick;
  end;

procedure Register;

implementation

const
  MaxDay : array[1..12] of byte = (31,28,31,30,31,30,31,31,30,31,30,31);
  DiaSem : array[1..7] of char = ('D','S','T','Q','Q','S','S');

 { . . . }

procedure Register;
begin
  RegisterComponents('DROID', [TDRYearCal]);
end;

end.
