(*
    Top-ten list management for the "Yawn" game
    Copyright (c) 1995 Alessandro Scotti
*)
{$I-}
unit TopTool;

interface

const
  TOP_LISTLEN   = 10;
  TOP_NAMELEN   = 15;
  TOP_QUOTELEN  = 43;
type
  (* Top-ten entry *)
  TYawnTopEntry = record
    Name    : string[TOP_NAMELEN];
    Quote   : string[TOP_QUOTELEN];
    Score   : word;
    RandSeed: word;
  end;
  PYawnTopEntry = ^TYawnTopEntry;
  (* Top-ten list *)
  TYawnTopList = array[ 1..TOP_LISTLEN ] of TYawnTopEntry;
var
  yawnTopTen    : TYawnTopList;

function topGetPos( Score: word ): word;
procedure topClear;
procedure topLoadFromFile( FName: string );
procedure topSaveToFile( FName: string );
procedure topInsert( N, Q: string; S, R: word );

implementation

procedure topClear;
var
  I: integer;
begin
  (* Clear top-ten list *)
  for I:=1 to TOP_LISTLEN do with yawnTopTen[I] do begin
    Name := '';
    Quote := '';
    Score := 0;
    RandSeed := 0;
  end;
end;

procedure topLoadFromFile( FName: string );
var
  I: integer;
  F: file;
  T: TYawnTopList;
begin
  (* Get list from file *)
  if( FName = '' ) then
    FName := 'YAWN.T10';
  Assign( F, FName );
  Reset( F, 1 );
  if( IOResult <> 0 ) then Exit;
  BlockRead( F, T, SizeOf(T), I );
  Close( F );
  if( I <> SizeOf(T) ) then Exit;
  yawnTopTen := T;
end;

procedure topSaveToFile( FName: string );
var
  F: file;
begin
  if( FName = '' ) then
    FName := 'YAWN.T10';
  Assign( F, FName );
  ReWrite( F, 1 );
  BlockWrite( F, yawnTopTen, SizeOf(yawnTopTen) );
  Close( F );
end;

function topGetPos( Score: word ): word;
var
  I: integer;
  R: word;
begin
  R := 1;
  while( R <= TOP_LISTLEN )and( yawnTopTen[R].Score >= Score ) do
    Inc( R );
  if( R > TOP_LISTLEN ) then
    R := 0;
  topGetPos := R;
end;

procedure topInsert( N, Q: string; S, R: word );
var
  P: word;
  I: integer;
begin
  P := topGetPos( S );
  if( P = 0 ) then
    Exit;
  for I:=TOP_LISTLEN downto P+1 do
    yawnTopTen[I] := yawnTopTen[I-1];
  with yawnTopTen[P] do begin
    Name := N;
    Quote := Q;
    Score := S;
    RandSeed := R;
  end;
end;

end.
