unit Mainform;

interface

uses
  BossTool, Dice, DiceTool, YawnTool,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, Menus;

type
  TfrmMain = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    BitBtn9: TBitBtn;
    BitBtn10: TBitBtn;
    BitBtn11: TBitBtn;
    BitBtn12: TBitBtn;
    BitBtn13: TBitBtn;
    btnAbout: TBitBtn;
    btnBoss: TBitBtn;
    btnRoll: TBitBtn;
    PaintBox1: TPaintBox;
    btnTop10: TBitBtn;
    Panel1: TPanel;
    Dice1: TDice;
    Dice2: TDice;
    Dice3: TDice;
    Dice4: TDice;
    Dice5: TDice;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Image1: TImage;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    btnNewGame: TBitBtn;
    lblPoints: TLabel;
    lblRating: TLabel;
    lblBonus: TLabel;
    btnQuit: TBitBtn;
    procedure PaintBox1Paint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnRollClick(Sender: TObject);
    procedure Dice1Click(Sender: TObject);
    procedure btnBossClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure btnNewGameClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure btnQuitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    DA: TDieArray;
    SS: TYawnScoreSheet;
    XS: TYawnScoreSheet;
    BB: array[ YWN_FIRST..YWN_LAST ] of TBitBtn;
    BU: array[ YWN_FIRST..YWN_LAST ] of boolean;
    Round: integer;
    procedure PaintScoreCell( Cell: integer; S: string; Color: TColor );
    procedure PaintScoreSheet( SS: TYawnScoreSheet; U: word );
    procedure EndGame;
    procedure NewRound;
  end;

var
  frmMain: TfrmMain;

implementation

const
  PSS_SHOWUNUSED = 0;
  PSS_WIPEUNUSED = 1;
  PSS_HIDEUNUSED = 2;

{$R *.DFM}

procedure TfrmMain.PaintScoreCell( Cell: integer; S: string; Color: TColor );
var
  X, Y: integer;
  W, H: word;
  L: integer;
begin
  with PaintBox1 do begin
    W := Width;
    H := Height;
  end;
  X := (Cell div 7) * (W div 2) + 2;
  Y := (Cell mod 7) * ((H-2) div 7) + 2;
  W := W div 2 - 4;
  H := H div 7 - 4;
  with PaintBox1.Canvas do begin
    Pen.Color := clWhite;
    Rectangle( X, Y, X+W, Y+H );
    Inc( X, W - TextWidth( S ) - 4 );
    Inc( Y, 2 + (H - TextHeight( S )) div 2 );
    Font.Color := Color;
    TextOut( X, Y, S );
  end;
end;

procedure TfrmMain.PaintScoreSheet( SS: TYawnScoreSheet; U: word );
var
  I, Y   : integer;
  ST     : TYawnScoreTable;
  S      : string;
begin
  for I:=YWN_FIRST to YWN_LAST do begin
    Y := I - 1;
    if( Y > 5 ) then Inc( Y );
    if( BU[I] ) then
      PaintScoreCell( Y, IntToStr(SS[I]), clBlack )
    else begin
      case U of
        PSS_SHOWUNUSED: PaintScoreCell( Y, IntToStr(SS[I]), clGray );
        PSS_WIPEUNUSED: PaintScoreCell( Y, '', clWhite );
      end;
      SS[I] := -1;
    end;
  end;
  yawnSetScoreTable( SS, ST );
  Y := 0;
  for I:=1 to 6 do
    if( BU[I] ) then Inc( Y );
  if( Y = 6 ) then begin
    lblBonus.Caption := 'Bonus';
    PaintScoreCell( 6, IntToStr(ST.Bonus), clBlack )
  end
  else if( Y <> 0 ) then begin
    S := IntToStr( ST.Average );
    if( ST.Average > 0 ) then S := '+' + S;
    if( ST.Average >= 0 ) then
      PaintScoreCell( 6, S, clGreen )
    else
      PaintScoreCell( 6, S, clRed );
  end;
  lblPoints.Caption := IntToStr( ST.Score );
  lblRating.Caption := IntToStr( ST.Rating ) + '%';
end;

procedure TfrmMain.PaintBox1Paint(Sender: TObject);
var
  W, H: word;
  I, Y: word;
begin
  with PaintBox1 do begin
    W := Width;
    H := Height;
  end;
  with PaintBox1.Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color := clWhite;
    Pen.Style := psSolid;
    Pen.Color := clBlue;
    (* Erase background *)
    Rectangle( 0, 0, W, H );
    (* Draw grid *)
    MoveTo( W div 2, 0 );
    LineTo( W div 2, H );
    for I:=1 to 6 do begin
      Y := ((H-2) div 7) * I;
      MoveTo( 0, Y );
      LineTo( W, Y );
    end;
  end;
  PaintScoreSheet( SS, PSS_WIPEUNUSED );
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
  I: integer;
begin
  (* Fill the die array, which will be much easier to handle *)
  for I:=1 to 5 do begin
    DA[I].dcDie := TDice( FindComponent( 'Dice'+IntToStr(I) ) );
    DA[I].dcDie.Tag := I;
    DA[I].dcLabel := TLabel( FindComponent( 'Label'+IntToStr(I) ) );
  end;
  (* Now for the button array *)
  for I:=YWN_FIRST to YWN_LAST do begin
    BB[I] := TBitBtn( FindComponent( 'BitBtn'+IntToStr(I) ) );
    BB[I].Tag := I;
    BB[I].OnClick := BitBtn1Click;
  end;
  (* Initialize variables *)
  EndGame;
end;

procedure TfrmMain.btnRollClick(Sender: TObject);
var
  I: integer;
  D: array[ 1..5 ] of word;
begin
  for I:=1 to 5 do begin
    if not( DA[I].dcHold ) then DA[I].dcDie.Roll;
    D[I] := DA[I].dcDie.Value;
  end;
  if( DA[1].dcDie.Visible = FALSE ) then
    dieArraySetVisible( DA, TRUE );
  Inc( Round );
  if( Round <= 3 ) then
    btnRoll.Caption := 'Roll: ' + IntToStr(Round)
  else
    btnRoll.Enabled := FALSE;
  yawnSetScoreSheet( XS, D );
  for I:=YWN_FIRST to YWN_LAST do
    if( BU[I] ) then XS[I] := SS[I];
  PaintScoreSheet( XS, PSS_SHOWUNUSED );
end;

procedure TfrmMain.Dice1Click(Sender: TObject);
begin
  dieToggleState( DA[(Sender as TDice).Tag] );
end;

procedure TfrmMain.btnBossClick(Sender: TObject);
begin
  bossEnter( Handle, 'Calculator', Image1.Picture.Icon.Handle );
  WindowState := wsMinimized;
end;

procedure TfrmMain.FormResize(Sender: TObject);
begin
  if( WindowState <> wsMinimized )and( bossCheck ) then
    bossLeave;
end;

procedure TfrmMain.EndGame;
var
  I: integer;
begin
  dieArrayReset( DA );
  dieArraySetVisible( DA, FALSE );
  for I:=YWN_FIRST to YWN_LAST do
    BB[I].Enabled := FALSE;
  btnRoll.Enabled := FALSE;
end;

procedure TfrmMain.NewRound;
var
  I, U: integer;
begin
  U := 0;
  for I:=YWN_FIRST to YWN_LAST do
    if( BU[I] ) then Inc( U );
  if( U = YWN_LAST-YWN_FIRST+1 ) then begin
    EndGame;
    Exit;
  end;
  dieArraySetVisible( DA, FALSE );
  dieArrayReset( DA );
  Round := 1;
  btnRoll.Caption := 'Roll: 1';
  btnRoll.Enabled := TRUE;
end;

procedure TfrmMain.btnNewGameClick(Sender: TObject);
var
  I: integer;
begin
  Randomize;
  for I:=YWN_FIRST to YWN_LAST do begin
    BB[I].Enabled := TRUE;
    BU[I] := FALSE;
    SS[I] := 0;
  end;
  lblBonus.Caption := 'Average';
  NewRound;
  PaintBox1Paint( Self );
end;

procedure TfrmMain.BitBtn1Click(Sender: TObject);
var
  I: integer;
  V: integer;
begin
  if( Round <= 1 ) then begin
    Application.MessageBox( 'You must roll your dice first!',
      'Yawn',
      mb_OK or mb_IconInformation );
    Exit;
  end;
  I := (Sender as TBitBtn).Tag;
  SS[I] := XS[I];
  BU[I] := TRUE;
  (Sender as TBitBtn).Enabled := FALSE;
  PaintScoreSheet( XS, PSS_WIPEUNUSED );
  NewRound;
end;

procedure TfrmMain.btnQuitClick(Sender: TObject);
begin
  Application.Terminate;
end;

end.
