unit Main;

interface

uses
  About, BossTool, Dice, DiceTool, EnterTop, TopTool, Top10, YawnTool,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, Menus, Gauges;

type
  TfrmMain = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    BitBtn9: TBitBtn;
    BitBtn10: TBitBtn;
    BitBtn11: TBitBtn;
    BitBtn12: TBitBtn;
    BitBtn13: TBitBtn;
    btnAbout: TBitBtn;
    btnBoss: TBitBtn;
    btnRoll: TBitBtn;
    PaintBox1: TPaintBox;
    btnTop10: TBitBtn;
    Panel1: TPanel;
    Dice1: TDice;
    Dice2: TDice;
    Dice3: TDice;
    Dice4: TDice;
    Dice5: TDice;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Image1: TImage;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    btnNewGame: TBitBtn;
    lblPoints: TLabel;
    lblRating: TLabel;
    lblBonus: TLabel;
    btnQuit: TBitBtn;
    procedure PaintBox1Paint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnRollClick(Sender: TObject);
    procedure Dice1Click(Sender: TObject);
    procedure btnBossClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure btnNewGameClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure btnQuitClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btnTop10Click(Sender: TObject);
  protected
    procedure WndProc( var M: TMessage ); override;
  private
    { Private declarations }
  public
    { Public declarations }
    DA: TDieArray;
    SS: TYawnScoreSheet;
    XS: TYawnScoreSheet;
    BB: array[ YWN_FIRST..YWN_LAST ] of TBitBtn;
    BU: array[ YWN_FIRST..YWN_LAST ] of boolean;
    ST: TYawnScoreTable;
    RSeed: word;
    RollCount: integer;
    IsPlaying: boolean;
    Top10FName: string;
    procedure PaintScoreCell( Cell: integer; S: string; Color: TColor );
    procedure PaintScoreSheet( SS: TYawnScoreSheet; U: word );
    procedure EndGame;
    procedure NewRound;
    procedure DoShowHint( var Text: string; var Show: Boolean;
      var HintInfo: THintInfo );
  end;

var
  frmMain: TfrmMain;

implementation

const
  PSS_SHOWUNUSED = 0;
  PSS_WIPEUNUSED = 1;
  PSS_HIDEUNUSED = 2;

{$R *.DFM}

(*----------------------------------------
    Hook the Application.OnShowHint event to change the
    hint appearance and allow multi-line text.
----------------------------------------*)
procedure TfrmMain.DoShowHint;
var
  P: integer;
begin
  (* Convert the '@' character into a CRLF sequence *)
  repeat
    P := Pos( '@', Text );
    if( P > 0 ) then begin
      Delete( Text, P, 1 );
      Insert( #13#10, Text, P );
    end;
  until( P = 0 );
  (* Force wrapping of long text *)
  HintInfo.HintMaxWidth := 160;
  (* Change the background color to bright green *)
  HintInfo.HintColor := clLime;
end;

(*----------------------------------------
    Trap the WM_NCHITTEST message: we don't want the
    window to be resized even if it has a sizeable
    border. Also patch the system menu to avoid
    manual resizing.
----------------------------------------*)
procedure TfrmMain.WndProc;
begin
  case M.Msg of
    (* Non-client hit test *)
    WM_NCHITTEST: begin
      inherited WndProc( M );
      case M.Result of
        HTTOPLEFT, HTTOP, HTTOPRIGHT,
        HTLEFT, HTRIGHT,
        HTBOTTOMLEFT, HTBOTTOM, HTBOTTOMRIGHT:
          M.Result := HTBORDER;
      end;
    end;
    (* Menu initialization *)
    WM_INITMENU: begin
      EnableMenuItem( M.wParam, SC_SIZE, MF_GRAYED or MF_BYCOMMAND );
      M.Result := 0;
    end;
    (* System command *)
    WM_SYSCOMMAND:
      if( M.wParam and $FFF0 = SC_SIZE ) then
        M.Result := 0
      else
        inherited WndProc( M );
    (* Default *)
    else
      inherited WndProc( M );
  end;
end;

(*----------------------------------------
    Form creation
----------------------------------------*)
procedure TfrmMain.FormCreate(Sender: TObject);
var
  I: integer;
  S: string;
begin
  (* Fill the die array, which will be much easier to handle *)
  for I:=1 to 5 do begin
    DA[I].dcDie := TDice( FindComponent( 'Dice'+IntToStr(I) ) );
    DA[I].dcDie.Tag := I;
    DA[I].dcLabel := TLabel( FindComponent( 'Label'+IntToStr(I) ) );
  end;
  (* Now for the button array *)
  for I:=YWN_FIRST to YWN_LAST do begin
    BB[I] := TBitBtn( FindComponent( 'BitBtn'+IntToStr(I) ) );
    BB[I].Tag := I;
    BB[I].OnClick := BitBtn1Click;
    SS[I] := -1;
    XS[I] := -1;
  end;
  (* Initialize variables *)
  Application.OnShowHint := DoShowHint;
  EndGame;
  Left := (Screen.Width - Width) div 2;
  Top := (Screen.Height - Height) div 3;
  Top10FName := Application.ExeName;
  Top10FName := Copy( Top10FName, 1, Length(Top10FName)-3 ) + 'T10';
  topClear;
  topLoadFromFile( Top10FName );
end;

(*----------------------------------------
    Draw the specified score cell
----------------------------------------*)
procedure TfrmMain.PaintScoreCell( Cell: integer; S: string; Color: TColor );
var
  X, Y: integer;
  W, H: word;
  L: integer;
begin
  with PaintBox1 do begin
    W := Width;
    H := Height;
  end;
  X := (Cell div 7) * (W div 2) + 2;
  Y := (Cell mod 7) * ((H-2) div 7) + 2;
  W := W div 2 - 4;
  H := H div 7 - 4;
  with PaintBox1.Canvas do begin
    Pen.Color := clWhite;
    Rectangle( X, Y, X+W, Y+H );
    Inc( X, W - TextWidth( S ) - 4 );
    Inc( Y, 2 + (H - TextHeight( S )) div 2 );
    Font.Color := Color;
    TextOut( X, Y, S );
  end;
end;

(*----------------------------------------
    Draws the specified score sheet
----------------------------------------*)
procedure TfrmMain.PaintScoreSheet( SS: TYawnScoreSheet; U: word );
var
  I, Y   : integer;
  S      : string;
begin
  for I:=YWN_FIRST to YWN_LAST do begin
    Y := I - 1;
    if( Y > 5 ) then Inc( Y );
    if( BU[I] ) then
      PaintScoreCell( Y, IntToStr(SS[I]), clBlack )
    else begin
      case U of
        PSS_SHOWUNUSED: PaintScoreCell( Y, IntToStr(SS[I]), clGray );
        PSS_WIPEUNUSED: PaintScoreCell( Y, '', clWhite );
        (* Default is PSS_HIDEUNUSED *)
      end;
      SS[I] := -1;
    end;
  end;
  yawnSetScoreTable( SS, ST );
  Y := 0;
  for I:=1 to 6 do
    if( BU[I] ) then Inc( Y );
  if( Y = 6 ) then begin
    lblBonus.Caption := 'Bonus';
    PaintScoreCell( 6, IntToStr(ST.Bonus), clBlack )
  end
  else if( Y <> 0 ) then begin
    S := IntToStr( ST.Average );
    if( ST.Average > 0 ) then S := '+' + S;
    if( ST.Average >= 0 ) then
      PaintScoreCell( 6, S, clGreen )
    else
      PaintScoreCell( 6, S, clRed );
  end;
  lblPoints.Caption := IntToStr( ST.Score );
  lblRating.Caption := IntToStr( ST.Rating ) + '%';
end;

(*----------------------------------------
    Score sheet paint event
----------------------------------------*)
procedure TfrmMain.PaintBox1Paint(Sender: TObject);
var
  W, H: word;
  I, Y: word;
begin
  with PaintBox1 do begin
    W := Width;
    H := Height;
  end;
  with PaintBox1.Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color := clWhite;
    Pen.Style := psSolid;
    Pen.Color := clBlue;
    (* Erase background *)
    Rectangle( 0, 0, W, H );
    (* Draw grid *)
    MoveTo( W div 2, 0 );
    LineTo( W div 2, H );
    for I:=1 to 6 do begin
      Y := ((H-2) div 7) * I;
      MoveTo( 0, Y );
      LineTo( W, Y );
    end;
  end;
  PaintScoreSheet( SS, PSS_WIPEUNUSED );
end;

(*----------------------------------------
    Rolls the dice
----------------------------------------*)
procedure TfrmMain.btnRollClick(Sender: TObject);
var
  I: integer;
  D: array[ 1..5 ] of word;
begin
  (* Rolls "free" dice *)
  for I:=1 to 5 do begin
    if not( DA[I].dcHold ) then DA[I].dcDie.Roll;
    D[I] := DA[I].dcDie.Value;
  end;
  (* Show dice if previously hidden *)
  if( DA[1].dcDie.Visible = FALSE ) then
    dieArraySetVisible( DA, TRUE );
  (* Increment roll count *)
  Inc( RollCount );
  if( RollCount <= 3 ) then
    btnRoll.Caption := 'Roll: ' + IntToStr(RollCount)
  else
    btnRoll.Enabled := FALSE;
  (* Update score sheet with current dice configuration *)
  yawnSetScoreSheet( XS, D );
  for I:=YWN_FIRST to YWN_LAST do
    if( BU[I] ) then XS[I] := SS[I];
  PaintScoreSheet( XS, PSS_SHOWUNUSED );
end;

(*----------------------------------------
    Click event for all the dice
----------------------------------------*)
procedure TfrmMain.Dice1Click(Sender: TObject);
begin
  (* Toggle the "hold" status *)
  dieToggleState( DA[(Sender as TDice).Tag] );
end;

(*----------------------------------------
    Terminates the current game
----------------------------------------*)
procedure TfrmMain.EndGame;
var
  I: integer;
begin
  (* Reset and hide dice *)
  dieArrayReset( DA );
  dieArraySetVisible( DA, FALSE );
  (* Disable game buttons *)
  for I:=YWN_FIRST to YWN_LAST do
    BB[I].Enabled := FALSE;
  btnRoll.Enabled := FALSE;
  lblBonus.Visible := FALSE;
  IsPlaying := FALSE;
end;

(*----------------------------------------
    Start a new round
----------------------------------------*)
procedure TfrmMain.NewRound;
var
  I, U: integer;
begin
  (* First check if no more rounds *)
  U := 0;
  for I:=YWN_FIRST to YWN_LAST do
    if( BU[I] ) then Inc( U );
  if( U = YWN_LAST-YWN_FIRST+1 ) then begin
    btnNewGame.SetFocus;
    EndGame;
    if( topGetPos(ST.Score) <> 0 ) then begin
      I := frmEnterTop.ShowModal;
      if( I = mrOk ) then
        frmTop10.ShowModal;
    end;
    Exit;
  end;
  (* Hide and initialize dice *)
  dieArraySetVisible( DA, FALSE );
  dieArrayReset( DA );
  (* Initialize roll button *)
  RollCount := 1;
  btnRoll.Caption := 'Roll: 1';
  btnRoll.Enabled := TRUE;
  btnRoll.SetFocus;
end;

(*----------------------------------------
    Start a new game
----------------------------------------*)
procedure TfrmMain.btnNewGameClick(Sender: TObject);
var
  I: integer;
begin
  (* Initialize variables *)
  Randomize;
  RSeed := RandSeed;
  for I:=YWN_FIRST to YWN_LAST do begin
    BB[I].Enabled := TRUE;
    BU[I] := FALSE;
    SS[I] := 0;
  end;
  lblBonus.Caption := 'Average';
  lblBonus.Visible := TRUE;
  IsPlaying := TRUE;
  (* Start first round *)
  NewRound;
  PaintBox1Paint( Self );
end;

(*----------------------------------------
    Click event for score-sheet buttons
----------------------------------------*)
procedure TfrmMain.BitBtn1Click(Sender: TObject);
var
  I: integer;
  V: integer;
begin
  (* Exit if no dice rolled *)
  if( RollCount <= 1 ) then begin
    Application.MessageBox( 'You must roll your dice first!',
      'Yawn',
      mb_OK or mb_IconInformation );
    Exit;
  end;
  (* Set score on specified cell *)
  I := (Sender as TBitBtn).Tag;
  SS[I] := XS[I];
  BU[I] := TRUE;
  PaintScoreSheet( XS, PSS_WIPEUNUSED );
  (* Disable button *)
  (Sender as TBitBtn).Enabled := FALSE;
  (* Start next round *)
  NewRound;
end;

(*----------------------------------------
    Quit application
----------------------------------------*)
procedure TfrmMain.btnQuitClick(Sender: TObject);
var
  R: integer;
begin
  if( IsPlaying ) then begin
    R := Application.MessageBox(
      'Really quit?',
      'Please confirm',
      MB_ICONQUESTION or MB_YESNO );
    if( R <> IDYES ) then
      Exit;
  end;
  topSaveToFile( Top10FName );
  Application.Terminate;
end;

(*----------------------------------------
    Show about box
----------------------------------------*)
procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  frmAbout.ShowModal;
end;

(*----------------------------------------
    Enter boss mode
----------------------------------------*)
procedure TfrmMain.btnBossClick(Sender: TObject);
begin
  bossEnter( Handle, 'Calculator', Image1.Picture.Icon.Handle );
  WindowState := wsMinimized;
end;

(*----------------------------------------
    Leave boss mode if necessary
----------------------------------------*)
procedure TfrmMain.FormResize(Sender: TObject);
begin
  if( WindowState <> wsMinimized )and( bossCheck ) then
    bossLeave;
end;

(*----------------------------------------
    Choose button to set focus when
    form is activated
----------------------------------------*)
procedure TfrmMain.FormActivate(Sender: TObject);
begin
  if( IsPlaying ) then
    btnRoll.SetFocus
  else
    btnNewGame.SetFocus;
end;

(*----------------------------------------
    Show top ten list
----------------------------------------*)
procedure TfrmMain.btnTop10Click(Sender: TObject);
begin
  frmTop10.ShowModal;
end;

end.
