unit Entertop;

interface

uses
  TopTool,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons;

type
  TfrmEnterTop = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    edtName: TEdit;
    edtQuote: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label5: TLabel;
    lblRank: TLabel;
    Label6: TLabel;
    lblScore: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Score: word;
    RSeed: word;
    LastName: string;
  end;

var
  frmEnterTop: TfrmEnterTop;

implementation uses Main;

{$R *.DFM}

procedure TfrmEnterTop.FormCreate(Sender: TObject);
begin
  Left := (Screen.Width - Width) div 2;
  Top := (Screen.Height - Height) div 3;
  LastName := '';
  edtName.MaxLength := TOP_NAMELEN;
  edtQuote.MaxLength := TOP_QUOTELEN;
end;

procedure TfrmEnterTop.BitBtn1Click(Sender: TObject);
begin
  topInsert( edtName.Text, edtQuote.Text, Score, RSeed );
  LastName := edtName.Text;
end;

procedure TfrmEnterTop.FormActivate(Sender: TObject);
begin
  Score := frmMain.ST.Score;
  RSeed := frmMain.RSeed;
  lblRank.Caption := IntToStr(topGetPos(Score));
  lblScore.Caption := IntToStr(Score);
  edtName.Text := LastName;
  edtQuote.Text := '';
  if( LastName <> '' ) then
    edtQuote.SetFocus
  else
    edtName.SetFocus;
end;

end.
