(*
    Dice management for the "Yawn" game
    Copyright (c) 1995 Alessandro Scotti
*)
unit DiceTool;

interface

uses
  Controls, Dice, StdCtrls;

type
  TDieCombo = record
    dcDie   : TDice;
    dcHold  : boolean;
    dcLabel : TLabel;
  end;
  TDieArray = array[ 1..5 ] of TDieCombo;

procedure dieArrayReset( var DA: TDieArray );
procedure dieArraySetVisible( var DA: TDieArray; V: boolean );
procedure dieSetState( var DC: TDieCombo; S: boolean );
procedure dieToggleState( var DC: TDieCombo );

implementation

procedure dieArrayReset( var DA: TDieArray );
var
  I: integer;
begin
  for I:=1 to 5 do begin
    DA[I].dcDie.Value := 0;
    DA[I].dcHold := FALSE;
    DA[I].dcLabel.Caption := '';
  end;
end;

procedure dieArraySetVisible( var DA: TDieArray; V: boolean );
var
  I: integer;
begin
  for I:=1 to 5 do begin
    DA[I].dcDie.Visible := V;
    DA[I].dcLabel.Visible := V;
  end;
end;

procedure dieSetState( var DC: TDieCombo; S: boolean );
begin
  if( S ) then begin
    DC.dcHold := TRUE;
    DC.dcLabel.Caption := 'Hold';
  end
  else begin
    DC.dcHold := FALSE;
    DC.dcLabel.Caption := '';
  end;
end;

procedure dieToggleState( var DC: TDieCombo );
begin
  dieSetState( DC, not DC.dcHold );
end;

end.
