(*
    Boss mode management
    Copyright (c) 1995 Alessandro Scotti
*)
unit BossTool;

interface

uses
  WinTypes, WinProcs;

function bossCheck: boolean;
procedure bossEnter( Wnd: HWnd; Caption: string; Icon: HIcon );
procedure bossLeave;

implementation

const
  OldCaption  : array[ 0..255 ] of char = '';
  OldIcon     : HIcon = 0;
  WndHandle   : HWnd = 0;

(*
    Activates boss mode
*)
procedure bossEnter( Wnd: HWnd; Caption: string; Icon: HIcon );
var
  S: string;
begin
  if( bossCheck ) then
    Exit;
  (* Save current caption and icon *)
  GetWindowText( Wnd, OldCaption, 255 );
  OldIcon := GetClassWord( Wnd, -14 );
  (* Set new caption and icon *)
  Caption := Caption + #0;
  SetWindowText( Wnd, @Caption[1] );
  if( Icon <> 0 ) then
    SetClassWord( Wnd, -14, Icon );
  (* Remember window handle *)
  WndHandle := Wnd;
end;

(*
    Terminates boss mode
*)
procedure bossLeave;
begin
  if( bossCheck ) then begin
    (* Restore original caption and text *)
    SetWindowText( WndHandle, OldCaption );
    SetClassWord( WndHandle, -14, OldIcon );
    (* Reset window handle *)
    WndHandle := 0;
  end;
end;

(*
    Returns TRUE if currently in boss mode,
    FALSE otherwise
*)
function bossCheck: boolean;
begin
  bossCheck := WndHandle <> 0;
end;

end.
