unit About;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons;

type
  TfrmAbout = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Image1: TImage;
    BitBtn1: TBitBtn;
    Bevel1: TBevel;
    lblMsg: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Image1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    MsgIdx: word;
  end;

var
  frmAbout: TfrmAbout;

implementation

{$R *.DFM}

procedure TfrmAbout.FormCreate(Sender: TObject);
begin
  Left := (Screen.Width - Width) div 2;
  Top := (Screen.Height - Height) div 2;
end;

function GetLabelMessage( Idx: word ): string;
begin
  case Idx of
    0: Result := 'You''ve found it!'#13#10'Try again...';
    1: Result := 'Winners do not use drugs';
    2: Result := 'Please, send me a postcard!';
    3: Result := 'You''re running out of memory!';
    4: Result := 'This program is freeware';
    5: Result := 'Warning:'#13#10'virus detected!';
    6: Result := 'No cool message now, try later...';
    7: Result := 'The top-ten list has been reset';
    8: Result := 'This space for rent';
    9: Result := 'Please stop clicking!!!';
    else
       Result := 'Mph!';
  end;
end;

procedure TfrmAbout.FormActivate(Sender: TObject);
begin
  (* Do not use the random function here, because it *)
  (* would interfere with the game *)
  MsgIdx := 0;
  lblMsg.Caption := GetLabelMessage( 1 + GetTickCount and 7 );
end;

(* Shift-clicking on the icon shows all messages *)
procedure TfrmAbout.Image1Click(Sender: TObject);
begin
  if( GetAsyncKeyState( VK_SHIFT ) >= 0 ) then
    Exit;
  lblMsg.Caption := GetLabelMessage( MsgIdx );
  Inc( MsgIdx );
end;

end.
