{------------------------------------------------------------------------------}
unit XLabel;                                       { (c) Julien RICHETTI, 1995 }
{------------------------------------------------------------------------------}
{ Nouveau Contrle Delphi TXLabel permettant d'ecrire un texte selon           }
{ un angle d'inclinaison quelconque et avec ventuellement un effet de relief  }
{------------------------------------------------------------------------------}

interface

{------------------------------------------------------------------------------}
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Menus, StdCtrls;

{------------------------------------------------------------------------------}
type

 { Cration d'un nouveau contrle fond sur la classe des TLabel's }
 TXLabel = class(TCustomLabel)
  private
    FAngle:   Integer;                   { valeur de l'inclinaison }
    FRelief:  Boolean;                   { flag prsence de relief }
    procedure SetAngle(value: Integer);  { affectation de l'angle  }
    procedure SetRelief(value: Boolean); { affectation du relief   }

  protected
    procedure Paint; override; { Nouvelle mthode PAINT personnalise}

  public
    { Hritage des constructeur et destructeur de l'objet anctre }
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;

  published
    { Publication de nouvelles proprits du contrle... }
{*} property Angle: Integer read FAngle write SetAngle default 0;
{*} property Relief: Boolean read FRelief Write SetRelief default False;
{*} property Color; { en fait utilise pour le relief... }
    {
     Hritage direct des autres proprits
     sauf certaines :
     AutoSize, Transparent, Alignment, ShowAccelChar, FocusControl
     qui posent encore quelques petits problmes ou sont inutiles...
    }

    property Align;
    property Caption;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register; { dclaration avance... }

{------------------------------------------------------------------------------}
implementation

{------------------------------------------------------------------------------}
uses DsgnIntf;

{------------------------------------------------------------------------------}

{ TXLabel }
{------------------------------------------------------------------------------}
constructor TXLabel.Create(AOwner: TComponent);
{------------------------------------------------------------------------------}
begin
 { Appel du constructeur hrit de l'objet anctre }
 inherited Create(AOwner);
 { Affectation des valeurs par defaut }
 FAngle:= 0;
 FRelief:= False;
end;

{------------------------------------------------------------------------------}
destructor TXLabel.Destroy;
{------------------------------------------------------------------------------}
begin
 { Appel du destructeur hrit de l'objet anctre }
 inherited Destroy;
end;

{------------------------------------------------------------------------------}
procedure TXLabel.SetAngle(Value: Integer);
{------------------------------------------------------------------------------}
var a: integer;
begin
 { Affectation de la valeur de l'inclinaison du texte }
 { on limite la plage d'angle de -180  +180}
 a:= Value;
 if a>0
  then a:=  a mod 360
  else a:=  -(abs(a) mod 360);
 if a> 180 then a:= a - 360;
 if a<-180 then a:= a + 360;
 FAngle:= a;
 { force  repeindre le contrle }
 Invalidate;
end;

{------------------------------------------------------------------------------}
procedure TXLabel.SetRelief(Value: Boolean);
{------------------------------------------------------------------------------}
begin
 { affectation du drapeau indicant la prsence d'un effet de relief }
 FRelief:= Value;
 { force  repeindre le contrle }
 Invalidate;
end;

{------------------------------------------------------------------------------}
procedure TXLabel.Paint;
{------------------------------------------------------------------------------}
var
 s, p    : string;
 X, Y, a : integer;
 NH, NW  : integer;
 hFontNew: HFONT;
 hFontOld: HFONT;
 W, H, R : real;
 k       : Longint;

begin

 { Petites convertions pour compatibilit API C++ }
 a:= FAngle * 10; s:= Caption; p:= Font.Name + #0;

 { Cration de l'objet mmoire de la police inclin }
 hFontNew:= CreateFont(
  { Height      } Font.Height,
  { Width       } 0,
  { Escapement  } a, { angle d'inclinaison du texte }
  { Orientation } 0, { exprim en dixime de degr  }
  { Weight      } ord(fsBold in Font.Style) * FW_BOLD,
  { Italic      } ord(fsItalic     in Font.Style),
  { Underline   } ord(fsUnderLine  in Font.Style),
  { SrtikeOut   } ord(fsStrikeOut  in Font.Style),
  { Charset     } DEFAULT_CHARSET,
  { OutputPrec. } OUT_DEFAULT_PRECIS,
  { ClipPrec.   } CLIP_DEFAULT_PRECIS,
  { Quality     } DEFAULT_QUALITY,
  { Picth       } DEFAULT_PITCH + FF_DONTCARE,
  { FaceName    } @p[1]
 );

 { Affectation de la nouvelle police au HDC }
 hFontOld:= SelectObject(Canvas.Handle, hFontNew);

 { Calcul de la hauteur et largeur de la chane }
 k:= GetTextExtent(Canvas.Handle, @s[1], Length(s));
 W:= LoWord(k); H:= HiWord(k); R:= pi * (FAngle / 180);

 { Calcul de la bote englobante du texte }
 { Attention si on utilise 'Align' a pose plein de problmes !}
 NW:= Round(Abs( H * sin(R)) + Abs( W * cos(R))) + ord(FRelief);
 NH:= Round(Abs( W * sin(R)) + Abs( H * cos(R))) + ord(FRelief);

 if (Align=alTop) or (Align=alNone) or (Align=alBottom) then Height:= NH;
 if (Align=alLeft) or (Align=alRight) or (align=alNone) then Width:= NW;

 { Determination du point de depart du texte dans le cadre }
 if (FAngle<=90) and (FAngle>=0)   then begin X:= 0; Y:= Abs(Round(W*sin(R)));  end;
 if (FAngle<0)   and (FAngle>=-90) then begin X:= Abs(Round(H*sin(R))); Y:= 0;  end;
 if (FAngle>90)  and (FAngle<=180) then begin X:= Abs(Round(W*cos(R))); Y:= NH; end;
 if (FAngle<-90) and (FAngle>-180) then begin X:= NW; Y:= Abs(Round(H*cos(R))); end;

 { Utiliser un pinceau de fond transparent pour ecrire le texte }
 Canvas.Brush.Style:= bsClear;

 { Utilisation la proprit 'Color' pour dessinner le relief }
 SetTextColor(Canvas.Handle, ColorToRGB(Color));

 { Dessin du relief, lgrement dcal }
 if FRelief then
  TextOut(Canvas.Handle, X+1, Y+1, @s[1], Length(s));

 { Utlisation de la couleur de la police pour dessiner le texte }
 SetTextColor(Canvas.Handle, ColorToRGB(Font.Color));

 { Dessin du texte proprement dit }
 TextOut(Canvas.Handle, X, Y, @s[1], Length(s));

 { Revient  la police prcedente utlise dans ce HDC }
 SelectObject(Canvas.Handle, hFontOld);

 { Detruit l'objet mmoire de la police incline }
 DeleteObject(hFontNew);

end;


{------------------------------------------------------------------------------}
procedure Register;
{------------------------------------------------------------------------------}
begin
  { Enregistrement du nouveau contrle dans la bibliothque de }
  { composants de Deplhi dans la rubrique 'Exemple'}
  RegisterComponents('Exemples', [TXLabel]);
  { le Fichier XLABEL.DCR doit tre dans le mme rpertoire et }
  { contient le dessin du bouton apparaissant dans Delphi...   }
end;

end.

