{*******************************************************}
{                                                       }
{       xTool - Component Collection                    }
{                                                       }
{       Copyright (c) 1997 Fabula Software              }
{                                                       }
{*******************************************************}
unit xCursor;
  { general cursors needed by various components & controls }

{$IFDEF Win32}
  {$R xCursor.r32 }
{$ELSE}
  {$R xCursor.res }
{$ENDIF}

interface

const
  crHand     = 17779;
  crMagnify  = 17780;
  crWait     = 17781;
  crHandMove = 17782;

procedure cursorWait;
procedure cursorDefault;

implementation

uses
  WinProcs, SysUtils, Controls, Forms;

const
  WAIT_CURSOR = 'wait.ani';

procedure cursorWait;
begin
  Screen.Cursor:=crWait;
end;

procedure cursorDefault;
begin
  Screen.Cursor:=crDefault;
end;

initialization

  Screen.Cursors[crHand]    :=LoadCursor(hInstance,'X_HAND');
  Screen.Cursors[crMagnify] :=LoadCursor(hInstance,'X_MAGNIFY');
  Screen.Cursors[crHandMove]:=LoadCursor(hInstance,'X_MOVE');

{$IFDEF Win32}
  if FileExists(ExtractFilePath(ParamStr(0))+WAIT_CURSOR) then
     Screen.Cursors[crWait]:=LoadCursorFromFile(PChar(ExtractFilePath(ParamStr(0))+WAIT_CURSOR))
  else
{$ENDIF}
     Screen.Cursors[crWait]:=Screen.Cursors[crHourGlass];

end.
