unit MainWin;

{ WallPaper Browser
  -----------------
  update version (v1.1)
  created on July 1996
  by Balza Achmad
  (balzach@t-nuklir.ugm.ac.id)
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, FileCtrl, Buttons;

type
  TMainWindow = class(TForm)
    Label1: TLabel;
    IDS_Wallpaper: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    IDS_Path: TLabel;
    IDL_Filenames: TFileListBox;
    IDL_Directory: TDirectoryListBox;
    IDC_Tiled: TCheckBox;
    Bevel1: TBevel;
    IDC_Drive: TDriveComboBox;
    IDC_Stretch: TCheckBox;
    IDB_Assign: TBitBtn;
    IDB_Cancel: TBitBtn;
    IDB_Exit: TBitBtn;
    ScrollBox: TScrollBox;                 {v1.1}
    IDI_Preview: TImage;
    IDB_Clear: TBitBtn;                    {v1.1}
    procedure IDB_CancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure IDL_FilenamesClick(Sender: TObject);
    procedure IDB_AssignClick(Sender: TObject);
    procedure IDC_StretchClick(Sender: TObject);
    procedure IDB_ClearClick(Sender: TObject);
    procedure IDB_ExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainWindow: TMainWindow;
  oldWallpaper: array [0..128] of char;
  oldTiled: integer;

implementation

{$R *.DFM}

procedure TMainWindow.IDB_CancelClick(Sender: TObject);
var
  tiled: array [0..1] of char;
begin
  if oldTiled = 1 then
    lStrCpy(tiled, '1')
  else
    lStrCpy(tiled, '0');
  WriteProfileString('Desktop', 'TileWallpaper', tiled);
  SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, @oldwallpaper,
    SPIF_UPDATEINIFILE);
  Close;
end;

procedure TMainWindow.FormCreate(Sender: TObject);
begin
  GetProfileString('Desktop', 'Wallpaper', '', oldWallpaper, 128);
  IDS_Wallpaper.Caption := oldWallpaper;
  oldTiled := GetProfileInt('Desktop', 'TileWallpaper', 0);
  IDC_Tiled.Checked := boolean(oldTiled);
end;

procedure TMainWindow.IDL_FilenamesClick(Sender: TObject);
begin
  IDI_Preview.Picture.LoadFromFile(IDL_Filenames.FileName);
  IDC_StretchClick(Sender);
end;

procedure TMainWindow.IDB_AssignClick(Sender: TObject);
var
  fn: array [0..128] of char;
  tiled: array [0..1] of char;
begin
  if IDL_Filenames.FileName<>'' then begin
    if IDC_Tiled.Checked then
      lStrCpy(tiled, '1')
    else
      lStrCpy(tiled, '0');
    WriteProfileString('Desktop', 'TileWallPaper', tiled);
    StrPCopy(fn, IDL_Filenames.FileName);
    SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, @fn, SPIF_UPDATEINIFILE)
    end;
end;

procedure TMainWindow.IDC_StretchClick(Sender: TObject);
begin
  with ScrollBox do                {v1.1}
    begin
      IDI_Preview.Stretch := IDC_Stretch.Checked;
      if (IDI_Preview.Stretch) then
        begin
          IDI_Preview.Width := 125;
          IDI_Preview.Height := 125;
          HorzScrollBar.Visible := False;
          ScrollBox.VertScrollBar.Visible := False;
        end
      else
        begin
          IDI_Preview.AutoSize := True;
          if (IDI_Preview.Width < 125) then
            IDI_Preview.Width := 125
          else
            HorzScrollBar.Visible := True;
          if (IDI_Preview.Height < 125) then
            IDI_Preview.Height := 125
          else
            VertScrollBar.Visible := True;
          HorzScrollBar.Position := (IDI_Preview.Width - Width) div 2;
          VertScrollBar.Position := (IDI_Preview.Height - Height) div 2;
        end;
    end;
end;

procedure TMainWindow.IDB_ClearClick(Sender: TObject);   {v1.1}
var
  fn: array [0..10] of char;
begin
  lStrCpy(fn, '(none)');
  SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, @fn, SPIF_UPDATEINIFILE);
end;

procedure TMainWindow.IDB_ExitClick(Sender: TObject);
begin
  Close;
end;

end.
