unit worddecs; 

interface

uses sysutils;

{$IFNDEF WIN32}  type shortstring = string[255]; {$ENDIF}

{**************************** Word Command Codes *****************************}

const
  wdAbs                           = -32768; 
  wdActivate                      = -32670; 
  wdActivateObject                =    126;
  wdAddAddIn                      = -32392; 
  wdAddButton                     = -32395; 
  wdAddCommand                    = -32394; 
  wdAddDropDownItem               = -32376; 
  wdAddInState                    = -32381; 
  wdAllCaps                       = -32693; 
  wdAnnotationRefFromSelStr       = -32434; 
  wdAppActivate                   = -32669; 
  wdAppClose                      = -32505; 
  wdAppCount                      = -32504; 
  wdAppGetNames                   = -32503; 
  wdAppHide                       = -32502; 
  wdAppInfoStr                    = -32587; 
  wdAppIsRunning                  = -32501; 
  wdAppMaximize                   = -32702; 
  wdAppMinimize                   = -32703; 
  wdAppMove                       = -32704;
  wdAppRestore                    = -32701; 
  wdAppSendMessage                = -32496; 
  wdAppShow                       = -32479; 
  wdAppSize                       = -32705; 
  wdAppWindowHeight               = -32445; 
  wdAppWindowPosLeft              = -32446; 
  wdAppWindowPosTop               = -32494; 
  wdAppWindowWidth                = -32444; 
  wdAsc                           = -32764; 
  wdAtEndOfDocument               = -32292; 
  wdAtStartOfDocument             = -32291; 
  wdAutoMarkIndexEntries          = -32422; 
  wdAutoText                      =    653;
  wdAutoTextNameStr               = -32727; 
  wdBeep                          = -32724; 
  wdBold                          = -32696; 
  wdBookmarkNameStr               = -32737; 
  wdBorderBottom                  = -16346; 
  wdBorderInside                  = -16344; 
  wdBorderLeft                    = -16347; 
  wdBorderLineStyle               = -32453; 
  wdBorderNone                    = -16359; 
  wdBorderOutside                 = -16360;
  wdBorderRight                   = -16345; 
  wdBorderTop                     = -16348; 
  wdCancel                        =     72;
  wdCancelButton                  = -32568; 
  wdCenterPara                    = -32685; 
  wdChangeCase                    = -32588; 
  wdCharColor                     = -32697; 
  wdCharLeft                      = -16384; 
  wdCharRight                     = -16383; 
  wdChDefaultDir                  = -32360; 
  wdChDir                         = -32596; 
  wdCheckBox                      = -32552; 
  wdCheckBoxFormField             =    350;
  wdChooseButtonImage             =    627;
  wdChrStr                        = -32763; 
  wdCleanStringStr                = -32341; 
  wdClearAddIns                   = -32382; 
  wdClearFormField                =    706;
  wdClosePane                     =    243;
  wdClosePreview                  =    437;
  wdCloseUpPara                   = -32677; 
  wdCloseViewHeaderFooter         =    640;
  wdCmpBookmarks                  = -32745;
  wdColumnSelect                  = -32751; 
  wdComboBox                      = -32548; 
  wdCommandValid                  = -32572; 
  wdConnect                       =    420;
  wdControlRun                    =    235;
  wdConverterLookup               = -32349; 
  wdConverterStr                  = -32346; 
  wdConvertObject                 =    392;
  wdCopyBookmark                  = -32744; 
  wdCopyButtonImage               = -32366; 
  wdCopyFile                      =    300;
  wdCopyFormat                    =     73;
  wdCopyText                      =     19;
  wdCountAddIns                   = -32383; 
  wdCountAutoTextEntries          = -32728; 
  wdCountBookmarks                = -32739; 
  wdCountDirectories              = -32536; 
  wdCountDocumentVars             = -32344; 
  wdCountFiles                    = -32730; 
  wdCountFonts                    = -32645; 
  wdCountFoundFiles               = -32583; 
  wdCountKeys                     = -32577; 
  wdCountLanguages                = -32641;
  wdCountMacros                   = -32585; 
  wdCountMenuItems                = -32447; 
  wdCountMenus                    = -32449; 
  wdCountMergeFields              = -32738; 
  wdCountStyles                   = -32735; 
  wdCountToolbarButtons           = -32295; 
  wdCountToolbars                 = -32363; 
  wdCountToolsGrammarStatistics   = -32462; 
  wdCountWindows                  = -32710; 
  wdCreateSubdocument             =    491;
  wdDateSerial                    = -32528; 
  wdDateStr                       = -32756; 
  wdDateValue                     = -32527; 
  wdDay                           = -32526; 
  wdDays360                       = -32525; 
  wdDDEExecute                    = -32673; 
  wdDDEInitiate                   = -32676; 
  wdDDEPoke                       = -32672; 
  wdDDERequestStr                 = -32671; 
  wdDDETerminate                  = -32675; 
  wdDDETerminateAll               = -32674; 
  wdDefaultDirStr                 = -32372; 
  wdDeleteAddIn                   = -32393;
  wdDeleteBackWord                =     29;
  wdDeleteButton                  = -32396; 
  wdDeleteWord                    =     28;
  wdDemoteList                    =    592;
  wdDemoteToBodyText              =    366;
  wdDialogEditor                  =    552;
  wdDisableAutoMacros             = -32554; 
  wdDisableInput                  = -32610; 
  wdDlgControlId                  = -32477; 
  wdDlgEnable                     = -32485; 
  wdDlgFilePreview                = -32387; 
  wdDlgFilePreviewStr             = -32458; 
  wdDlgFocus                      = -32456; 
  wdDlgFocusStr                   = -32480; 
  wdDlgListBoxArray               = -32478; 
  wdDlgSetPicture                 = -32474; 
  wdDlgText                       = -32457; 
  wdDlgTextStr                    = -32481; 
  wdDlgUpdateFilePreview          = -32484; 
  wdDlgValue                      = -32482; 
  wdDlgVisible                    = -32483; 
  wdDocClose                      = -32609; 
  wdDocMaximize                   = -32700;
  wdDocMinimize                   = -32507; 
  wdDocMove                       = -32718; 
  wdDocRestore                    =    233;
  wdDocSize                       = -32717; 
  wdDocSplit                      = -32707; 
  wdDocumentStatistics            =     78;
  wdDocWindowHeight               = -32518; 
  wdDocWindowPosLeft              = -32442; 
  wdDocWindowPosTop               = -32443; 
  wdDocWindowWidth                = -32517; 
  wdDoFieldClick                  =    282;
  wdDOSToWinStr                   = -32516; 
  wdDottedUnderline               = -32461; 
  wdDoubleUnderline               = -32689; 
  wdDrawAlign                     = 634;
  wdDrawArc                       = 455;    
  wdDrawBringForward              = 500;    
  wdDrawBringInFrontOfText        = 469;    
  wdDrawBringToFront              = 466;    
  wdDrawCallout                   = 611;    
  wdDrawClearRange                = -32417; 
  wdDrawCount                     = -32416; 
  wdDrawCountPolyPoints           = -32410;
  wdDrawDisassemblePicture        = 575;    
  wdDrawEllipse                   = 454;    
  wdDrawExtendSelect              = -32414; 
  wdDrawFlipHorizontal            = 559;    
  wdDrawFlipVertical              = 560;    
  wdDrawFreeformPolygon           = 538;    
  wdDrawGetCalloutTextbox         = -32407; 
  wdDrawGetPolyPoints             = -32409; 
  wdDrawGetType                   = -32411; 
  wdDrawGroup                     = 465;    
  wdDrawInsertWordPicture         = 648;    
  wdDrawLine                      = 376;    
  wdDrawNudgeDown                 = 671;    
  wdDrawNudgeDownPixel            = 701;    
  wdDrawNudgeLeft                 = 672;    
  wdDrawNudgeLeftPixel            = 702;    
  wdDrawNudgeRight                = 673;    
  wdDrawNudgeRightPixel           = 703;    
  wdDrawNudgeUp                   = 670;    
  wdDrawNudgeUpPixel              = 700;    
  wdDrawRectangle                 = 377;    
  wdDrawResetWordPicture          = 696;    
  wdDrawReshape                   = 608;
  wdDrawRotateLeft                = 562;    
  wdDrawRotateRight               = 561;    
  wdDrawRoundRectangle            = 537;    
  wdDrawSelect                    = -32415; 
  wdDrawSelectNext                = 709;    
  wdDrawSelectPrevious            = 710;    
  wdDrawSendBackward              = 501;    
  wdDrawSendBehindText            = 468;    
  wdDrawSendToBack                = 467;    
  wdDrawSetCalloutTextbox         = -32406; 
  wdDrawSetInsertToAnchor         = -32412; 
  wdDrawSetInsertToTextbox        = -32413; 
  wdDrawSetPolyPoints             = -32408; 
  wdDrawSetRange                  = -32419; 
  wdDrawSnapToGrid                = 633;
  wdDrawTextbox                   = 363;    
  wdDrawUngroup                   = 485;    
  wdDrawUnselect                  = 708;    
  wdDropDownFormField             = 351;    
  wdDropListBox                   = -32440; 
  wdEditAutoText                  = 123;
  wdEditBookmark                  = 168;
  wdEditButtonImage               = -32364;
  wdEditClear                     = -32639; 
  wdEditConvertAllEndnotes        = 440;    
  wdEditConvertAllFootnotes       = 439;    
  wdEditConvertNotes              = 462;    
  wdEditCopy                      = 109;    
  wdEditCut                       = 108;    
  wdEditFind                      = 112;
  wdEditFindClearFormatting       = 116;    
  wdEditFindFont                  = 113;
  wdEditFindFound                 = -32553; 
  wdEditFindLang                  = 428;
  wdEditFindPara                  = 114;
  wdEditFindStyle                 = 115;
  wdEditGoTo                      = 122;
  wdEditLinks                     = 124;
  wdEditObject                    = 125;
  wdEditPaste                     = 110;    
  wdEditPasteSpecial              = 111;
  wdEditPicture                   = 296;    
  wdEditRedo                      = -32358; 
  wdEditRepeat                    = 68;     
  wdEditReplace                   = 117;
  wdEditReplaceClearFormatting    = 121;
  wdEditReplaceFont               = 118;
  wdEditReplaceLang               = 429;
  wdEditReplacePara               = 119;
  wdEditReplaceStyle              = 120;
  wdEditSelectAll                 = 237;    
  wdEditSwapAllNotes              = 441;    
  wdEditTOACategory               = 625;
  wdEditUndo                      = -32359; 
  wdEmptyBookmark                 = -32740; 
  wdEnableFormField               = -32431; 
  wdEndOfColumn                   = -32556; 
  wdEndOfDocument                 = -16367; 
  wdEndOfLine                     = -16371; 
  wdEndOfRow                      = -32558; 
  wdEndOfWindow                   = -16369; 
  wdEnvironStr                    = -32530; 
  wdEof                           = -32599; 
  wdExistingBookmark              = -32741; 
  wdExitWindows                   = -32555; 
  wdExtendMode                    = -32615; 
  wdExtendSelection               = -32616; 
  wdFieldSeparatorStr             = -32288; 
  wdFile1                         = -32637;
  wdFile2                         = -32636; 
  wdFile3                         = -32635; 
  wdFile4                         = -32634; 
  wdFile5                         = -32633; 
  wdFile6                         = -32632; 
  wdFile7                         = -32631; 
  wdFile8                         = -32630; 
  wdFile9                         = -32629; 
  wdFileClose                     = -32608; 
  wdFileCloseAll                  = -32438; 
  wdFileClosePicture              = 694;    
  wdFileConfirmConversions        = -32348; 
  wdFileExit                      = -32606; 
  wdFileFind                      = 99;
  wdFileList                      = -32638; 
  wdFileNameFromWindowStr         = -32429; 
  wdFileNameInfoStr               = -32371; 
  wdFileNameStr                   = -32731; 
  wdFileNew                       = 79;
  wdFileNewDefault                = 301;    
  wdFileOpen                      = 80;
  wdFilePageSetup                 = 178;
  wdFilePreview                   = -32459;
  wdFilePrint                     = 88;
  wdFilePrintDefault              = 302;    
  wdFilePrintPreview              = -32604; 
  wdFilePrintPreviewFullScreen    = 516;    
  wdFilePrintPreviewPages         = -32602; 
  wdFilePrintSetup                = 97;
  wdFileQuit                      = -32350; 
  wdFileRoutingSlip               = 624;
  wdFileSave                      = 83;     
  wdFileSaveAll                   = -32605; 
  wdFileSaveAs                    = 84;
  wdFileSendMail                  = 613;    
  wdFilesStr                      = -32607; 
  wdFileSummaryInfo               = 86;
  wdFileTemplates                 = 87;
  wdFont                          = -32644; 
  wdFontSize                      = -32643; 
  wdFontSizeSelect                = 43;     
  wdFontStr                       = -32646; 
  wdFontSubstitution              = 581;
  wdFormatAddrFonts               = 103;
  wdFormatAutoFormat              = 385;    
  wdFormatBordersAndShading       = 189;
  wdFormatBullet                  = 389;
  wdFormatBulletDefault           = -32390; 
  wdFormatBulletsAndNumbering     = 397;
  wdFormatCallout                 = 610;
  wdFormatChangeCase              = 322;
  wdFormatColumns                 = 177;
  wdFormatDefineStyleBorders      = 185;
  wdFormatDefineStyleFont         = 181;
  wdFormatDefineStyleFrame        = 184;
  wdFormatDefineStyleLang         = 186;
  wdFormatDefineStyleNumbers      = 602;
  wdFormatDefineStylePara         = 182;
  wdFormatDefineStyleTabs         = 183;
  wdFormatDrawingObject           = 565;
  wdFormatDropCap                 = 488;
  wdFormatFont                    = 174;
  wdFormatFrame                   = 190;
  wdFormatHeaderFooterLink        = 242;    
  wdFormatHeadingNumber           = 606;
  wdFormatHeadingNumbering        = 603;
  wdFormatMultilevel              = 391;
  wdFormatNumber                  = 390;
  wdFormatNumberDefault           = -32389;
  wdFormatPageNumber              = 298;
  wdFormatParagraph               = 175;
  wdFormatPicture                 = 187;
  wdFormatRetAddrFonts            = 221;
  wdFormatSectionLayout           = 176;
  wdFormatStyle                   = 180;
  wdFormatStyleGallery            = 505;
  wdFormatTabs                    = 179;
  wdFormFieldOptions              = 353;
  wdFormShading                   = -32298; 
  wdFoundFileNameStr              = -32582; 
  wdGetAddInId                    = -32384; 
  wdGetAddInNameStr               = -32391; 
  wdGetAttr                       = -32497; 
  wdGetAutoCorrectStr             = -32352; 
  wdGetAutoTextStr                = -32729; 
  wdGetBookmarkStr                = -32746; 
  wdGetDirectoryStr               = -32535; 
  wdGetDocumentVarNameStr         = -32343; 
  wdGetDocumentVarStr             = -32435; 
  wdGetFieldDataStr               = -32427; 
  wdGetFormResult                 = -32297; 
  wdGetFormResultStr              = -32433;
  wdGetHwnd                       = -32287; 
  wdGetInst                       = -32385; 
  wdGetMergeFieldStr              = -32347; 
  wdGetPrivateProfileStringStr    = -32499; 
  wdGetProfileStringStr           = -32699; 
  wdGetSelEndPos                  = -32400; 
  wdGetSelStartPos                = -32401; 
  wdGetSystemInfo                 = -32506; 
  wdGetSystemInfoStr              = -32500; 
  wdGetTextStr                    = -32398; 
  wdGoBack                        = 69;     
  wdGotoAnnotationScope           = 597;    
  wdGoToHeaderFooter              = 590;    
  wdGoToNextAnnotation            = 412;    
  wdGoToNextEndnote               = 410;    
  wdGoToNextFootnote              = 408;    
  wdGoToNextPage                  = 404;    
  wdGoToNextSection               = 406;    
  wdGoToNextSubdocument           = -32303; 
  wdGoToPreviousAnnotation        = 413;    
  wdGoToPreviousEndnote           = 411;    
  wdGoToPreviousFootnote          = 409;    
  wdGoToPreviousPage              = 405;
  wdGoToPreviousSection           = 407;    
  wdGoToPreviousSubdocument       = -32302; 
  wdGroupBox                      = -32566; 
  wdGrowFont                      = 11;     
  wdGrowFontOnePoint              = 513;    
  wdHangingIndent                 = 40;     
  wdHelp                          = 1;      
  wdHelpAbout                     = 9;
  wdHelpActiveWindow              = 4;      
  wdHelpContents                  = 688;    
  wdHelpExamplesAndDemos          = 8;      
  wdHelpIndex                     = 6;      
  wdHelpKeyboard                  = 5;      
  wdHelpPSSHelp                   = 360;    
  wdHelpQuickPreview              = 7;      
  wdHelpSearch                    = 510;    
  wdHelpTipOfTheDay               = 635;
  wdHelpTool                      = 2;      
  wdHelpUsingHelp                 = 3;      
  wdHelpWordPerfectHelp           = 10;
  wdHelpWordPerfectHelpOptions    = 511;
  wdHidden                        = -32691; 
  wdHLine                         = -32715;
  wdHour                          = -32524; 
  wdHPage                         = -32713; 
  wdHScroll                       = -32711; 
  wdIconBarMode                   = 238;    
  wdIndent                        = 38;     
  wdInputBoxStr                   = -32591; 
  wdInputStr                      = -32601; 
  wdInsert                        = -32750; 
  wdInsertAddCaption              = 402;
  wdInsertAnnotation              = 161;    
  wdInsertAutoCaption             = 359;
  wdInsertAutoText                = 20;     
  wdInsertBreak                   = 159;
  wdInsertCaption                 = 357;
  wdInsertCaptionNumbering        = 358;
  wdInsertChart                   = 285;    
  wdInsertColumnBreak             = 278;    
  wdInsertCrossReference          = 367;
  wdInsertDatabase                = 341;
  wdInsertDateField               = 240;    
  wdInsertDateTime                = 165;
  wdInsertDrawing                 = 284;    
  wdInsertEquation                = 683;
  wdInsertExcelTable              = 567;    
  wdInsertField                   = 166;
  wdInsertFieldChars              = 31;     
  wdInsertFile                    = 164;
  wdInsertFootnote                = 370;
  wdInsertFormField               = 483;
  wdInsertFrame                   = 158;    
  wdInsertIndex                   = 170;
  wdInsertMergeField              = 167;
  wdInsertObject                  = 172;
  wdInsertPageBreak               = 277;    
  wdInsertPageField               = 239;    
  wdInsertPageNumbers             = 294;
  wdInsertPara                    = -32749; 
  wdInsertPicture                 = 163;
  wdInsertSectionBreak            = 707;    
  wdInsertSound                   = 519;    
  wdInsertSpike                   = 16;     
  wdInsertSubdocument             = 583;
  wdInsertSymbol                  = 162;
  wdInsertTableOfAuthorities      = 471;
  wdInsertTableOfContents         = 171;
  wdInsertTableOfFigures          = 472;
  wdInsertTimeField               = 241;    
  wdInsertWordArt                 = 682;    
  wdInStr                         = -32753; 
  wdInt                           = -32766; 
  wdIsDocumentDirty               = -32733; 
  wdIsExecuteOnly                 = -32573; 
  wdIsMacro                       = -32430; 
  wdIsTemplateDirty               = -32488; 
  wdItalic                        = -32695; 
  wdJustifyPara                   = -32682; 
  wdKeyCode                       = -32576; 
  wdKeyMacroStr                   = -32575; 
  wdKill                          = -32597; 
  wdLanguage                      = -32640; 
  wdLanguageStr                   = -32642; 
  wdLCaseStr                      = -32592; 
  wdLeftPara                      = -32684; 
  wdLeftStr                       = -32760; 
  wdLen                           = -32765; 
  wdLineDown                      = -16375; 
  wdLineUp                        = -16376; 
  wdListBox                       = -32550; 
  wdLockDocument                  = -32304;
  wdLockFields                    = 35;     
  wdLof                           = -32598; 
  wdLTrimStr                      = -32534; 
  wdMacroCopy                     = -32574; 
  wdMacroDescStr                  = -32578; 
  wdMacroFileNameStr              = -32370; 
  wdMacroNameFromWindowStr        = -32428; 
  wdMacroNameStr                  = -32584; 
  wdMagnifier                     = -32405; 
  wdMailMerge                     = 676;
  wdMailMergeAskToConvertChevrons = -32424; 
  wdMailMergeCheck                = 677;
  wdMailMergeConvertChevrons      = -32425; 
  wdMailMergeCreateDataSource     = 642;
  wdMailMergeCreateHeaderSource   = 643;
  wdMailMergeDataForm             = 340;
  wdMailMergeDataSourceStr        = -32492; 
  wdMailMergeEditDataSource       = 104;    
  wdMailMergeEditHeaderSource     = 675;    
  wdMailMergeEditMainDocument     = 219;    
  wdMailMergeFindRecord           = 569;
  wdMailMergeFirstRecord          = 480;    
  wdMailMergeFoundRecord          = -32345;
  wdMailMergeGoToRecord           = -32455; 
  wdMailMergeHelper               = 680;
  wdMailMergeInsertAsk            = 4047;
  wdMailMergeInsertFillIn         = 4048;
  wdMailMergeInsertIf             = 4049;
  wdMailMergeInsertMergeRec       = 4050;   
  wdMailMergeInsertMergeSeq       = 4051;   
  wdMailMergeInsertNext           = 4052;   
  wdMailMergeInsertNextIf         = 4053;
  wdMailMergeInsertSet            = 4054;
  wdMailMergeInsertSkipIf         = 4055;
  wdMailMergeLastRecord           = 481;    
  wdMailMergeListWordFields       = 568;    
  wdMailMergeMainDocumentType     = -32472; 
  wdMailMergeNextRecord           = 478;    
  wdMailMergeOpenDataSource       = 81;
  wdMailMergeOpenHeaderSource     = 82;
  wdMailMergePrevRecord           = 479;    
  wdMailMergeQueryOptions         = 681;
  wdMailMergeReset                = 96;     
  wdMailMergeState                = -32491; 
  wdMailMergeToDoc                = 678;    
  wdMailMergeToPrinter            = 679;
  wdMailMergeViewData             = -32377; 
  wdMarkCitation                  = 463;
  wdMarkIndexEntry                = 169;
  wdMarkTableOfContentsEntry      = 442;
  wdMenuItemMacroStr              = -32450; 
  wdMenuItemTextStr               = -32451; 
  wdMenuMode                      = 293;    
  wdMenuTextStr                   = -32448; 
  wdMergeFieldNameStr             = -32736; 
  wdMergeSubdocument              = 584;    
  wdMicrosoftAccess               = 658;    
  wdMicrosoftExcel                = 657;    
  wdMicrosoftFoxPro               = 660;    
  wdMicrosoftMail                 = 656;    
  wdMicrosoftPowerPoint           = 661;    
  wdMicrosoftProject              = 663;    
  wdMicrosoftPublisher            = 662;    
  wdMicrosoftSchedule             = 659;    
  wdMicrosoftSystemInfo           = 711;    
  wdMidStr                        = -32758; 
  wdMinute                        = -32523; 
  wdMkDir                         = -32595; 
  wdMonth                         = -32522;
  wdMoveButton                    = -32397; 
  wdMoveText                      = 18;     
  wdMoveToolbar                   = -32421; 
  wdMsgBox                        = -32725; 
  wdNewToolbar                    = 586;
  wdNextCell                      = -32561; 
  wdNextField                     = -32563; 
  wdNextObject                    = -32618; 
  wdNextPage                      = -32620; 
  wdNextTab                       = -32612; 
  wdNextWindow                    = 22;     
  wdNormalFontPosition            = 572;    
  wdNormalFontSpacing             = 571;    
  wdNormalStyle                   = 248;    
  wdNormalViewHeaderArea          = 155;
  wdNoteOptions                   = 373;
  wdNow                           = -32521; 
  wdOK                            = 71;     
  wdOKButton                      = -32569; 
  wdOnTime                        = -32589; 
  wdOpenSubdocument               = 599;    
  wdOpenUpPara                    = -32678; 
  wdOptionButton                  = -32565;
  wdOptionGroup                   = -32549; 
  wdOrganizer                     = 222;
  wdOtherPane                     = 21;     
  wdOutlineCollapse               = 250;    
  wdOutlineDemote                 = 245;    
  wdOutlineExpand                 = 249;    
  wdOutlineLevel                  = -32613; 
  wdOutlineMoveDown               = 247;    
  wdOutlineMoveUp                 = 246;    
  wdOutlinePromote                = 244;    
  wdOutlineShowFirstLine          = -32648; 
  wdOutlineShowFormat             = 262;    
  wdOvertype                      = -32647; 
  wdPageDown                      = -16373; 
  wdPageUp                        = -16374; 
  wdParaDown                      = -16377; 
  wdParaKeepLinesTogether         = -32666; 
  wdParaKeepWithNext              = -32665; 
  wdParaPageBreakBefore           = -32663; 
  wdParaUp                        = -16378; 
  wdParaWidowOrphanControl        = -32662; 
  wdPasteButtonImage              = -32367; 
  wdPasteFormat                   = 486;
  wdPathFromMacPathStr            = -32339; 
  wdPathFromWinPathStr            = -32340; 
  wdPauseRecorder                 = 216;    
  wdPicture                       = -32475; 
  wdPrevCell                      = -32560; 
  wdPrevField                     = -32562; 
  wdPrevObject                    = -32617; 
  wdPrevPage                      = -32619; 
  wdPrevTab                       = -32611; 
  wdPrevWindow                    = 23;     
  wdPrint                         = -32342; 
  wdPromoteList                   = 591;    
  wdPushButton                    = -32564; 
  wdPutFieldData                  = -32426; 
  wdRemoveAllDropDownItems        = -32299; 
  wdRemoveBulletsNumbers          = 522;    
  wdRemoveDropDownItem            = -32375; 
  wdRemoveFrames                  = 292;    
  wdRemoveSubdocument             = 639;    
  wdRenameMenu                    = -32439; 
  wdRepeatFind                    = 24;     
  wdResetButtonImage              = -32388; 
  wdResetChar                     = -32722;
  wdResetNoteSepOrNotice          = 388;    
  wdResetPara                     = -32721; 
  wdRightPara                     = -32683; 
  wdRightStr                      = -32759; 
  wdRmDir                         = -32594; 
  wdRnd                           = -32754; 
  wdRTrimStr                      = -32533; 
  wdRunPrintManager               = 684;    
  wdSaveTemplate                  = 70;     
  wdScreenRefresh                 = 665;    
  wdScreenUpdating                = -32495; 
  wdSecond                        = -32513; 
  wdSeek                          = -32600; 
  wdSelectCurAlignment            = 287;    
  wdSelectCurColor                = 291;    
  wdSelectCurFont                 = 286;    
  wdSelectCurIndent               = 289;    
  wdSelectCurSentence             = -32489; 
  wdSelectCurSpacing              = 288;    
  wdSelectCurTabs                 = 290;    
  wdSelectCurWord                 = -32490; 
  wdSelectDrawingObjects          = 545;    
  wdSelectionFileNameStr          = -32301;
  wdSelectionStr                  = -32747; 
  wdSelInfo                       = -32586; 
  wdSelType                       = -32614; 
  wdSendKeys                      = -32668; 
  wdSentLeft                      = -16380; 
  wdSentRight                     = -16379; 
  wdSetAttr                       = -32509; 
  wdSetAutoText                   = -32726; 
  wdSetDocumentDirty              = -32732; 
  wdSetDocumentVar                = -32436; 
  wdSetEndOfBookmark              = -32742; 
  wdSetFormResult                 = -32432; 
  wdSetPrivateProfileString       = -32498; 
  wdSetProfileString              = -32698; 
  wdSetSelRange                   = -32399; 
  wdSetStartOfBookmark            = -32743; 
  wdSetTemplateDirty              = -32487; 
  wdSgn                           = -32767; 
  wdShadingPattern                = -32452; 
  wdShell                         = -32723; 
  wdShowAll                       = -32752; 
  wdShowAllHeadings               = 260;    
  wdShowAnnotationBy              = -32510;
  wdShowHeading1                  = 251;    
  wdShowHeading2                  = 252;    
  wdShowHeading3                  = 253;    
  wdShowHeading4                  = 254;    
  wdShowHeading5                  = 255;    
  wdShowHeading6                  = 256;    
  wdShowHeading7                  = 257;    
  wdShowHeading8                  = 258;    
  wdShowHeading9                  = 259;    
  wdShowNextHeaderFooter          = 589;    
  wdShowPrevHeaderFooter          = 588;    
  wdShowVars                      = 263;    
  wdShrinkFont                    = 12;     
  wdShrinkFontOnePoint            = 514;    
  wdShrinkSelection               = 236;    
  wdSizeToolbar                   = -32420; 
  wdSkipNumbering                 = -32386; 
  wdSmallCaps                     = -32694; 
  wdSortArray                     = -32437; 
  wdSpacePara1                    = -32681; 
  wdSpacePara15                   = -32680; 
  wdSpacePara2                    = -32679; 
  wdSpike                         = 15;
  wdSplitSubdocument              = 585;    
  wdStartOfColumn                 = -32557; 
  wdStartOfDocument               = -16368; 
  wdStartOfLine                   = -16372; 
  wdStartOfRow                    = -32559; 
  wdStartOfWindow                 = -16370; 
  wdStop                          = -32441; 
  wdStrikethrough                 = -32692; 
  wdStringStr                     = -32757; 
  wdStrStr                        = -32761; 
  wdStyle                         = -32493; 
  wdStyleDescStr                  = -32667; 
  wdStyleNameStr                  = -32734; 
  wdSubscript                     = -32686; 
  wdSuperscript                   = -32687; 
  wdSymbolFont                    = -32300; 
  wdTabLeaderStr                  = -32719; 
  wdTableAutoFormat               = 563;
  wdTableAutoSum                  = 641;
  wdTableColumnWidth              = 143;
  wdTableDeleteCells              = 133;
  wdTableDeleteColumn             = 135;    
  wdTableDeleteRow                = 134;
  wdTableFormula                  = 348;
  wdTableGridlines                = -32649; 
  wdTableHeadings                 = -32373; 
  wdTableInsertCells              = 130;
  wdTableInsertColumn             = 132;    
  wdTableInsertRow                = 131;
  wdTableInsertTable              = 129;
  wdTableMergeCells               = 136;    
  wdTableRowHeight                = 142;
  wdTableSelectColumn             = 141;    
  wdTableSelectRow                = 140;    
  wdTableSelectTable              = 139;    
  wdTableSort                     = 199;
  wdTableSortAToZ                 = 393;    
  wdTableSortZToA                 = 394;    
  wdTableSplit                    = 138;    
  wdTableSplitCells               = 137;
  wdTableToText                   = 128;
  wdTableUpdateAutoFormat         = 626;    
  wdTabType                       = -32720; 
  wdText                          = -32567; 
  wdTextBox                       = -32551; 
  wdTextFormField                 = 349;
  wdTextToTable                   = 127;
  wdTimeSerial                    = -32514; 
  wdTimeStr                       = -32755; 
  wdTimeValue                     = -32512; 
  wdToday                         = -32511; 
  wdToggleFieldDisplay            = 34;     
  wdToggleFull                    = 582;    
  wdToggleHeaderFooterLink        = 652;    
  wdToggleMainTextLayer           = 587;    
  wdTogglePortrait                = 306;
  wdToggleScribbleMode            = 308;    
  wdToolbarButtonMacroStr         = -32294; 
  wdToolbarNameStr                = -32362; 
  wdToolbarState                  = -32296; 
  wdToolsAddRecordDefault         = 629;    
  wdToolsAdvancedSettings         = 206;
  wdToolsAutoCorrect              = 378;
  wdToolsAutoCorrectDays          = -32353; 
  wdToolsAutoCorrectInitialCaps   = -32355; 
  wdToolsAutoCorrectReplaceText   = -32356; 
  wdToolsAutoCorrectSentenceCaps  = -32354; 
  wdToolsAutoCorrectSmartQuotes   = -32486; 
  wdToolsBulletListDefault        = 307;
  wdToolsBulletsNumbers           = 196;
  wdToolsCalculate                = -32547; 
  wdToolsCompareVersions          = 198;
  wdToolsCreateEnvelope           = 173;
  wdToolsCreateLabels             = 489;
  wdToolsCustomize                = 152;
  wdToolsCustomizeKeyboard        = 432;
  wdToolsCustomizeMenuBar         = 615;
  wdToolsCustomizeMenus           = 433;
  wdToolsEnvelopesAndLabels       = 607;
  wdToolsGetSpelling              = -32624; 
  wdToolsGetSynonyms              = -32623; 
  wdToolsGrammar                  = 193;    
  wdToolsGrammarStatisticsArray   = -32460; 
  wdToolsHyphenation              = 195;
  wdToolsHyphenationManual        = 704;    
  wdToolsLanguage                 = 188;
  wdToolsMacro                    = 215;
  wdToolsManageFields             = 631;
  wdToolsMergeRevisions           = 435;
  wdToolsNumberListDefault        = 309;    
  wdToolsOptions                  = 202;
  wdToolsOptionsAutoFormat        = 365;
  wdToolsOptionsCompatibility     = 525;
  wdToolsOptionsEdit              = 224;
  wdToolsOptionsFileLocations     = 225;
  wdToolsOptionsGeneral           = 203;
  wdToolsOptionsGrammar           = 212;
  wdToolsOptionsPrint             = 208;
  wdToolsOptionsRevisions         = 386;
  wdToolsOptionsSave              = 209;
  wdToolsOptionsSpelling          = 211;
  wdToolsOptionsUserInfo          = 213;
  wdToolsOptionsView              = 204;
  wdToolsProtectDocument          = 503;
  wdToolsProtectSection           = 578;
  wdToolsRemoveRecordDefault      = 630;    
  wdToolsRepaginate               = 201;    
  wdToolsReviewRevisions          = 506;
  wdToolsRevisionAuthorStr        = -32379; 
  wdToolsRevisionDate             = -32378; 
  wdToolsRevisionDateStr          = -32374; 
  wdToolsRevisions                = 197;
  wdToolsRevisionType             = -32380; 
  wdToolsShrinkToFit              = 504;    
  wdToolsSpelling                 = 191;
  wdToolsSpellSelection           = 192;    
  wdToolsThesaurus                = 194;    
  wdToolsUnprotectDocument        = 521;    
  wdToolsWordCount                = 228;    
  wdUCaseStr                      = -32593; 
  wdUnderline                     = -32690; 
  wdUnHang                        = 41;     
  wdUnIndent                      = 39;     
  wdUnlinkFields                  = 33;     
  wdUnlockFields                  = 36;     
  wdUpdateFields                  = 32;     
  wdUpdateSource                  = 37;     
  wdUserDialog                    = 297;    
  wdVal                           = -32762; 
  wdViewAnnotations               = -32660; 
  wdViewBorderToolbar             = 604;    
  wdViewDraft                     = -32658; 
  wdViewDrawingToolbar            = 605;    
  wdViewEndnoteArea               = -32476; 
  wdViewEndnoteContNotice         = 498;    
  wdViewEndnoteContSeparator      = 497;    
  wdViewEndnoteSeparator          = 496;    
  wdViewFieldCodes                = -32659;
  wdViewFooter                    = -32368; 
  wdViewFootnoteArea              = -32351; 
  wdViewFootnoteContNotice        = 495;    
  wdViewFootnoteContSeparator     = 494;    
  wdViewFootnotes                 = -32661; 
  wdViewFootnoteSeparator         = 493;    
  wdViewHeader                    = -32369; 
  wdViewMasterDocument            = -32357; 
  wdViewMenus                     = -32650; 
  wdViewNormal                    = -32651; 
  wdViewOutline                   = -32652; 
  wdViewPage                      = -32653; 
  wdViewRibbon                    = -32655; 
  wdViewRuler                     = -32656; 
  wdViewStatusBar                 = -32657; 
  wdViewToggleMasterDocument      = 632;    
  wdViewToolbar                   = -32654; 
  wdViewToolbars                  = 323;    
  wdViewZoom                      = 577;    
  wdViewZoom100                   = 305;    
  wdViewZoom200                   = 573;    
  wdViewZoom75                    = 574;    
  wdViewZoomPageWidth             = 304;
  wdViewZoomWholePage             = 303;    
  wdVLine                         = -32716; 
  wdVPage                         = -32714; 
  wdVScroll                       = -32712; 
  wdWaitCursor                    = -32529; 
  wdWeekday                       = -32520; 
  wdWindow                        = -32706;
  wdWindow1                       = -32545; 
  wdWindow2                       = -32544; 
  wdWindow3                       = -32543; 
  wdWindow4                       = -32542; 
  wdWindow5                       = -32541; 
  wdWindow6                       = -32540; 
  wdWindow7                       = -32539; 
  wdWindow8                       = -32538; 
  wdWindow9                       = -32537; 
  wdWindowArrangeAll              = 218;    
  wdWindowList                    = -32546; 
  wdWindowNameStr                 = -32709; 
  wdWindowNewWindow               = 217;    
  wdWindowPane                    = -32708; 
  wdWinToDOSStr                   = -32515; 
  wdWordLeft                      = -16382;
  wdWordRight                     = -16381; 
  wdWordUnderline                 = -32688; 
  wdYear                          = -32519; 

{*************************** Word Error Codes ********************************}

  errIllegalFunctionCall   =  5;
  errOverflow              =  6;
  errOutOfMemory           =  7;
  errSubscriptOutOfRange   =  9;
  errDivisionByZero        = 11;
  errOutOfStringSpace      = 14;
  errCaseElseExpected      = 39;
  errInternalError         = 51;
  errBadFileNameOrNumber   = 52;
  errFileNotFound          = 53;
  errBadFileMode           = 54;
  errFileAlreadyOpen       = 55;
  errDeviceIOError         = 57;
  errInputPastEndOfFile    = 62;
  errBadFileName           = 64;
  errTooManyFiles          = 67;
  errAdvFeatureUnavail     = 73;
  errRenameAcrossDisks     = 74;
  errPathFileAccessError   = 75;
  errPathNotFound          = 76;
  errBadArrayBound         = 22;
  errCannotWriteDisk       = 23;
  errBadParam              = 24;
  errOutOfStack            = 25;
  errUDlgNoButton          = 26;
  errNoResume              = 27;
  errDirExists             = 28;
  errSyntaxError          = 100;
  errCommaMissing         = 101;
  errCommandFailed        = 102;
  errDlgRecVarExpected    = 103;
  errElseWithoutIf        = 104;
  errEndIfWithoutIf       = 105;
  errInputMissing         = 109;
  errNoResumeNext         = 110;
  errExpressionTooComplex = 111;
  errIdentifierExpected   = 112;
  errDuplicateLabel       = 113;
  errLabelNotFound        = 114;
  errMissingRightParen    = 115;
  errArgCountMismatch     = 116;
  errMissingNextOrWend    = 117;
  errNestedSubOrFunc      = 118;
  errNextWithoutFor       = 119;
  errArrayAlreadyDimed    = 120;
  errTypeMismatch         = 122;
  errUndefDlgRecField     = 123;
  errSubprogNotDefined    = 124;
  errUnexpectedEndOfMacro = 125;
  errWendWithoutWhile     = 126;
  errWrongNumOfDimensions = 127;
  errTooManyCtrlStructs   = 129;
  errMissingEndSelect     = 130;
  errIllegalRedim         = 131;
  errDllMadeStringTooLong = 132;
  errBadDllCall           = 133;
  errBadDate              = 134;
  errNotOnThisPlatform    = 135;
  errCmdNotOnThisPlatform = 136;
  errInvalidPathOpt       = 137;
  errCantChangeSel        = 138;
  errUserDlgUp            = 139;
  errInvalDlgControlId    = 140;
  errUnavailableOnCtl     = 141;
  errBadAppName           = 142;
  errInvalDlgHideDisable  = 143;
  errInvalDlgFocus        = 144;
  errInvalMergeField      = 145;
  errNoMergeField         = 146;
  errInternalStringError  = 147;
  errAppMaximized         = 148;
  errCommandNotFunction   = 149;
  errDuplDlgControlId     = 150;
  errDocMaximized         = 151;
  errNoDocOpen            = 152;
  errDocMinimized         = 153;
  errAppMinimized         = 154;
  errNotInField           = 155;
  errFieldHasNoData       = 156;
  errNotDataField         = 157;
  errParamTooLow          = 158;
  errParamTooHigh         = 159 ;
  errWrongNumOfParams     = 160 ;
  errCantCallDlg          = 161 ;
  errCommandOnlyFunction  = 162  ;
  errDlgActiveOnly        = 163   ;
  errArrayNotDimed        = 164   ;
  errCannotInitiate       = 500   ;
  errBogusDcl             = 501   ;
  errNoResponse           = 502;
  errAppNacked            = 503;
  errNoSuchWin            = 504;
  errCantActivate         = 505;
  errCannotSendKeys       = 506;
  errAppBusyed            = 508;
  errModeError            = 509;
  errNoMacro              = 511;
  errOutOfRange           = 512;
  errStringTooBig         = 513;
  errDocNotOpen           = 514;
  errUnableToLoadSpeller  = 528;
  errCannotOpenDictionary = 529;
  errDlgBoxTooComplex     = 530;
  errUnknownLoc           = 532;
  errNoWordkey            = 534;
  errMacroAlreadyRunning  = 535;
  errBadMacroName         = 536;
  errCantRun              = 537;
  errCantEdit             = 538;
  errCantRename           = 539;
  errCantDelete           = 540;
  errCantSetDesc          = 541;
  errCantEditDesc         = 542;
  errCantFindLib          = 543;
  errNoScrollBar          = 544;
  errStatementDisabled    = 545;
  errFtnEdnNotContinuous  = 546;
  errNoNetPerm            = 547;
  errMenuDoesntExist      = 549;
  errCantRecord           = 550;
  errGlsyDocLocked        = 551;
  errNoTemplate           = 552;
  errCantCreate           = 553;
  errNoDrawingRangeSet    = 554;
  errInvalidDrawingRangeBookmark = 555;
  errWrongDrawnObjectType = 556;
  errCouldntInsertDO      = 557;
  errChapterLock          = 558;
  errBlockSel             = 559;
  errRevisionsHidden      = 560;
  errProtectedDoc         = 561;
  errGramStatsMultLang    = 562;
  errNotMaster            = 563;
  errGotoInvalid          = 564;
  errNotAnAddInFile       = 565;
  errFileInUse            = 566;
  errListMaxReached       = 567;
  errFontNotExist         = 568;
  errFindSearchType       = 569;
  errSortArrayDim         = 570;
  errTooManyAccelKey      = 571;
  errIllegalFirstAccel    = 572;
  errIllegalSecondAccel   = 573;
  errCAPINoError             =  0;       { No error                                }
  errWLLNoWordFound          =  5000;    { I added this }
  errCAPIBadCommandId        =  5001;    { Command Id is invalid                   }
  errCAPIOddParamBlock       =  5002;    { parameter block has odd number of bytes }
  errCAPICmdNotAvailable     =  5003;    { command is not available                }
  errCAPIBadArgCount         =  5004;    { too many or too few arguments           }
  errCAPIInternalError       =  5005;    { error in our own data or handling       }
  errCAPIByteCountMismatch   =  5006;    { pb doesn't have acceptable # of bytes  }
  errCAPINotFunction         =  5007;    { non function called as function        }
  errCAPIBadType             =  5008;    { parameter type passed or expected is wrong }
  errCAPIStringTooLong       =  5009;    { string is longer than 255 characters       }
  errCAPINullReturnBuffer    =  5010;    { pointer for output is Nil                  }
  errCAPICantLock            =  5011;    { can't lock global handle                   }
  errCAPICantAllocate        =  5012;    { can't allocate global handle               }
  errCAPINoDialog            =  5013;    { commmand has no dialog                     }
  errCAPIOutOfMemory         =  5014;    { CAPI is out of memory                     }
  errCAPIFieldIdOutOfRange   =  5015;    { too many parameters passed to function }
  errCAPIBadFieldId          =  5016;    { Field Id not in Dialog                 }
  errCAPIBadHandle           =  5017;    { Handle has not been allocated          }
  errCAPIArrayExpected       =  5018;    { parameter takes an array only          }
  errCAPITooManyDimensions   =  5019;    { too many dimesions for array           }
  errCAPIExpectedNumericType =  5020;    { parameter passed was not a short long or num}
  errCAPIExpectedStringType  =  5021;    { parameter passed was not a string           }
  errCAPIParameterOutOfRange =  5022;    { parameter value was out of acceptable range }
  errCAPICantReturnString    =  5023;    { String Type requested for numeric only field}
  errCAPICantReturnNumeric   =  5024;    { Numeric Type requested for string only field}
  errCAPIReturnOverflow      =  5025;    { Buffer for return string is too small}
  errCAPIArrayOverflow       =  5026;    { Array string buffer is too small    }
  errCAPIDlgCommandOverflow  =  5027;    { Dialog command string buffer too small}
  errCAPIOverflowNotHandled  =  5028;    { BufferTooSmall bit set on input      }
  errCAPICantParse           =  5029;    { String Passed can't be parsed        }
  errCAPIBadMessage          =  5030;    { Bad pointer in message (CMI)         }
  errCAPICommandFailed       =  5031;    { CAPI command failed                  }
  errCAPIBadDocRef           =  5032;    { Document Reference Number is Invalid}
  errCAPIInsufficientStack   =  5033;   { Minimum Stack not available         }
  errCAPIUninitializedString =  5034;    { 0 was passed as string pointer    }

{ turn the errors around }

function errorDesc(i:integer):shortstring;

const
{****************************** Word Field codes *****************************}

  fidAccent                  = 902;
  fidAcceptAll               = 728;
  fidAcceptRevisions         = 211;
  fidActivateAs              = 934;
  fidAdd                     = 152;
  fidAddBelow                = 665;
  fidAddedStyles             = 656;
  fidAddRecipient            = 892;
  fidAddress                 = 491;
  fidAddrFromLeft            = 832;
  fidAddrFromTop             = 833;
  fidAddSlip                 = 894;
  fidAddToDictionary         = 153;
  fidAddToDocument           = 517;
  fidAddToMru                = 597;
  fidAddToTemplate           = 95;
  fidAdjustEmptyParas        = 903;
  fidAdjustParaMarks         = 862;
  fidAdjustTabsSpaces        = 863;
  fidAfter                   = 165;
  fidAlign                   = 251;
  fidAlignment               = 160;
  fidAlignRows               = 280;
  fidAllAtOnce               = 813;
  fidAllCaps                 = 315;
  fidAllowAccentedUppercase  = 927;
  fidAllowRowSplit           = 708;
  fidAlways                  = 397;
  fidAlwaysSuggest           = 240;
  fidAnchors                 = 247;
  fidAndOr1                  = 567;
  fidAndOr2                  = 568;
  fidAndOr3                  = 569;
  fidAndOr4                  = 570;
  fidAndOr5                  = 571;
  fidAngle                   = 784;
  fidAnnotations             = 193;
  fidAPPCOPYRIGHT            = 85;
  fidAppendPrFile            = 643;
  fidApplication             = 467;
  fidApply                   = 401;
  fidApplyColsTo             = 469;
  fidApplyPropsTo            = 463;
  fidApplyStylesBodyText     = 860;
  fidApplyStylesHeadings     = 858;
  fidApplyStylesLists        = 859;
  fidApplyStylesOtherParas   = 861;
  fidApplyTo                 = 281;
  fidAPPNAME                 = 25;
  fidAppName_2               = 340;
  fidAPPORGANIZATION         = 10;
  fidAPPSERIALNUMBER         = 86;
  fidAPPUSERNAME             = 9;
  fidAPPVERSION              = 26;
  fidArrowLength             = 822;
  fidArrowStyle              = 824;
  fidArrowWidth              = 823;
  fidAskOnce                 = 882;
  fidAssign                  = 5;
  fidAttach                  = 666;
  fidAttributeControls       = 462;
  fidAuthor                  = 100;
  fidAutoAttach              = 901;
  fidAutoCaption             = 636;
  fidAutoCorrectInitialCaps  = 625;
  fidAutoCorrectTyping       = 259;
  fidAutoDelete              = 56;
  fidAutoExpand              = 241;
  fidAutoFit                 = 387;
  fidAutoHyphenation         = 804;
  fidAutoMark                = 886;
  fidAutoSave                = 52;
  fidAutoUpdate              = 307;
  fidAutoWordSelection       = 761;
  fidBackground              = 424;
  fidBackgroundSpellChecking = 260;
  fidBasedOn                 = 123;
  fidBefore                  = 164;
  fidBlankLines              = 486;
  fidBlueScreen              = 880;
  fidBold                    = 36;
  fidBookMarks               = 800;
  fidBorder                  = 170;
  fidBorders                 = 770;
  fidBordShadThinBlack       = 914;
  fidBottomBorder            = 276;
  fidBottomColor             = 357;
  fidBottomMargin            = 74;
  fidBottomWidth             = 363;
  fidBreadth                 = 572;
  fidButton                  = 436;
  fidButtonFieldClicks       = 32;
  fidCalc1                   = 301;
  fidCannotFind              = 92;
  fidCaps                    = 38;
  fidCaption                 = 654;
  fidCaseSensitive           = 234;
  fidCategory                = 328;
  fidCategoryName            = 917;
  fidChange                  = 151;
  fidChangeAll               = 348;
  fidChangeTo                = 131;
  fidChapterNumber           = 809;
  fidCharacter               = 30;
  fidCharacters              = 542;
  fidCharNum                 = 388;
  fidCharPosition            = 316;
  fidCharSpace               = 317;
  fidCheckDefault            = 856;
  fidCheckErrors             = 680;
  fidCheckSize               = 854;
  fidCheckSpelling           = 675;
  fidCheckWidth              = 855;
  fidClass                   = 474;
  fidClear                   = 253;
  fidClearAll                = 254;
  fidClearRecipients         = 891;
  fidClearRouteSlip          = 829;
  fidClearSlip               = 896;
  fidCollate                 = 433;
  fidColLine                 = 220;
  fidColor                   = 35;
  fidColorButtons            = 764;
  fidColumn                  = 309;
  fidColumnNo                = 606;
  fidColumns                 = 218;
  fidColumnSpacing           = 219;
  fidColumnWidth             = 236;
  fidCommandKeyHelp          = 723;
  fidCommandValue            = 749;
  fidComments                = 102;
  fidCompany                 = 492;
  fidComparedTo1             = 554;
  fidComparedTo2             = 555;
  fidComparedTo3             = 556;
  fidComparedTo4             = 557;
  fidComparedTo5             = 558;
  fidComparedTo6             = 559;
  fidCompareTo               = 878;
  fidComparison              = 877;
  fidCompatOptions           = 741;
  fidCompOp1                 = 549;
  fidCompOp2                 = 550;
  fidCompOp3                 = 551;
  fidCompOp4                 = 552;
  fidCompOp5                 = 553;
  fidCompOp6                 = 560;
  fidCondition1              = 519;
  fidCondition2              = 520;
  fidCondition3              = 521;
  fidCondition4              = 522;
  fidCondition5              = 523;
  fidConfirm                 = 142;
  fidConfirmConversions      = 329;
  fidConfirmFormat           = 183;
  fidConnection              = 600;
  fidContext                 = 3;
  fidContNotice              = 50;
  fidControl                 = 390;
  fidContSeparator           = 49;
  fidCONVENTIONALMEMORY      = 87;
  fidConvertFrom             = 285;
  fidConvertTo               = 286;
  fidConvFrom                = 426;
  fidConvMailMergeEsc        = 921;
  fidCopy                    = 647;
  fidCountBy                 = 125;
  fidCountFootnotes          = 573;
  fidCreate                  = 250;
  fidCreateBackup            = 215;
  fidCreated                 = 535;
  fidCreateDate              = 105;
  fidCropBottom              = 181;
  fidCropLeft                = 180;
  fidCropMarks               = 709;
  fidCropRight               = 182;
  fidCropTop                 = 179;
  fidCrossReference          = 788;
  fidCrossReferenceAutoText  = 867;
  fidCursorBlink             = 291;
  fidCustomDict1             = 427;
  fidCustomDict10            = 634;
  fidCustomDict2             = 428;
  fidCustomDict3             = 429;
  fidCustomDict4             = 430;
  fidCustomDict5             = 629;
  fidCustomDict6             = 630;
  fidCustomDict7             = 631;
  fidCustomDict8             = 632;
  fidCustomDict9             = 633;
  fidCustomZoomPercent       = 497;
  fidDataSource              = 487;
  fidDataType                = 318;
  fidDateCreatedFrom         = 20;
  fidDateCreatedTo           = 21;
  fidDateSavedFrom           = 22;
  fidDateSavedTo             = 23;
  fidDateTimePic             = 496;
  fidDays                    = 736;
  fidDefault                 = 457;
  fidDefaultBookmarkText     = 883;
  fidDefaultFillInText       = 889;
  fidDefaultFormat           = 213;
  fidDefaultLanguage         = 421;
  fidDefaultTray             = 799;
  fidDefine                  = 44;
  fidDefinitions             = 158;
  fidDefTabs                 = 72;
  fidDelete                  = 11;
  fidDeletedText             = 228;
  fidDeletedTextColor        = 661;
  fidDeletedTextMark         = 660;
  fidDemoGuidance            = 720;
  fidDemoSpeed               = 722;
  fidDescription             = 310;
  fidDestination             = 134;
  fidDfltTrueType            = 505;
  fidDifferentFirstPage      = 838;
  fidDirection               = 217;
  fidDirectory               = 104;
  fidDISKSPACE               = 225;
  fidDisplay                 = 338;
  fidDisplayAsPrinted        = 63;
  fidDisplayIcon             = 932;
  fidDisplayOut              = 298;
  fidDistanceFromText        = 266;
  fidDistFromText            = 384;
  fidDistVertFromText        = 446;
  fidDocNavKeys              = 724;
  fidDocTypes                = 581;
  fidDocumentPassword        = 714;
  fidDOHeight                = 908;
  fidDontHyphen              = 839;
  fidDontSortHdr             = 584;
  fidDOWidth                 = 909;
  fidDraft                   = 189;
  fidDraftFont               = 685;
  fidDragAndDrop             = 495;
  fidDrawingObjects          = 920;
  fidDrawings                = 688;
  fidDrive                   = 644;
  fidDrop                    = 782;
  fidDropHeight              = 692;
  fidDump                    = 577;
  fidEdit                    = 502;
  fidEditPicture             = 470;
  fidEditSource              = 394;
  fidEditTime                = 109;
  fidEffects3d               = 676;
  fidEmbedFonts              = 776;
  fidEnable                  = 794;
  fidEnableProt              = 637;
  fidEndContNotice           = 623;
  fidEndContSeparator        = 622;
  fidEndnotes                = 715;
  fidEndnotesAt              = 614;
  fidEndNumberAs             = 615;
  fidEndRestartNum           = 617;
  fidEndSeparator            = 621;
  fidEndStartingNum          = 616;
  fidEntry                   = 145;
  fidEntryAutoText           = 808;
  fidEnvAddress              = 477;
  fidEnvCategory             = 747;
  fidEnvFeederInstalled      = 515;
  fidEnvHeight               = 245;
  fidEnvLabelCategory        = 748;
  fidEnvOmitReturn           = 512;
  fidEnvPaperSize            = 511;
  fidEnvReturn               = 476;
  fidEnvWidth                = 244;
  fidErrorBeeps              = 638;
  fidEvenlySpaced            = 607;
  fidExit                    = 793;
  fidExplain                 = 399;
  fidExtractAddress          = 669;
  fidFace                    = 923;
  fidFacingPages             = 78;
  fidFalseAutoText           = 873;
  fidFalseText               = 874;
  fidFastSave                = 214;
  fidFastSaves               = 342;
  fidField                   = 148;
  fidFieldCodes              = 334;
  fidFieldFormat             = 292;
  fidFieldName               = 628;
  fidFieldNum                = 232;
  fidFieldNum2               = 585;
  fidFieldNum3               = 587;
  fidFields                  = 199;
  fidFieldShading            = 924;
  fidFile                    = 14;
  fidFileName                = 103;
  fidFiles                   = 579;
  fidFileSize                = 926;
  fidFillColor               = 816;
  fidFillPattern             = 817;
  fidFillPatternColor        = 818;
  fidFind                    = 404;
  fidFindNext                = 594;
  fidFindPrevious            = 670;
  fidFindReplCancel          = 603;
  fidFineShading             = 827;
  fidFirstColumn             = 768;
  fidFirstIndent             = 163;
  fidFirstPage               = 139;
  fidFixedHeight             = 386;
  fidFixedHeightNew          = 450;
  fidFixedWidth              = 380;
  fidFixedWidthNew           = 449;
  fidFldType                 = 503;
  fidFont                    = 33;
  fidFootContNotice          = 620;
  fidFootContSeparator       = 619;
  fidFooterDistance          = 138;
  fidFootnoteReferenceMark   = 48;
  fidFootnotes               = 222;
  fidFootnotesAt             = 79;
  fidFootNumberAs            = 611;
  fidFootRestartNum          = 613;
  fidFootSeparator           = 618;
  fidFootStartingNum         = 612;
  fidForeground              = 423;
  fidFormat                  = 203;
  fidFormatNumber            = 465;
  fidFormatOutline           = 464;
  fidFormatPolyline          = 786;
  fidFormatTextbox           = 785;
  fidFormatting              = 732;
  fidFormsData               = 798;
  fidFormula                 = 691;
  fidFrom                    = 186;
  fidFromColumn              = 308;
  fidFromLeft                = 374;
  fidFromText                = 224;
  fidFromTop                 = 377;
  fidFullPage                = 389;
  fidFullScreen              = 881;
  fidGap                     = 783;
  fidGetData                 = 604;
  fidGlobalDotPrompt         = 940;
  fidGoto                    = 645;
  fidGutter                  = 77;
  fidHang                    = 481;
  fidHangingIndent           = 466;
  fidHeaderDistance          = 137;
  fidHeaderRecord            = 507;
  fidHeaderSource            = 504;
  fidHeadingParas            = 198;
  fidHeadingRows             = 766;
  fidHeadingSeparator        = 144;
  fidHeight                  = 779;
  fidHeightRule              = 456;
  fidHeightType              = 385;
  fidHelp                    = 243;
  fidHelpText                = 725;
  fidHelpType                = 879;
  fidHidden                  = 39;
  fidHide                    = 478;
  fidHideAutoFit             = 947;
  fidHideMarks               = 671;
  fidHorizBorder             = 367;
  fidHorizColor              = 359;
  fidHorizontal              = 262;
  fidHorizontalFrom          = 905;
  fidHorizontalPos           = 904;
  fidHorizWidth              = 365;
  fidHotZone                 = 143;
  fidHRelativeTo             = 263;
  fidHRuler                  = 707;
  fidHScroll                 = 66;
  fidHyphenateAll            = 246;
  fidHyphenateCaps           = 141;
  fidHyphenateNow            = 805;
  fidHyphenationZone         = 931;
  fidHyphens                 = 61;
  fidIcon                    = 437;
  fidIconFilename            = 936;
  fidIconNumber              = 937;
  fidIdleCount               = 288;
  fidIdleInterrupt           = 290;
  fidIdleMode                = 289;
  fidIgnore                  = 147;
  fidIgnoreAll               = 347;
  fidIgnoreAllCaps           = 154;
  fidIgnoreCaps              = 239;
  fidIgnoreIndentsAndSpacing = 686;
  fidIgnoreMixedDigits       = 369;
  fidInclude                 = 950;
  fidIncludeFields           = 802;
  fidIncludeNum              = 948;
  fidIncrement               = 452;
  fidIndent                  = 493;
  fidIndentRows              = 272;
  fidInitialCaps             = 734;
  fidInitialColWidth         = 284;
  fidInitials                = 57;
  fidInput                   = 122;
  fidInsert                  = 133;
  fidInsertAs                = 726;
  fidInsertAsField           = 929;
  fidInsertAsText            = 514;
  fidInsertedTextColor       = 659;
  fidInsertedTextMark        = 658;
  fidInsertLoop              = 229;
  fidInsertMode              = 293;
  fidInsForPaste             = 330;
  fidInsideBorder            = 277;
  fidInsideMargin            = 780;
  fidInternalMargin          = 910;
  fidItalic                  = 37;
  fidItem                    = 341;
  fidKeepFormatting          = 763;
  fidKeepTogether            = 168;
  fidKeepWithNext            = 169;
  fidKerning                 = 792;
  fidKerningMin              = 754;
  fidKey                     = 392;
  fidKeyCode                 = 2;
  fidKeyCode2                = 648;
  fidKeywords                = 101;
  fidKillLink                = 346;
  fidLabel                   = 608;
  fidLabelAcross             = 702;
  fidLabelAutoText           = 835;
  fidLabelColumn             = 746;
  fidLabelDotMatrix          = 834;
  fidLabelDown               = 703;
  fidLabelHeight             = 696;
  fidLabelHorPitch           = 700;
  fidLabelIndex              = 693;
  fidLabelListIndex          = 695;
  fidLabelRow                = 745;
  fidLabelSideMargin         = 699;
  fidLabelText               = 836;
  fidLabelTopMargin          = 698;
  fidLabelTray               = 694;
  fidLabelVertPitch          = 701;
  fidLabelWidth              = 697;
  fidLanguage                = 420;
  fidLargeButtons            = 765;
  fidLastColumn              = 769;
  fidLastPrintedDate         = 110;
  fidLastRow                 = 767;
  fidLastSaved               = 536;
  fidLastSavedBy             = 107;
  fidLastSavedDate           = 106;
  fidLayout1                 = 297;
  fidLayout2                 = 296;
  fidLayout3                 = 295;
  fidLayout4                 = 294;
  fidLeader                  = 252;
  fidLeftBorder              = 278;
  fidLeftColor               = 356;
  fidLeftIndent              = 161;
  fidLeftMargin              = 75;
  fidLeftWidth               = 362;
  fidLength                  = 900;
  fidLevel                   = 184;
  fidLimitConsecutiveHyphens = 750;
  fidLinebreaks              = 335;
  fidLineColor               = 353;
  fidLineNum                 = 223;
  fidLines                   = 598;
  fidLineSpacing             = 166;
  fidLineSpacingRule         = 324;
  fidLineStyle               = 820;
  fidLineType                = 930;
  fidLineWeight              = 821;
  fidLink                    = 149;
  fidLinkStyles              = 807;
  fidLinkToFile              = 454;
  fidLinkToSource            = 803;
  fidLinkToTemplate          = 126;
  fidListBy                  = 887;
  fidLocation                = 402;
  fidLockAnchor              = 849;
  fidLockAnnot               = 216;
  fidLocked                  = 475;
  fidLongCitation            = 760;
  fidLongCitationAutoText    = 868;
  fidMacro                   = 438;
  fidMailAddress             = 846;
  fidMailAsAttachment        = 847;
  fidMailMerge               = 848;
  fidMailSubject             = 845;
  fidMainDic                 = 237;
  fidMainDict                = 350;
  fidMainDoc                 = 488;
  fidMakePicture             = 393;
  fidMark                    = 757;
  fidMarkAll                 = 758;
  fidMarkCitation            = 885;
  fidMarkEntry               = 884;
  fidMarkRevisions           = 208;
  fidMatchCase               = 207;
  fidMATHCOPROCESSOR         = 88;
  fidMenu                    = 7;
  fidMenuHelp                = 114;
  fidMenuSimulation          = 721;
  fidMenuText                = 8;
  fidMenuType                = 684;
  fidMerge                   = 46;
  fidMergeCells              = 270;
  fidMergeField              = 489;
  fidMergeField1             = 543;
  fidMergeField2             = 544;
  fidMergeField3             = 545;
  fidMergeField4             = 546;
  fidMergeField5             = 547;
  fidMergeField6             = 548;
  fidMergeRec                = 532;
  fidMergerecords            = 119;
  fidMergeRecords_2          = 533;
  fidMergeType               = 605;
  fidMessage                 = 810;
  fidMessageBeeps            = 640;
  fidMinHeight               = 405;
  fidMinimumRowHeight        = 273;
  fidModify                  = 268;
  fidMouseSimulation         = 719;
  fidMoveCol                 = 415;
  fidMoveRow                 = 414;
  fidMoveWithText            = 445;
  fidMSQuery                 = 738;
  fidMultiplePages           = 683;
  fidMultLineSpace           = 739;
  fidName                    = 1;
  fidNativePictureFormat     = 925;
  fidNetwork                 = 591;
  fidNew                     = 94;
  fidNewDict                 = 371;
  fidNewDocument             = 197;
  fidNewName                 = 117;
  fidNewPicture              = 303;
  fidNewTemplate             = 155;
  fidNewText                 = 210;
  fidNext                    = 398;
  fidNextCitation            = 840;
  fidNextCol                 = 412;
  fidNextColumn              = 410;
  fidNextRow                 = 409;
  fidNextStyle               = 124;
  fidNo                      = 29;
  fidNoColumnBalance         = 919;
  fidNoFormatting            = 627;
  fidNoLineNum               = 173;
  fidNoReset                 = 946;
  fidNoSpaceRaiseLower       = 913;
  fidNoTabHangIndent         = 912;
  fidNoteType                = 610;
  fidNumChars                = 113;
  fidNumColumns              = 282;
  fidNumCopies               = 185;
  fidNumFormat               = 136;
  fidNumLines                = 704;
  fidNumMode                 = 226;
  fidNumPages                = 111;
  fidNumParas                = 200;
  fidNumRestart              = 325;
  fidNumRows                 = 283;
  fidNumWords                = 112;
  fidObject                  = 635;
  fidObjectType              = 935;
  fidOddAndEvenPages         = 140;
  fidOldRecipient            = 893;
  fidOneAfterAnother         = 812;
  fidOpen                    = 15;
  fidOpenSource              = 344;
  fidOption                  = 312;
  fidOptions                 = 400;
  fidOrder                   = 230;
  fidOrder2                  = 677;
  fidOrder3                  = 678;
  fidOrganizer               = 578;
  fidOrientation             = 327;
  fidOriginal                = 176;
  fidOrigWordTableRules      = 943;
  fidOtherPages              = 460;
  fidOtherSep                = 679;
  fidOutline                 = 41;
  fidOutlineBorder           = 274;
  fidOutsideMargin           = 781;
  fidOvertype                = 331;
  fidOwnHelp                 = 795;
  fidOwnStat                 = 796;
  fidPageAttribControls      = 458;
  fidPageBreak               = 172;
  fidPageControls            = 461;
  fidPageHeight              = 71;
  fidPages                   = 540;
  fidPageSize                = 326;
  fidPageWidth               = 70;
  fidPagination              = 54;
  fidPanel                   = 609;
  fidPaperSize               = 459;
  fidParagraph               = 31;
  fidParagraphs              = 256;
  fidParagraphWidth          = 267;
  fidParas                   = 60;
  fidPartialPages            = 681;
  fidPassim                  = 762;
  fidPassword                = 96;
  fidPasswordDoc             = 321;
  fidPasswordDot             = 322;
  fidPaste                   = 319;
  fidPath                    = 406;
  fidPatternMatch            = 755;
  fidPictureEditor           = 928;
  fidPicturePlaceHolders     = 333;
  fidPictures                = 64;
  fidPoints                  = 34;
  fidPosition                = 43;
  fidPositionHorz            = 373;
  fidPositionHorzNew         = 443;
  fidPositionHorzRel         = 444;
  fidPositionVert            = 376;
  fidPositionVertNew         = 447;
  fidPositionVertRel         = 448;
  fidPreserveIndentLevels    = 869;
  fidPreserveStyles          = 857;
  fidPreset                  = 716;
  fidPrevCol                 = 413;
  fidPrevColumn              = 411;
  fidPreview                 = 918;
  fidPrevRow                 = 408;
  fidPrint                   = 16;
  fidPrintBarCode            = 118;
  fidPrintColBlack           = 915;
  fidPrinted                 = 539;
  fidPrintEnvLabel           = 516;
  fidPrinter                 = 47;
  fidPrintFIMA               = 249;
  fidPrintRevisions          = 674;
  fidPrintToFile             = 435;
  fidProduct                 = 740;
  fidPrompt                  = 509;
  fidPrompy                  = 121;
  fidProtect                 = 442;
  fidPrToFileName            = 642;
  fidPunctuation             = 453;
  fidQueryOptions            = 484;
  fidRange                   = 146;
  fidRanges                  = 590;
  fidReadOnly                = 159;
  fidRecentFileCount         = 89;
  fidRecentFiles             = 97;
  fidRecipients              = 811;
  fidRecommendReadOnly       = 713;
  fidRecord                  = 646;
  fidRecord1                 = 524;
  fidRecord2                 = 525;
  fidRecord3                 = 526;
  fidRecord4                 = 527;
  fidRecord5                 = 528;
  fidRecord6                 = 529;
  fidReference               = 128;
  fidReferenceItem           = 899;
  fidReferenceKind           = 898;
  fidReferenceType           = 897;
  fidRejectAll               = 729;
  fidRejectRevisions         = 791;
  fidRelativeHorz            = 375;
  fidRelativeTo              = 777;
  fidRelativeVert            = 378;
  fidReload                  = 667;
  fidRemove                  = 441;
  fidRemoveAttachments       = 561;
  fidRemoveFrame             = 510;
  fidRemoveToolbars          = 689;
  fidRename                  = 116;
  fidRepeatAllPages          = 383;
  fidReplace                 = 205;
  fidReplaceAll              = 480;
  fidReplaceBullets          = 866;
  fidReplaceOne              = 483;
  fidReplaceQuotes           = 864;
  fidReplaceSelection        = 304;
  fidReplaceSymbols          = 865;
  fidReplaceText             = 737;
  fidReset                   = 439;
  fidResetAll                = 4;
  fidResetIgnoreAll          = 257;
  fidResetSlip               = 895;
  fidResetTool               = 498;
  fidRestartNum              = 81;
  fidRetAddrFromLeft         = 751;
  fidRetAddrFromTop          = 752;
  fidReturnWhenDone          = 814;
  fidReverse                 = 188;
  fidRevert                  = 718;
  fidReview                  = 672;
  fidRevisedLinesColor       = 663;
  fidRevisedLinesMark        = 662;
  fidRevision                = 537;
  fidRevisionBar             = 209;
  fidRevisionNumber          = 108;
  fidRightAlignPageNumbers   = 789;
  fidRightBorder             = 279;
  fidRightColor              = 358;
  fidRightIndent             = 162;
  fidRightMargin             = 76;
  fidRightWidth              = 364;
  fidRoundCorners            = 826;
  fidRouteDocument           = 831;
  fidRuler                   = 705;
  fidRulerStyle              = 518;
  fidRun                     = 501;
  fidSavedBy                 = 18;
  fidSaveInterval            = 343;
  fidSavePictureInDoc        = 830;
  fidScaleX                  = 178;
  fidScaleY                  = 177;
  fidSearch                  = 204;
  fidSearchAgain             = 24;
  fidSearchName              = 870;
  fidSearchPath              = 425;
  fidSearchText              = 19;
  fidSection                 = 668;
  fidSectionName             = 801;
  fidSectionStart            = 221;
  fidSelect                  = 508;
  fidSelected                = 574;
  fidSelectedFile            = 500;
  fidSelection               = 639;
  fidSendMailAttach          = 790;
  fidSentence                = 396;
  fidSentenceCaps            = 735;
  fidSeparator               = 231;
  fidSet                     = 115;
  fidSetDefault              = 84;
  fidSetDesc                 = 564;
  fidSetSize                 = 499;
  fidSetting                 = 313;
  fidSetup                   = 27;
  fidShading                 = 171;
  fidShadingColor            = 354;
  fidShadow                  = 434;
  fidShift                   = 391;
  fidShiftCells              = 269;
  fidShortCitation           = 759;
  fidShow                    = 336;
  fidShowAll                 = 62;
  fidShowBreaksInFrames      = 951;
  fidShowCodes               = 195;
  fidShowHidden              = 194;
  fidShowMacro               = 494;
  fidShowMarks               = 933;
  fidShowPageNumbers         = 196;
  fidShowRulers              = 690;
  fidShowStatistics          = 482;
  fidSingleLabel             = 837;
  fidSizeX                   = 565;
  fidSizeY                   = 566;
  fidSmallCaps               = 93;
  fidSmartCutPaste           = 657;
  fidSmartQuotes             = 120;
  fidSnapToGrid              = 771;
  fidSort                    = 13;
  fidSortBy                  = 12;
  fidSortColumn              = 233;
  fidSoundsLike              = 753;
  fidSource                  = 127;
  fidSpace                   = 949;
  fidSpaceBetweenCols        = 271;
  fidSpaces                  = 59;
  fidSpacing                 = 45;
  fidSplitCells              = 311;
  fidSQLStatement            = 599;
  fidSQLStatement1           = 953;
  fidStartAt                 = 201;
  fidStartAtBeginning        = 370;
  fidStartingNum             = 80;
  fidStartNewCol             = 468;
  fidStartupTips             = 944;
  fidStatText                = 797;
  fidStatusBar               = 332;
  fidStore                   = 471;
  fidStoreGlsy               = 472;
  fidStoreMacro              = 473;
  fidStrikeout               = 314;
  fidStrikethrough           = 922;
  fidStrikethru              = 42;
  fidStyle                   = 167;
  fidStyleAreaWidth          = 69;
  fidStyleGallery            = 890;
  fidStyleSheets             = 580;
  fidSubDir                  = 888;
  fidSubject                 = 99;
  fidSubscript               = 711;
  fidSubstituteFont          = 844;
  fidSuggest                 = 150;
  fidSuggestFromMainDictOnly = 255;
  fidSuggestions             = 132;
  fidSummary                 = 192;
  fidSummaryPrompt           = 55;
  fidSuperscript             = 710;
  fidSuppDic                 = 238;
  fidSuppDict                = 351;
  fidSuppression             = 534;
  fidSuppressSpBfAfterPgBrk  = 941;
  fidSuppressTopSpacing      = 942;
  fidSupression              = 530;
  fidSwapBordersFacingPages  = 952;
  fidSwitch                  = 531;
  fidSwitchKeyboard          = 422;
  fidSymbol                  = 641;
  fidSynonymList             = 157;
  fidSynonyms                = 174;
  fidSysOptions              = 742;
  fidTab                     = 911;
  fidTableGridlines          = 68;
  fidTableHeader             = 727;
  fidTableId                 = 655;
  fidTabs                    = 58;
  fidTask                    = 589;
  fidTemplate                = 82;
  fidTest                    = 300;
  fidText                    = 305;
  fidTextBoundaries          = 65;
  fidTextDefault             = 852;
  fidTextFormat              = 853;
  fidTextSize                = 850;
  fidTextType                = 841;
  fidTextWidth               = 851;
  fidTime                    = 538;
  fidTitle                   = 98;
  fidTitleAutoText           = 806;
  fidTo                      = 187;
  fidTool                    = 506;
  fidToolbar                 = 479;
  fidToolTips                = 756;
  fidTopBorder               = 275;
  fidTopColor                = 355;
  fidTopMargin               = 73;
  fidTopWidth                = 361;
  fidToTemplate              = 91;
  fidTrackStatus             = 815;
  fidTransparent             = 382;
  fidTransparentMetafiles    = 945;
  fidTrueAutoText            = 871;
  fidTrueText                = 872;
  fidTwoPages                = 939;
  fidType                    = 135;
  fidType2                   = 586;
  fidType3                   = 588;
  fidUnAssign                = 6;
  fidUnavailableFont         = 843;
  fidUnderline               = 40;
  fidUndo                    = 349;
  fidUndoRevisions           = 212;
  fidUnframe                 = 451;
  fidUngroup                 = 787;
  fidUnits                   = 53;
  fidUnlink                  = 339;
  fidUnlinkMain              = 513;
  fidUnlocked                = 320;
  fidUpdate                  = 302;
  fidUpdateFields            = 190;
  fidUpdateLinks             = 299;
  fidUpdateMode              = 337;
  fidUpdateNow               = 345;
  fidUseEnvFeeder            = 248;
  fidUsePathAsDefault        = 403;
  fidUserDict1               = 416;
  fidUserDict2               = 417;
  fidUserDict3               = 418;
  fidUserDict4               = 419;
  fidUserID                  = 602;
  fidUsrDlg                  = 287;
  fidValueAutoText           = 876;
  fidValueText               = 875;
  fidVariable                = 129;
  fidVerb                    = 938;
  fidVertAlign               = 227;
  fidVertBorder              = 368;
  fidVertColor               = 360;
  fidVertical                = 264;
  fidVerticalFrom            = 907;
  fidVerticalPos             = 906;
  fidVertWidth               = 366;
  fidView                    = 395;
  fidViewRevisions           = 673;
  fidVRelativeTo             = 265;
  fidVRuler                  = 706;
  fidVScroll                 = 67;
  fidWeight                  = 624;
  fidWhere                   = 485;
  fidWholeWord               = 206;
  fidWidowControl            = 83;
  fidWidth                   = 778;
  fidWidthRule               = 455;
  fidWidthType               = 379;
  fidWindow                  = 593;
  fidWith                    = 626;
  fidWizard                  = 825;
  fidWord                    = 235;
  fidWordField               = 490;
  fidWords                   = 541;
  fidWPCommand               = 592;
  fidWPDocNavKeys            = 563;
  fidWPHelp                  = 562;
  fidWrap                    = 381;
  fidWrapToWindow            = 687;
  fidWrapTrailSpaces         = 916;
  fidWritePassword           = 712;
  fidWritePasswordDoc        = 743;
  fidWritePasswordDot        = 744;
  fidXGrid                   = 774;
  fidXOrigin                 = 772;
  fidXReplace                = 306;
  fidYes                     = 28;
  fidYES_2                   = 51;
  fidYGrid                   = 775;
  fidYOrigin                 = 773;
  fidZoomPercent             = 323;

  { word format codes }
  wfWord      = 0;
  wfTemplate  = 1;
  wfText      = 2;
  wfTextlb    = 3;
  wfDosText   = 4;
  wfDosTextlb = 5;
  wfRTF       = 6;

implementation

function errorDesc;
begin
 case i of
   5:result := 'IllegalFunctionCall   ';
   6:result := 'Overflow              ';
   7:result := 'OutOfMemory           ';
   9:result := 'SubscriptOutOfRange   ';
   11:result := 'DivisionByZero        ';
   14:result := 'OutOfStringSpace      ';
   39:result := 'CaseElseExpected      ';
   51:result := 'InternalError         ';
   52:result := 'BadFileNameOrNumber   '; 
   53:result := 'FileNotFound          ';
   54:result := 'BadFileMode           '; 
   55:result := 'FileAlreadyOpen       ';
   57:result := 'DeviceIOError         '; 
   62:result := 'InputPastEndOfFile    '; 
   64:result := 'BadFileName           ';
   67:result := 'TooManyFiles          '; 
   73:result := 'AdvFeatureUnavail     '; 
   74:result := 'RenameAcrossDisks     '; 
   75:result := 'PathFileAccessError   '; 
   76:result := 'PathNotFound          '; 
   22:result := 'BadArrayBound         '; 
   23:result := 'CannotWriteDisk       '; 
   24:result := 'BadParam              ';
   25:result := 'OutOfStack            '; 
   26:result := 'UDlgNoButton          '; 
   27:result := 'NoResume              '; 
   28:result := 'DirExists             ';
   100:result := 'SyntaxError          '; 
   101:result := 'CommaMissing         '; 
   102:result := 'CommandFailed        '; 
   103:result := 'DlgRecVarExpected    ';
   104:result := 'ElseWithoutIf        '; 
   105:result := 'EndIfWithoutIf       '; 
   109:result := 'InputMissing         '; 
   110:result := 'NoResumeNext         ';
   111:result := 'ExpressionTooComplex ';
   112:result := 'IdentifierExpected   '; 
   113:result := 'DuplicateLabel       '; 
   114:result := 'LabelNotFound        ';
   115:result := 'MissingRightParen    '; 
   116:result := 'ArgCountMismatch     '; 
   117:result := 'MissingNextOrWend    '; 
   118:result := 'NestedSubOrFunc      ';
   119:result := 'NextWithoutFor       '; 
   120:result := 'ArrayAlreadyDimed    '; 
   122:result := 'TypeMismatch         '; 
   123:result := 'UndefDlgRecField     ';
   124:result := 'SubprogNotDefined    '; 
   125:result := 'UnexpectedEndOfMacro ';
   126:result := 'WendWithoutWhile     '; 
   127:result := 'WrongNumOfDimensions ';
   129:result := 'TooManyCtrlStructs   '; 
   130:result := 'MissingEndSelect     '; 
   131:result := 'IllegalRedim         '; 
   132:result := 'DllMadeStringTooLong ';
   133:result := 'BadDllCall           '; 
   134:result := 'BadDate              '; 
   135:result := 'NotOnThisPlatform    '; 
   136:result := 'CmdNotOnThisPlatform ';
   137:result := 'InvalidPathOpt       '; 
   138:result := 'CantChangeSel        '; 
   139:result := 'UserDlgUp            '; 
   140:result := 'InvalDlgControlId    ';
   141:result := 'UnavailableOnCtl     '; 
   142:result := 'BadAppName           '; 
   143:result := 'InvalDlgHideDisable  '; 
   144:result := 'InvalDlgFocus        ';
   145:result := 'InvalMergeField      '; 
   146:result := 'NoMergeField         '; 
   147:result := 'InternalStringError  '; 
   148:result := 'AppMaximized         ';
   149:result := 'CommandNotFunction   '; 
   150:result := 'DuplDlgControlId     '; 
   151:result := 'DocMaximized         '; 
   152:result := 'NoDocOpen            ';
   153:result := 'DocMinimized         '; 
   154:result := 'AppMinimized         '; 
   155:result := 'NotInField           '; 
   156:result := 'FieldHasNoData       ';
   157:result := 'NotDataField         '; 
   158:result := 'ParamTooLow          '; 
   159:result := 'ParamTooHigh         '; 
   160:result := 'WrongNumOfParams     ';
   161:result := 'CantCallDlg          '; 
   162:result := 'CommandOnlyFunction  '; 
   163:result := 'DlgActiveOnly        '; 
   164:result := 'ArrayNotDimed        ';
   500:result := 'CannotInitiate       '; 
   501:result := 'BogusDcl             '; 
   502:result := 'NoResponse           '; 
   503:result := 'AppNacked            ';
   504:result := 'NoSuchWin            '; 
   505:result := 'CantActivate         '; 
   506:result := 'CannotSendKeys       '; 
   508:result := 'AppBusyed            ';
   509:result := 'ModeError            '; 
   511:result := 'NoMacro              '; 
   512:result := 'OutOfRange           '; 
   513:result := 'StringTooBig         ';
   514:result := 'DocNotOpen           '; 
   528:result := 'UnableToLoadSpeller  '; 
   529:result := 'CannotOpenDictionary ';
   530:result := 'DlgBoxTooComplex     ';
   532:result := 'UnknownLoc           '; 
   534:result := 'NoWordkey            '; 
   535:result := 'MacroAlreadyRunning  '; 
   536:result := 'BadMacroName         ';
   537:result := 'CantRun              '; 
   538:result := 'CantEdit             '; 
   539:result := 'CantRename           '; 
   540:result := 'CantDelete           ';
   541:result := 'CantSetDesc          '; 
   542:result := 'CantEditDesc         '; 
   543:result := 'CantFindLib          '; 
   544:result := 'NoScrollBar          ';
   545:result := 'StatementDisabled    '; 
   546:result := 'FtnEdnNotContinuous  '; 
   547:result := 'NoNetPerm            '; 
   549:result := 'MenuDoesntExist      ';
   550:result := 'CantRecord           '; 
   551:result := 'GlsyDocLocked        '; 
   552:result := 'NoTemplate           '; 
   553:result := 'CantCreate           ';
   554:result := 'NoDrawingRangeSet    '; 
   555:result := 'InvalidDrawingRangeBookmark ';
   556:result := 'WrongDrawnObjectType ';
   557:result := 'CouldntInsertDO      ';
   558:result := 'ChapterLock          '; 
   559:result := 'BlockSel             '; 
   560:result := 'RevisionsHidden      '; 
   561:result := 'ProtectedDoc         ';
   562:result := 'GramStatsMultLang    '; 
   563:result := 'NotMaster            '; 
   564:result := 'GotoInvalid          '; 
   565:result := 'NotAnAddInFile       ';
   566:result := 'FileInUse            '; 
   567:result := 'ListMaxReached       '; 
   568:result := 'FontNotExist         '; 
   569:result := 'FindSearchType       ';
   570:result := 'SortArrayDim         '; 
   571:result := 'TooManyAccelKey      '; 
   572:result := 'IllegalFirstAccel    '; 
   573:result := 'IllegalSecondAccel   ';
   0:result    := 'WrdApi No Error'  ;
   5000:result := 'Unable to access word link';
   5001:result := 'WrdApi Invalid Command Id ' ;
   5002:result := 'WrdApi parameter block has odd number of bytes '  ;
   5003:result := 'WrdApi command is not available '              ;
   5004:result := 'WrdApi too many or too few arguments '         ;
   5005:result := 'WrdApi Error in our own data or handling '      ;
   5006:result := 'WrdApi pb doesn''t have acceptable # of bytes' ;
   5007:result := 'WrdApi non function called as function'         ;
   5008:result := 'WrdApi parameter type passed or expected is wrong' ;
   5009:result := 'WrdApi string is longer than 255 characters '   ;
   5010:result := 'WrdApi pointer for output is Nil     ';
   5011:result := 'WrdApi can''t lock global handle'   ;
   5012:result := 'WrdApi can''t allocate global handle'   ;
   5013:result := 'WrdApi commmand has no dialog '        ;
   5014:result := 'WrdApi is out of memory'                ;
   5015:result := 'WrdApi too many parameters passed to function'  ;
   5016:result := 'WrdApi Field Id not in Dialog '                ;
   5017:result := 'WrdApi Handle has not been allocated'            ;
   5018:result := 'WrdApi parameter takes an array only'           ;
   5019:result := 'WrdApi too many dimesions for array'             ;
   5020:result := 'WrdApi parameter passed was not a short long or num'   ;
   5021:result := 'WrdApi parameter passed was not a string'            ;
   5022:result := 'WrdApi parameter value was out of acceptable range'  ;
   5023:result := 'WrdApi String Type requested for numeric only field' ;
   5024:result := 'WrdApi Numeric Type requested for string only field' ;
   5025:result := 'WrdApi Buffer for return string is too small'       ;
   5026:result := 'WrdApi Array string buffer is too small '           ;
   5027:result := 'WrdApi Dialog command string buffer too small' ;
   5028:result := 'WrdApi BufferTooSmall bit set on input'    ;
   5029:result := 'WrdApi String Passed can''t be parsed '   ;
   5030:result := 'WrdApi Bad pointer in message (CMI) '  ;
   5031:result := 'WrdApi WrdApi command failed '         ;
   5032:result := 'WrdApi Document Reference Number is Invalid' ;
   5033:result := 'WrdApi Minimum Stack not available '        ;
   5034:result := 'WrdApi0 was passed as string pointer '     ;
  else result := 'Undefined Error type ' + inttostr(i);       ;
 end;
end;

                                             
end.
