unit Wall;

{$A+,B-,D-,F-,G+,I-,K+,P+,Q-,R-,S-,T-,V-,W-,X+,Y+}

interface

uses Windows,
  SysUtils, Classes, Messages, Menus, Buttons, Controls, Graphics, Forms,
  ExtCtrls;

type
  TWallpaper = class(TCustomPanel)
  private
    FWallpaper: TPicture;
    procedure WallpaperChanged(Sender: TObject);
    procedure SetWallpaper(Value: TPicture);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Align;
    property BevelInner;
    property BevelOuter;
    property BevelWidth;
    property BorderWidth;
    property BorderStyle;
    property Caption;
    property Color;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Locked;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint default False;
    property PopupMenu;
    property ShowHint default True;
    property TabOrder;
    property TabStop;
    property Wallpaper: TPicture read FWallpaper write SetWallpaper;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
    property OnResize;
  end;

procedure Register;

implementation

{ TWallpaper }

constructor TWallpaper.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FWallpaper := TPicture.Create;
  FWallpaper.OnChange := WallpaperChanged;
  ParentShowHint := False;
  ShowHint := True;
  inherited Align := alTop;
end;

destructor TWallpaper.Destroy;
begin
  FWallpaper.OnChange := nil;
  FWallpaper.Free;
  FWallpaper := nil;
  inherited Destroy;
end;

procedure TWallpaper.WallpaperChanged(Sender: TObject);
begin
  Invalidate;
end;

procedure TWallpaper.SetWallpaper(Value: TPicture);
begin
  FWallpaper.Assign(Value);
end;

procedure TWallpaper.Paint;
var
  XCnt, YCnt, X, Y: Integer;
  BevelSize, SaveIndex: Integer;
  Rect: TRect;
begin
    inherited Paint;
    if (FWallpaper.Graphic <> nil) and (FWallpaper.Width > 0) and
      (FWallpaper.Height > 0) then
    begin
      Rect := ClientRect;
      BevelSize := BorderWidth;
      if BevelOuter <> bvNone then Inc(BevelSize, BevelWidth);
      if BevelInner <> bvNone then Inc(BevelSize, BevelWidth);
      InflateRect(Rect, -BevelSize, -BevelSize);
      SaveIndex := SaveDC(Canvas.Handle);
      try
        IntersectClipRect(Canvas.Handle, Rect.Left, Rect.Top,
                Rect.Right -Rect.Left +1,
                Rect.Bottom-Rect.Top  +1 );
          XCnt := (ClientWidth - 2 * BevelSize) div FWallpaper.Width;
          YCnt := (ClientHeight - 2 * BevelSize) div FWallpaper.Height;
          for X := 0 to XCnt do
            for Y := 0 to YCnt do
              Canvas.Draw(Rect.Left + X * FWallpaper.Width,
                Rect.Top + Y * FWallpaper.Height, FWallpaper.Graphic);
      finally
        RestoreDC(Canvas.Handle, SaveIndex);
      end;
    end;
end;

{+--------------------------------------------------------------+}
{| Register the components                                      |}
{+--------------------------------------------------------------+}

procedure Register;
begin
  RegisterComponents('Additional', [TWallpaper]);
end;

end.
