{
$Id$

$Log$

vtssinc.pas
A Delphi binding for the Visual Tools Formula One spreadsheet VBX.

Matt Francomb,
Setanta Software Ltd.,
St. John's Innovation Centre,
Cambridge CB4 4WS,
UK

If you need help with this code, you can contact me at

matt@setanta.demon.co.uk

If you want to know about Setanta Software's products, visit
our home page at
http://www.demon.co.uk/setanta

If you want to give this file to anybody else, please do so,
but please preserve this comment.

If you find any glaring bugs, I'd be interested to know what you
did to fix them ;)

converted from
// vtss.h
//
// Copyright (c) 1992-1994, VisualTools, Inc. All rights reserved
//
}
{$D-} {The file is too big for me to compile with debugging info}
UNIT vtssinc;

INTERFACE

USES SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, VBXCtrl, vtss, ExtCtrls;

TYPE
	DWORD = Longint;
   LONGPARAM = Longint;
   LRESULT = Longint;
   RC = Integer;
	SSERROR = Integer;
   COLORREF = TColorref;
	IOFUNC = FUNCTION (dwUserData:  DWORD; pRWBuf:  Pointer; nBytesToRW:  Word):  DWORD;

CONST
	kShiftHorizontal = 1;
	kShiftVertical = 2;
	kShiftRows = 3;
	kShiftColumns = 4;

	kHAlignGeneral = 1;
	kHAlignLeft = 2;
	kHAlignCenter = 3;
	kHAlignRight = 4;
	kHAlignFill = 5;
	kHAlignJustify = 6;
	kHAlignCenterAcrossCells = 7;

	kVAlignTop = 1;
	kVAlignCenter = 2;
	kVAlignBottom = 3;

	SSERROR_NONE = 0;					{	// No error }
	SSERROR_GENERAL = 1;				{	// Error }
	SSERROR_BAD_ARGUMENT = 2;			{	// Bad argument provided to function }
	SSERROR_NO_MEMORY = 3;				{	// Not enough memory to complete operation }
	SSERROR_BAD_FORMULA = 4;			{	// Unable to parse formula }
	SSERROR_BUF_TOO_SHORT = 5;			{	// Provided buffer too short for result }
	SSERROR_NOT_FOUND = 6;				{	// Name not found (user name or table name) }
	SSERROR_BAD_RC = 7;					{	// Bad RC value sent to function }
	SSERROR_BAD_HSS = 8;				{	// Bad HSS value passed to function }
	SSERROR_TOO_MANY_HSS = 9;			{	// Unable to create any more HSSs }
	SSERROR_NO_TABLE = 10;				{	// No table attached to view }
	SSERROR_UNABLE_TO_OPEN_FILE = 11;	{	// Unable to open file }
	SSERROR_INVALID_FILE = 12;			{	// Tried to read invalid file }
	SSERROR_INSERT_SHIFT_OFF_TABLE = 13;{	// Insert would push cells out of bounds of worksheet }
	SSERROR_ONLY_ONE_RANGE = 14;		{	// Cannot do command with more than one range selected }
	SSERROR_NOTHING_TO_PASTE = 15;		{	// Called SSEditPaste() but there is nothing to paste }
	SSERROR_BAD_NUMBER_FORMAT = 16;
	SSERROR_TOO_MANY_FONTS = 17;
	SSERROR_TOO_MANY_SELECTED_RANGES = 18;
	SSERROR_UNABLE_TO_WRITE_FILE = 19;
	SSERROR_NO_TRANSACTION = 20;		{	// SSTransactCommit() or SSTransactRollback() called without first calling SSTransactStart()}
	SSERROR_NOTHING_TO_PRINT = 21;
	SSERROR_PRINT_MARGINS_DONT_FIT = 22;
	SSERROR_CANCEL = 23;
	SSERROR_UNABLE_TO_INITIALIZE_PRINTER = 24;
	SSERROR_STRING_TOO_LONG = 25;
	SSERROR_FORMULA_TOO_LONG = 26;
	SSERROR_UNABLE_TO_OPEN_CLIPBOARD = 27;{	// OpenClipboard() Windows call failed }
	SSERROR_PASTE_WOULD_OVERFLOW_SHEET = 28;
	SSERROR_LOCKED_CELLS_CANNOT_BE_MODIFIED = 29;
	SSERROR_LOCKED_DOCUMENT_CANNOT_BE_MODIFIED = 30;
	SSERROR_INVALID_NAME = 31;
	SSERROR_CANT_DELETE_NAME_IN_USE = 32;
	SSERROR_UNABLE_TO_FIND_NAME = 33;
	SSERROR_NO_WINDOW = 34;

	SSERROR_LAST = SSERROR_NO_WINDOW;


TYPE

   SSEDIThandle = Pointer;
	SShandle = Pointer;

	CSSEdit = CLASS
	PUBLIC
		CONSTRUCTOR MakeCSSEdit (hSSEdit:  SSEDIThandle);
		FUNCTION Height:  Integer;
		FUNCTION Move (x, y, cx, cy:  Integer):  SSERROR;
		FUNCTION MakeNew (hWndParent:  HWND):  SSERROR;
	PRIVATE
		m_hSSEdit: SSEDIThandle;
	END;


	CSSCell = CLASS
   PUBLIC
		m_nRow, m_nCol:  RC;
   END;


	CSSRange = CLASS
	PUBLIC
		m_nRow1, m_nCol1, m_nRow2, m_nCol2:  Integer;
		FUNCTION Rows:  RC;
		FUNCTION Cols:	RC;
	END;

	CSS = CLASS
   PUBLIC
		CONSTRUCTOR Create (TheControl:  TSheet);
		FUNCTION CheckNew:  SSERROR;
		FUNCTION AddColPageBreak (nCol:  RC):  SSERROR;
		FUNCTION AddPageBreak:  SSERROR;
		FUNCTION AddRowPageBreak (nRow:  RC):  SSERROR;
		FUNCTION AddSelection (nR1, nC1, nR2, nC2:  RC):  SSERROR;
		FUNCTION Attach (pTitle:  String):  SSERROR;
		FUNCTION AttachToSS (hSrcSS:  SShandle):  SSERROR;
		FUNCTION CalculationDlg:  SSERROR;
		FUNCTION CallWindowProc(nMessage, wParam:  Word; lParam: LONGPARAM):  LRESULT;
		FUNCTION CancelEdit:  SSERROR;
		FUNCTION CanEditPaste (VAR pCanEditPaste:  Boolean):  SSERROR;
		FUNCTION CheckModified:  SSERROR;
		FUNCTION CheckRecalc:  SSERROR;
		FUNCTION ClearClipboard:  SSERROR;
		FUNCTION ClearRange (nR1, nC1, nR2, nC2:  RC; nClearType:  Integer):  SSERROR;
		FUNCTION ColorPaletteDlg:  SSERROR;
		FUNCTION ColWidthDlg:  SSERROR;
		FUNCTION CopyAll (hSrcSS:  SShandle):  SSERROR;
		FUNCTION CopyRange (nDstR1, nDstC1, nDstR2, nDstC2:  RC;
   						SrcSS:  CSS;
           	            nSrcR1, nSrcC1, nSrcR2, nSrcC2:  RC):  SSERROR;

		FUNCTION DefinedNameDlg:  SSERROR;
		FUNCTION DeleteDefinedName (pName:  String):  SSERROR;
       FUNCTION DeleteRange (nR1, nC1, nR2, nC2:  RC;
   						  nShiftType:  Integer):  SSERROR;
		FUNCTION DeleteTable:  SSERROR;
		FUNCTION EditClear (nClearType:  Integer):  SSERROR;
		FUNCTION EditCopy:  SSERROR;
		FUNCTION EditCopyDown:  SSERROR;
		FUNCTION EditCopyRight:  SSERROR;
		FUNCTION EditCut:  SSERROR;
		FUNCTION EditDelete (nShiftType:  Integer):  SSERROR;
		FUNCTION EditInsert (nShiftType:  Integer):  SSERROR;
		FUNCTION EditPaste:  SSERROR;
		FUNCTION EndEdit:  SSERROR;
		FUNCTION ErrorNumberToText (nError:  SSERROR; VAR pBuf:  String):  SSERROR;
		FUNCTION FilePageSetupDlg:  SSERROR;
		FUNCTION FilePrint (bShowPrintDlg:  Boolean):  SSERROR;
		FUNCTION FilePrintSetupDlg:  SSERROR;
		FUNCTION FormatAlignmentDlg:  SSERROR;
		FUNCTION FormatBorderDlg:  SSERROR;
		FUNCTION FormatCurrency0:  SSERROR;
		FUNCTION FormatCurrency2:  SSERROR;
		FUNCTION FormatFixed:  SSERROR;
		FUNCTION FormatFixed2:  SSERROR;
		FUNCTION FormatFontDlg:  SSERROR;
		FUNCTION FormatFraction:  SSERROR;
		FUNCTION FormatGeneral:  SSERROR;
		FUNCTION FormatHmmampm:  SSERROR;
		FUNCTION FormatMdyy:  SSERROR;
		FUNCTION FormatNumberDlg:  SSERROR;
		FUNCTION FormatPatternDlg:  SSERROR;
		FUNCTION FormatPercent:  SSERROR;
		FUNCTION FormatRCNr (nRow, nCol:  RC;
   						 bDoAbsolute:  Boolean;
           	             pBuf:  PChar; nBufSize:  Integer):  SSERROR;
		FUNCTION FormatScientific:  SSERROR;
		FUNCTION GetActiveCell (VAR pRow, pCol:  RC):  SSERROR;
		FUNCTION GetAllowArrows (VAR Allow:  Boolean):  SSERROR;
		FUNCTION GetAllowDelete (VAR Allow:  Boolean):  SSERROR;
		FUNCTION GetAllowEditHeaders (VAR Allow:  Boolean):  SSERROR;
		FUNCTION GetAllowFillRange (VAR Allow:  Boolean):  SSERROR;
		FUNCTION GetAllowInCellEditing (VAR Allow:  Boolean):  SSERROR;
		FUNCTION GetAllowMoveRange (VAR Allow:  Boolean):  SSERROR;
		FUNCTION GetAllowResize (VAR Allow:  Boolean):  SSERROR;
		FUNCTION GetAllowSelections (VAR Allow:  Boolean):  SSERROR;
		FUNCTION GetAllowTabs (VAR Allow:  Boolean):  SSERROR;
		FUNCTION GetAllowFormulas (VAR Allow:  Boolean):  SSERROR;
		FUNCTION GetAutoRecalc (VAR pAutoRecalc:  Boolean):  SSERROR;
		FUNCTION GetBackColor (VAR pBackColor:  COLORREF):  SSERROR;
		FUNCTION GetColWidth (nCol:  RC; VAR pWidth:  Integer):  SSERROR;
		FUNCTION GetDefinedName (CONST pName:  String; VAR pBuf:  String):  SSERROR;
		FUNCTION GetEnableProtection (VAR pEnableProtection:  Boolean):  SSERROR;
		FUNCTION GetEnterMovesDown (VAR pEnterMovesDown:  Boolean):  SSERROR;
		FUNCTION GetEntry (VAR pBuf:  String):  SSERROR;
		FUNCTION GetEntryRC (nRow, nCol:  RC; VAR pBuf:  String):  SSERROR;
		FUNCTION GetExtraColor (VAR pExtraColor:  COLORREF):  SSERROR;
		FUNCTION GetFireEvent (nEvent:  Word; VAR pFireIt:  Boolean):  SSERROR;
		FUNCTION GetFixedCols (VAR pC1, pCols:  RC):  SSERROR;
		FUNCTION GetFixedRows (VAR pR1, pRows:  RC):  SSERROR;
		FUNCTION GetFormattedText (VAR pBuf:  String):  SSERROR;
		FUNCTION GetFormattedTextRC (nRow, nCol:  RC; VAR pBuf:  String):  SSERROR;
		FUNCTION GetFormula (VAR pBuf:  String):  SSERROR;
		FUNCTION GetFormulaRC (nRow, nCol:  RC; VAR pBuf:  String):  SSERROR;
		FUNCTION GetHdrSelection (VAR pTopLeftHdr, pRowHdr, pColHdr:  Boolean):  SSERROR;
		FUNCTION GetIteration (VAR pIteration:  Boolean;
   						   VAR pMaxIterations:  Integer;
           	               VAR pMaxChange:  Double):  SSERROR;
		FUNCTION GetLastCol (VAR pLastCol:  RC):  SSERROR;
		FUNCTION GetLastColForRow (nRow:  RC;  VAR pLastColForRow:  RC):  SSERROR;
		FUNCTION GetLastRow (VAR pLastRow:  RC):  SSERROR;
		FUNCTION GetLeftCol (VAR pLeftCol:  RC):  SSERROR;
		FUNCTION GetLogicalRC (nRow, nCol:  RC; VAR pIsTrue:  Boolean):  SSERROR;
		FUNCTION GetMinCol (VAR pMinCol:  RC):  SSERROR;
		FUNCTION GetMinRow (VAR pMinRow:  RC):  SSERROR;
		FUNCTION GetMaxCol (VAR pMaxCol:  RC):  SSERROR;
		FUNCTION GetMaxRow (VAR pMaxRow:  RC):  SSERROR;
		FUNCTION GetNumber (VAR pNumber:  Double):  SSERROR;
		FUNCTION GetNumberRC (nRow, nCol:  RC; VAR pNumber:  Double):  SSERROR;
		FUNCTION GetPrintArea (VAR pBuf:  String):  SSERROR;
		FUNCTION GetPrintBottomMargin (VAR pPrintBottomMargin:  Double):  SSERROR;
		FUNCTION GetPrintColHeading (VAR pPrintColHeading: Boolean):  SSERROR;
		FUNCTION GetPrintFooter (VAR pBuf:  String):  SSERROR;
		FUNCTION GetPrintGridLines (VAR pPrintGridLines:  Boolean):  SSERROR;
		FUNCTION GetPrintHCenter (VAR pPrintHCenter: Boolean):  SSERROR;
		FUNCTION GetPrintHeader (VAR pBuf:  String):  SSERROR;
		FUNCTION GetPrintLeftMargin (VAR pPrintLeftMargin:  Double):  SSERROR;
		FUNCTION GetPrintLeftToRight (VAR pPrintLeftToRight:  Boolean):  SSERROR;
		FUNCTION GetPrintNoColor (VAR pNoColor:  Boolean):  SSERROR;
		FUNCTION GetPrintRightMargin (VAR pPrintRightMargin:  Double):  SSERROR;
		FUNCTION GetPrintRowHeading (VAR pPrintRowHeading:  Boolean):  SSERROR;
		FUNCTION GetPrintTitles (VAR pBuf:  String):  SSERROR;
		FUNCTION GetPrintTopMargin (VAR pPrintTopMargin:  Double):  SSERROR;
		FUNCTION GetPrintVCenter (VAR pPrintVCenter:  Boolean):  SSERROR;
		FUNCTION GetRepaint (VAR pRepaint:  Boolean):  SSERROR;
		FUNCTION GetRowHeight (nRow:  RC; VAR pHeight:  Integer):  SSERROR;
		FUNCTION GetRowMode (VAR pRowMode:  Boolean):  SSERROR;
		FUNCTION GetSelection (nSelection:  Integer;
   					   VAR pR1, pC1, pR2, pC2:  RC):  SSERROR;
		FUNCTION GetSelectionCount (VAR pCount:  Integer):  SSERROR;
		FUNCTION GetSelectionRef (VAR pBuf:  String):  SSERROR;
		FUNCTION GetShowColHeading (VAR pShowColHeading:  Boolean):  SSERROR;
		FUNCTION GetShowFormulas (VAR pShowFormulas:  Boolean):  SSERROR;
		FUNCTION GetShowGridLines (VAR pShowGridLines:  Boolean):  SSERROR;
		FUNCTION GetShowHScrollBar (VAR pShowHScrollBar:  Integer):  SSERROR;
		FUNCTION GetShowRowHeading (VAR pShowRowHeading:  Boolean):  SSERROR;
		FUNCTION GetShowSelections (VAR pShowSelections:  Integer):  SSERROR;
		FUNCTION GetShowVScrollBar (VAR pShowVScrollBar:  Integer):  SSERROR;
		FUNCTION GetShowZeroValues (VAR pShowZeroValues:  Boolean):  SSERROR;
		FUNCTION GetSSEdit (VAR pSSEdit:  SSEDIThandle):  SSERROR;
		FUNCTION GetText (pBuf:  PChar):  SSERROR;
		FUNCTION GetTextRC (nRow, nCol:  RC; pBuf:  PChar):  SSERROR;
		FUNCTION GetString (VAR pBuf:  String):  SSERROR;
		FUNCTION GetStringRC (nRow, nCol:  RC; VAR pBuf:  String):  SSERROR;
		FUNCTION GetTitle (VAR pBuf:  String):  SSERROR;
		FUNCTION GetTopRow (VAR pTopRow:  RC):  SSERROR;
		FUNCTION GetTypeRC (nRow, nCol:  RC; VAR pType:  Integer):  SSERROR;
		FUNCTION GotoDlg:  SSERROR;
		FUNCTION InitTable:  SSERROR;
		FUNCTION InsertRange (nR1, nC1, nR2, nC2:  RC; nShiftType:  Integer):  SSERROR;
		FUNCTION LaunchAppDesigner:  SSERROR;
		FUNCTION MaxCol:  RC;
		FUNCTION MaxRow:  RC;
		FUNCTION MoveRange (nR1, nC1, nR2, nC2, nRowOffset, nColOffset:  RC):  SSERROR;
		FUNCTION NextColPageBreak (nCol:  RC;  VAR pNextCol:  RC):  SSERROR;
		FUNCTION NextRowPageBreak (nRow:  RC;  VAR pNextRow:  RC):  SSERROR;
		FUNCTION OpenFileDlg (CONST pTitle:  String; hWndParent:  HWND;
   						    VAR pBuf:  String):  SSERROR;
		FUNCTION ProtectionDlg:  SSERROR;
		FUNCTION RangeToTwips (nRow1, nCol1, nRow2, nCol2:  RC;
   					   VAR pX, pY, pCX, pCY:  Longint;
           	           VAR pShown:  Integer):  SSERROR;
		FUNCTION Read (CONST pPathName:  String; VAR pFileType:  Integer):  SSERROR;
		FUNCTION ReadIO (dwUserData:  DWORD; ioFunction:  IOFUNC;
   				 VAR pUserRet:  DWORD):  SSERROR;
		FUNCTION Recalc:  SSERROR;
		FUNCTION RemoveColPageBreak (nCol:  RC):  SSERROR;
		FUNCTION RemovePageBreak:  SSERROR;
		FUNCTION RemoveRowPageBreak (nRow:  RC):  SSERROR;
		FUNCTION RowHeightDlg:  SSERROR;
		FUNCTION SaveFileDlg (CONST pTitle:  String; VAR pBuf:  String;
   					  VAR pFileType:  Integer):  SSERROR;
		FUNCTION SaveWindowInfo:  SSERROR;
		FUNCTION SetActiveCell (nRow, nCol:  RC):  SSERROR;
		FUNCTION SetAlignment (nHorizontal:  Integer; bWordWrap:  Boolean;
   						   nVertical, nOrientation:  Integer):  SSERROR;
		FUNCTION SetAllowArrows (Allow:  Boolean):  SSERROR;
		FUNCTION SetAllowDelete (Allow:  Boolean):  SSERROR;
		FUNCTION SetAllowEditHeaders (Allow:  Boolean):  SSERROR;
		FUNCTION SetAllowFillRange (Allow:  Boolean):  SSERROR;
		FUNCTION SetAllowInCellEditing (Allow:  Boolean):  SSERROR;
		FUNCTION SetAllowMoveRange (Allow:  Boolean):  SSERROR;
		FUNCTION SetAllowResize (Allow:  Boolean):  SSERROR;
		FUNCTION SetAllowSelections (Allow:  Boolean):  SSERROR;
		FUNCTION SetAllowTabs (Allow:  Boolean):  SSERROR;
		FUNCTION SetAllowFormulas (Allow:  Boolean):  SSERROR;
		FUNCTION SetAppName (CONST pAppName:  String):  SSERROR;
		FUNCTION SetAutoRecalc (bAutoRecalc:  Boolean):  SSERROR;
		FUNCTION SetBackColor (crBackColor:  COLORREF):  SSERROR;
		FUNCTION SetBorder (nOutline, nLeft, nRight,
							nTop, nBottom, nShade:  Integer;
							crOutline, crLeft, crRight,
               	        crTop, crBottom:  COLORREF):  SSERROR;
		FUNCTION SetColText (nCol:  RC; CONST pColText:  String):  SSERROR;
		FUNCTION SetColWidth (nC1, nC2:  RC;
   						  nWidth:  Integer; bDefColWidth:  Boolean):  SSERROR;
		FUNCTION SetColWidthAuto (nR1, nC1, nR2, nC2:  RC; bSetDefaults:  Boolean):  SSERROR;
		FUNCTION SetDefinedName (CONST pName, pFormula:  String):  SSERROR;
		FUNCTION SetDefWindowProc (pWindowProc:  Pointer):  SSERROR;
		FUNCTION SetDoSetCursor (bDoSetCursor:  Boolean):  SSERROR;
		FUNCTION SetEnableProtection (bEnableProtection:  Boolean):  SSERROR;
		FUNCTION SetEnterMovesDown (bEnterMovesDown:  Boolean):  SSERROR;
		FUNCTION SetEntry (CONST pEntry:  String):  SSERROR;
		FUNCTION SetEntryRC (nRow, nCol:  RC; CONST pEntry:  String):  SSERROR;
		FUNCTION SetExtraColor (crExtraColor:  COLORREF):  SSERROR;
		FUNCTION SetFireEvent (nEvent:  Word; bFireIt:  Boolean):  SSERROR;
		FUNCTION SetFixedCols (nC1, nCols:  RC):  SSERROR;
		FUNCTION SetFixedRows (nR1, nRows:  RC):  SSERROR;
		FUNCTION SetFont (CONST pName:  String; nSize:  Integer;
   					  bBold, bItalic, bUnderline, bStrikeout:  Boolean;
           	          crColor:  COLORREF;
               	      bOutline, bShadow:  Boolean):  SSERROR;
		FUNCTION SetFormula (CONST pFormula:  String):  SSERROR;
		FUNCTION SetFormulaRC (nRow, nCol:  RC; CONST pFormula:  String):  SSERROR;
		FUNCTION SetHdrHeight (nHeight:  Integer):  SSERROR;
		FUNCTION SetHdrSelection (bTopLeftHdr, bRowHdr, bColHdr:  Boolean):  SSERROR;
		FUNCTION SetHdrWidth (nWidth:  Integer):  SSERROR;
		FUNCTION SetIteration (bIteration:  Boolean; nMaxIterations:  Integer;
   						   nMaxChange:  Double):  SSERROR;
		FUNCTION SetLeftCol (nLeftCol:  RC):  SSERROR;
		FUNCTION SetLogicalRC (nRow, nCol:  RC; bIsTrue:  Boolean):  SSERROR;
		FUNCTION SetMinCol (nMinCol:  RC):  SSERROR;
		FUNCTION SetMinRow (nMinRow:  RC):  SSERROR;
		FUNCTION SetMaxCol (nMaxCol:  RC):  SSERROR;
		FUNCTION SetMaxRow (nMaxRow:  RC):  SSERROR;
		FUNCTION SetNumber (nNumber:  Double):  SSERROR;
		FUNCTION SetNumberFormat (CONST pNumberFormat:  String):  SSERROR;
		FUNCTION SetNumberRC (nRow, nCol: RC;  nNumber:  Double):  SSERROR;
		FUNCTION SetPattern (nPattern:  Integer; crFG, crBG: COLORREF):  SSERROR;
		FUNCTION SetPrintArea (CONST pFormula:  String):  SSERROR;
		FUNCTION SetPrintAreaFromSelection:  SSERROR;
		FUNCTION SetPrintBottomMargin (nMargin:  Double):  SSERROR;
		FUNCTION SetPrintColHeading (bColHeading:  Boolean):  SSERROR;
		FUNCTION SetPrintFooter (CONST pPrintFooter:  String):  SSERROR;
		FUNCTION SetPrintGridLines (bGridLines:  Boolean):  SSERROR;
		FUNCTION SetPrintHCenter (bHCenter:  Boolean):  SSERROR;
		FUNCTION SetPrintHeader (CONST pPrintHeader:  String):  SSERROR;
		FUNCTION SetPrintLeftMargin (nMargin:  Double):  SSERROR;
		FUNCTION SetPrintLeftToRight (bLeftToRight:  Boolean):  SSERROR;
		FUNCTION SetPrintNoColor (bNoColor:  Boolean):  SSERROR;
		FUNCTION SetPrintRightMargin (nMargin:  Double):  SSERROR;
		FUNCTION SetPrintRowHeading (bRowHeading:  Boolean):  SSERROR;
		FUNCTION SetPrintTitles (CONST pFormula:  String):  SSERROR;
		FUNCTION SetPrintTitlesFromSelection:  SSERROR;
		FUNCTION SetPrintTopMargin (nMargin:  Double):  SSERROR;
		FUNCTION SetPrintVCenter (bVCenter:  Boolean):  SSERROR;
		FUNCTION SetProtection (bLocked, bHidden:  Boolean):  SSERROR;
		FUNCTION SetRepaint (bRepaint:  Boolean):  SSERROR;
		FUNCTION SetRowHeight (nR1, nR2:  RC;
   						   nHeight:  Integer; bDefRowHeight:  Boolean):  SSERROR;
		FUNCTION SetRowHeightAuto (nR1, nC1, nR2, nC2:  RC; bSetDefaults:  Boolean):  SSERROR;
		FUNCTION SetRowMode (bRowMode:  Boolean):  SSERROR;
		FUNCTION SetRowText (nRow:  RC; CONST pRowText:  String):  SSERROR;
		FUNCTION SetSelection (nR1, nC1, nR2, nC2:  RC):  SSERROR;
		FUNCTION SetSelectionRef (CONST pFormula:  String):  SSERROR;
		FUNCTION SetShowColHeading (bColHeading:  Boolean):  SSERROR;
		FUNCTION SetShowFormulas (bFormulas:  Boolean):  SSERROR;
		FUNCTION SetShowGridLines (bGridLines:  Boolean):  SSERROR;
		FUNCTION SetShowHScrollBar (nShowHScrollBar:  Integer):  SSERROR;
		FUNCTION SetShowRowHeading (bRowHeading:  Boolean):  SSERROR;
		FUNCTION SetShowSelections (nSelections:  Integer):  SSERROR;
		FUNCTION SetShowVScrollBar (nShowVScrollBar:  Integer):  SSERROR;
		FUNCTION SetShowZeroValues (bZeroValues:  Boolean):  SSERROR;
		FUNCTION SetSSEdit (hSSEdit:  SSEDIThandle):  SSERROR;
		FUNCTION SetText (pText:  PChar):  SSERROR;
		FUNCTION SetTextRC (nRow, nCol:  RC;  pText:  PChar):  SSERROR;
		FUNCTION SetString (CONST pText:  String):  SSERROR;
		FUNCTION SetStringRC (nRow, nCol:  RC;  CONST pText:  String):  SSERROR;
		FUNCTION SetTitle (CONST pTitle:  String):  SSERROR;
		FUNCTION SetTopLeftText (CONST pTopLeftText:  String):  SSERROR;
		FUNCTION SetTopRow (nTopRow:  RC):  SSERROR;
		FUNCTION ShowActiveCell:  SSERROR;
		FUNCTION Sort (nR1, nC1, nR2, nC2:  RC;
   				   bSortByRows:  Boolean; CONST pKeys:  ARRAY OF Integer; nKeys:  Integer):  SSERROR;
		FUNCTION Sort3 (nR1, nC1, nR2, nC2:  RC;
   					bSortByRows:  Boolean;
           	        nKey1, nKey2, nKey3:  Integer):  SSERROR;
		FUNCTION SortDlg:  SSERROR;
		FUNCTION StartEdit (bClear, bInCellEditFocus, bArrowsExitEditMode:  Boolean):  SSERROR;
		FUNCTION SwapTables (hSS2:  SShandle):  SSERROR;
		FUNCTION TransactCommit:  SSERROR;
		FUNCTION TransactRollback:  SSERROR;
		FUNCTION TransactStart:  SSERROR;
		FUNCTION TwipsToRC (x, y:  Longint; VAR pRow, pCol:  RC):  SSERROR;
		FUNCTION PixelsToRC (x, y:  Integer; VAR pRow, pCol:  RC):  SSERROR;
		FUNCTION Write (CONST pPathName:  String; nFileType:  Integer):  SSERROR;
		FUNCTION WriteIO (dwUserData:  DWORD; ioFunction:  IOFUNC;
   				  VAR pUserRet:  DWORD):  SSERROR;
	PRIVATE
		m_hSS:  SShandle;
       PixelsX,
       PixelsY:	Longint;
	END;

PROCEDURE SSUpdate;
FUNCTION SSVersion:  Word;

IMPLEMENTATION

CONST
	kMaxEditLength = 1024;

	kFormatRCNrBufSize = 16;

	kFileFormulaOne = 1;
	kFileExcel4 = 2;
	kFileTabbedText = 3;	{ Only SSRead() supports this type.}

	kClearDlg = 0;
	kClearAll = 1;
	kClearFormats = 2;
	kClearValues = 3;

FUNCTION SSAddColPageBreak (hSS:  SShandle; nCol:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSAddPageBreak (hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSAddRowPageBreak (hSS:  SShandle; nRow:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSAddSelection (hSS:  SShandle; nR1, nC1, nR2, nC2:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSAttach (hSS:  SShandle; pTitle:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSAttachToSS (hDstSS, hSrcSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSCalculationDlg (hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSCallWindowProc(hSS:  SShandle;
						nMessage, wParam: Word;
                       lParam:  Longint): Longint;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSCancelEdit (hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSCanEditPaste (hSS:  SShandle; pCanEditPaste:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSCheckModified (hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSCheckRecalc (hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSClearClipboard: SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSClearRange (hSS:  SShandle; nR1, nC1, nR2, nC2:  RC;
						nClearType:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSColorPaletteDlg (hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSColWidthDlg (hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSCopyAll (hDstSS, hSrcSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';

FUNCTION SSCopyRange(hDstSS:  SShandle;
					 nDstR1, nDstC1, nDstR2, nDstC2:  RC;
                    hSrcSS:  SShandle;
                    nSrcR1, nSrcC1, nSrcR2, nSrcC2:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSDefinedNameDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSDelete(hSS:  SShandle; bSendDeleteTableMsg:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSDeleteDefinedName(hSS:  SShandle; pName:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSDeleteRange(hSS:  SShandle;
						nR1, nC1, nR2, nC2:  RC;
                       nShiftType:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSDeleteTable(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditBarDelete(hSSEdit:  SSEDIThandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditBarHeight: Integer;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditBarMove(hSSEdit:  SSEDIThandle;
						 x, y, cx, cy:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditBarNew(hWndParent:  HWND;
					pSSEdit: Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditClear(hSS:  SShandle; nClearType:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditCopy(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditCopyDown(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditCopyRight(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditCut(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditDelete(hSS:  SShandle; nShiftType:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditInsert(hSS:  SShandle; nShiftType:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEditPaste(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSEndEdit(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSErrorNumberToText(nError:  SSERROR;
							 pBuf:  Pchar;
                            nBufSize:  INteger): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFilePageSetupDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFilePrint(hSS:  SShandle; bShowPrintDlg:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFilePrintSetupDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatAlignmentDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatBorderDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatCurrency0(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatCurrency2(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatFixed(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';

FUNCTION SSFormatFixed2(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatFontDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatFraction(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatGeneral(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatHmmampm(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatMdyy(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatNumberDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatPatternDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatPercent(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatRCNr(hSS:  SShandle; nRow, nCol:  RC;
					   bDoAbsolute:  Word;
                      pBuf:  PChar; nBufSize:  INteger): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSFormatScientific(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetActiveCell(hSS:  SShandle; pRow, pCol:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAllowArrows(hSS:  SShandle; pAllowArrows:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAllowDelete(hSS:  SShandle; pAllowDelete:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAllowEditHeaders(hSS:  SShandle; pAllowEditHeaders:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAllowFillRange(hSS:  SShandle; pAllowFillRange:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAllowInCellEditing(hSS:  SShandle; pAllowInCellEditing:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAllowMoveRange(hSS:  SShandle; pAllowMoveRange:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAllowResize(hSS:  SShandle; pAllowResize:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAllowSelections(hSS:  SShandle; pAllowSelections:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAllowTabs(hSS:  SShandle; pAllowTabs:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAllowFormulas(hSS:  SShandle; pAllowFormulas:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetAutoRecalc(hSS:  SShandle; pAutoRecalc:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetBackColor(hSS:  SShandle; pBackColor:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetColWidth(hSS:  SShandle; nCol:  RC; pWidth:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetDefinedName(hSS:  SShandle; pName, pBuf:  PChar;
						   nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetEnableProtection(hSS:  SShandle; pEnableProtection:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetEnterMovesDown(hSS:  SShandle; pEnterMovesDown: Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetEntry(hSS:  SShandle; pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetEntryRC(hSS:  SShandle; nRow, nCol:  RC;
					   pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetExtraColor(hSS:  SShandle; pExtraColor:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetFireEvent(hSS:  SShandle; nEvent:  Word; pFireIt:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetFixedCols(hSS:  SShandle; pC1, pCols:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetFixedRows(hSS:  SShandle; pR1, pRows:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetFormattedText(hSS:  SShandle; pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetFormattedTextRC(hSS:  SShandle; nRow, nCol:  RC;
							   pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetFormula(hSS:  SShandle; pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetFormulaRC(hSS:  SShandle; nRow, nCol:  RC;
						 pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetHdrSelection(hSS:  SShandle; pTopLeftHdr, pRowHdr, pColHdr:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetIteration(hSS:  SShandle; pIteration, pMaxIterations, pMaxChange:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetLastCol(hSS:  SShandle; pLastCol:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetLastColForRow(hSS:  SShandle; nRow:  RC; pLastColForRow:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetLastRow(hSS:  SShandle; pLastRow:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetLeftCol(hSS:  SShandle; pLeftCol:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetLogicalRC(hSS:  SShandle; nRow, nCol:  RC;
						 pIsTrue:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetMinCol(hSS:  SShandle; pMinCol:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetMinRow(hSS:  SShandle; pMinRow:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetMaxCol(hSS:  SShandle; pMaxCol:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetMaxRow(hSS:  SShandle; pMaxRow:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetNumber(hSS:  SShandle; pNumber:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetNumberRC(hSS:  SShandle; nRow, nCol:  RC;
						pNumber:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintArea(hSS:  SShandle; pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintBottomMargin(hSS:  SShandle; pPrintBottomMargin:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintColHeading(hSS:  SShandle; pPrintColHeading:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintFooter(hSS:  SShandle; pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintGridLines(hSS:  SShandle; pPrintGridLines:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintHCenter(hSS:  SShandle; pPrintHCenter:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintHeader(hSS:  SShandle; pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintLeftMargin(hSS:  SShandle; pPrintLeftMargin:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintLeftToRight(hSS:  SShandle; pPrintLeftToRight:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintNoColor(hSS:  SShandle; pNoColor:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintRightMargin(hSS:  SShandle; pPrintRightMargin:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintRowHeading(hSS:  SShandle; pPrintRowHeading:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintTitles(hSS:  SShandle; pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintTopMargin(hSS:  SShandle; pPrintTopMargin:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetPrintVCenter(hSS:  SShandle; pPrintVCenter:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetRepaint(hSS:  SShandle; pRepaint:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetRowHeight(hSS:  SShandle; nRow:  RC; pHeight: Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetRowMode(hSS:  SShandle; pRowMode:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetSelection(hSS:  SShandle; nSelection:  Integer;
						 pR1, pC1, pR2, pC2:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetSelectionCount(hSS:  SShandle; pCount:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetSelectionRef(hSS:  SShandle; pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetShowColHeading(hSS:  SShandle; pShowColHeading:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetShowFormulas(hSS:  SShandle; pShowFormulas:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetShowGridLines(hSS:  SShandle; pShowGridLines:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetShowHScrollBar(hSS:  SShandle; pShowHScrollBar:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetShowRowHeading(hSS:  SShandle; pShowRowHeading:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetShowSelections(hSS:  SShandle; pShowSelections:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetShowVScrollBar(hSS:  SShandle; pShowVScrollBar:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetShowZeroValues(hSS:  SShandle; pShowZeroValues:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetSSEdit(hSS:  SShandle; phSSEdit:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetText(hSS:  SShandle; pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetTextRC(hSS:  SShandle; nRow, nCol:  RC;
					  pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetTitle(hSS:  SShandle; pBuf:  PChar; nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetTopRow(hSS:  SShandle; pTopRow:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGetTypeRC(hSS:  SShandle; nRow, nCol:  RC; pType:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSGotoDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSInitTable(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSInsertRange(hSS:  SShandle; nR1, nC1, nR2, nC2:  RC;
					    nShiftType:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSLaunchAppDesigner(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSMaxCol:  RC;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSMaxRow:  RC;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSMoveRange(hSS:  SShandle; nR1, nC1, nR2, nC2, nRowOffset, nColOffset:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSNew(Windowhandle: HWND; pSS:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSNextColPageBreak(hSS:  SShandle; nCol:  RC; pNextCol:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSNextRowPageBreak(hSS:  SShandle; nRow:  RC; pNextRow:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSOpenFileDlg(pTitle:  PChar; hWndParent:  HWND;
					    pBuf:  PChar;  nBufSize:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSProtectionDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSRangeToTwips(hSS:  SShandle; nRow1, nCol1, nRow2, nCol2:  RC;
						 pX, pY, pCX, pCY:  Pointer;
                        pShown:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSRead(hSS:  SShandle; pPathName:  PChar; pFileType:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSReadIO(hSS:  SShandle; dwUserData:  DWORD;
				   ioFunction:  IOFUNC; pUserRet:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSRecalc(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSRemoveColPageBreak(hSS:  SShandle; nCol:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSRemovePageBreak(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSRemoveRowPageBreak(hSS:  SShandle; nRow:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSRowHeightDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSaveFileDlg(hSS:  SShandle; pTitle, pBuf:  PCHAR; nBufSize:  Integer;
					    pFileType:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSaveWindowInfo(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetActiveCell(hSS:  SShandle; nRow, nCol:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAlignment(hSS:  SShandle; nHorizontal:  Integer;
					     bWordWrap:  Word;
                        nVertical, nOrientation:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAllowArrows(hSS:  SShandle; bAllowArrows:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAllowDelete(hSS:  SShandle; bAllowDelete:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAllowEditHeaders(hSS:  SShandle; bAllowEditHeaders:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAllowFillRange(hSS:  SShandle; bAllowFillRange:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAllowInCellEditing(hSS:  SShandle; bAllowInCellEditing:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAllowMoveRange(hSS:  SShandle; bAllowMoveRange:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAllowResize(hSS:  SShandle; bAllowResize:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAllowSelections(hSS:  SShandle; bAllowSelections:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAllowTabs(hSS:  SShandle; bAllowTabs:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAllowFormulas(hSS:  SShandle; bAllowFormulas:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAppName(hSS:  SShandle; pAppName:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetAutoRecalc(hSS:  SShandle; bAutoRecalc:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetBackColor(hSS:  SShandle; crBackColor:  COLORREF): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetBorder(hSS:  SShandle; nOutline, nLeft, nRight, nTop, nBottom, nShade:  Integer;
					  crOutline, crLeft, crRight, crTop, crBottom:  COLORREF): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetColText(hSS:  SShandle; nCol:  RC;  pColText:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetColWidth(hSS:  SShandle; nC1, nC2:  RC;
						nWidth:  Integer; bDefColWidth:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetColWidthAuto(hSS:  SShandle; nR1, nC1, nR2, nC2:  RC;
							bSetDefaults:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetDefinedName(hSS:  SShandle; pName, pFormula:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetDefWindowProc(hSS:  SShandle; pWindowProc:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetDoSetCursor(hSS:  SShandle; bDoSetCursor:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetEnableProtection(hSS:  SShandle; bEnableProtection:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetEnterMovesDown(hSS:  SShandle; bEnterMovesDown:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetEntry(hSS:  SShandle; pEntry: PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetEntryRC(hSS:  SShandle; nRow, nCol: RC; pEntry: PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetExtraColor(hSS:  SShandle; crExtraColor:  COLORREF): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetFireEvent(hSS:  SShandle; nEvent, bFireIt:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetFixedCols(hSS:  SShandle; nC1, nCols:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetFixedRows(hSS:  SShandle; nR1, nRows:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetFont(hSS:  SShandle; pName:  PChar;
					nSize:  Integer; bBold, bItalic, bUnderline, bStrikeout: Word;
                   crColor:  COLORREF; bOutline, bShadow:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetFormula(hSS:  SShandle; pFormula:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetFormulaRC(hSS:  SShandle; nRow, nCol:  RC;
						 pFormula:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetHdrHeight(hSS:  SShandle; nHeight:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetHdrSelection(hSS:  SShandle; bTopLeftHdr, bRowHdr, bColHdr:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetHdrWidth(hSS:  SShandle; nWidth:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetIteration(hSS:  SShandle; bIteration:  Word;
						 nMaxIterations:  Integer;
                        nMaxChange:  Double): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetLeftCol(hSS:  SShandle; nLeftCol:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetLogicalRC(hSS:  SShandle; nRow, nCol:  RC; bIsTrue:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetMinCol(hSS:  SShandle; nMinCol:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetMinRow(hSS:  SShandle; nMinRow:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetMaxCol(hSS:  SShandle; nMaxCol:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetMaxRow(hSS:  SShandle; nMaxRow:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetNumber(hSS:  SShandle; nNumber:  Double): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetNumberFormat(hSS:  SShandle; pNumberFormat:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetNumberRC(hSS:  SShandle; nRow, nCol:  RC; nNumber:  Double): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPattern(hSS:  SShandle; nPattern:  Integer;
					   crFG, crBG:  COLORREF): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintArea(hSS:  SShandle; pFormula:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintAreaFromSelection(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintBottomMargin(hSS:  SShandle; nMargin:  Double): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintColHeading(hSS:  SShandle; bColHeading:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintFooter(hSS:  SShandle; pPrintFooter:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintGridLines(hSS:  SShandle; bGridLines:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintHCenter(hSS:  SShandle; bHCenter:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintHeader(hSS:  SShandle; pPrintHeader:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintLeftMargin(hSS:  SShandle; nMargin:  Double): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintLeftToRight(hSS:  SShandle; bLeftToRight:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintNoColor(hSS:  SShandle; bNoColor:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintRightMargin(hSS:  SShandle; nMargin:  Double): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintRowHeading(hSS:  SShandle; bRowHeading:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintTitles(hSS:  SShandle; pFormula:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintTitlesFromSelection(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintTopMargin(hSS:  SShandle; nMargin:  Double): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetPrintVCenter(hSS:  SShandle; bVCenter:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetProtection(hSS:  SShandle; bLocked, bHidden:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetRepaint(hSS:  SShandle; bRepaint:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetRowHeight(hSS:  SShandle; nR1, nR2:  RC;
					 	 nHeight:  Integer; bDefRowHeight: Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetRowHeightAuto(hSS:  SShandle; nR1, nC1, nR2, nC2:  RC;
							 bSetDefaults:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetRowMode(hSS:  SShandle; bRowMode:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetRowText(hSS:  SShandle; nRow:  RC; pRowText:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetSelection(hSS:  SShandle; nR1, nC1, nR2, nC2:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetSelectionRef(hSS:  SShandle; pFormula:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetShowColHeading(hSS:  SShandle; bColHeading:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetShowFormulas(hSS:  SShandle; bFormulas:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetShowGridLines(hSS:  SShandle; bGridLines:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetShowHScrollBar(hSS:  SShandle; nShowHScrollBar:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetShowRowHeading(hSS:  SShandle; bRowHeading:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetShowSelections(hSS:  SShandle; nSelections:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetShowVScrollBar(hSS:  SShandle; nShowVScrollBar:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetShowZeroValues(hSS:  SShandle; bZeroValues:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetSSEdit(hSS:  SShandle; hSSEdit:  SSEDIThandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetText(hSS:  SShandle; pText:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetTextRC(hSS:  SShandle; nRow, nCol:  RC; pText:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetTitle(hSS:  SShandle; pTitle:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetTopLeftText(hSS:  SShandle; pTopLeftText:  PChar): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSetTopRow(hSS:  SShandle; nTopRow:  RC): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSShowActiveCell(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSort(hSS:  SShandle; nR1, nC1, nR2, nC2:  RC;
				 bSortByRows:  Word;
                pKeys:  Pointer; nKeys:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSort3(hSS:  SShandle; nR1, nC1, nR2, nC2:  RC;
				  bSortByRows:  Word;
                 nKey1, nKey2, nKey3:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSortDlg(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSStartEdit(hSS:  SShandle; bClear, bInCellEditFocus, bArrowsExitEditMode:  Word): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSSwapTables(hSS1, hSS2:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSTransactCommit(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSTransactRollback(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSTransactStart(hSS:  SShandle): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSTwipsToRC(hSS:  SShandle; x, y:  Longint; pRow, pCol:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
PROCEDURE SSUpdate; EXTERNAL 'VTSSDLL';
FUNCTION SSVersion:  Word; EXTERNAL 'VTSSDLL';
FUNCTION SSWrite(hSS:  SShandle; pPathName:  PChar;  nFileType:  Integer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';
FUNCTION SSWriteIO(hSS:  SShandle; dwUserData:  DWORD;
				    ioFunction:  IOFUNC; pUserRet:  Pointer): SSERROR;
	FAR; EXTERNAL 'VTSSDLL';

CONSTRUCTOR CSSEdit.MakeCSSEdit (hSSEdit:  SSEDIThandle);
BEGIN
	INHERITED Create;
	m_hSSEdit := hSSEdit
END;


FUNCTION CSSEdit.Height:  Integer;
BEGIN
	Result := SSEditBarHeight
END;

FUNCTION CSSEdit.Move (x, y, cx, cy:  Integer):  SSERROR;
BEGIN
	Result := SSEditBarMove (m_hSSEdit, x, y, cx, cy)
END;

FUNCTION CSSEdit.MakeNew (hWndParent:  HWND):  SSERROR;
BEGIN
	Result := SSEditBarNew (hWndParent, m_hSSEdit)
END;

FUNCTION CSSRange.Rows:  RC;
BEGIN
	Result := m_nRow2 - m_nRow1 + 1
END;

FUNCTION CSSRange.Cols:	RC;
BEGIN
	Result := m_nCol2 - m_nCol1 + 1
END;

CONSTRUCTOR CSS.Create (TheControl:  TSheet);
VAR
   D:	HDC;
BEGIN
	INHERITED Create;
   m_hSS := NIL;
   m_hSS := SShandle (TheControl.SS);
   D := GetDC (0);
   PixelsX := GetDeviceCaps (D, LOGPIXELSX);
   PixelsY := GetDeviceCaps (D, LOGPIXELSY);
END;

FUNCTION CSS.CheckNew:  SSERROR;
BEGIN
	IF m_hSS = NIL THEN
   	Result := SSERROR_NO_MEMORY
   ELSE
   	Result := SSERROR_NONE
END;

FUNCTION CSS.AddColPageBreak (nCol:  RC):  SSERROR;
BEGIN
	Result := SSAddColPageBreak (m_hSS, nCol)
END;

FUNCTION CSS.AddPageBreak:  SSERROR;
BEGIN
	Result := SSAddPageBreak (m_hSS)
END;

FUNCTION CSS.AddRowPageBreak (nRow:  RC):  SSERROR;
BEGIN
	Result := SSAddRowPageBreak (m_hSS, nRow)
END;

FUNCTION CSS.AddSelection (nR1, nC1, nR2, nC2:  RC):  SSERROR;
BEGIN
	Result := SSAddSelection (m_hSS, nR1, nC1, nR2, nC2)
END;

FUNCTION CSS.Attach (pTitle:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	Result := CheckNew;
	IF Result = SSERROR_NONE THEN BEGIN
   	pc := StrAlloc (Length (pTitle) + 1);
     	pc := StrPCopy (pc, pTitle);
		Result := SSAttach (m_hSS, pc);
       StrDispose (pc)
   END
END;

FUNCTION CSS.AttachToSS (hSrcSS:  SShandle):  SSERROR;
BEGIN
	Result := CheckNew;
	IF Result = SSERROR_NONE THEN
		Result := SSAttachToSS (m_hSS, hSrcSS)
END;

FUNCTION CSS.CalculationDlg:  SSERROR;
BEGIN
	Result := SSCalculationDlg (m_hSS)
END;

FUNCTION CSS.CallWindowProc (nMessage, wParam:  Word; lParam: Longint):  LRESULT;
BEGIN
	Result := SSCallWindowProc (m_hSS, nMessage, wParam, lParam)
END;

FUNCTION CSS.CancelEdit:  SSERROR;
BEGIN
	result := SSCancelEdit (m_hSS)
END;

FUNCTION CSS.CanEditPaste (VAR pCanEditPaste:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSCanEditPaste (m_hSS, @W);
   pCanEditPaste := (W <> 0)
END;

FUNCTION CSS.CheckModified:  SSERROR;
BEGIN
	Result := SSCheckModified (m_hSS)
END;

FUNCTION CSS.CheckRecalc:  SSERROR;
BEGIN
	Result := SSCheckRecalc (m_hSS)
END;

FUNCTION CSS.ClearClipboard:  SSERROR;
BEGIN
	Result := SSClearClipboard
END;

FUNCTION CSS.ClearRange (nR1, nC1, nR2, nC2:  RC; nClearType:  Integer):  SSERROR;
BEGIN
	Result := SSClearRange (m_hSS, nR1, nC1, nR2, nC2, nClearType)
END;

FUNCTION CSS.ColorPaletteDlg:  SSERROR;
BEGIN
	Result := SSColorPaletteDlg (m_hSS)
END;

FUNCTION CSS.ColWidthDlg:  SSERROR;
BEGIN
	Result := SSColWidthDlg (m_hSS)
END;

FUNCTION CSS.CopyAll (hSrcSS:  SShandle):  SSERROR;
BEGIN
	Result := SSCopyAll (m_hSS, hSrcSS)
END;

FUNCTION CSS.CopyRange (nDstR1, nDstC1, nDstR2, nDstC2:  RC;
   					 SrcSS:  CSS;
           	         nSrcR1, nSrcC1, nSrcR2, nSrcC2:  RC):  SSERROR;
BEGIN
	Result := SSCopyRange (m_hSS, nDstR1, nDstC1, nDstR2, nDstC2,
   					   SrcSS.m_hss, nSrcR1, nSrcC1, nSrcR2, nSrcC2)
END;

FUNCTION CSS.DefinedNameDlg:  SSERROR;
BEGIN
	Result := SSDefinedNameDlg (m_hSS)
END;

FUNCTION CSS.DeleteDefinedName (pName:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pName) + 1);
   pc := StrPCopy (pc, pName);
   Result := SSDeleteDefinedName (m_hSS, pc);
   StrDispose (pc)
END;

FUNCTION CSS.DeleteRange (nR1, nC1, nR2, nC2:  RC;
   					   nShiftType:  Integer):  SSERROR;
BEGIN
	Result := SSDeleteRange (m_hSS, nR1, nC1, nR2, nC2, nShiftType)
END;

FUNCTION CSS.DeleteTable:  SSERROR;
BEGIN
	Result := SSDeleteTable (m_hSS)
END;

FUNCTION CSS.EditClear (nClearType:  Integer):  SSERROR;
BEGIN
	Result := SSEditClear (m_hSS, nClearType)
END;

FUNCTION CSS.EditCopy:  SSERROR;
BEGIN
	Result := SSEditCopy (m_hSS)
END;

FUNCTION CSS.EditCopyDown:  SSERROR;
BEGIN
	Result := SSEditCopyDown (m_hSS)
END;

FUNCTION CSS.EditCopyRight:  SSERROR;
BEGIN
	Result := SSEditCopyRight (m_hSS)
END;

FUNCTION CSS.EditCut:  SSERROR;
BEGIN
	Result := SSEditCut (m_hSS)
END;

FUNCTION CSS.EditDelete (nShiftType:  Integer):  SSERROR;
BEGIN
	Result := SSEditDelete (m_hSS, nShiftType)
END;

FUNCTION CSS.EditInsert (nShiftType:  Integer):  SSERROR;
BEGIN
	Result := SSEditInsert (m_hSS, nShiftType)
END;

FUNCTION CSS.EditPaste:  SSERROR;
BEGIN
	Result := SSEditPaste (m_hSS)
END;

FUNCTION CSS.EndEdit:  SSERROR;
BEGIN
	Result := SSEndEdit (m_hSS)
END;

FUNCTION CSS.ErrorNumberToText (nError:  SSERROR; VAR pBuf:  String):  SSERROR;
VAR pc:  PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSErrorNumberToText (nError, pc, 255);
   pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.FilePageSetupDlg:  SSERROR;
BEGIN
	Result := SSFilePageSetupDlg (m_hSS)
END;

FUNCTION CSS.FilePrint (bShowPrintDlg:  Boolean):  SSERROR;
BEGIN
	Result := SSFilePrint (m_hSS, ORD (bShowPrintDlg))
END;

FUNCTION CSS.FilePrintSetupDlg:  SSERROR;
BEGIN
	Result := SSFilePrintSetupDlg (m_hSS)
END;

FUNCTION CSS.FormatAlignmentDlg:  SSERROR;
BEGIN
	Result := SSFormatAlignmentDlg (m_hSS)
END;

FUNCTION CSS.FormatBorderDlg:  SSERROR;
BEGIN
	Result := SSFormatBorderDlg (m_hSS)
END;

FUNCTION CSS.FormatCurrency0:  SSERROR;
BEGIN
	Result := SSFormatCurrency0 (m_hSS)
END;

FUNCTION CSS.FormatCurrency2:  SSERROR;
BEGIN
	Result := SSFormatCurrency2 (m_hSS)
END;

FUNCTION CSS.FormatFixed:  SSERROR;
BEGIN
	Result := SSFormatFixed (m_hSS)
END;

FUNCTION CSS.FormatFixed2:  SSERROR;
BEGIN
	Result := SSFormatFixed2 (m_hSS)
END;

FUNCTION CSS.FormatFontDlg:  SSERROR;
BEGIN
	Result := SSFormatFontDlg (m_hSS)
END;

FUNCTION CSS.FormatFraction:  SSERROR;
BEGIN
	Result := SSFormatFraction (m_hSS)
END;

FUNCTION CSS.FormatGeneral:  SSERROR;
BEGIN
	Result := SSFormatGeneral (m_hSS)
END;

FUNCTION CSS.FormatHmmampm:  SSERROR;
BEGIN
	Result := SSFormatHmmampm (m_hSS)
END;

FUNCTION CSS.FormatMdyy:  SSERROR;
BEGIN
	Result := SSFormatMdyy (m_hSS)
END;

FUNCTION CSS.FormatNumberDlg:  SSERROR;
BEGIN
	Result := SSFormatNumberDlg (m_hSS)
END;

FUNCTION CSS.FormatPatternDlg:  SSERROR;
BEGIN
	Result := SSFormatPatternDlg (m_hSS)
END;

FUNCTION CSS.FormatPercent:  SSERROR;
BEGIN
	Result := SSFormatPercent (m_hSS)
END;

FUNCTION CSS.FormatRCNr (nRow, nCol:  RC;
   					  bDoAbsolute:  Boolean;
           	          pBuf:  PChar; nBufSize:  Integer):  SSERROR;
BEGIN
	Result := SSFormatRCNr (m_hSS, nRow, nCol, ORD (bDoAbsolute), pBuf, nBufSize)
END;

FUNCTION CSS.FormatScientific:  SSERROR;
BEGIN
	Result := SSFormatScientific (m_hSS)
END;

FUNCTION CSS.GetActiveCell (VAR pRow, pCol:  RC):  SSERROR;
BEGIN
	Result := SSGetActiveCell (m_hSS, @pRow, @pCol)
END;

FUNCTION CSS.GetAllowArrows (VAR Allow:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAllowArrows (m_hSS, @W);
   Allow := (W <> 0)
END;

FUNCTION CSS.GetAllowDelete (VAR Allow:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAllowDelete (m_hSS, @W);
   Allow := (W <> 0)
END;

FUNCTION CSS.GetAllowEditHeaders (VAR Allow:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAllowEditHeaders (m_hSS, @W);
   Allow := (W <> 0)
END;

FUNCTION CSS.GetAllowFillRange (VAR Allow:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAllowFillRange (m_hSS, @W);
   Allow := (W <> 0)
END;

FUNCTION CSS.GetAllowInCellEditing (VAR Allow:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAllowInCellEditing (m_hSS, @W);
   Allow := (W <> 0)
END;

FUNCTION CSS.GetAllowMoveRange (VAR Allow:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAllowMoveRange (m_hSS, @W);
   Allow := (W <> 0)
END;

FUNCTION CSS.GetAllowResize (VAR Allow:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAllowResize (m_hSS, @W);
   Allow := (W <> 0)
END;

FUNCTION CSS.GetAllowSelections (VAR Allow:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAllowSelections (m_hSS, @W);
   Allow := (W <> 0)
END;

FUNCTION CSS.GetAllowTabs (VAR Allow:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAllowTabs (m_hSS, @W);
   Allow := (W <> 0)
END;

FUNCTION CSS.GetAllowFormulas (VAR Allow:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAllowFormulas (m_hSS, @W);
   Allow := (W <> 0)
END;

FUNCTION CSS.GetAutoRecalc (VAR pAutoRecalc:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetAutoRecalc (m_hSS, @W);
   pAutoRecalc := (W <> 0)
END;

FUNCTION CSS.GetBackColor (VAR pBackColor:  COLORREF):  SSERROR;
BEGIN
	Result := SSGetBackColor (m_hSS, @pBackColor)
END;

FUNCTION CSS.GetColWidth (nCol:  RC; VAR pWidth:  Integer):  SSERROR;
BEGIN
	Result := SSGetColWidth (m_hSS, nCol, @pWidth)
END;

FUNCTION CSS.GetDefinedName (CONST pName:  String; VAR pBuf:  String):  SSERROR;
VAR pc1, pc2:	PChar;
BEGIN
	pc1 := StrAlloc (Length (pName) + 1);
   pc1 := StrPCopy (pc1, pName);
   pc2 := StrAlloc (255);
   Result := SSGetDefinedName (m_hSS, pc1, pc2, 255);
	pBuf := StrPas (pc2);
   StrDispose (pc1);
   StrDispose (pc2)
END;

FUNCTION CSS.GetEnableProtection (VAR pEnableProtection:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetEnableProtection (m_hSS, @W);
   pEnableProtection := (W <> 0)
END;

FUNCTION CSS.GetEnterMovesDown (VAR pEnterMovesDown:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetEnterMovesDown (m_hSS, @W);
   pEnterMovesDown := (W <> 0)
END;

FUNCTION CSS.GetEntry (VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetEntry (m_hSS, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetEntryRC (nRow, nCol:  RC; VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetEntryRC (m_hSS, nRow, nCol, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetExtraColor (VAR pExtraColor:  COLORREF):  SSERROR;
BEGIN
	Result := SSGetExtraColor (m_hSS, @pExtraColor)
END;

FUNCTION CSS.GetFireEvent (nEvent:  Word; VAR pFireIt:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetFireEvent (m_hSS, nEvent, @W);
   pFireIt := (W <> 0)
END;

FUNCTION CSS.GetFixedCols (VAR pC1, pCols:  RC):  SSERROR;
BEGIN
	Result := SSGetFixedCols (m_hSS, @pC1, @pCols)
END;

FUNCTION CSS.GetFixedRows (VAR pR1, pRows:  RC):  SSERROR;
BEGIN
	Result := SSGetFixedRows (m_hSS, @pR1, @pRows)
END;

FUNCTION CSS.GetFormattedText (VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetFormattedText (m_hSS, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetFormattedTextRC (nRow, nCol:  RC; VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetFormattedTextRC (m_hSS, nRow, nCol, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetFormula (VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetFormula (m_hSS, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetFormulaRC (nRow, nCol:  RC; VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetFormulaRC (m_hSS, nRow, nCol, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetHdrSelection (VAR pTopLeftHdr, pRowHdr, pColHdr:  Boolean):  SSERROR;
VAR W1, W2, W3:  Word;
BEGIN
	Result := SSGetHdrSelection (m_hSS, @W1, @W2, @W3);
   pTopLeftHdr := (W1 <> 0);
   pRowHdr := (W2 <> 0);
   pColHdr := (W3 <> 0)
END;

FUNCTION CSS.GetIteration (VAR pIteration:  Boolean;
   						VAR pMaxIterations:  Integer;
           	            VAR pMaxChange:  Double):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetIteration (m_hSS, @W, @pMaxIterations, @pMaxChange);
   pIteration := (W <> 0)
END;

FUNCTION CSS.GetLastCol (VAR pLastCol:  RC):  SSERROR;
BEGIN
	Result := SSGetLastCol (m_hSS, @pLastCol)
END;

FUNCTION CSS.GetLastColForRow (nRow:  RC;  VAR pLastColForRow:  RC):  SSERROR;
BEGIN
	Result := SSGetLastColForRow (m_hSS, nRow, @pLastColForRow)
END;

FUNCTION CSS.GetLastRow (VAR pLastRow:  RC):  SSERROR;
BEGIN
	Result := SSGetLastRow (m_hSS, @pLastRow)
END;

FUNCTION CSS.GetLeftCol (VAR pLeftCol:  RC):  SSERROR;
BEGIN
	Result := SSGetLeftCol (m_hSS, @pLeftCol)
END;

FUNCTION CSS.GetLogicalRC (nRow, nCol:  RC; VAR pIsTrue:  Boolean):  SSERROR;
VAR W:  Word;
BEGIN
	Result := SSGetLogicalRC (m_hSS, nRow, nCol, @W);
   pIsTrue := (W <> 0)
END;

FUNCTION CSS.GetMinCol (VAR pMinCol:  RC):  SSERROR;
BEGIN
	Result := SSGetMinCol (m_hSS, @pMinCol)
END;

FUNCTION CSS.GetMinRow (VAR pMinRow:  RC):  SSERROR;
BEGIN
	Result := SSGetMinRow (m_hSS, @pMinRow)
END;

FUNCTION CSS.GetMaxCol (VAR pMaxCol:  RC):  SSERROR;
BEGIN
	Result := SSGetMaxCol (m_hSS, @pMaxCol)
END;

FUNCTION CSS.GetMaxRow (VAR pMaxRow:  RC):  SSERROR;
BEGIN
	Result := SSGetMaxRow (m_hSS, @pMaxRow)
END;

FUNCTION CSS.GetNumber (VAR pNumber:  Double):  SSERROR;
BEGIN
	Result := SSGetNumber (m_hSS, @pNumber)
END;

FUNCTION CSS.GetNumberRC (nRow, nCol:  RC; VAR pNumber:  Double):  SSERROR;
BEGIN
	Result := SSGetNumberRC (m_hSS, nRow, nCol, @pNumber)
END;

FUNCTION CSS.GetPrintArea (VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetPrintArea (m_hSS, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetPrintBottomMargin (VAR pPrintBottomMargin:  Double):  SSERROR;
BEGIN
	Result := SSGetPrintBottomMargin (m_hSS, @pPrintBottomMargin)
END;

FUNCTION CSS.GetPrintColHeading (VAR pPrintColHeading: Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetPrintColHeading (m_hSS, @W);
   pPrintColHeading := (W <> 0)
END;

FUNCTION CSS.GetPrintFooter (VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetPrintFooter (m_hSS, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetPrintGridLines (VAR pPrintGridLines:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetPrintGridLines (m_hSS, @W);
   pPrintGridLines := (W <> 0)
END;

FUNCTION CSS.GetPrintHCenter (VAR pPrintHCenter: Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetPrintHCenter (m_hSS, @W);
   pPrintHCenter := (W <> 0)
END;

FUNCTION CSS.GetPrintHeader (VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetPrintHeader (m_hSS, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetPrintLeftMargin (VAR pPrintLeftMargin:  Double):  SSERROR;
BEGIN
	Result := SSGetPrintLeftMargin (m_hSS, @pPrintLeftMargin)
END;

FUNCTION CSS.GetPrintLeftToRight (VAR pPrintLeftToRight:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetPrintLeftToRight (m_hSS, @W);
   pPrintLeftToRight := (W <> 0)
END;

FUNCTION CSS.GetPrintNoColor (VAR pNoColor:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetPrintNoColor (m_hSS, @W);
   pNoColor := (W <> 0)
END;

FUNCTION CSS.GetPrintRightMargin (VAR pPrintRightMargin:  Double):  SSERROR;
BEGIN
	Result := SSGetPrintRightMargin (m_hSS, @pPrintRightMargin)
END;

FUNCTION CSS.GetPrintRowHeading (VAR pPrintRowHeading:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetPrintRowHeading (m_hSS, @W);
   pPrintRowHeading := (W <> 0)
END;

FUNCTION CSS.GetPrintTitles (VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetPrintTitles (m_hSS, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetPrintTopMargin (VAR pPrintTopMargin:  Double):  SSERROR;
BEGIN
	Result := SSGetPrintTopMargin (m_hSS, @pPrintTopMargin)
END;

FUNCTION CSS.GetPrintVCenter (VAR pPrintVCenter:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetPrintVCenter (m_hSS, @W);
   pPrintVCenter := (W <> 0)
END;

FUNCTION CSS.GetRepaint (VAR pRepaint:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetRepaint (m_hSS, @W);
   pRepaint := (W <> 0)
END;

FUNCTION CSS.GetRowHeight (nRow:  RC; VAR pHeight:  Integer):  SSERROR;
BEGIN
	Result := SSGetRowHeight (m_hSS, nRow, @pHeight)
END;

FUNCTION CSS.GetRowMode (VAR pRowMode:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetRowMode (m_hSS, @W);
   pRowMode := (W <> 0)
END;

FUNCTION CSS.GetSelection (nSelection:  Integer;
   					VAR pR1, pC1, pR2, pC2:  RC):  SSERROR;
BEGIN
	Result := SSGetSelection (m_hSS, nSelection, @pR1, @pC1, @pR2, @pC2)
END;

FUNCTION CSS.GetSelectionCount (VAR pCount:  Integer):  SSERROR;
BEGIN
	Result := SSGetSelectionCount (m_hSS, @pCount)
END;

FUNCTION CSS.GetSelectionRef (VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetSelectionRef (m_hSS, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetShowColHeading (VAR pShowColHeading:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetShowColHeading (m_hSS, @W);
   pShowColHeading := (W <> 0)
END;

FUNCTION CSS.GetShowFormulas (VAR pShowFormulas:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetShowFormulas (m_hSS, @W);
   pShowFormulas := (W <> 0)
END;

FUNCTION CSS.GetShowGridLines (VAR pShowGridLines:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetShowGridLines (m_hSS, @W);
   pShowGridLines := (W <> 0)
END;

FUNCTION CSS.GetShowHScrollBar (VAR pShowHScrollBar:  Integer):  SSERROR;
BEGIN
	Result := SSGetShowHScrollBar (m_hSS, @pShowHScrollBar)
END;

FUNCTION CSS.GetShowRowHeading (VAR pShowRowHeading:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetShowRowHeading (m_hSS, @W);
   pShowRowHeading := (W <> 0)
END;

FUNCTION CSS.GetShowSelections (VAR pShowSelections:  Integer):  SSERROR;
BEGIN
	Result := SSGetShowSelections (m_hSS, @pShowSelections)
END;

FUNCTION CSS.GetShowVScrollBar (VAR pShowVScrollBar:  Integer):  SSERROR;
BEGIN
	Result := SSGetShowVScrollBar (m_hSS, @pShowVScrollBar)
END;

FUNCTION CSS.GetShowZeroValues (VAR pShowZeroValues:  Boolean):  SSERROR;
VAR W: Word;
BEGIN
	Result := SSGetShowZeroValues (m_hSS, @W);
   pShowZeroValues := (W <> 0)
END;

FUNCTION CSS.GetSSEdit (VAR pSSEdit:  SSEDIThandle):  SSERROR;
BEGIN
	Result := SSGetSSEdit (m_hSS, @pSSEdit)
END;

FUNCTION CSS.GetText (pBuf:  PChar):  SSERROR;
BEGIN
	Result := SSGetText (m_hSS, pBuf, StrBufSize (pBuf));
END;

FUNCTION CSS.GetTextRC (nRow, nCol:  RC; pBuf:  PChar):  SSERROR;
BEGIN
	Result := SSGetTextRC (m_hSS, nRow, nCol, pBuf, StrBufSize (pBuf));
END;

FUNCTION CSS.GetString (VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetText (m_hSS, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetStringRC (nRow, nCol:  RC; VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetTextRC (m_hSS, nRow, nCol, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetTitle (VAR pBuf:  String):  SSERROR;
VAR pc: PChar;
BEGIN
	pc := StrAlloc (255);
	Result := SSGetTitle (m_hSS, pc, 255);
	pBuf := StrPas (pc);
   StrDispose (pc)
END;

FUNCTION CSS.GetTopRow (VAR pTopRow:  RC):  SSERROR;
BEGIN
	Result := SSGetTopRow (m_hSS, @pTopRow)
END;

FUNCTION CSS.GetTypeRC (nRow, nCol:  RC; VAR pType:  Integer):  SSERROR;
BEGIN
	Result := SSGetTypeRC (m_hSS, nRow, nCol, @pType)
END;

FUNCTION CSS.GotoDlg:  SSERROR;
BEGIN
	Result := SSGotoDlg (m_hSS)
END;

FUNCTION CSS.InitTable:  SSERROR;
BEGIN
	Result := CheckNew;
   IF Result = SSERROR_NONE THEN
		Result := SSInitTable (m_hSS)
END;

FUNCTION CSS.InsertRange (nR1, nC1, nR2, nC2:  RC; nShiftType:  Integer):  SSERROR;
BEGIN
	Result := SSInsertRange (m_hSS, nR1, nC1, nR2, nC2, nShiftType)
END;

FUNCTION CSS.LaunchAppDesigner:  SSERROR;
BEGIN
	Result := SSLaunchAppDesigner(m_hSS)
END;

FUNCTION CSS.MaxCol:  RC;
BEGIN
	Result := SSMaxCol
END;

FUNCTION CSS.MaxRow:  RC;
BEGIN
	Result := SSMaxRow
END;

FUNCTION CSS.MoveRange (nR1, nC1, nR2, nC2, nRowOffset, nColOffset:  RC):  SSERROR;
BEGIN
	Result := SSMoveRange (m_hSS, nR1, nC1, nR2, nC2, nRowOffset, nColOffset)
END;

FUNCTION CSS.NextColPageBreak (nCol:  RC;  VAR pNextCol:  RC):  SSERROR;
BEGIN
	Result := SSNextColPageBreak (m_hSS, nCol, @pNextCol)
END;

FUNCTION CSS.NextRowPageBreak (nRow:  RC;  VAR pNextRow:  RC):  SSERROR;
BEGIN
	Result := SSNextRowPageBreak (m_hSS, nRow, @pNextRow)
END;

FUNCTION CSS.OpenFileDlg (CONST pTitle:  String; hWndParent:  HWND;
   						 VAR pBuf:  String):  SSERROR;
VAR pc1, pc2: PChar;
BEGIN
	pc1 := StrAlloc (Length (pTitle) + 1);
   pc2 := StrAlloc (255);
   pc1 := StrPCopy (pc1, pTitle);
	Result := SSOpenFileDlg (pc1, hWndParent, pc2, 255);
   pBuf := StrPas (pc2);
   StrDispose (pc1);
   strDispose (pc2)
END;

FUNCTION CSS.ProtectionDlg:  SSERROR;
BEGIN
	Result := SSProtectionDlg (m_hSS)
END;

FUNCTION CSS.RangeToTwips (nRow1, nCol1, nRow2, nCol2:  RC;
   					   VAR pX, pY, pCX, pCY:  Longint;
           	           VAR pShown:  Integer):  SSERROR;
BEGIN
	Result := SSRangeToTwips (m_hSS, nRow1, nCol1, nRow2, nCol2,
   						  @pX, @pY, @pCX, @pCY, @pShown)
END;

FUNCTION CSS.Read (CONST pPathName:  String; VAR pFileType:  Integer):  SSERROR;
VAR pc:	PChar;
BEGIN
	Result := CheckNew;
   IF Result = SSERROR_NONE THEN BEGIN
		pc := StrAlloc (Length (pPathName) + 1);
   	pc := StrPCopy (pc, pPathName);
		Result := SSRead (m_hSS, pc, @pFileType);
       StrDispose (pc)
   END
END;

FUNCTION CSS.ReadIO (dwUserData:  DWORD; ioFunction:  IOFUNC;
   				 VAR pUserRet:  DWORD):  SSERROR;
BEGIN
	Result := CheckNew;
   IF Result = SSERROR_NONE THEN
		Result := SSReadIO (m_hSS, dwUserData, ioFunction, @pUserRet);
END;

FUNCTION CSS.Recalc:  SSERROR;
BEGIN
	Result := SSRecalc (m_hSS)
END;

FUNCTION CSS.RemoveColPageBreak (nCol:  RC):  SSERROR;
BEGIN
	Result := SSRemoveColPageBreak (m_hSS, nCol)
END;

FUNCTION CSS.RemovePageBreak:  SSERROR;
BEGIN
	Result := SSRemovePageBreak (m_hSS)
END;

FUNCTION CSS.RemoveRowPageBreak (nRow:  RC):  SSERROR;
BEGIN
	Result := SSRemoveRowPageBreak (m_hSS, nRow)
END;

FUNCTION CSS.RowHeightDlg:  SSERROR;
BEGIN
	Result := SSRowHeightDlg (m_hSS)
END;

FUNCTION CSS.SaveFileDlg (CONST pTitle:  String; VAR pBuf:  String;
   					     VAR pFileType:  Integer):  SSERROR;
VAR pc1, pc2: PChar;
BEGIN
	pc1 := StrAlloc (Length (pTitle) + 1);
   pc2 := StrAlloc (255);
   pc1 := StrPCopy (pc1, pTitle);
	Result := SSSaveFileDlg(m_hSS, pc1, pc2, 255, @pFileType);
   pBuf := StrPas (pc2);
   StrDispose (pc1);
   strDispose (pc2)
END;

FUNCTION CSS.SaveWindowInfo:  SSERROR;
BEGIN
	Result := SSSaveWindowInfo (m_hSS)
END;

FUNCTION CSS.SetActiveCell (nRow, nCol:  RC):  SSERROR;
BEGIN
	Result := SSSetActiveCell(m_hSS, nRow, nCol)
END;

FUNCTION CSS.SetAlignment (nHorizontal:  Integer; bWordWrap:  Boolean;
   						   nVertical, nOrientation:  Integer):  SSERROR;
BEGIN
	Result := SSSetAlignment (m_hSS, nHorizontal, ORD (bWordWrap),
   						  nVertical, nOrientation)
END;

FUNCTION CSS.SetAllowArrows (Allow:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAllowArrows (m_hSS, ORD (Allow))
END;

FUNCTION CSS.SetAllowDelete (Allow:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAllowDelete (m_hSS, ORD (Allow));
END;

FUNCTION CSS.SetAllowEditHeaders (Allow:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAllowEditHeaders (m_hSS, ORD (Allow))
END;

FUNCTION CSS.SetAllowFillRange (Allow:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAllowFillRange (m_hSS, ORD (Allow))
END;

FUNCTION CSS.SetAllowInCellEditing (Allow:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAllowInCellEditing (m_hSS, ORD (Allow))
END;

FUNCTION CSS.SetAllowMoveRange (Allow:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAllowMoveRange (m_hSS, ORD (Allow))
END;

FUNCTION CSS.SetAllowResize (Allow:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAllowResize (m_hSS, ORD (Allow))
END;

FUNCTION CSS.SetAllowSelections (Allow:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAllowSelections (m_hSS, ORD (Allow))
END;

FUNCTION CSS.SetAllowTabs (Allow:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAllowTabs (m_hSS, ORD (Allow))
END;

FUNCTION CSS.SetAllowFormulas (Allow:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAllowFormulas (m_hSS, ORD (Allow))
END;

FUNCTION CSS.SetAppName (CONST pAppName:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pAppName) + 1);
   pc := StrPCopy (pc, pAppName);
	Result := SSSetAppName (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetAutoRecalc (bAutoRecalc:  Boolean):  SSERROR;
BEGIN
	Result := SSSetAutoRecalc (m_hSS, ORD (bAutoRecalc))
END;

FUNCTION CSS.SetBackColor (crBackColor:  COLORREF):  SSERROR;
BEGIN
	Result := SSSetBackColor (m_hSS, crBackColor)
END;

FUNCTION CSS.SetBorder (nOutline, nLeft, nRight,
							nTop, nBottom, nShade:  Integer;
							crOutline, crLeft, crRight,
               	        crTop, crBottom:  COLORREF):  SSERROR;
BEGIN
	Result := SSSetBorder(m_hSS, nOutline, nLeft, nRight, nTop, nBottom, nShade,
				crOutline, crLeft, crRight, crTop, crBottom)
END;

FUNCTION CSS.SetColText (nCol:  RC; CONST pColText:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pColText) + 1);
   pc := StrPCopy (pc, pColText);
   Result := SSSetColText (m_hSS, nCol, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetColWidth (nC1, nC2:  RC;
   					   nWidth:  Integer; bDefColWidth:  Boolean):  SSERROR;
BEGIN
	Result := SSSetColWidth (m_hSS, nC1, nC2, nWidth, ORD (bDefColWidth))
END;

FUNCTION CSS.SetColWidthAuto (nR1, nC1, nR2, nC2:  RC; bSetDefaults:  Boolean):  SSERROR;
BEGIN
	Result := SSSetColWidthAuto (m_hSS, nR1, nC1, nR2, nC2, ORD (bSetDefaults))
END;

FUNCTION CSS.SetDefinedName (CONST pName, pFormula:  String):  SSERROR;
VAR pc1, pc2:	PChar;
BEGIN
	pc1 := StrAlloc (Length (pName) + 1);
   pc1 := StrPCopy (pc1, pName);
	pc2 := StrAlloc (Length (pFormula) + 1);
   pc2 := StrPCopy (pc2, pFormula);
	Result := SSSetDefinedName (m_hSS, pc1, pc2);
	StrDispose (pc1);
	StrDispose (pc2)
END;

FUNCTION CSS.SetDefWindowProc (pWindowProc:  Pointer):  SSERROR;
BEGIN
	Result := SSSetDefWindowProc (m_hSS, pWindowProc)
END;

FUNCTION CSS.SetDoSetCursor (bDoSetCursor:  Boolean):  SSERROR;
BEGIN
	Result := SSSetDoSetCursor (m_hSS, ORD (bDoSetCursor))
END;

FUNCTION CSS.SetEnableProtection (bEnableProtection:  Boolean):  SSERROR;
BEGIN
	Result := SSSetEnableProtection (m_hSS, ORD (bEnableProtection))
END;

FUNCTION CSS.SetEnterMovesDown (bEnterMovesDown:  Boolean):  SSERROR;
BEGIN
	Result := SSSetEnterMovesDown (m_hSS, ORD (bEnterMovesDown))
END;

FUNCTION CSS.SetEntry (CONST pEntry:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pEntry) + 1);
   pc := StrPCopy (pc, pEntry);
   Result := SSSetEntry (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetEntryRC (nRow, nCol:  RC; CONST pEntry:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pEntry) + 1);
   pc := StrPCopy (pc, pEntry);
   Result := SSSetEntryRC (m_hSS, nRow, nCol, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetExtraColor (crExtraColor:  COLORREF):  SSERROR;
BEGIN
	Result := SSSetExtraColor (m_hSS, crExtraColor)
END;

FUNCTION CSS.SetFireEvent (nEvent:  Word; bFireIt:  Boolean):  SSERROR;
BEGIN
	Result := SSSetFireEvent (m_hSS, nEvent, ORD (bFireIt))
END;

FUNCTION CSS.SetFixedCols (nC1, nCols:  RC):  SSERROR;
BEGIN
	Result := SSSetFixedCols (m_hSS, nC1, nCols)
END;

FUNCTION CSS.SetFixedRows (nR1, nRows:  RC):  SSERROR;
BEGIN
	Result := SSSetFixedRows (m_hSS, nR1, nRows)
END;

FUNCTION CSS.SetFont (CONST pName:  String; nSize:  Integer;
   					  bBold, bItalic, bUnderline, bStrikeout:  Boolean;
           	          crColor:  COLORREF;
               	      bOutline, bShadow:  Boolean):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pName) + 1);
   pc := StrPCopy (pc, pName);
   Result := SSSetFont (m_hSS, pc, nSize,
   					 ORD (bBold), ORD (bItalic), ORD (bUnderline), ORD (bStrikeout),
                        crColor, ORD (bOutline), ORD (bShadow));
	StrDispose (pc)
END;

FUNCTION CSS.SetFormula (CONST pFormula:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pFormula) + 1);
   pc := StrPCopy (pc, pFormula);
   Result := SSSetFormula (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetFormulaRC (nRow, nCol:  RC; CONST pFormula:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pFormula) + 1);
   pc := StrPCopy (pc, pFormula);
   Result := SSSetFormulaRC (m_hSS, nRow, nCol, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetHdrHeight (nHeight:  Integer):  SSERROR;
BEGIN
	Result := SSSetHdrHeight (m_hSS, nHeight)
END;

FUNCTION CSS.SetHdrSelection (bTopLeftHdr, bRowHdr, bColHdr:  Boolean):  SSERROR;
BEGIN
	Result := SSSetHdrSelection (m_hSS, ORD (bTopLeftHdr), ORD (bRowHdr), ORD (bColHdr))
END;

FUNCTION CSS.SetHdrWidth (nWidth:  Integer):  SSERROR;
BEGIN
	Result := SSSetHdrWidth (m_hSS, nWidth)
END;

FUNCTION CSS.SetIteration (bIteration:  Boolean; nMaxIterations:  Integer;
						nMaxChange:  Double):  SSERROR;
BEGIN
	Result := SSSetIteration (m_hSS, ORD (bIteration), nMaxIterations, nMaxChange)
END;

FUNCTION CSS.SetLeftCol (nLeftCol:  RC):  SSERROR;
BEGIN
	Result := SSSetLeftCol (m_hSS, nLeftCol)
END;

FUNCTION CSS.SetLogicalRC (nRow, nCol:  RC; bIsTrue:  Boolean):  SSERROR;
BEGIN
	Result := SSSetLogicalRC (m_hSS, nRow, nCol, ORD (bIsTrue))
END;

FUNCTION CSS.SetMinCol (nMinCol:  RC):  SSERROR;
BEGIN
	Result := SSSetMinCol (m_hSS, nMinCol)
END;

FUNCTION CSS.SetMinRow (nMinRow:  RC):  SSERROR;
BEGIN
	Result := SSSetMinRow (m_hSS, nMinRow)
END;

FUNCTION CSS.SetMaxCol (nMaxCol:  RC):  SSERROR;
BEGIN
	Result := SSSetMaxCol (m_hSS, nMaxCol)
END;

FUNCTION CSS.SetMaxRow (nMaxRow:  RC):  SSERROR;
BEGIN
	Result := SSSetMaxRow (m_hSS, nMaxRow)
END;

FUNCTION CSS.SetNumber (nNumber:  Double):  SSERROR;
BEGIN
	Result := SSSetNumber (m_hSS, nNumber)
END;

FUNCTION CSS.SetNumberFormat (CONST pNumberFormat:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pNumberFormat) + 1);
   pc := StrPCopy (pc, pNumberFormat);
   Result := SSSetNumberFormat (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetNumberRC (nRow, nCol: RC;  nNumber:  Double):  SSERROR;
BEGIN
	Result := SSSetNumberRC (m_hSS, nRow, nCol, nNumber)
END;

FUNCTION CSS.SetPattern (nPattern:  Integer; crFG, crBG: COLORREF):  SSERROR;
BEGIN
	Result := SSSetPattern (m_hSS, nPattern, crFG, crBG)
END;

FUNCTION CSS.SetPrintArea (CONST pFormula:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pFormula) + 1);
   pc := StrPCopy (pc, pFormula);
   Result := SSSetPrintArea (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetPrintAreaFromSelection:  SSERROR;
BEGIN
	Result := SSSetPrintAreaFromSelection (m_hSS)
END;

FUNCTION CSS.SetPrintBottomMargin (nMargin:  Double):  SSERROR;
BEGIN
	Result := SSSetPrintBottomMargin (m_hSS, nMargin)
END;

FUNCTION CSS.SetPrintColHeading (bColHeading:  Boolean):  SSERROR;
BEGIN
	Result := SSSetPrintColHeading (m_hSS, ORD (bColHeading))
END;

FUNCTION CSS.SetPrintFooter (CONST pPrintFooter:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pPrintFooter) + 1);
   pc := StrPCopy (pc, pPrintFooter);
   Result := SSSetPrintFooter (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetPrintGridLines (bGridLines:  Boolean):  SSERROR;
BEGIN
	Result := SSSetPrintGridLines (m_hSS, ORD (bGridLines))
END;

FUNCTION CSS.SetPrintHCenter (bHCenter:  Boolean):  SSERROR;
BEGIN
	Result := SSSetPrintHCenter (m_hSS, ORD (bHCenter))
END;

FUNCTION CSS.SetPrintHeader (CONST pPrintHeader:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pPrintHeader) + 1);
   pc := StrPCopy (pc, pPrintHeader);
   Result := SSSetPrintHeader (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetPrintLeftMargin (nMargin:  Double):  SSERROR;
BEGIN
	Result := SSSetPrintLeftMargin (m_hSS, nMargin)
END;

FUNCTION CSS.SetPrintLeftToRight (bLeftToRight:  Boolean):  SSERROR;
BEGIN
	Result := SSSetPrintLeftToRight (m_hSS, ORD (bLeftToRight))
END;

FUNCTION CSS.SetPrintNoColor (bNoColor:  Boolean):  SSERROR;
BEGIN
	Result := SSSetPrintNoColor (m_hSS, ORD (bNoColor))
END;

FUNCTION CSS.SetPrintRightMargin (nMargin:  Double):  SSERROR;
BEGIN
	Result := SSSetPrintRightMargin (m_hSS, nMargin)
END;

FUNCTION CSS.SetPrintRowHeading (bRowHeading:  Boolean):  SSERROR;
BEGIN
	Result := SSSetPrintRowHeading (m_hSS, ORD (bRowHeading))
END;

FUNCTION CSS.SetPrintTitles (CONST pFormula:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pFormula) + 1);
   pc := StrPCopy (pc, pFormula);
   Result := SSSetPrintTitles (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetPrintTitlesFromSelection:  SSERROR;
BEGIN
	Result := SSSetPrintTitlesFromSelection (m_hSS)
END;

FUNCTION  CSS.SetPrintTopMargin (nMargin:  Double):  SSERROR;
BEGIN
	Result := SSSetPrintTopMargin(m_hSS, nMargin)
END;

FUNCTION CSS.SetPrintVCenter (bVCenter:  Boolean):  SSERROR;
BEGIN
	Result := SSSetPrintVCenter (m_hSS, ORD (bVCenter))
END;

FUNCTION CSS.SetProtection (bLocked, bHidden:  Boolean):  SSERROR;
BEGIN
	Result := SSSetProtection (m_hSS, ORD (bLocked), ORD (bHidden))
END;

FUNCTION CSS.SetRepaint (bRepaint:  Boolean):  SSERROR;
BEGIN
	Result := SSSetRepaint (m_hSS, ORD (bRepaint))
END;

FUNCTION CSS.SetRowHeight (nR1, nR2:  RC;
   						nHeight:  Integer; bDefRowHeight:  Boolean):  SSERROR;
BEGIN
	Result := SSSetRowHeight (m_hSS, nR1, nR2, nHeight, ORD (bDefRowHeight))
END;

FUNCTION CSS.SetRowHeightAuto (nR1, nC1, nR2, nC2:  RC; bSetDefaults:  Boolean):  SSERROR;
BEGIN
	Result := SSSetRowHeightAuto (m_hSS, nR1, nC1, nR2, nC2, ORD (bSetDefaults))
END;

FUNCTION CSS.SetRowMode (bRowMode:  Boolean):  SSERROR;
BEGIN
	Result := SSSetRowMode (m_hSS, ORD (bRowMode))
END;

FUNCTION CSS.SetRowText (nRow:  RC; CONST pRowText:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pRowText) + 1);
   pc := StrPCopy (pc, pRowText);
   Result := SSSetRowText (m_hSS, nRow, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetSelection (nR1, nC1, nR2, nC2:  RC):  SSERROR;
BEGIN
	Result := SSSetSelection (m_hSS, nR1, nC1, nR2, nC2)
END;

FUNCTION CSS.SetSelectionRef (CONST pFormula:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pFormula) + 1);
   pc := StrPCopy (pc, pFormula);
   Result := SSSetSelectionRef (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetShowColHeading (bColHeading:  Boolean):  SSERROR;
BEGIN
	Result := SSSetShowColHeading (m_hSS, ORD (bColHeading))
END;

FUNCTION CSS.SetShowFormulas (bFormulas:  Boolean):  SSERROR;
BEGIN
	Result := SSSetShowFormulas (m_hSS, ORD (bFormulas))
END;

FUNCTION CSS.SetShowGridLines (bGridLines:  Boolean):  SSERROR;
BEGIN
	Result := SSSetShowGridLines (m_hSS, ORD (bGridLines))
END;

FUNCTION CSS.SetShowHScrollBar (nShowHScrollBar:  Integer):  SSERROR;
BEGIN
	Result := SSSetShowHScrollBar (m_hSS, nShowHScrollBar)
END;

FUNCTION CSS.SetShowRowHeading (bRowHeading:  Boolean):  SSERROR;
BEGIN
	Result := SSSetShowRowHeading (m_hSS, ORD (bRowHeading))
END;

FUNCTION CSS.SetShowSelections (nSelections:  Integer):  SSERROR;
BEGIN
	Result := SSSetShowSelections (m_hSS, nSelections)
END;

FUNCTION CSS.SetShowVScrollBar (nShowVScrollBar:  Integer):  SSERROR;
BEGIN
	Result := SSSetShowVScrollBar (m_hSS, nShowVScrollBar)
END;

FUNCTION CSS.SetShowZeroValues (bZeroValues:  Boolean):  SSERROR;
BEGIN
	Result := SSSetShowZeroValues (m_hSS, ORD (bZeroValues))
END;

FUNCTION CSS.SetSSEdit (hSSEdit:  SSEDIThandle):  SSERROR;
BEGIN
	Result := SSSetSSEdit (m_hSS, hSSEdit)
END;

FUNCTION CSS.SetText (pText:  PChar):  SSERROR;
BEGIN
   Result := SSSetText (m_hSS, pText);
END;

FUNCTION CSS.SetTextRC (nRow, nCol:  RC;  pText:  PChar):  SSERROR;
BEGIN
   Result := SSSetTextRC (m_hSS, nRow, nCol, pText);
END;

FUNCTION CSS.SetString (CONST pText:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pText) + 1);
   pc := StrPCopy (pc, pText);
   Result := SSSetText (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetStringRC (nRow, nCol:  RC;  CONST pText:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pText) + 1);
   pc := StrPCopy (pc, pText);
   Result := SSSetTextRC (m_hSS, nRow, nCol, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetTitle (CONST pTitle:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pTitle) + 1);
   pc := StrPCopy (pc, pTitle);
   Result := SSSetTitle (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetTopLeftText (CONST pTopLeftText:  String):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pTopLeftText) + 1);
   pc := StrPCopy (pc, pTopLeftText);
   Result := SSSetTopLeftText (m_hSS, pc);
	StrDispose (pc)
END;

FUNCTION CSS.SetTopRow (nTopRow:  RC):  SSERROR;
BEGIN
	Result := SSSetTopRow (m_hSS, nTopRow)
END;

FUNCTION CSS.ShowActiveCell:  SSERROR;
BEGIN
	Result := SSShowActiveCell (m_hSS)
END;

FUNCTION CSS.Sort (nR1, nC1, nR2, nC2:  RC;
   				bSortByRows:  Boolean; CONST pKeys:  ARRAY OF Integer; nKeys:  Integer):  SSERROR;
BEGIN
	Result := SSSort (m_hSS, nR1, nC1, nR2, nC2, ORD (bSortByRows), @pKeys, nKeys)
END;

FUNCTION CSS.Sort3 (nR1, nC1, nR2, nC2:  RC;
   				 bSortByRows:  Boolean;
           	     nKey1, nKey2, nKey3:  Integer):  SSERROR;
BEGIN
	Result := SSSort3 (m_hSS, nR1, nC1, nR2, nC2, ORD (bSortByRows), nKey1, nKey2, nKey3)
END;

FUNCTION CSS.SortDlg:  SSERROR;
BEGIN
	Result := SSSortDlg (m_hSS)
END;

FUNCTION CSS.StartEdit (bClear, bInCellEditFocus, bArrowsExitEditMode:  Boolean):  SSERROR;
BEGIN
	Result := SSStartEdit (m_hSS, ORD (bClear),
   						ORD (bInCellEditFocus),
                           ORD (bArrowsExitEditMode))
END;

FUNCTION CSS.SwapTables (hSS2:  SShandle):  SSERROR;
BEGIN
	Result := SSSwapTables (m_hSS, hSS2)
END;

FUNCTION CSS.TransactCommit:  SSERROR;
BEGIN
	Result := SSTransactCommit (m_hSS)
END;

FUNCTION CSS.TransactRollback:  SSERROR;
BEGIN
	Result := SSTransactRollback (m_hSS)
END;

FUNCTION CSS.TransactStart:  SSERROR;
BEGIN
	Result := SSTransactStart (m_hSS)
END;

FUNCTION CSS.TwipsToRC (x, y:  Longint; VAR pRow, pCol:  RC):  SSERROR;
BEGIN
	Result := SSTwipsToRC (m_hSS, x, y, @pRow, @pCol)
END;

FUNCTION CSS.PixelsToRC (x, y:  Integer; VAR pRow, pCol:  RC):  SSERROR;
VAR
	TwipsX, TwipsY:	LongInt;
BEGIN
   TwipsX := Round (x * (1440 / PixelsX));
   TwipsY := Round (y * (1440 / PixelsY));
	Result := SSTwipsToRC (m_hSS, TwipsX, TwipsY, @pRow, @pCol)
END;

FUNCTION CSS.Write (CONST pPathName:  String; nFileType:  Integer):  SSERROR;
VAR pc:	PChar;
BEGIN
	pc := StrAlloc (Length (pPathName) + 1);
   pc := StrPCopy (pc, pPathName);
   Result := SSWrite (m_hSS, pc, nFileType);
   StrDispose (pc)
END;

FUNCTION CSS.WriteIO (dwUserData:  DWORD; ioFunction:  IOFUNC;
   				  VAR pUserRet:  DWORD):  SSERROR;
BEGIN
	Result := SSWriteIO (m_hSS, dwUserData, ioFunction, @pUserRet)
END;

END.
