unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Volinfo, DB, DBTables, ExtCtrls, FileCtrl;

type
  TVolumeInformationDemoForm = class(TForm)
    VolumeInformation: TVolumeInformation;
    Panel1: TPanel;
    Panel2: TPanel;
    DriveComboBox: TDriveComboBox;
    VolumeInformationsGroupBox: TGroupBox;
    Label6: TLabel;
    Label1: TLabel;
    Label7: TLabel;
    Label2: TLabel;
    Label8: TLabel;
    Label3: TLabel;
    Label9: TLabel;
    Label4: TLabel;
    Label10: TLabel;
    Label5: TLabel;
    FileSystemFlagsGroupBox: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    procedure FormCreate(Sender: TObject);
    procedure VolumeInformationError(ErrorNumber: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  VolumeInformationDemoForm: TVolumeInformationDemoForm;

implementation

{$R *.DFM}


procedure TVolumeInformationDemoForm.FormCreate(Sender: TObject);
begin
  VolumeInformation.Drive := DriveComboBox.Drive;
  Label1.Caption := VolumeInformation.VolumeLabel;
  Label2.Caption := VolumeInformation.VolumeSerialNumber;
  Label3.Caption := VolumeInformation.VolumeFileSystemName;
  Label4.Caption := IntToStr(VolumeInformation.VolumeFileSystemFlags);
  Label5.Caption := VolumeInformation.Version;
  RadioButton1.Checked := VolumeInformation.CaseIsPreserved;
  RadioButton2.Checked := VolumeInformation.CaseSensitive;
  RadioButton3.Checked := VolumeInformation.UnicodeStoredOnDisk;
  RadioButton4.Checked := VolumeInformation.PersistentACLs;
  RadioButton5.Checked := VolumeInformation.SupportsFileCompression;
  RadioButton6.Checked := VolumeInformation.VolumeIsCompressed;
end;

procedure TVolumeInformationDemoForm.VolumeInformationError(ErrorNumber: Integer);
begin
  ShowMessage(IntToStr(ErrorNumber));
end;

end.
