{ Richard Hansen
  CompuServe : 70242,3367
}
unit VcsMain;

interface

uses
  About, Files, Dialogs, VcsIntf, ToolIntf, SysUtils, IniFiles;

const
  VCS_ID = 'VCS.DEMO';
  VCS_TRACK_PROJ_ID = 'TRACK PROJECT';
  VCS_MENUNAME = '&VCS Demo';
  VCS_MENUITEM_COUNT = 4;
  VCS_MENUITEMS : Array[0..VCS_MENUITEM_COUNT-1] of String[30] =
    (
     'About',
     '-',
     'Compare Project',
     'Track Current Project'
     );

  ABOUT_INDEX = 0;
  COMPARE_INDEX = ABOUT_INDEX + 2;
  TRACK_INDEX = COMPARE_INDEX + 1;

type
  TMyVCSClient = class(TIVCSClient)
    constructor Create;
    function GetIDString: string; override;
    procedure ExecuteVerb(Index: Integer); override;
    function GetMenuName: string; override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
    function GetVerbState(Index: Integer): Word; override;
    procedure ProjectChange; override;

    private
      Delphi    : TIToolServices;
      ProjName  : String;
      TrackProj : Boolean;

      procedure CompareProject;
      procedure About;

    protected
    public
    procedure Init(VCSInterface: TIToolServices);
  end;

implementation

constructor TMyVCSClient.Create;
begin
  TObject.Create;
  ProjName  := '';
  TrackProj := True;
end;

procedure TMyVCSClient.Init(VCSInterface: TIToolServices);
begin
  Delphi := VCSInterface;
end;

procedure TMyVCSClient.About;
begin
  try
  AboutBox := TAboutBox.Create(nil);
  AboutBox.ShowModal;
  finally
  AboutBox.Free;
  end;
end;

procedure TMyVCSClient.CompareProject;
var
  i : Integer;

begin
  try
  FilesDlg := TFilesDlg.Create(nil);
  FilesDlg.Caption := ProjName;

  FilesDlg.lstFiles.Items.Add('FORMS = ' + IntToStr(Delphi.GetFormCount));
  for i := 0 to Delphi.GetFormCount - 1 do begin
    FilesDlg.lstFiles.Items.Add(Delphi.GetFormName(i));
  end;

  { BUG : This returns one to FEW PAS files! }
  FilesDlg.lstFiles.Items.Add('UNITS = ' + IntToStr(Delphi.GetUnitCount));
  for i := 0 to Delphi.GetUnitCount - 1 do begin
    FilesDlg.lstFiles.Items.Add(Delphi.GetUnitName(i));
  end;

  FilesDlg.ShowModal;
  finally
  FilesDlg.Free;
  end;
end;

function TMyVCSClient.GetIDString: string;
begin
  Result := VCS_ID;
end;

procedure TMyVCSClient.ExecuteVerb(Index: Integer);
begin
  Case Index of
    ABOUT_INDEX: About;
    COMPARE_INDEX : CompareProject;
    TRACK_INDEX : TrackProj := not TrackProj;
  end; {CASE}
end;

function TMyVCSClient.GetMenuName: string;
begin
  Result := VCS_MENUNAME;
end;

function TMyVCSClient.GetVerb(Index: Integer): string;
begin
  Result := VCS_MENUITEMS[Index];
end;

function TMyVCSClient.GetVerbCount: Integer;
begin
  Result := VCS_MENUITEM_COUNT;
end;

function TMyVCSClient.GetVerbState(Index: Integer): Word;
begin
  Result := vsEnabled;

  Case Index of
    TRACK_INDEX : if TrackProj then Result := Result or vsChecked;
  end; {CASE}
end;

procedure TMyVCSClient.ProjectChange;
begin
  { if NewProjName = '' and ProjName <> '' then project is being closed
    if NewProjName <> '' and ProjName = '' then a new project is being opened
  }
  if TrackProj then begin
    ProjName := Delphi.GetProjectName;
    ShowMessage('Project = ' + ProjName);
  end;
end;

end.

