unit MetrUnit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Gauges, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Gauge1: TGauge;
    Label1: TLabel;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

Procedure CreateMeter;export;
Procedure DestoryMeter;export;
Procedure SetMeterValue(var i:integer);export;
Procedure SetMeterTitle(s:Pchar);export;
Procedure SetMeterDescription(s:Pchar);export;

var
  Form1: TForm1;

implementation

var
  MeterForm:TForm1;
  AlreadyCreate:Boolean;

{$R *.DFM}
Procedure CreateMeter;
begin
  if not AlreadyCreate Then
  begin
    MeterForm := TForm1.Create(Application);
    MeterForm.show;
    AlreadyCreate:=True;
  end;
end;

Procedure DestoryMeter;
begin
  if AlreadyCreate Then
  begin
    MeterForm.Free;
    AlreadyCreate:=False;
  end;
end;

Procedure SetMeterValue(var i:integer);
begin
  if AlreadyCreate Then
  begin
    if i>100 then i:=100;
    if i<0 then i:=0;
    MeterForm.Gauge1.Progress:=i;
  end;
end;

Procedure SetMeterTitle(s:Pchar);
begin
  if AlreadyCreate Then
  begin
    MeterForm.Caption:=StrPas(s);
  end;
end;

Procedure SetMeterDescription(s:Pchar);
begin
  if AlreadyCreate Then
  begin
    MeterForm.Label1.Caption:=StrPas(s);
  end;
end;

initialization
	AlreadyCreate:=False;
end.
