(*			TValueIndicator Component			*)
(*												*)
(*			Advanced Software Development   	*)
(*		   	Created by Chris Kokkos, 8/95.		*)
(*  		Inet mail:  Beat@Hellas.hol.gr		*)
(*												*)
(*			  Free for all DELPHI Users!		*)
(*	        Please give me some credits...		*)
(*												*)

unit Valueind;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;


type
	TIndicatorKind = (ikHorizontal, ikVertical);

type
  TValueIndicator = class(TGraphicControl)
  private
  	FMinValue		: Longint;
    FMaxValue		: Longint;
    FCurValue		: Longint;
    FBorder			: Boolean;
    FBorder3D 		: Boolean;
    FBackColor 		: TColor;
    FPart1Color 	: TColor;
    FPart2Color 	: TColor;
    FPart3Color 	: TColor;
    FFirstPoint 	: Longint;
    FSecondPoint 	: Longint;
    FKind			: TIndicatorKind;
    procedure SetMinValue(Value: Longint);
    procedure SetMaxValue(Value: Longint);
    procedure SetValue(Value: Longint);
    function GetPercentDone: Longint;
    procedure SetBackColor(Value: TColor);
    procedure SetPart1Color(Value:TColor);
    procedure SetPart2Color(Value:TColor);
    procedure SetPart3Color(Value:TColor);
    procedure SetFirstPoint(Value:Longint);
    procedure SetSecondPoint(Value:Longint);
    procedure SetIndicatorKind(Value: TIndicatorKind);
    procedure SetBorder3D(Value:Boolean);
    procedure SetBorder(Value:Boolean);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure AddValue(Value: Longint);
    property PercentDone: Longint read GetPercentDone;
  published
  	property Align;
    property BackColor:TColor read FBackColor write SetBackColor default clSilver;
    property Border:Boolean read FBorder write SetBorder default True;
    property Border3D:Boolean read FBorder3D write SetBorder3D default True;
    property Enabled;
    property Kind: TIndicatorKind read FKind write SetIndicatorKind default ikHorizontal;
  	property MinValue: Longint read FMinValue write SetMinValue default 0;
    property MaxValue: Longint read FMaxValue write SetMaxValue default 100;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property Part1Color : TColor read FPart1Color write SetPart1Color default clRed;
    property Part2Color : TColor read FPart2Color write SetPart2Color default clYellow;
    property Part3Color : TColor read FPart3Color write SetPart3Color default clLime;
    property FirstPoint : Longint read FFirstPoint write SetFirstPoint default 50;
	property SecondPoint : Longint read FSecondPoint write SetSecondPoint default 90;
    property Indicator: Longint read FCurValue write SetValue;
    property ShowHint;
    property Visible;
  end;

procedure Register;

implementation

function SolveForX(Y, Z: Longint): Integer;
begin
  SolveForX := Trunc( Z * (Y * 0.01) );
end;

function SolveForY(X, Z: Longint): Integer;
begin
  if Z = 0 then SolveForY := 0
  else SolveForY := Trunc( (X * 100) / Z );
end;


(*		*)
constructor TValueIndicator.Create(AOwner: TComponent);
begin
  	inherited Create(AOwner);
  	ControlStyle := ControlStyle + [csFramed, csOpaque];
  	FMinValue := 0;
  	FMaxValue := 100;
  	FCurValue := 0;
    FBorder3d := True;
    FBorder := True;
    FBackColor := clSilver;
    FPart1Color := clRed;
    FPart2Color := clYellow;
    FPart3Color := clLime;
    FFirstPoint := 50;
    FSecondPoint := 90;
    FKind := ikHorizontal;
    Width := 150;
    Height := 20;
end;

(*		*)
function TValueIndicator.GetPercentDone: Longint;
begin
	GetPercentDone := SolveForY(FCurValue - FMinValue, FMaxValue - FMinValue);
end;

(*		*)
procedure TValueIndicator.Paint;
var p1,p2,p3 : word;
    tr : TRect;
    TheRect : TRect;
    bitmap : TBitmap;
    W,H,X,bot : integer;
    perc : byte;

    	function FindPoint(Y : Longint):Integer;
        begin
        	FindPoint := Trunc((Y*X)/FMaxValue);
        end;

begin
  	with Canvas do begin
    	TheRect := ClipRect;
        if FBorder3D then Frame3D(Canvas,TheRect,clGray,clWhite,1);
        if FBorder then Frame3D(Canvas,TheRect,clBlack,clBlack,1);
        bitmap := TBitmap.Create;
        W := TheRect.Right-TheRect.Left+1;
        H := TheRect.Bottom-TheRect.Top+1;
        if FKind=ikHorizontal then X:=W else X:=H;
        bitmap.Width := W;
        bitmap.Height := H;
        bitmap.canvas.Brush.Color := FBackColor;
  		bitmap.Canvas.Brush.Style := bsSolid;
        bitmap.canvas.FillRect(Rect(0,0,W,H));
    	(**)
        p1 := 0; p2 :=0; p3:=0; bot := TheRect.Bottom;
        if FCurValue<FirstPoint then p1 := FindPoint(FCurValue)
        else begin
        	p1:=FindPoint(FirstPoint);
        	if FCurValue<SecondPoint then p2 := FindPoint(FCurValue)
            else begin
            	p2:=FindPoint(SecondPoint);
                if FCurValue<FMaxValue then p3 := FindPoint(FCurValue)
                else p3:=FindPoint(FMaxValue);
            end;
        end;
        if p1>0 then begin
	        bitmap.canvas.Brush.Color := Part1Color;
            if FKind=ikHorizontal
            	then bitmap.canvas.FillRect(Rect(0,0,p1,H))
                else bitmap.canvas.FillRect(Rect(0,bot-p1,W,bot))
        end;
        dec(bot,p1);
        if p2>0 then begin
	        bitmap.canvas.Brush.Color := Part2Color;
            if FKind=ikHorizontal
            	then bitmap.canvas.FillRect(Bounds(p1,0,p2-p1+1,H))
            	else bitmap.canvas.FillRect(Rect(0,bot-(p2-p1+1),W,bot));
        end;
        dec(bot,p2-p1);
        if p3>0 then begin
	        bitmap.canvas.Brush.Color := Part3Color;
            if FKind=ikHorizontal
				then bitmap.canvas.FillRect(Bounds(p2,0,p3-p2+1,H))
                else begin
                	p3 := bot-(p3-p2+1);
                    if p3<0 then p3:=0;
                	bitmap.canvas.FillRect(Rect(0,p3,W,bot));
                end;
        end;
	    (**)
        Canvas.CopyRect(TheRect,bitmap.Canvas,Bounds(0,0,W,H));
        Bitmap.Free;
    end;
end;


procedure TValueIndicator.SetMinValue(Value: Longint);
begin
  if Value <> FMinValue then
  begin
    FMinValue := Value;
    Refresh;
  end;
end;

procedure TValueIndicator.SetMaxValue(Value: Longint);
begin
  if Value <> FMaxValue then
  begin
    FMaxValue := Value;
    Refresh;
  end;
end;

procedure TValueIndicator.SetValue(Value: Longint);
begin
	if (FCurValue <> Value) and (Value >= FMinValue) and (Value <= FMaxValue) then
  	begin
    	FCurValue := Value;
    	Refresh;
  	end;
end;

procedure TValueIndicator.AddValue(Value: Longint);
begin
	Inc(FCurValue,Value);
  	Refresh;
end;

procedure TValueIndicator.SetBackColor(Value: TColor);
begin
  	if Value <> FBackColor then begin
    	FBackColor := Value;
    	Refresh;
  	end;
end;

procedure TValueIndicator.SetPart1Color(Value: TColor);
begin
  	if Value <> FPart1Color then begin
    	FPart1Color := Value;
    	Refresh;
  	end;
end;

procedure TValueIndicator.SetPart2Color(Value: TColor);
begin
  	if Value <> FPart2Color then begin
    	FPart2Color := Value;
    	Refresh;
  	end;
end;

procedure TValueIndicator.SetPart3Color(Value: TColor);
begin
  	if Value <> FPart3Color then begin
    	FPart3Color := Value;
    	Refresh;
  	end;
end;

procedure TValueIndicator.SetFirstPoint(Value:Longint);
begin
	if (Value <> FFirstPoint) and (Value>=FMinValue) and (Value<=FMaxValue) then begin
    	FFirstPoint := Value;
    	Refresh;
    end;
end;

procedure TValueIndicator.SetSecondPoint(Value:Longint);
begin
	if (Value <> FSecondPoint) and (Value>=FMinValue) and (Value<=FMaxValue) then begin
    	FSecondPoint := Value;
    	Refresh;
    end;
end;

procedure TValueIndicator.SetIndicatorKind(Value: TIndicatorKind);
begin
	if Value <> FKind then begin
    	FKind := Value;
        Refresh;
  	end;
end;

procedure TValueIndicator.SetBorder(Value:Boolean);
begin
	if Value<>FBorder then begin
    	FBorder := Value;
        Refresh;
    end;
end;

procedure TValueIndicator.SetBorder3D(Value:Boolean);
begin
	if Value<>FBorder3D then begin
    	FBorder3D := Value;
        Refresh;
    end;
end;

procedure Register;
begin
  RegisterComponents('ASD', [TValueIndicator]);
end;

end.
