unit TBUUCode;
interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, Forms, UUCode;

type
  EUUCode = class(Exception);

  TUUCode = class(TComponent)
  public
    { Public class declarations (override) }
    constructor Create(AOwner: TComponent); override;

  private
    { Private field declarations }
    FInputFileName: String;
    FOutputFileName: String;

  protected
    { Protected method declarations }
    function InputFilePChar: PChar;
    function OutputFilePChar: PChar;

  public
    { Public interface declarations }
    procedure UUEncode;
    procedure UUDecode;

  published
    { Published design declarations }
    property InputFile:  String read FInputFileName write FInputFileName;
    property OutputFile: String read FOutputFileName write FOutputFileName;
  end;

procedure Register;

implementation

  constructor TUUCode.Create(AOwner: TComponent);
  begin
    if not UUCodeLoaded then raise EUUCode.Create('UUCode.DLL not loaded');
    inherited Create(AOwner);
  end {Create};


  function TUUCode.InputFilePChar: PChar;
  begin
    FInputFileName[Length(FInputFileName)+1] := #0;
    InputFilePChar := @FInputFileName[1]
  end {InputFilePChar};

  function TUUCode.OutputFilePChar: PChar;
  begin
    FOutputFileName[Length(FOutputFileName)+1] := #0;
    OutputFilePChar := @FOutputFileName[1]
  end {OutputFilePChar};


  procedure TUUCode.UUEncode;
  var Error: Word;
  begin
    if FInputFileName = '' then raise EUUCode.Create('InputFileName is empty');
    if FOutputFileName = '' then raise EUUCode.Create('OutputFileName is empty');
    Error := UUEncoder(InputFilePChar,OutputFilePChar,664,False,nil);
    case Error of
      1: raise EUUCode.Create('UUEnCode: input file is output file');
      2: raise EUUCode.Create('UUEnCode: input file does not exist');
      3: raise EUUCode.Create('UUEnCode: output file exists');
      4: raise EUUCode.Create('UUEnCode: could not create output file');
      5: raise EUUCode.Create('UUEnCode: DLL bussy, try again later (shared buffers)')
    { else OK }
    end
  end {UUEncode};

  procedure TUUCode.UUDecode;
  var Error: Word;
  begin
    if FInputFileName = '' then raise EUUCode.Create('InputFileName is empty');
    Error := UUDecoder(InputFilePChar,nil);
    case Error of
      1: raise EUUCode.Create('UUDECode: input file is output file');
      2: raise EUUCode.Create('UUDECode: input file does not exist');
      3: raise EUUCode.Create('UUDECode: output file exists');
      4: raise EUUCode.Create('UUDeCode: could not create output file');
      5: raise EUUCode.Create('UUDeCode: DLL bussy, try again later (shared buffers)')
    { else OK }
    end
  end {UUDecode};


procedure Register;
begin
  RegisterComponents('Dr.Bob', [TUUCode]);
end {Register};

end.
