unit fmSetDlg;

interface

uses
  Buttons, Classes, Controls, DFSClrBn, ExtCtrls, Forms, Spin, StdCtrls;

type
  TfrmSettingsDialog = class(TForm)
    bvlMain: TBevel;
    grpGridSize: TGroupBox;
    lblGridSizeAcross: TLabel;
    edtGridSizeAcross: TSpinEdit;
    lblGridSizeDown: TLabel;
    edtGridSizeDown: TSpinEdit;
    grpColour: TGroupBox;
    lblColourBackground: TLabel;
    btnColourBackground: TDFSColorButton;
    lblColourLivingCells: TLabel;
    btnColourLivingCells: TDFSColorButton;
    btnDisplayedInformationColour: TDFSColorButton;
    grpDisplayedInformation: TGroupBox;
    chkDisplayedInformationGeneration: TCheckBox;
    chkDisplayedInformationLivingCells: TCheckBox;
    grpAnimation: TGroupBox;
    lblAnimationDelay: TLabel;
    edtAnimationDelay: TSpinEdit;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    btnDefault: TBitBtn;
    procedure btnDefaultClick(Sender : TObject);
    procedure btnOKClick(Sender : TObject);
    procedure DisplayedInformationChanged(Sender : TObject);
    procedure FormCreate(Sender : TObject);
  private
    procedure ReadOptions;
  end;

var
  frmSettingsDialog : TfrmSettingsDialog;

implementation

uses
  UOptions;

{$R *.DFM}

procedure TfrmSettingsDialog.btnDefaultClick(Sender : TObject);

begin
  Options.RestoreDefaults;
  ReadOptions
end;

procedure TfrmSettingsDialog.btnOKClick(Sender : TObject);

begin
  with Options do
  begin
    GridHeight := edtGridSizeDown.Value;
    GridWidth := edtGridSizeAcross.Value;
    BackgroundColor := btnColourBackground.Color;
    LivingCellColor := btnColourLivingCells.Color;
    DisplayGeneration := chkDisplayedInformationGeneration.Checked;
    DisplayedInformationColor := btnDisplayedInformationColour.Color;
    DisplayLivingCells := chkDisplayedInformationLivingCells.Checked;
    AnimationDelay := edtAnimationDelay.Value;
    if Modified then
      SaveToFile
  end
end;

procedure TfrmSettingsDialog.DisplayedInformationChanged(Sender : TObject);

begin
  btnDisplayedInformationColour.Enabled := chkDisplayedInformationGeneration.Checked or
                                           chkDisplayedInformationLivingCells.Checked
end;

procedure TfrmSettingsDialog.FormCreate(Sender : TObject);

begin
  ReadOptions
end;

procedure TfrmSettingsDialog.ReadOptions;

begin
  with Options do
  begin
    edtGridSizeAcross.Value := GridWidth;
    edtGridSizeDown.Value := GridHeight;
    btnColourBackground.Color := BackgroundColor;
    btnColourLivingCells.Color := LivingCellColor;
    chkDisplayedInformationGeneration.Checked := DisplayGeneration;
    btnDisplayedInformationColour.Color := DisplayedInformationColor;
    chkDisplayedInformationLivingCells.Checked := DisplayLivingCells;
    edtAnimationDelay.Value := AnimationDelay
  end
end;

end.
