unit fmSettingsDialog;

interface

uses
  Buttons, Classes, ComCtrls, Controls, DFSClrBn, ExtCtrls, Forms, StdCtrls;

type
  TfrmSettingsDialog = class(TForm)
    bvlMain: TBevel;
    grpGridSize: TGroupBox;
    lblGridSizeAcross: TLabel;
    edtGridSizeAcross: TEdit;
    arwGridSizeAcross: TUpDown;
    lblGridSizeDown: TLabel;
    edtGridSizeDown: TEdit;
    arwGridSizeDown: TUpDown;
    grpColour: TGroupBox;
    btnColourBackground: TDFSColorButton;
    btnColourLivingCells: TDFSColorButton;
    lblColourBackground: TLabel;
    lblColourLivingCells: TLabel;
    grpGridLines: TGroupBox;
    chkGridLines: TCheckBox;
    lblGridLinesStyle: TLabel;
    edtGridLinesStyle: TComboBox;
    lblGridLinesColour: TLabel;
    grpDisplayedInformation: TGroupBox;
    chkDisplayedInformationGeneration: TCheckBox;
    chkDisplayedInformationLivingCells: TCheckBox;
    btnDisplayedInformationColour: TDFSColorButton;
    grpAnimation: TGroupBox;
    lblAnimationDelay: TLabel;
    edtAnimationDelay: TEdit;
    arwAnimationDelay: TUpDown;
    grpMouse: TGroupBox;
    lblMouseSensitivity: TLabel;
    edtMouseSensitivity: TEdit;
    arwMouseSensitivity: TUpDown;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    btnDefault: TBitBtn;
    btnGridLinesColour: TDFSColorButton;
    procedure btnCancelClick(Sender : TObject);
    procedure btnOKClick(Sender : TObject);
    procedure btnDefaultClick(Sender : TObject);
    procedure chkGridLinesClick(Sender : TObject);
    procedure DisplayedInformationChanged(Sender : TObject);
    procedure FormCreate(Sender : TObject);
  private
    procedure ReadOptions;
  end;

var
  frmSettingsDialog : TfrmSettingsDialog;

implementation

uses
  Graphics, UOptions;

{$R *.DFM}

procedure TfrmSettingsDialog.btnCancelClick(Sender : TObject);

begin
  Close
end;

procedure TfrmSettingsDialog.btnOKClick(Sender : TObject);

begin
  Options.GridHeight := arwGridSizeDown.Position;
  Options.GridWidth := arwGridSizeAcross.Position;
  Options.BackgroundColor := btnColourBackground.Color;
  Options.LivingCellColor := btnColourLivingCells.Color;
  Options.GridLinesVisible := chkGridLines.Checked;
  Options.GridLinesStyle := TPenStyle(edtGridLinesStyle.ItemIndex);
  Options.GridLinesColor := btnGridLinesColour.Color;
  Options.DisplayGeneration := chkDisplayedInformationGeneration.Checked;
  Options.DisplayedInformationColor := btnDisplayedInformationColour.Color;
  Options.DisplayLivingCells := chkDisplayedInformationLivingCells.Checked;
  Options.AnimationDelay := arwAnimationDelay.Position;
  Options.MouseSensitivity := arwMouseSensitivity.Position;
  Close
end;

procedure TfrmSettingsDialog.btnDefaultClick(Sender : TObject);

begin
  Options.RestoreDisplayDefaults;
  ReadOptions
end;

procedure TfrmSettingsDialog.chkGridLinesClick(Sender : TObject);

begin
  edtGridLinesStyle.Enabled := chkGridLines.Checked;
  btnGridLinesColour.Enabled := chkGridLines.Checked
end;

procedure TfrmSettingsDialog.DisplayedInformationChanged(Sender : TObject);

begin
  btnDisplayedInformationColour.Enabled := chkDisplayedInformationGeneration.Checked or
                                           chkDisplayedInformationLivingCells.Checked
end;

procedure TfrmSettingsDialog.FormCreate(Sender : TObject);

begin
  btnColourBackground.CustomColorsKey := RegistryKey;
  btnColourLivingCells.CustomColorsKey := RegistryKey;
  btnGridLinesColour.CustomColorsKey := RegistryKey;
  btnDisplayedInformationColour.CustomColorsKey := RegistryKey;
  ReadOptions
end;

procedure TfrmSettingsDialog.ReadOptions;

begin
  arwGridSizeAcross.Position := Options.GridWidth;
  arwGridSizeDown.Position := Options.GridHeight;
  btnColourBackground.Color := Options.BackgroundColor;
  btnColourLivingCells.Color := Options.LivingCellColor;
  chkGridLines.Checked := Options.GridLinesVisible;
  chkGridLinesClick(nil);
  edtGridLinesStyle.ItemIndex := Ord(Options.GridLinesStyle);
  btnGridLinesColour.Color := Options.GridLinesColor;
  chkDisplayedInformationGeneration.Checked := Options.DisplayGeneration;
  btnDisplayedInformationColour.Color := Options.DisplayedInformationColor;
  chkDisplayedInformationLivingCells.Checked := Options.DisplayLivingCells;
  arwAnimationDelay.Position := Options.AnimationDelay;
  arwMouseSensitivity.Position := Options.MouseSensitivity
end;

end.
