unit fmScreenSaver;

interface

uses
  Classes, Controls, ExtCtrls, fmBaseScreen, Forms, Messages, StdCtrls, ULife, Windows;

type
  TfrmScreenSaver = class(TfrmBaseScreen)
    procedure cmpLifeMouseDown(Sender : TObject; Button : TMouseButton; Shift : TShiftState;
                               X, Y : Integer);
    procedure cmpLifeMouseMove(Sender : TObject; Shift : TShiftState; X, Y : Integer);
    procedure FormCreate(Sender : TObject);
    procedure FormDestroy(Sender : TObject);
  private
    FLastNotifiedMousePosition : TPoint;
    procedure CloseScreenSaver;
  protected
    procedure PatternRepeating(const Periodicity : Cardinal); override;
    procedure WMKeyDown(var Msg : TWMKeyDown); message WM_KEYDOWN;
    procedure WMSysKeyDown(var Msg : TWMSysKeyDown); message WM_SYSKEYDOWN;
  end;

var
  frmScreenSaver : TfrmScreenSaver;

implementation

uses
  fmRepeatingPattern, Password, UOptions;

{$R *.DFM}

procedure TfrmScreenSaver.CloseScreenSaver;

begin
  if not PasswordRequired or EnterPassword(Self) then
    Close
end;

procedure TfrmScreenSaver.cmpLifeMouseDown(Sender : TObject; Button : TMouseButton;
                                           Shift : TShiftState; X, Y : Integer);

begin
  Inherited;
  CloseScreenSaver
end;

procedure TfrmScreenSaver.cmpLifeMouseMove(Sender : TObject; Shift : TShiftState;
                                           X, Y : Integer);

begin
  Inherited;
  if (FLastNotifiedMousePosition.X >= 0) and
     ((Abs(FLastNotifiedMousePosition.X - X) > Options.MouseSensitivity) or
      (Abs(FLastNotifiedMousePosition.Y - Y) > Options.MouseSensitivity)) then
    CloseScreenSaver;
  FLastNotifiedMousePosition.X := X;
  FLastNotifiedMousePosition.Y := Y
end;

procedure TfrmScreenSaver.FormCreate(Sender : TObject);

begin
  cmpLife.GridHeight := Options.GridHeight;
  cmpLife.GridWidth := Options.GridWidth;
  Inherited;
  FLastNotifiedMousePosition.X := -1;
  // Prevent task switching
  SystemParametersInfo(SPI_SCREENSAVERRUNNING, Word(True), nil, 0);
  ShowCursor(False) { Hide the mouse pointer }
end;

procedure TfrmScreenSaver.FormDestroy(Sender : TObject);

begin
  Inherited;
  // Re-enable task switching
  SystemParametersInfo(SPI_SCREENSAVERRUNNING, Word(False), nil, 0);
  ShowCursor(True) { Show the mouse pointer }
end;

procedure TfrmScreenSaver.PatternRepeating(const Periodicity : Cardinal);

var
  frmRepeatingPattern : TfrmRepeatingPattern;

begin
  tmrSpeed.Enabled := False;
  try
    frmRepeatingPattern := TfrmRepeatingPattern.Create(Self);
    try
      frmRepeatingPattern.Execute(Periodicity)
    finally
      frmRepeatingPattern.Free;
      FLastNotifiedMousePosition.X := -1
    end;
    Inherited
  finally
    tmrSpeed.Enabled := True
  end
end;

procedure TfrmScreenSaver.WMKeyDown(var Msg : TWMKeyDown);

begin
  CloseScreenSaver;
  Msg.Result := 1
end;

procedure TfrmScreenSaver.WMSysKeyDown(var Msg : TWMSysKeyDown);

begin
  CloseScreenSaver;
  Msg.Result := 1
end;

end.
