unit fmRepeatingPattern;

interface

uses
  Buttons, Classes, Controls, ExtCtrls, Forms, StdCtrls;

type
  TfrmRepeatingPattern = class(TForm)
    memMessage: TMemo;
    lblPrompt1: TLabel;
    lblPrompt2: TLabel;
    btnKillTimer: TSpeedButton;
    lblPrompt3: TLabel;
    btnOK: TBitBtn;
    tmrContinue: TTimer;
    procedure btnKillTimerClick(Sender : TObject);
    procedure FormCreate(Sender : TObject);
    procedure FormMouseMove(Sender : TObject; Shift : TShiftState; X, Y : Integer);
    procedure tmrContinueTimer(Sender : TObject);
  private
    FSecsRemaining : Integer;
    procedure ResetCountdownTimer;
    procedure SetSecsRemaining(const Value : Integer);
    property SecsRemaining : Integer read FSecsRemaining write SetSecsRemaining;
  public
    procedure Execute(const Periodicity : Cardinal);
  end;

implementation

uses
  SysUtils, Windows;

{$R *.DFM}

const
  TimeOut = 60;

procedure TfrmRepeatingPattern.btnKillTimerClick(Sender : TObject);

begin
  tmrContinue.Enabled := False;
  btnKillTimer.Enabled := False;
  lblPrompt1.Caption := 'Click on OK';
  lblPrompt2.Caption := 'to create a new pattern';
  lblPrompt3.Visible := False
end;

procedure TfrmRepeatingPattern.Execute(const Periodicity : Cardinal);

var
  msg : String;

begin
  if Periodicity = 1 then
    msg := 'The pattern has stabilised and is now repeating every generation!'
  else
    msg := Format('The pattern has stabilised and is now repeating every %d generations!',
                  [Periodicity]);
  memMessage.Lines.Add(msg);
  ShowCursor(True);
  try
    ShowModal
  finally
    ShowCursor(False)
  end
end;

procedure TfrmRepeatingPattern.FormCreate(Sender : TObject);

begin
  ResetCountdownTimer
end;

procedure TfrmRepeatingPattern.FormMouseMove(Sender : TObject; Shift : TShiftState; X, Y : Integer);

begin
  if btnKillTimer.Enabled then
    ResetCountdownTimer
end;

procedure TfrmRepeatingPattern.ResetCountdownTimer;

begin
  SecsRemaining := TimeOut
end;

procedure TfrmRepeatingPattern.SetSecsRemaining(const Value : Integer);

begin
  FSecsRemaining := Value;
  lblPrompt2.Caption := Format('%d seconds', [FSecsRemaining])
end;

procedure TfrmRepeatingPattern.tmrContinueTimer(Sender : TObject);

begin
  if SecsRemaining <= 1 then
    Close
  else
    SecsRemaining := SecsRemaining - 1
end;

end.
