unit fmBaseScreen;

interface

uses
  Classes, Controls, ExtCtrls, Forms, Messages, StdCtrls, ULife;

type
  TfrmBaseScreen = class(TForm)
    cmpLife: TLife;
    pnlInformation: TPanel;
    lblGeneration: TLabel;
    lblGenerationValue: TLabel;
    lblLivingCells: TLabel;
    lblLivingCellsValue: TLabel;
    tmrSpeed: TTimer;
    procedure cmpLifeChange(Sender : TObject);
    procedure FormCreate(Sender : TObject);
    procedure FormShow(Sender : TObject);
    procedure tmrSpeedTimer(Sender : TObject);
  protected
    procedure CreateRandomPattern;
    procedure PatternRepeating(const Periodicity : Cardinal); virtual;
    procedure WMSysCommand(var Msg : TWMSysCommand); message WM_SYSCOMMAND;
  end;

implementation

uses
  SysUtils, UOptions, Windows;

{$R *.DFM}

procedure TfrmBaseScreen.cmpLifeChange(Sender : TObject);

begin
  lblGenerationValue.Caption := IntToStr(cmpLife.Generation);
  lblLivingCellsValue.Caption := IntToStr(cmpLife.LiveCellCount)
end;

procedure TfrmBaseScreen.CreateRandomPattern;

var
  x, y : Integer;

begin
  // Create a random pattern of cells
  with cmpLife do
    for x := 0 to GridWidth - 1 do
      for y := 0 to GridHeight - 1 do
        if Random < 0.5 then
          Cells[x, y] := True
        else
          Cells[x, y] := False
end;

procedure TfrmBaseScreen.FormCreate(Sender : TObject);

begin
  cmpLife.Color := Options.BackgroundColor;
  cmpLife.CellColor := Options.LivingCellColor;
  cmpLife.ShowGridLines := Options.GridLinesVisible;
  cmpLife.GridLineColor := Options.GridLinesColor;
  cmpLife.GridLineStyle := Options.GridLinesStyle;
  if Options.DisplayGeneration or Options.DisplayLivingCells then
  begin
    pnlInformation.Color := cmpLife.Color;
    if Options.DisplayGeneration then
    begin
      lblGeneration.Font.Color := Options.DisplayedInformationColor;
      lblGenerationValue.Font.Color := Options.DisplayedInformationColor
    end
    else
    begin
      lblGeneration.Visible := False;
      lblGenerationValue.Visible := False
    end;
    if Options.DisplayLivingCells then
    begin
      lblLivingCells.Font.Color := Options.DisplayedInformationColor;
      lblLivingCellsValue.Font.Color := Options.DisplayedInformationColor
    end
    else
    begin
      lblLivingCells.Visible := False;
      lblLivingCellsValue.Visible := False
    end
  end
  else
    pnlInformation.Visible := False;
  tmrSpeed.Interval := Options.AnimationDelay;
  Randomize;
  CreateRandomPattern
end;

procedure TfrmBaseScreen.FormShow(Sender : TObject);

begin
{$IFDEF VER90}
  ShowWindow(Handle, SW_MAXIMIZE)
{$ENDIF}
end;

procedure TfrmBaseScreen.PatternRepeating(const Periodicity : Cardinal);

begin
  CreateRandomPattern
end;

procedure TfrmBaseScreen.tmrSpeedTimer(Sender : TObject);

var
  Periodicity : Cardinal;

begin
  Periodicity := cmpLife.NextGeneration;
  if cmpLife.NextGeneration > 0 then
    PatternRepeating(Periodicity)
end;

procedure TfrmBaseScreen.WMSysCommand(var Msg : TWMSysCommand);

begin
  if Msg.CmdType = SC_SCREENSAVE then
    Msg.Result := 1 { Do not activate the saver more than once }
  else
    Inherited
end;

end.
